/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.wizard;

import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.gui.ClassPathDialog;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.wizard.UserChoicesWizardTemplate;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import it.businesslogic.ireport.util.ReportGenerator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class UserTemplatesDialog
extends JDialog {
    private int dialogResult = 2;
    private boolean modifiedList = false;
    private JButton jButtonCancel;
    private JButton jButtonCreateReports;
    private JButton jButtonDeleteTemplate;
    private JButton jButtonSave;
    private JList jList1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;

    public UserTemplatesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        this.jList1.setModel(new DefaultListModel());
        Misc.centerFrame(this);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                UserTemplatesDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        DefaultListModel dlm = new DefaultListModel();
        this.jList1.setModel(dlm);
        List list = MainFrame.getMainInstance().getUserChoicesWizardTemplates();
        for (int i = 0; i < list.size(); ++i) {
            dlm.addElement(list.get(i));
        }
        if (list.size() > 0) {
            this.jList1.setSelectedIndex(0);
        }
        this.jList1.updateUI();
        this.getRootPane().setDefaultButton(this.jButtonSave);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel1 = new JPanel();
        this.jButtonCreateReports = new JButton();
        this.jButtonDeleteTemplate = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(0);
        this.setTitle("Classpath");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                UserTemplatesDialog.this.formWindowClosed(evt);
            }

            public void windowClosing(WindowEvent evt) {
                UserTemplatesDialog.this.formWindowClosing(evt);
            }
        });
        this.jScrollPane2.setPreferredSize(new Dimension(258, 300));
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                UserTemplatesDialog.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jList1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setMinimumSize(new Dimension(120, 10));
        this.jPanel1.setPreferredSize(new Dimension(120, 10));
        this.jButtonCreateReports.setText("Create report(s)");
        this.jButtonCreateReports.setToolTipText("Create report from selected template");
        this.jButtonCreateReports.setEnabled(false);
        this.jButtonCreateReports.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserTemplatesDialog.this.jButtonDeselectAllActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonCreateReports, gridBagConstraints);
        this.jButtonDeleteTemplate.setText("Delete temlplate");
        this.jButtonDeleteTemplate.setToolTipText("");
        this.jButtonDeleteTemplate.setEnabled(false);
        this.jButtonDeleteTemplate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserTemplatesDialog.this.jButtonCreateReportsjButtonDeselectAllActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonDeleteTemplate, gridBagConstraints);
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserTemplatesDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserTemplatesDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        if (this.jList1.getSelectedIndex() >= 0) {
            this.jButtonCreateReports.setEnabled(true);
            this.jButtonDeleteTemplate.setEnabled(true);
        } else {
            this.jButtonCreateReports.setEnabled(false);
            this.jButtonDeleteTemplate.setEnabled(false);
        }
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        List list = MainFrame.getMainInstance().getUserChoicesWizardTemplates();
        list.clear();
        DefaultListModel dlm = (DefaultListModel)this.jList1.getModel();
        for (int i = 0; i < dlm.getSize(); ++i) {
            list.add(dlm.getElementAt(i));
        }
        UserChoicesWizardTemplate.storeWizardTemplates(list);
        this.setDialogResult(0);
        this.setVisible(false);
    }

    private void jButtonCreateReportsjButtonDeselectAllActionPerformed1(ActionEvent evt) {
        DefaultListModel dlm = (DefaultListModel)this.jList1.getModel();
        int[] indexes = this.jList1.getSelectedIndices();
        for (int i = indexes.length - 1; i >= 0; --i) {
            dlm.remove(indexes[i]);
            this.modifiedList = true;
        }
    }

    private void jButtonDeselectAllActionPerformed1(ActionEvent evt) {
        Object[] templates = this.jList1.getSelectedValues();
        if (templates.length == 0) {
            return;
        }
        int filesCreated = 0;
        JFileChooser jfc = new JFileChooser(MainFrame.getMainInstance().getCurrentDirectory());
        jfc.setDialogTitle("Select output directory");
        jfc.setDialogTitle(I18n.getString("selectOutputDirectory", "Select output directory"));
        jfc.setAcceptAllFileFilterUsed(true);
        jfc.setFileSelectionMode(1);
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this) == 0) {
            File directory = jfc.getSelectedFile();
            MainFrame.getMainInstance().setCurrentDirectory(directory, true);
            for (int i = templates.length - 1; i >= 0; --i) {
                UserChoicesWizardTemplate template = (UserChoicesWizardTemplate)templates[i];
                File file = new File(directory, Misc.string_replace("_", " ", template.getName()) + ".jrxml");
                if (file.exists()) {
                    int ret = JOptionPane.showConfirmDialog(this, I18n.getFormattedString("userTemplatesDialog.message.overwrite", "The file {0} already exists.\nDo you want overwrite it?", new Object[]{"" + file}), "", 1, 2);
                    if (ret == 2) break;
                    if (ret == 1) {
                        jfc = new JFileChooser(MainFrame.getMainInstance().getCurrentDirectory());
                        jfc.setDialogTitle("Save report as XML jasperreports file...");
                        jfc.setSelectedFile(file);
                        jfc.setFileFilter(new FileFilter(){

                            public boolean accept(File file) {
                                String filename = file.getName();
                                return filename.toLowerCase().endsWith(".xml") || file.isDirectory() || filename.toLowerCase().endsWith(".jrxml");
                            }

                            public String getDescription() {
                                return "JasperReports XML *.xml, *.jrxml";
                            }
                        });
                        jfc.setMultiSelectionEnabled(false);
                        jfc.setDialogType(1);
                        if (jfc.showSaveDialog(this) != 0) {
                            return;
                        }
                        file = jfc.getSelectedFile();
                    }
                }
                try {
                    Report report = ReportGenerator.createReport(template);
                    report.saveXMLFile("" + file);
                    ++filesCreated;
                    continue;
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), I18n.getString("message.title.exception", "Exception"), 0);
                    break;
                }
            }
            JOptionPane.showMessageDialog(this, I18n.getFormattedString("userTemplatesDialog.message.createdReports", "{0} report(s) created successful.", new Object[]{new Integer(filesCreated)}), "", 1);
        }
    }

    private void formWindowClosed(WindowEvent evt) {
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.modifiedList) {
            int ret = JOptionPane.showConfirmDialog(this, I18n.getString("userTemplatesDialog.saveTemplatesList", "Do you want save the changes ?"));
            if (ret == 2) {
                return;
            }
            this.jButtonSaveActionPerformed(null);
        } else {
            this.setVisible(false);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new ClassPathDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void applyI18n() {
        this.jButtonCancel.setText(I18n.getString("jRFieldDialog.buttonCancel", "Cancel"));
        this.jButtonCreateReports.setText(I18n.getString("userTemplatesDialog.buttonGenerateReport", "Generate report(s)"));
        this.jButtonDeleteTemplate.setText(I18n.getString("userTemplatesDialog.buttonRemoveTemplate", "Remove template"));
        this.jButtonSave.setText(I18n.getString("userTemplatesDialog.buttonSave", "Save changes"));
        this.setTitle(I18n.getString("userTemplatesDialog.title", "User choices templates"));
    }
}

