/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.BarcodeReportElement;
import it.businesslogic.ireport.Box;
import it.businesslogic.ireport.BoxElement;
import it.businesslogic.ireport.BreakReportElement;
import it.businesslogic.ireport.ChartReportElement;
import it.businesslogic.ireport.ChartReportElement2;
import it.businesslogic.ireport.ConditionedStyle;
import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.EllipseReportElement;
import it.businesslogic.ireport.FrameReportElement;
import it.businesslogic.ireport.GraphicReportElement;
import it.businesslogic.ireport.Group;
import it.businesslogic.ireport.HyperLinkableReportElement;
import it.businesslogic.ireport.IReportFont;
import it.businesslogic.ireport.ImageReportElement;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRLinkParameter;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRProperty;
import it.businesslogic.ireport.JRSubreportParameter;
import it.businesslogic.ireport.JRSubreportReturnValue;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.LineReportElement;
import it.businesslogic.ireport.RectangleReportElement;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.ScriptletCode;
import it.businesslogic.ireport.SortField;
import it.businesslogic.ireport.StaticTextReportElement;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.SubReportElement;
import it.businesslogic.ireport.TextFieldReportElement;
import it.businesslogic.ireport.TextReportElement;
import it.businesslogic.ireport.TransformationType;
import it.businesslogic.ireport.chart.AreaChart;
import it.businesslogic.ireport.chart.AreaPlot;
import it.businesslogic.ireport.chart.Axis;
import it.businesslogic.ireport.chart.AxisFormat;
import it.businesslogic.ireport.chart.Bar3DChart;
import it.businesslogic.ireport.chart.Bar3DPlot;
import it.businesslogic.ireport.chart.BarChart;
import it.businesslogic.ireport.chart.BarPlot;
import it.businesslogic.ireport.chart.BubbleChart;
import it.businesslogic.ireport.chart.BubblePlot;
import it.businesslogic.ireport.chart.CandlestickChart;
import it.businesslogic.ireport.chart.CandlestickPlot;
import it.businesslogic.ireport.chart.CategoryDataset;
import it.businesslogic.ireport.chart.CategorySeries;
import it.businesslogic.ireport.chart.DataRange;
import it.businesslogic.ireport.chart.Dataset;
import it.businesslogic.ireport.chart.HighLowChart;
import it.businesslogic.ireport.chart.HighLowDataset;
import it.businesslogic.ireport.chart.HighLowPlot;
import it.businesslogic.ireport.chart.LineChart;
import it.businesslogic.ireport.chart.LinePlot;
import it.businesslogic.ireport.chart.MeterChart;
import it.businesslogic.ireport.chart.MeterInterval;
import it.businesslogic.ireport.chart.MeterPlot;
import it.businesslogic.ireport.chart.MultiAxisChart;
import it.businesslogic.ireport.chart.MultiAxisPlot;
import it.businesslogic.ireport.chart.Pie3DChart;
import it.businesslogic.ireport.chart.Pie3DPlot;
import it.businesslogic.ireport.chart.PieChart;
import it.businesslogic.ireport.chart.PieDataset;
import it.businesslogic.ireport.chart.PiePlot;
import it.businesslogic.ireport.chart.Plot;
import it.businesslogic.ireport.chart.ScatterChart;
import it.businesslogic.ireport.chart.ScatterPlot;
import it.businesslogic.ireport.chart.SectionItemHyperlink;
import it.businesslogic.ireport.chart.SeriesColor;
import it.businesslogic.ireport.chart.StackedAreaChart;
import it.businesslogic.ireport.chart.StackedBar3DChart;
import it.businesslogic.ireport.chart.StackedBarChart;
import it.businesslogic.ireport.chart.ThermometerChart;
import it.businesslogic.ireport.chart.ThermometerPlot;
import it.businesslogic.ireport.chart.TimePeriodDataset;
import it.businesslogic.ireport.chart.TimePeriodSeries;
import it.businesslogic.ireport.chart.TimeSeries;
import it.businesslogic.ireport.chart.TimeSeriesChart;
import it.businesslogic.ireport.chart.TimeSeriesDataset;
import it.businesslogic.ireport.chart.TimeSeriesPlot;
import it.businesslogic.ireport.chart.ValueDataset;
import it.businesslogic.ireport.chart.ValueDisplay;
import it.businesslogic.ireport.chart.XYAreaChart;
import it.businesslogic.ireport.chart.XYBarChart;
import it.businesslogic.ireport.chart.XYDataset;
import it.businesslogic.ireport.chart.XYLineChart;
import it.businesslogic.ireport.chart.XYSeries;
import it.businesslogic.ireport.chart.XYZDataset;
import it.businesslogic.ireport.chart.XYZSeries;
import it.businesslogic.ireport.crosstab.CrosstabCell;
import it.businesslogic.ireport.crosstab.CrosstabColumnGroup;
import it.businesslogic.ireport.crosstab.CrosstabGroup;
import it.businesslogic.ireport.crosstab.CrosstabParameter;
import it.businesslogic.ireport.crosstab.CrosstabRowGroup;
import it.businesslogic.ireport.crosstab.Measure;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import it.businesslogic.ireport.util.PageSize;
import java.awt.Color;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ReportReader {
    private Report report = null;

    public ReportReader(Report report) {
        this.report = report;
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Report readFile(String xmlFile) throws IOException {
        this.getReport().setLanguage("java");
        for (int i = 0; i < this.getReport().getBands().size(); ++i) {
            ((Band)this.getReport().getBands().elementAt(i)).setHeight(0);
        }
        InputStream input_source = null;
        try {
            Object ffile;
            if (xmlFile.toLowerCase().endsWith(".jasper")) {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    JRReport jreport = (JRReport)JRLoader.loadObject((String)xmlFile);
                    JasperCompileManager.writeReportToXmlStream((JRReport)jreport, (OutputStream)bos);
                    input_source = new ByteArrayInputStream(bos.toByteArray());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else {
                this.getReport().setFilename(xmlFile);
                this.getReport().checkReadOnlyFlag();
                this.getReport().setLoadTime(Misc.getLastWriteTime(xmlFile));
                ffile = new File(xmlFile);
                input_source = ((File)ffile).exists() ? new FileInputStream((File)ffile) : this.getReport().getClass().getClassLoader().getResourceAsStream(xmlFile);
            }
            ffile = this.readFromStream(input_source);
            return ffile;
        }
        catch (IOException e) {
            System.out.println(e);
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
        finally {
            try {
                if (input_source != null) {
                    input_source.close();
                }
            }
            catch (Exception exception) {}
        }
        return this.getReport();
    }

    public Report readFromStream(InputStream input_source) throws IOException {
        try {
            int i;
            DOMParser parser = new DOMParser();
            parser.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    InputSource inputSource = null;
                    if (systemId != null) {
                        InputStream is;
                        String dtd = null;
                        if (systemId.equals("http://jasperreports.sourceforge.net/dtds/jasperreport.dtd") || systemId.equals("http://www.jasperreports.com/dtds/jasperreport.dtd")) {
                            dtd = "net/sf/jasperreports/engine/dtds/jasperreport.dtd";
                        } else if (systemId.equals("http://jasperreports.sourceforge.net/dtds/jasperprint.dtd") || systemId.equals("http://www.jasperreports.com/dtds/jasperprint.dtd")) {
                            dtd = "net/sf/jasperreports/engine/dtds/jasperprint.dtd";
                        } else {
                            return new InputSource(systemId);
                        }
                        ClassLoader classLoader = ReportReader.this.getReport().getClass().getClassLoader();
                        URL url = null;
                        if (classLoader != null && (url = classLoader.getResource(dtd)) == null) {
                            classLoader = ReportReader.this.getReport().getClass().getClassLoader();
                        }
                        if ((is = classLoader.getResourceAsStream(dtd)) != null) {
                            InputStreamReader isr = new InputStreamReader(is);
                            inputSource = new InputSource(isr);
                        } else {
                            throw new IOException("iReport Internal error in report.java: Could not find: " + dtd + "\n");
                        }
                    }
                    return inputSource;
                }
            });
            InputSource input_sss = new InputSource(input_source);
            input_sss.setSystemId("file:///" + this.getReport().getFilename());
            parser.parse(input_sss);
            Document document = parser.getDocument();
            this.getReport().setEncoding(Misc.nvl(input_sss.getEncoding(), "UTF-8"));
            this.traverse(document.getDocumentElement());
            this.getReport().setReportFormat(PageSize.deductPageFormat(this.getReport().getWidth(), this.getReport().getHeight()));
            for (i = 0; i < this.getReport().getGroups().size(); ++i) {
                Group grp = (Group)this.getReport().getGroups().elementAt(i);
                this.getReport().addGroup(grp, false);
            }
            for (i = 0; i < this.getReport().getElements().size(); ++i) {
                ReportElement re = (ReportElement)this.getReport().getElements().elementAt(i);
                if (re.getParentElement() != null) {
                    re.trasform(new Point((int)re.getParentElement().getPosition().getX(), (int)re.getParentElement().getPosition().getY()), TransformationType.TRANSFORMATION_MOVE);
                    continue;
                }
                re.trasform(new Point(this.getReport().getLeftMargin() + 10, this.getReport().getBandYLocation(re.getBand()) + 10), TransformationType.TRANSFORMATION_MOVE);
            }
            if (this.getReport().getScriptletFileName() != null) {
                Report report = this.getReport();
                this.getReport();
                report.setScriptletHandling(Report.SCRIPTLET_CLASSIC_HANDLING);
            }
            for (int pk = 0; pk < this.getReport().getJRproperties().size(); ++pk) {
                JRProperty prop = (JRProperty)this.getReport().getJRproperties().elementAt(pk);
                if (prop.getName().equals("ireport.scriptlethandling")) {
                    if (prop.getValue().equals("0")) {
                        this.getReport().setScriptletHandling(0);
                    } else if (prop.getValue().equals("1")) {
                        Report report = this.getReport();
                        this.getReport();
                        report.setScriptletHandling(Report.SCRIPTLET_IREPORT_INTERNAL_HANDLING);
                        File scriptletFile = new File(this.getReport().getScriptletFileName());
                        if (scriptletFile.exists()) {
                            this.getReport().setScripletCode(new ScriptletCode(this.getReport().getScriptletFileName()));
                        }
                    }
                }
                if (prop.getName().equals("ireport.encoding")) {
                    this.getReport().setEncoding(prop.getValue());
                }
                if (!prop.getValue().startsWith("ireport.")) continue;
                this.getReport().getJRproperties().remove(prop);
                --pk;
            }
            if (this.getReport().getScriptletHandling() == 2 && (this.getReport().getScriptletClass() == null || this.getReport().getScriptletClass().equals(""))) {
                this.getReport().setScriptletHandling(0);
            }
        }
        catch (IOException e) {
            System.out.println(e);
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
        this.getReport().setReportChanges(0);
        return this.getReport();
    }

    private void traverse(Node node) {
        NodeList children;
        Band b;
        Node bandNode;
        boolean seeInside = false;
        if (node.getNodeType() == 1 && node.getNodeName().equals("jasperReport")) {
            seeInside = true;
            NamedNodeMap nnm = node.getAttributes();
            this.getReport().setName(nnm.getNamedItem("name") != null ? nnm.getNamedItem("name").getNodeValue() : "");
            if (nnm.getNamedItem("columnCount") != null) {
                this.getReport().setColumnCount(Integer.parseInt(nnm.getNamedItem("columnCount").getNodeValue()));
            }
            if (nnm.getNamedItem("printOrder") != null) {
                this.getReport().setPrintOrder(nnm.getNamedItem("printOrder").getNodeValue());
            }
            if (nnm.getNamedItem("orientation") != null) {
                this.getReport().setOrientation(nnm.getNamedItem("orientation").getNodeValue());
            }
            if (nnm.getNamedItem("scriptletClass") != null) {
                this.getReport().setScriptletClass(nnm.getNamedItem("scriptletClass").getNodeValue());
            }
            if (nnm.getNamedItem("resourceBundle") != null) {
                this.getReport().setResourceBundleBaseName(nnm.getNamedItem("resourceBundle").getNodeValue());
            }
            if (nnm.getNamedItem("pageWidth") != null) {
                this.getReport().setWidth(Integer.parseInt(nnm.getNamedItem("pageWidth").getNodeValue()));
            }
            if (nnm.getNamedItem("pageHeight") != null) {
                this.getReport().setHeight(Integer.parseInt(nnm.getNamedItem("pageHeight").getNodeValue()));
            }
            if (nnm.getNamedItem("columnWidth") != null) {
                this.getReport().setColumnWidth(Integer.parseInt(nnm.getNamedItem("columnWidth").getNodeValue()));
            }
            if (nnm.getNamedItem("columnSpacing") != null) {
                this.getReport().setColumnSpacing(Integer.parseInt(nnm.getNamedItem("columnSpacing").getNodeValue()));
            }
            if (nnm.getNamedItem("leftMargin") != null) {
                this.getReport().setLeftMargin(Integer.parseInt(nnm.getNamedItem("leftMargin").getNodeValue()));
            }
            if (nnm.getNamedItem("rightMargin") != null) {
                this.getReport().setRightMargin(Integer.parseInt(nnm.getNamedItem("rightMargin").getNodeValue()));
            }
            if (nnm.getNamedItem("topMargin") != null) {
                this.getReport().setTopMargin(Integer.parseInt(nnm.getNamedItem("topMargin").getNodeValue()));
            }
            if (nnm.getNamedItem("bottomMargin") != null) {
                this.getReport().setBottomMargin(Integer.parseInt(nnm.getNamedItem("bottomMargin").getNodeValue()));
            }
            if (nnm.getNamedItem("whenNoDataType") != null) {
                this.getReport().setWhenNoDataType(nnm.getNamedItem("whenNoDataType").getNodeValue());
            }
            if (nnm.getNamedItem("isTitleNewPage") != null) {
                this.getReport().setIsTitleNewPage(nnm.getNamedItem("isTitleNewPage").getNodeValue().equalsIgnoreCase("true"));
            }
            if (nnm.getNamedItem("isSummaryNewPage") != null) {
                this.getReport().setIsSummaryNewPage(nnm.getNamedItem("isSummaryNewPage").getNodeValue().equalsIgnoreCase("true"));
            }
            if (nnm.getNamedItem("isFloatColumnFooter") != null) {
                this.getReport().setFloatColumnFooter(nnm.getNamedItem("isFloatColumnFooter").getNodeValue().equalsIgnoreCase("true"));
            }
            if (nnm.getNamedItem("language") != null) {
                this.getReport().setLanguage(nnm.getNamedItem("language").getNodeValue());
            }
            if (nnm.getNamedItem("whenResourceMissingType") != null) {
                this.getReport().setWhenResourceMissingType(nnm.getNamedItem("whenResourceMissingType").getNodeValue());
            }
            if (nnm.getNamedItem("isIgnorePagination") != null) {
                this.getReport().setIgnorePagination(nnm.getNamedItem("isIgnorePagination").getNodeValue().equalsIgnoreCase("true"));
            }
            if (nnm.getNamedItem("formatFactoryClass") != null) {
                this.getReport().setFormatFactoryClass(nnm.getNamedItem("formatFactoryClass").getNodeValue());
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("property")) {
            JRProperty property = this.readPropertyElement(node);
            if (property.getName() != null && property.getName().length() != 0) {
                this.getReport().addJRProperty(property);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("import")) {
            NamedNodeMap nnm = node.getAttributes();
            if (nnm.getNamedItem("value") != null) {
                this.getReport().addImport(nnm.getNamedItem("value").getNodeValue());
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("reportFont")) {
            boolean isDefaultFont = false;
            IReportFont font = new IReportFont();
            NamedNodeMap nnm = node.getAttributes();
            for (int kkk = 0; kkk < nnm.getLength(); ++kkk) {
                String propName = nnm.item(kkk).getNodeName();
                String propValue = nnm.item(kkk).getNodeValue();
                if (propName == null || propValue == null) continue;
                if (propName.equals("name")) {
                    font.setReportFont(propValue);
                }
                if (propName.equals("isDefault")) {
                    isDefaultFont = propValue.equals("true");
                    font.setDefaultFont(isDefaultFont);
                }
                if (propName.equals("fontName")) {
                    font.setFontName(propValue);
                    continue;
                }
                if (propName.equals("pdfFontName")) {
                    font.setPDFFontName(propValue);
                    continue;
                }
                if (propName.equals("size")) {
                    font.setFontSize(Integer.parseInt("" + propValue));
                    continue;
                }
                if (propName.equals("isBold")) {
                    font.setBold(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (propName.equals("isItalic")) {
                    font.setItalic(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (propName.equals("isUnderline")) {
                    font.setUnderline(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (propName.equals("isStrikeThrough")) {
                    font.setStrikeTrought(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (propName.equals("isPdfEmbedded")) {
                    font.setPdfEmbedded(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (!propName.equals("pdfEncoding")) continue;
                font.setPdfEncoding("" + propValue);
            }
            if (isDefaultFont) {
                this.getReport().setDefaultFont((IReportFont)font.clone());
            }
            this.getReport().getFonts().addElement(font);
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("style")) {
            Style style = this.readStyle(node);
            this.getReport().getStyles().addElement(style);
            for (int i = 0; i < this.getReport().getStyles().size(); ++i) {
                Style s = (Style)this.getReport().getStyles().elementAt(i);
                if (s.getAttribute("style") == null) continue;
                if (s.getAttribute("style") instanceof Style) continue;
                for (int j = 0; j < this.getReport().getStyles().size(); ++j) {
                    Style sparent = (Style)this.getReport().getStyles().elementAt(j);
                    if (!sparent.getName().equals(s.getAttribute("style") + "")) continue;
                    s.getAttributes().put("style", sparent);
                }
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("parameter")) {
            JRParameter parameter = this.readParameterElement(node);
            if (parameter.getName() != null && parameter.getName().length() != 0) {
                this.getReport().addParameter(parameter);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("queryString")) {
            NamedNodeMap nnm = node.getAttributes();
            if (nnm.getNamedItem("language") != null) {
                this.getReport().setQueryLanguage(nnm.getNamedItem("language").getNodeValue());
            }
            this.getReport().setQuery(ReportReader.readPCDATA(node));
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("filterExpression")) {
            this.getReport().setFilterExpression(ReportReader.readPCDATA(node));
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("field")) {
            JRField field = this.readFieldElement(node);
            if (field.getName() != null && field.getName().length() != 0) {
                this.getReport().addField(field);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("variable")) {
            JRVariable variable = this.readVariableElement(node);
            if (variable.getName() != null && variable.getName().length() != 0) {
                this.getReport().addVariable(variable);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("sortField")) {
            SortField sortField = this.readSortFieldElement(node);
            this.getReport().addSortField(sortField);
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("subDataset")) {
            SubDataset subDataset = new SubDataset();
            NamedNodeMap nnm = node.getAttributes();
            if (nnm.getNamedItem("scriptletClass") != null) {
                subDataset.setScriptletClass(nnm.getNamedItem("scriptletClass").getNodeValue());
            }
            if (nnm.getNamedItem("resourceBundle") != null) {
                subDataset.setResourceBundleBaseName(nnm.getNamedItem("resourceBundle").getNodeValue());
            }
            if (nnm.getNamedItem("whenResourceMissingType") != null) {
                subDataset.setWhenResourceMissingType(nnm.getNamedItem("whenResourceMissingType").getNodeValue());
            }
            subDataset.setName(nnm.getNamedItem("name") != null ? nnm.getNamedItem("name").getNodeValue() : "SubDataset");
            NodeList children2 = node.getChildNodes();
            if (children2 != null) {
                for (int k = 0; k < children2.getLength(); ++k) {
                    Node nodeChild = children2.item(k);
                    if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("property")) {
                        JRProperty property = this.readPropertyElement(nodeChild);
                        if (property.getName() == null || property.getName().length() == 0) continue;
                        subDataset.addJRProperty(property);
                        continue;
                    }
                    if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("parameter")) {
                        JRParameter parameter = this.readParameterElement(nodeChild);
                        if (parameter.getName() == null || parameter.getName().length() == 0) continue;
                        subDataset.addParameter(parameter);
                        continue;
                    }
                    if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("field")) {
                        JRField field = this.readFieldElement(nodeChild);
                        if (field.getName() == null || field.getName().length() == 0) continue;
                        subDataset.addField(field);
                        continue;
                    }
                    if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("variable")) {
                        JRVariable variable = this.readVariableElement(nodeChild);
                        if (variable.getName() == null || variable.getName().length() == 0) continue;
                        subDataset.addVariable(variable);
                        continue;
                    }
                    if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("queryString")) {
                        NamedNodeMap nnmChild = nodeChild.getAttributes();
                        if (nnmChild.getNamedItem("language") != null) {
                            subDataset.setQueryLanguage(nnmChild.getNamedItem("language").getNodeValue());
                        }
                        subDataset.setQuery(ReportReader.readPCDATA(nodeChild));
                        continue;
                    }
                    if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("filterExpression")) {
                        subDataset.setFilterExpression(ReportReader.readPCDATA(nodeChild));
                        continue;
                    }
                    if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("group")) {
                        Group group = this.readGroupElement(subDataset, nodeChild, false);
                        subDataset.getGroups().add(group);
                        continue;
                    }
                    if (nodeChild.getNodeType() != 1 || !nodeChild.getNodeName().equals("sortField")) continue;
                    SortField sortField = this.readSortFieldElement(nodeChild);
                    subDataset.addSortField(sortField);
                }
            }
            this.getReport().addSubDataset(subDataset);
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("group")) {
            Group group = this.readGroupElement(this.getReport(), node, true);
            if (group.getName() != null && group.getName().length() != 0) {
                this.getReport().getGroups().addElement(group);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("background")) {
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                bandNode = list_child.item(ck);
                if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                NamedNodeMap bandAttributes = bandNode.getAttributes();
                b = this.getReport().getBandByName("background");
                if (bandAttributes.getNamedItem("height") != null) {
                    b.setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                }
                if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                    b.setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                }
                this.readBandElements(bandNode, b);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("title")) {
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                bandNode = list_child.item(ck);
                if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                NamedNodeMap bandAttributes = bandNode.getAttributes();
                b = this.getReport().getBandByName("title");
                if (bandAttributes.getNamedItem("height") != null) {
                    b.setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                }
                if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                    b.setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                }
                this.readBandElements(bandNode, b);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("pageHeader")) {
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                bandNode = list_child.item(ck);
                if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                NamedNodeMap bandAttributes = bandNode.getAttributes();
                b = this.getReport().getBandByName("pageHeader");
                if (bandAttributes.getNamedItem("height") != null) {
                    b.setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                }
                if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                    b.setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                }
                this.readBandElements(bandNode, b);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("columnHeader")) {
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                bandNode = list_child.item(ck);
                if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                NamedNodeMap bandAttributes = bandNode.getAttributes();
                b = this.getReport().getBandByName("columnHeader");
                if (bandAttributes.getNamedItem("height") != null) {
                    b.setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                }
                if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                    b.setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                }
                this.readBandElements(bandNode, b);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("detail")) {
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                bandNode = list_child.item(ck);
                if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                NamedNodeMap bandAttributes = bandNode.getAttributes();
                b = this.getReport().getBandByName("detail");
                if (bandAttributes.getNamedItem("height") != null) {
                    b.setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                }
                if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                    b.setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                }
                this.readBandElements(bandNode, b);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("columnFooter")) {
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                bandNode = list_child.item(ck);
                if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                NamedNodeMap bandAttributes = bandNode.getAttributes();
                b = this.getReport().getBandByName("columnFooter");
                if (bandAttributes.getNamedItem("height") != null) {
                    b.setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                }
                if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                    b.setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                }
                this.readBandElements(bandNode, b);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("pageFooter")) {
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                bandNode = list_child.item(ck);
                if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                NamedNodeMap bandAttributes = bandNode.getAttributes();
                b = this.getReport().getBandByName("pageFooter");
                if (bandAttributes.getNamedItem("height") != null) {
                    b.setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                }
                if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                    b.setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                }
                this.readBandElements(bandNode, b);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("lastPageFooter")) {
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                bandNode = list_child.item(ck);
                if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                NamedNodeMap bandAttributes = bandNode.getAttributes();
                b = this.getReport().getBandByName("lastPageFooter");
                if (bandAttributes.getNamedItem("height") != null) {
                    b.setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                }
                if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                    b.setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                }
                this.readBandElements(bandNode, b);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("summary")) {
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                bandNode = list_child.item(ck);
                if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                NamedNodeMap bandAttributes = bandNode.getAttributes();
                b = this.getReport().getBandByName("summary");
                if (bandAttributes.getNamedItem("height") != null) {
                    b.setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                }
                if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                    b.setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                }
                this.readBandElements(bandNode, b);
            }
        } else if (node.getNodeType() == 5) {
            seeInside = true;
        }
        if (seeInside && (children = node.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                this.traverse(children.item(i));
            }
        }
    }

    private void readBandElements(Node bandNode, Band band) {
        this.readBandElements("", bandNode, band, null, null, null);
    }

    private void readBandElements(String parentElementGroup, Node bandNode, Band band, ReportElement parent) {
        this.readBandElements(parentElementGroup, bandNode, band, parent, null, null);
    }

    private JRParameter readParameterElement(Node parameterNode) {
        NodeList children;
        JRParameter parameter = new JRParameter("", "java.lang.String", true, "");
        NamedNodeMap nnm = parameterNode.getAttributes();
        if (nnm.getNamedItem("name") != null) {
            parameter.setName(nnm.getNamedItem("name").getNodeValue());
        }
        if (nnm.getNamedItem("class") != null) {
            parameter.setClassType(nnm.getNamedItem("class").getNodeValue());
        }
        if (nnm.getNamedItem("isForPrompting") != null) {
            parameter.setIsForPrompting(nnm.getNamedItem("isForPrompting").getNodeValue().equalsIgnoreCase("true"));
        }
        if ((children = parameterNode.getChildNodes()) != null) {
            for (int k = 0; k < children.getLength(); ++k) {
                Node child_child;
                int ck;
                NodeList list_child;
                Node nodeChild = children.item(k);
                if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("parameterDescription")) {
                    list_child = nodeChild.getChildNodes();
                    for (ck = 0; ck < list_child.getLength(); ++ck) {
                        child_child = list_child.item(ck);
                        if (child_child.getNodeType() != 4 && child_child.getNodeType() != 3) continue;
                        parameter.setDescription(child_child.getNodeValue());
                    }
                    continue;
                }
                if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("defaultValueExpression")) {
                    list_child = nodeChild.getChildNodes();
                    for (ck = 0; ck < list_child.getLength(); ++ck) {
                        child_child = list_child.item(ck);
                        if (child_child.getNodeType() != 4 && child_child.getNodeType() != 3) continue;
                        parameter.setDefaultValueExpression(child_child.getNodeValue());
                    }
                    continue;
                }
                if (nodeChild.getNodeType() != 1 || !nodeChild.getNodeName().equals("property")) continue;
                parameter.getProperties().add(this.readPropertyElement(nodeChild));
            }
        }
        return parameter;
    }

    private JRField readFieldElement(Node fieldNode) {
        NodeList children;
        JRField field = new JRField("", "java.lang.String");
        field.setDescription("");
        NamedNodeMap nnm = fieldNode.getAttributes();
        if (nnm.getNamedItem("name") != null) {
            field.setName(nnm.getNamedItem("name").getNodeValue());
        }
        if (nnm.getNamedItem("class") != null) {
            field.setClassType(nnm.getNamedItem("class").getNodeValue());
        }
        if ((children = fieldNode.getChildNodes()) != null) {
            for (int k = 0; k < children.getLength(); ++k) {
                Node nodeChild = children.item(k);
                if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("fieldDescription")) {
                    NodeList list_child = nodeChild.getChildNodes();
                    for (int ck = 0; ck < list_child.getLength(); ++ck) {
                        Node child_child = list_child.item(ck);
                        if (child_child.getNodeType() != 4 && child_child.getNodeType() != 3) continue;
                        field.setDescription(child_child.getNodeValue());
                    }
                    continue;
                }
                if (nodeChild.getNodeType() != 1 || !nodeChild.getNodeName().equals("property")) continue;
                field.getProperties().add(this.readPropertyElement(nodeChild));
            }
        }
        return field;
    }

    private SortField readSortFieldElement(Node fieldNode) {
        SortField field = new SortField();
        NamedNodeMap nnm = fieldNode.getAttributes();
        if (nnm.getNamedItem("name") != null) {
            field.setFieldName(nnm.getNamedItem("name").getNodeValue());
        }
        if (nnm.getNamedItem("order") != null) {
            field.setDesc(nnm.getNamedItem("order").getNodeValue().equals("Descending"));
        }
        return field;
    }

    private JRProperty readPropertyElement(Node propertyNode) {
        JRProperty property = new JRProperty();
        NamedNodeMap nnm = propertyNode.getAttributes();
        if (nnm.getNamedItem("name") != null) {
            property.setName(nnm.getNamedItem("name").getNodeValue());
        }
        if (nnm.getNamedItem("value") != null) {
            property.setValue(nnm.getNamedItem("value").getNodeValue());
        }
        return property;
    }

    private JRVariable readVariableElement(Node variableNode) {
        NodeList children;
        JRVariable variable = new JRVariable("", false);
        variable.setResetType("Report");
        variable.setResetGroup("");
        variable.setIncrementType("None");
        variable.setIncrementGroup("");
        variable.setCalculation("Nothing");
        NamedNodeMap nnm = variableNode.getAttributes();
        if (nnm.getNamedItem("name") != null) {
            variable.setName(nnm.getNamedItem("name").getNodeValue());
        }
        if (nnm.getNamedItem("class") != null) {
            variable.setClassType(nnm.getNamedItem("class").getNodeValue());
        }
        if (nnm.getNamedItem("resetType") != null) {
            variable.setResetType(nnm.getNamedItem("resetType").getNodeValue());
        }
        if (nnm.getNamedItem("resetGroup") != null) {
            variable.setResetGroup(nnm.getNamedItem("resetGroup").getNodeValue());
        }
        if (nnm.getNamedItem("calculation") != null) {
            variable.setCalculation(nnm.getNamedItem("calculation").getNodeValue());
        }
        if (nnm.getNamedItem("incrementerFactoryClass") != null) {
            variable.setIncrementerFactoryClass(nnm.getNamedItem("incrementerFactoryClass").getNodeValue());
        }
        if (nnm.getNamedItem("incrementType") != null) {
            variable.setIncrementType(nnm.getNamedItem("incrementType").getNodeValue());
        }
        if (nnm.getNamedItem("incrementGroup") != null) {
            variable.setIncrementGroup(nnm.getNamedItem("incrementGroup").getNodeValue());
        }
        if ((children = variableNode.getChildNodes()) != null) {
            for (int k = 0; k < children.getLength(); ++k) {
                Node child_child;
                int ck;
                NodeList list_child;
                Node nodeChild = children.item(k);
                if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("variableExpression")) {
                    list_child = nodeChild.getChildNodes();
                    for (ck = 0; ck < list_child.getLength(); ++ck) {
                        child_child = list_child.item(ck);
                        if (child_child.getNodeType() != 4 && child_child.getNodeType() != 3) continue;
                        variable.setExpression(child_child.getNodeValue());
                    }
                    continue;
                }
                if (nodeChild.getNodeType() != 1 || !nodeChild.getNodeName().equals("initialValueExpression")) continue;
                list_child = nodeChild.getChildNodes();
                for (ck = 0; ck < list_child.getLength(); ++ck) {
                    child_child = list_child.item(ck);
                    if (child_child.getNodeType() != 4 && child_child.getNodeType() != 3) continue;
                    variable.setInitialValueExpression(child_child.getNodeValue());
                }
            }
        }
        return variable;
    }

    private Measure readMeasureElement(Node measureNode) {
        NodeList children;
        Measure measure = new Measure("");
        NamedNodeMap nnm = measureNode.getAttributes();
        if (nnm.getNamedItem("name") != null) {
            measure.setName(nnm.getNamedItem("name").getNodeValue());
        }
        if (nnm.getNamedItem("class") != null) {
            measure.setClassType(nnm.getNamedItem("class").getNodeValue());
        }
        if (nnm.getNamedItem("calculation") != null) {
            measure.setCalculation(nnm.getNamedItem("calculation").getNodeValue());
        }
        if (nnm.getNamedItem("incrementerFactoryClass") != null) {
            measure.setIncrementerFactoryClass(nnm.getNamedItem("incrementerFactoryClass").getNodeValue());
        }
        if (nnm.getNamedItem("percentageOf") != null) {
            measure.setPercentageOf(nnm.getNamedItem("percentageOf").getNodeValue());
        }
        if (nnm.getNamedItem("percentageCalculatorClass") != null) {
            measure.setPercentageCalculatorClass(nnm.getNamedItem("percentageCalculatorClass").getNodeValue());
        }
        if ((children = measureNode.getChildNodes()) != null) {
            for (int k = 0; k < children.getLength(); ++k) {
                Node nodeChild = children.item(k);
                if (nodeChild.getNodeType() != 1 || !nodeChild.getNodeName().equals("measureExpression")) continue;
                measure.setExpression(ReportReader.readPCDATA(nodeChild));
            }
        }
        return measure;
    }

    private Style readStyle(Node styleNode) {
        return this.readStyle(styleNode, null);
    }

    private Style readStyle(Node styleNode, ConditionedStyle cStyle) {
        Style style = new Style();
        if (cStyle != null) {
            style = cStyle;
        }
        NamedNodeMap nnm = styleNode.getAttributes();
        for (int i = 0; i < Style.JRXMLStyleAttributes.length; ++i) {
            if (nnm.getNamedItem(Style.JRXMLStyleAttributes[i]) == null) continue;
            style.getAttributes().put(Style.JRXMLStyleAttributes[i], nnm.getNamedItem(Style.JRXMLStyleAttributes[i]).getNodeValue());
        }
        NodeList children = styleNode.getChildNodes();
        if (children != null) {
            for (int k = 0; k < children.getLength(); ++k) {
                Node nodeChild = children.item(k);
                if (nodeChild.getNodeType() != 1 || !nodeChild.getNodeName().equals("conditionalStyle")) continue;
                ConditionedStyle childStyle = this.readConditionalStyle(nodeChild);
                style.getConditionedStyles().add(childStyle);
            }
        }
        return style;
    }

    private ConditionedStyle readConditionalStyle(Node styleNode) {
        ConditionedStyle style = new ConditionedStyle();
        NodeList children = styleNode.getChildNodes();
        if (children != null) {
            for (int k = 0; k < children.getLength(); ++k) {
                Node nodeChild = children.item(k);
                if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("conditionExpression")) {
                    style.setCondition(ReportReader.readPCDATA(nodeChild));
                    continue;
                }
                if (nodeChild.getNodeType() != 1 || !nodeChild.getNodeName().equals("style")) continue;
                style = (ConditionedStyle)this.readStyle(nodeChild, style);
            }
        }
        return style;
    }

    private Group readGroupElement(SubDataset ds, Node groupNode, boolean fullRead) {
        NodeList children;
        NamedNodeMap nnm = groupNode.getAttributes();
        Group group = new Group(ds, "" + nnm.getNamedItem("name").getNodeValue());
        if (nnm.getNamedItem("isStartNewColumn") != null) {
            group.setIsStartNewColumn(nnm.getNamedItem("isStartNewColumn").getNodeValue().equals("true"));
        }
        if (nnm.getNamedItem("isStartNewPage") != null) {
            group.setIsStartNewPage(nnm.getNamedItem("isStartNewPage").getNodeValue().equals("true"));
        }
        if (nnm.getNamedItem("isResetPageNumber") != null) {
            group.setIsResetPageNumber(nnm.getNamedItem("isResetPageNumber").getNodeValue().equals("true"));
        }
        if (nnm.getNamedItem("isReprintHeaderOnEachPage") != null) {
            group.setIsReprintHeaderOnEachPage(nnm.getNamedItem("isReprintHeaderOnEachPage").getNodeValue().equals("true"));
        }
        if (nnm.getNamedItem("minHeightToStartNewPage") != null) {
            group.setMinHeightToStartNewPage(Integer.parseInt(nnm.getNamedItem("minHeightToStartNewPage").getNodeValue()));
        }
        if ((children = groupNode.getChildNodes()) != null) {
            for (int k = 0; k < children.getLength(); ++k) {
                NamedNodeMap bandAttributes;
                Node bandNode;
                int ck;
                NodeList list_child;
                Node nodeChild = children.item(k);
                if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("groupExpression")) {
                    list_child = nodeChild.getChildNodes();
                    for (ck = 0; ck < list_child.getLength(); ++ck) {
                        Node child_child = list_child.item(ck);
                        if (child_child.getNodeType() != 4 && child_child.getNodeType() != 3) continue;
                        group.setGroupExpression(child_child.getNodeValue());
                    }
                    continue;
                }
                if (fullRead && nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("groupHeader")) {
                    list_child = nodeChild.getChildNodes();
                    for (ck = 0; ck < list_child.getLength(); ++ck) {
                        bandNode = list_child.item(ck);
                        if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                        bandAttributes = bandNode.getAttributes();
                        if (bandAttributes.getNamedItem("height") != null) {
                            group.getGroupHeader().setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                        }
                        if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                            group.getGroupHeader().setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                        }
                        this.readBandElements(bandNode, group.getGroupHeader());
                    }
                    continue;
                }
                if (!fullRead || nodeChild.getNodeType() != 1 || !nodeChild.getNodeName().equals("groupFooter")) continue;
                list_child = nodeChild.getChildNodes();
                for (ck = 0; ck < list_child.getLength(); ++ck) {
                    bandNode = list_child.item(ck);
                    if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                    bandAttributes = bandNode.getAttributes();
                    if (bandAttributes.getNamedItem("height") != null) {
                        group.getGroupFooter().setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                    }
                    if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                        group.getGroupFooter().setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                    }
                    this.readBandElements(bandNode, group.getGroupFooter());
                }
            }
        }
        return group;
    }

    private void readBandElements(String parentElementGroup, Node bandNode, Band band, ReportElement parentElement, CrosstabReportElement crosstabReportElement, CrosstabCell cell) {
        ReportElement rElement = null;
        Style defualtStyle = this.getReport().getDefaultStyle();
        NodeList list_child = bandNode.getChildNodes();
        for (int ck = 0; ck < list_child.getLength(); ++ck) {
            String name;
            NamedNodeMap subNodeAttributes;
            Node child_child;
            ReportElement re;
            Node child = list_child.item(ck);
            if (child.getNodeType() == 1 && child.getNodeName().equals("printWhenExpression")) {
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    Node child_child2 = childsOfChild.item(c_count);
                    if (child_child2.getNodeType() != 4 && child_child2.getNodeType() != 3) continue;
                    band.setPrintWhenExpression(child_child2.getNodeValue());
                }
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("staticText")) {
                re = new StaticTextReportElement(0, 0, 0, 0);
                ((TextReportElement)re).setIReportFont(this.getReport().getDefaultFont());
                if (defualtStyle != null) {
                    ((TextReportElement)re).setStyle(defualtStyle);
                    ((TextReportElement)re).setStyle(null);
                }
                re.setBand(band);
                re.setCell(cell);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    Node child_child3 = childsOfChild.item(c_count);
                    if (child_child3.getNodeType() == 1 && child_child3.getNodeName().equals("reportElement")) {
                        this.readXMLReportElement(child_child3, re);
                        continue;
                    }
                    if (child_child3.getNodeType() == 1 && child_child3.getNodeName().equals("textElement")) {
                        this.readXMLTextElement(child_child3, (TextReportElement)re);
                        continue;
                    }
                    if (child_child3.getNodeType() == 1 && child_child3.getNodeName().equals("text")) {
                        ((TextReportElement)re).setText(ReportReader.readPCDATA(child_child3, false));
                        continue;
                    }
                    if (child_child3.getNodeType() != 1 || !child_child3.getNodeName().equals("box")) continue;
                    this.readBoxElement(child_child3, (BoxElement)((Object)re));
                }
                re.setPosition(((StaticTextReportElement)re).position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                rElement = re;
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("image")) {
                re = new ImageReportElement(0, 0, 0, 0);
                if (defualtStyle != null) {
                    ((ImageReportElement)re).setStyle(defualtStyle);
                    ((ImageReportElement)re).setStyle(null);
                }
                re.setBand(band);
                re.setCell(cell);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                NamedNodeMap nodeAttributes = child.getAttributes();
                if (nodeAttributes.getNamedItem("isUsingCache") != null) {
                    ((ImageReportElement)re).setIsUsingCache(("" + nodeAttributes.getNamedItem("isUsingCache").getNodeValue()).equals("true"));
                }
                if (nodeAttributes.getNamedItem("isLazy") != null) {
                    ((ImageReportElement)re).setIsLazy(("" + nodeAttributes.getNamedItem("isLazy").getNodeValue()).equals("true"));
                }
                if (nodeAttributes.getNamedItem("onErrorType") != null) {
                    ((ImageReportElement)re).setOnErrorType("" + nodeAttributes.getNamedItem("onErrorType").getNodeValue());
                }
                if (nodeAttributes.getNamedItem("scaleImage") != null) {
                    ((ImageReportElement)re).setScaleImage("" + nodeAttributes.getNamedItem("scaleImage").getNodeValue());
                }
                if (nodeAttributes.getNamedItem("vAlign") != null) {
                    ((ImageReportElement)re).setVerticalAlignment("" + nodeAttributes.getNamedItem("vAlign").getNodeValue());
                }
                if (nodeAttributes.getNamedItem("hAlign") != null) {
                    ((ImageReportElement)re).setHorizontalAlignment("" + nodeAttributes.getNamedItem("hAlign").getNodeValue());
                }
                if (nodeAttributes.getNamedItem("evaluationTime") != null) {
                    ((ImageReportElement)re).setEvaluationTime("" + nodeAttributes.getNamedItem("evaluationTime").getNodeValue());
                }
                if (nodeAttributes.getNamedItem("evaluationGroup") != null) {
                    ((ImageReportElement)re).setEvaluationGroup("" + nodeAttributes.getNamedItem("evaluationGroup").getNodeValue());
                }
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    child_child = childsOfChild.item(c_count);
                    subNodeAttributes = child_child.getAttributes();
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("reportElement")) {
                        this.readXMLReportElement(child_child, re);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("graphicElement")) {
                        if (subNodeAttributes.getNamedItem("pen") != null) {
                            ((GraphicReportElement)re).setGraphicElementPen("" + subNodeAttributes.getNamedItem("pen").getNodeValue());
                        }
                        if (subNodeAttributes.getNamedItem("fill") != null) {
                            re.setPropertyValue("FILL", "" + subNodeAttributes.getNamedItem("fill").getNodeValue());
                        }
                        if (subNodeAttributes.getNamedItem("stretchType") == null) continue;
                        re.setStretchType("" + subNodeAttributes.getNamedItem("stretchType").getNodeValue());
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("imageExpression")) {
                        if (subNodeAttributes.getNamedItem("class") != null) {
                            ((ImageReportElement)re).setImageClass("" + subNodeAttributes.getNamedItem("class").getNodeValue());
                        }
                        ((ImageReportElement)re).setImageExpression(ReportReader.readPCDATA(child_child));
                        ((ImageReportElement)re).setReportDirectory(new File(this.getReport().getFilename()).getParentFile());
                        continue;
                    }
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("box")) continue;
                    this.readBoxElement(child_child, (BoxElement)((Object)re));
                }
                this.readHyperlink(child, (HyperLinkableReportElement)((Object)re));
                re.setPosition(((ImageReportElement)re).position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                if (((ImageReportElement)re).getImageExpression().indexOf("it.businesslogic.ireport.chart.DefaultChartFactory.drawChart(") >= 0) {
                    ChartReportElement chart = new ChartReportElement(re.getPosition().x, re.getPosition().y, re.getWidth(), re.getHeight());
                    chart.setBand(re.getBand());
                    chart.setElementGroup(re.getElementGroup());
                    chart.setParentElement(re.getParentElement());
                    chart.setHyperlinkReferenceExpression(((ImageReportElement)re).getHyperlinkReferenceExpression());
                    chart.setHyperlinkPageExpression(((ImageReportElement)re).getHyperlinkPageExpression());
                    chart.setHyperlinkAnchorExpression(((ImageReportElement)re).getHyperlinkAnchorExpression());
                    chart.setHyperlinkType(((ImageReportElement)re).getHyperlinkType());
                    chart.setBgcolor(re.getBgcolor());
                    chart.setEvaluationGroup(((ImageReportElement)re).getEvaluationGroup());
                    chart.setEvaluationTime(((ImageReportElement)re).getEvaluationTime());
                    chart.setFgcolor(re.getFgcolor());
                    chart.setFill(((GraphicReportElement)re).getFill());
                    chart.setHorizontalAlignment(((ImageReportElement)re).getHorizontalAlignment());
                    chart.setImageClass(((ImageReportElement)re).getImageClass());
                    chart.setImageExpression(((ImageReportElement)re).getImageExpression());
                    chart.setName(re.getName());
                    chart.setPositionType(re.getPositionType());
                    chart.setPrintWhenExpression(re.getPrintWhenExpression());
                    chart.setPrintWhenGroupChanges(re.getPrintWhenGroupChanges());
                    chart.setScaleImage(((ImageReportElement)re).getScaleImage());
                    chart.setStretchType(re.getStretchType());
                    chart.setTransparent(re.getTransparent());
                    chart.setVerticalAlignment(((ImageReportElement)re).getVerticalAlignment());
                    chart.parseProperties(this.getReport().getJRproperties());
                    re = chart;
                }
                if (((ImageReportElement)re).getImageExpression().indexOf("it.businesslogic.ireport.barcode.BcImage.getBarcodeImage(") >= 0) {
                    BarcodeReportElement bc = new BarcodeReportElement(re.getPosition().x, re.getPosition().y, re.getWidth(), re.getHeight());
                    bc.setBand(re.getBand());
                    bc.setCell(cell);
                    bc.setElementGroup(re.getElementGroup());
                    bc.setParentElement(re.getParentElement());
                    bc.setHyperlinkReferenceExpression(((ImageReportElement)re).getHyperlinkReferenceExpression());
                    bc.setHyperlinkPageExpression(((ImageReportElement)re).getHyperlinkPageExpression());
                    bc.setHyperlinkAnchorExpression(((ImageReportElement)re).getHyperlinkAnchorExpression());
                    bc.setHyperlinkType(((ImageReportElement)re).getHyperlinkType());
                    bc.setBgcolor(re.getBgcolor());
                    bc.setEvaluationGroup(((ImageReportElement)re).getEvaluationGroup());
                    bc.setEvaluationTime(((ImageReportElement)re).getEvaluationTime());
                    bc.setFgcolor(re.getFgcolor());
                    bc.setFill(((GraphicReportElement)re).getFill());
                    bc.setHorizontalAlignment(((ImageReportElement)re).getHorizontalAlignment());
                    bc.setImageClass(((ImageReportElement)re).getImageClass());
                    bc.setImageExpression(((ImageReportElement)re).getImageExpression());
                    bc.setName(re.getName());
                    bc.setPositionType(re.getPositionType());
                    bc.setPrintWhenExpression(re.getPrintWhenExpression());
                    bc.setPrintWhenGroupChanges(re.getPrintWhenGroupChanges());
                    bc.setScaleImage(((ImageReportElement)re).getScaleImage());
                    bc.setStretchType(re.getStretchType());
                    bc.setTransparent(re.getTransparent());
                    bc.setVerticalAlignment(((ImageReportElement)re).getVerticalAlignment());
                    re = bc;
                }
                rElement = re;
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("rectangle")) {
                re = new RectangleReportElement(0, 0, 0, 0);
                if (defualtStyle != null) {
                    ((RectangleReportElement)re).setStyle(defualtStyle);
                    ((RectangleReportElement)re).setStyle(null);
                }
                re.setBand(band);
                re.setCell(cell);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                NamedNodeMap nodeAttributes = child.getAttributes();
                if (nodeAttributes.getNamedItem("radius") != null) {
                    ((RectangleReportElement)re).setRadius(Integer.parseInt("" + nodeAttributes.getNamedItem("radius").getNodeValue()));
                }
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    child_child = childsOfChild.item(c_count);
                    subNodeAttributes = child_child.getAttributes();
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("reportElement")) {
                        this.readXMLReportElement(child_child, re);
                        continue;
                    }
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("graphicElement")) continue;
                    if (subNodeAttributes.getNamedItem("pen") != null) {
                        ((GraphicReportElement)re).setGraphicElementPen("" + subNodeAttributes.getNamedItem("pen").getNodeValue());
                    }
                    if (subNodeAttributes.getNamedItem("fill") != null) {
                        re.setPropertyValue("FILL", "" + subNodeAttributes.getNamedItem("fill").getNodeValue());
                    }
                    if (subNodeAttributes.getNamedItem("stretchType") == null) continue;
                    re.setStretchType("" + subNodeAttributes.getNamedItem("stretchType").getNodeValue());
                }
                re.setPosition(((RectangleReportElement)re).position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                rElement = re;
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("line")) {
                re = new LineReportElement(0, 0, 0, 0);
                if (defualtStyle != null) {
                    ((GraphicReportElement)re).setStyle(defualtStyle);
                    ((GraphicReportElement)re).setStyle(null);
                }
                re.setBand(band);
                re.setCell(cell);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                NamedNodeMap nodeAttributes = child.getAttributes();
                if (nodeAttributes.getNamedItem("direction") != null) {
                    ((LineReportElement)re).setDirection("" + nodeAttributes.getNamedItem("direction").getNodeValue());
                }
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    child_child = childsOfChild.item(c_count);
                    subNodeAttributes = child_child.getAttributes();
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("reportElement")) {
                        this.readXMLReportElement(child_child, re);
                        continue;
                    }
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("graphicElement")) continue;
                    if (subNodeAttributes.getNamedItem("pen") != null) {
                        ((GraphicReportElement)re).setGraphicElementPen("" + subNodeAttributes.getNamedItem("pen").getNodeValue());
                    }
                    if (subNodeAttributes.getNamedItem("fill") != null) {
                        re.setPropertyValue("FILL", "" + subNodeAttributes.getNamedItem("fill").getNodeValue());
                    }
                    if (subNodeAttributes.getNamedItem("stretchType") == null) continue;
                    re.setStretchType("" + subNodeAttributes.getNamedItem("stretchType").getNodeValue());
                }
                re.setPosition(((LineReportElement)re).position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                rElement = re;
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("break")) {
                re = new BreakReportElement(0, 0, 0, 0);
                re.setBand(band);
                re.setCell(cell);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                NamedNodeMap nodeAttributes = child.getAttributes();
                if (nodeAttributes.getNamedItem("type") != null) {
                    ((BreakReportElement)re).setType("" + nodeAttributes.getNamedItem("type").getNodeValue());
                }
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    child_child = childsOfChild.item(c_count);
                    subNodeAttributes = child_child.getAttributes();
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("reportElement")) continue;
                    this.readXMLReportElement(child_child, re);
                }
                re.setHeight(0);
                re.setWidth(this.report.getWidth() - this.report.getRightMargin() - this.report.getLeftMargin());
                ((BreakReportElement)re).position.x = 0;
                re.setPosition(((BreakReportElement)re).position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                rElement = re;
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("ellipse")) {
                re = new EllipseReportElement(0, 0, 0, 0);
                if (defualtStyle != null) {
                    ((GraphicReportElement)re).setStyle(defualtStyle);
                    ((GraphicReportElement)re).setStyle(null);
                }
                re.setBand(band);
                re.setCell(cell);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                NamedNodeMap nodeAttributes = child.getAttributes();
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    child_child = childsOfChild.item(c_count);
                    subNodeAttributes = child_child.getAttributes();
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("reportElement")) {
                        this.readXMLReportElement(child_child, re);
                        continue;
                    }
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("graphicElement")) continue;
                    if (subNodeAttributes.getNamedItem("pen") != null) {
                        ((GraphicReportElement)re).setGraphicElementPen("" + subNodeAttributes.getNamedItem("pen").getNodeValue());
                    }
                    if (subNodeAttributes.getNamedItem("fill") != null) {
                        re.setPropertyValue("FILL", "" + subNodeAttributes.getNamedItem("fill").getNodeValue());
                    }
                    if (subNodeAttributes.getNamedItem("stretchType") == null) continue;
                    re.setStretchType("" + subNodeAttributes.getNamedItem("stretchType").getNodeValue());
                }
                re.setPosition(((EllipseReportElement)re).position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                rElement = re;
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("textField")) {
                re = new TextFieldReportElement(0, 0, 0, 0);
                ((TextReportElement)re).setIReportFont(this.getReport().getDefaultFont());
                if (defualtStyle != null) {
                    ((TextFieldReportElement)re).setStyle(defualtStyle);
                    ((TextFieldReportElement)re).setStyle(null);
                }
                re.setBand(band);
                re.setCell(cell);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                NamedNodeMap nodeAttributes = child.getAttributes();
                if (nodeAttributes.getNamedItem("evaluationTime") != null) {
                    ((TextFieldReportElement)re).setEvaluationTime("" + nodeAttributes.getNamedItem("evaluationTime").getNodeValue());
                }
                if (nodeAttributes.getNamedItem("evaluationGroup") != null) {
                    ((TextFieldReportElement)re).setGroup("" + nodeAttributes.getNamedItem("evaluationGroup").getNodeValue());
                }
                if (nodeAttributes.getNamedItem("isStretchWithOverflow") != null) {
                    ((TextFieldReportElement)re).setStretchWithOverflow(nodeAttributes.getNamedItem("isStretchWithOverflow").getNodeValue().equals("true"));
                }
                if (nodeAttributes.getNamedItem("isBlankWhenNull") != null) {
                    ((TextFieldReportElement)re).setBlankWhenNull(nodeAttributes.getNamedItem("isBlankWhenNull").getNodeValue().equals("true"));
                }
                if (nodeAttributes.getNamedItem("pattern") != null) {
                    ((TextFieldReportElement)re).setPattern("" + nodeAttributes.getNamedItem("pattern").getNodeValue());
                }
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    child_child = childsOfChild.item(c_count);
                    subNodeAttributes = child_child.getAttributes();
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("reportElement")) {
                        this.readXMLReportElement(child_child, re);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("textElement")) {
                        this.readXMLTextElement(child_child, (TextReportElement)re);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("textFieldExpression")) {
                        if (subNodeAttributes.getNamedItem("class") != null) {
                            ((TextFieldReportElement)re).setClassExpression("" + subNodeAttributes.getNamedItem("class").getNodeValue());
                        }
                        ((TextReportElement)re).setText(ReportReader.readPCDATA(child_child).trim());
                        continue;
                    }
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("box")) continue;
                    this.readBoxElement(child_child, (BoxElement)((Object)re));
                }
                this.readHyperlink(child, (HyperLinkableReportElement)((Object)re));
                re.setPosition(((TextFieldReportElement)re).position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                rElement = re;
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("frame")) {
                re = new FrameReportElement(0, 0, 0, 0);
                if (defualtStyle != null) {
                    ((FrameReportElement)re).setStyle(defualtStyle);
                    ((FrameReportElement)re).setStyle(null);
                }
                re.setBand(band);
                re.setCell(cell);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                NamedNodeMap nodeAttributes = child.getAttributes();
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    child_child = childsOfChild.item(c_count);
                    subNodeAttributes = child_child.getAttributes();
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("reportElement")) {
                        this.readXMLReportElement(child_child, re);
                        continue;
                    }
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("box")) continue;
                    this.readBoxElement(child_child, (BoxElement)((Object)re));
                }
                re.setPosition(((FrameReportElement)re).position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                rElement = re;
                if (crosstabReportElement != null) {
                    crosstabReportElement.getElements().addElement(rElement);
                } else {
                    this.getReport().getElements().addElement(rElement);
                }
                this.readBandElements("", child, band, re, crosstabReportElement, cell);
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("elementGroup")) {
                String newgroup = this.getReport().createChildGroup(parentElementGroup);
                this.readBandElements(newgroup, child, band, parentElement, crosstabReportElement, cell);
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("subreport")) {
                re = new SubReportElement(0, 0, 0, 0);
                if (defualtStyle != null) {
                    re.setStyle(defualtStyle);
                    re.setStyle(null);
                }
                re.setBand(band);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                NamedNodeMap nodeAttributes = child.getAttributes();
                if (nodeAttributes.getNamedItem("isUsingCache") != null) {
                    ((SubReportElement)re).setIsUsingCache(nodeAttributes.getNamedItem("isUsingCache").getNodeValue().equals("true"));
                }
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    child_child = childsOfChild.item(c_count);
                    subNodeAttributes = child_child.getAttributes();
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("reportElement")) {
                        this.readXMLReportElement(child_child, re);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("parametersMapExpression")) {
                        ((SubReportElement)re).setParametersMapExpression(ReportReader.readPCDATA(child_child));
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("returnValue")) {
                        JRSubreportReturnValue returnValue = new JRSubreportReturnValue();
                        if (subNodeAttributes.getNamedItem("subreportVariable") != null) {
                            returnValue.setSubreportVariable("" + subNodeAttributes.getNamedItem("subreportVariable").getNodeValue());
                        }
                        if (subNodeAttributes.getNamedItem("toVariable") != null) {
                            returnValue.setToVariable("" + subNodeAttributes.getNamedItem("toVariable").getNodeValue());
                        }
                        if (subNodeAttributes.getNamedItem("calculation") != null) {
                            returnValue.setCalculation("" + subNodeAttributes.getNamedItem("calculation").getNodeValue());
                        }
                        if (subNodeAttributes.getNamedItem("incrementerFactoryClass") != null) {
                            returnValue.setIncrementFactoryClass("" + subNodeAttributes.getNamedItem("incrementerFactoryClass").getNodeValue());
                        }
                        ((SubReportElement)re).getReturnValues().addElement(returnValue);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("subreportParameter")) {
                        name = "";
                        if (subNodeAttributes.getNamedItem("name") != null) {
                            name = "" + subNodeAttributes.getNamedItem("name").getNodeValue();
                        }
                        String expression = "";
                        NodeList childsOfChildOfChild = child_child.getChildNodes();
                        for (int c_count_2 = 0; c_count_2 < childsOfChildOfChild.getLength(); ++c_count_2) {
                            Node child_child_child = childsOfChildOfChild.item(c_count_2);
                            if (child_child_child.getNodeType() != 1 || !child_child_child.getNodeName().equals("subreportParameterExpression")) continue;
                            expression = ReportReader.readPCDATA(child_child_child);
                            break;
                        }
                        ((SubReportElement)re).getSubreportParameters().addElement(new JRSubreportParameter(name, expression));
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("connectionExpression")) {
                        ((SubReportElement)re).setConnectionExpression(ReportReader.readPCDATA(child_child));
                        ((SubReportElement)re).setUseConnection(true);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dataSourceExpression")) {
                        ((SubReportElement)re).setDataSourceExpression(ReportReader.readPCDATA(child_child));
                        ((SubReportElement)re).setUseConnection(false);
                        continue;
                    }
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("subreportExpression")) continue;
                    ((SubReportElement)re).setSubreportExpression(ReportReader.readPCDATA(child_child));
                    if (subNodeAttributes.getNamedItem("class") == null) continue;
                    ((SubReportElement)re).setSubreportExpressionClass("" + subNodeAttributes.getNamedItem("class").getNodeValue());
                }
                re.setPosition(((SubReportElement)re).position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                rElement = re;
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("pieChart") || child.getNodeType() == 1 && child.getNodeName().equals("pie3DChart") || child.getNodeType() == 1 && child.getNodeName().equals("barChart") || child.getNodeType() == 1 && child.getNodeName().equals("bar3DChart") || child.getNodeType() == 1 && child.getNodeName().equals("xyBarChart") || child.getNodeType() == 1 && child.getNodeName().equals("stackedBarChart") || child.getNodeType() == 1 && child.getNodeName().equals("stackedBar3DChart") || child.getNodeType() == 1 && child.getNodeName().equals("lineChart") || child.getNodeType() == 1 && child.getNodeName().equals("xyLineChart") || child.getNodeType() == 1 && child.getNodeName().equals("areaChart") || child.getNodeType() == 1 && child.getNodeName().equals("stackedAreaChart") || child.getNodeType() == 1 && child.getNodeName().equals("xyAreaChart") || child.getNodeType() == 1 && child.getNodeName().equals("scatterChart") || child.getNodeType() == 1 && child.getNodeName().equals("bubbleChart") || child.getNodeType() == 1 && child.getNodeName().equals("timeSeriesChart") || child.getNodeType() == 1 && child.getNodeName().equals("highLowChart") || child.getNodeType() == 1 && child.getNodeName().equals("candlestickChart") || child.getNodeType() == 1 && child.getNodeName().equals("meterChart") || child.getNodeType() == 1 && child.getNodeName().equals("thermometerChart") || child.getNodeType() == 1 && child.getNodeName().equals("multiAxisChart")) {
                re = new ChartReportElement2(0, 0, 0, 0);
                if (defualtStyle != null) {
                    ((ChartReportElement2)re).setStyle(defualtStyle);
                    ((ChartReportElement2)re).setStyle(null);
                }
                re.setBand(band);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                this.readChartReportElement(child, (ChartReportElement2)re);
                re.setPosition(((ChartReportElement2)re).position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                rElement = re;
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("crosstab")) {
                re = new CrosstabReportElement(0, 0, 0, 0);
                if (defualtStyle != null) {
                    re.setStyle(defualtStyle);
                    re.setStyle(null);
                }
                re.setBand(band);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                ((CrosstabReportElement)re).setReport(this.getReport());
                NamedNodeMap nodeAttributes = child.getAttributes();
                if (nodeAttributes.getNamedItem("isRepeatColumnHeaders") != null) {
                    ((CrosstabReportElement)re).setRepeatColumnHeaders(nodeAttributes.getNamedItem("isRepeatColumnHeaders").getNodeValue().equals("true"));
                }
                if (nodeAttributes.getNamedItem("isRepeatRowHeaders") != null) {
                    ((CrosstabReportElement)re).setRepeatRowHeaders(nodeAttributes.getNamedItem("isRepeatRowHeaders").getNodeValue().equals("true"));
                }
                if (nodeAttributes.getNamedItem("isRepeatRowHeaders") != null) {
                    try {
                        int columnBreakOffset = Integer.parseInt(nodeAttributes.getNamedItem("columnBreakOffset").getNodeValue());
                        ((CrosstabReportElement)re).setColumnBreakOffset(columnBreakOffset);
                    }
                    catch (Exception ex) {
                        System.out.println("Invalid columnBreakOffset, using default");
                    }
                }
                NodeList childsOfChild = child.getChildNodes();
                block14: for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    CrosstabCell detailCell;
                    child_child = childsOfChild.item(c_count);
                    subNodeAttributes = child_child.getAttributes();
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("reportElement")) {
                        this.readXMLReportElement(child_child, re);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("parametersMapExpression")) {
                        ((CrosstabReportElement)re).setParametersMapExpression(ReportReader.readPCDATA(child_child));
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("crosstabParameter")) {
                        name = "";
                        String clazz = "";
                        if (subNodeAttributes.getNamedItem("name") != null) {
                            name = "" + subNodeAttributes.getNamedItem("name").getNodeValue();
                        }
                        CrosstabParameter cp = new CrosstabParameter(name);
                        if (subNodeAttributes.getNamedItem("class") != null) {
                            clazz = "" + subNodeAttributes.getNamedItem("class").getNodeValue();
                            cp.setClassType(clazz);
                        }
                        String expression = "";
                        NodeList childsOfChildOfChild = child_child.getChildNodes();
                        for (int c_count_2 = 0; c_count_2 < childsOfChildOfChild.getLength(); ++c_count_2) {
                            Node child_child_child = childsOfChildOfChild.item(c_count_2);
                            if (child_child_child.getNodeType() != 1 || !child_child_child.getNodeName().equals("parameterValueExpression")) continue;
                            expression = ReportReader.readPCDATA(child_child_child);
                            cp.setParameterValueExpression(expression);
                            break;
                        }
                        ((CrosstabReportElement)re).getCrosstabParameters().addElement(cp);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("crosstabDataset")) {
                        ((CrosstabReportElement)re).setUseDataset(true);
                        if (subNodeAttributes.getNamedItem("isDataPreSorted") != null) {
                            ((CrosstabReportElement)re).setPreSorted(subNodeAttributes.getNamedItem("isDataPreSorted").getNodeValue().equals("true"));
                        }
                        NodeList childsOfChildOfChild = child_child.getChildNodes();
                        for (int c_count_2 = 0; c_count_2 < childsOfChildOfChild.getLength(); ++c_count_2) {
                            Node child_child_child = childsOfChildOfChild.item(c_count_2);
                            if (child_child_child.getNodeType() != 1 || !child_child_child.getNodeName().equals("dataset")) continue;
                            this.readDataset(child_child_child, ((CrosstabReportElement)re).getDataset());
                            continue block14;
                        }
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("rowGroup")) {
                        this.readCrosstabRowGroup(child_child, (CrosstabReportElement)re);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("columnGroup")) {
                        this.readCrosstabColumnGroup(child_child, (CrosstabReportElement)re);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("measure")) {
                        Measure measure = this.readMeasureElement(child_child);
                        ((CrosstabReportElement)re).getMeasures().add(measure);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("crosstabCell")) {
                        detailCell = new CrosstabCell();
                        this.readCellContents(child_child, detailCell, (CrosstabReportElement)re);
                        detailCell.setType(0);
                        detailCell.setParent((CrosstabReportElement)re);
                        ((CrosstabReportElement)re).getCells().add(detailCell);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("whenNoDataCell")) {
                        detailCell = new CrosstabCell();
                        this.readCellContents(child_child, detailCell, (CrosstabReportElement)re);
                        detailCell.setType(2);
                        detailCell.setParent((CrosstabReportElement)re);
                        ((CrosstabReportElement)re).getCells().add(detailCell);
                        continue;
                    }
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("crosstabHeaderCell")) continue;
                    detailCell = new CrosstabCell();
                    this.readCellContents(child_child, detailCell, (CrosstabReportElement)re);
                    detailCell.setType(3);
                    detailCell.setParent((CrosstabReportElement)re);
                    ((CrosstabReportElement)re).getCells().add(detailCell);
                }
                re.setPosition(((CrosstabReportElement)re).position);
                ((CrosstabReportElement)re).trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                rElement = re;
            }
            if (rElement != null && !(rElement instanceof FrameReportElement)) {
                if (crosstabReportElement != null) {
                    crosstabReportElement.getElements().addElement(rElement);
                } else {
                    this.getReport().getElements().addElement(rElement);
                }
            }
            rElement = null;
        }
    }

    private void readHyperlink(Node elementNode, HyperLinkableReportElement re) {
        NodeList childsOfChild = elementNode.getChildNodes();
        NamedNodeMap nodeAttributes = elementNode.getAttributes();
        if (nodeAttributes.getNamedItem("hyperlinkType") != null) {
            re.setHyperlinkType("" + nodeAttributes.getNamedItem("hyperlinkType").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("hyperlinkTarget") != null) {
            re.setHyperlinkTarget("" + nodeAttributes.getNamedItem("hyperlinkTarget").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("bookmarkLevel") != null) {
            re.setBookmarkLevel(Integer.parseInt(nodeAttributes.getNamedItem("bookmarkLevel").getNodeValue()));
        }
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            NamedNodeMap subNodeAttributes = child_child.getAttributes();
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("hyperlinkParameter")) {
                String name = "";
                if (subNodeAttributes.getNamedItem("name") != null) {
                    name = "" + subNodeAttributes.getNamedItem("name").getNodeValue();
                }
                String expression = "";
                NodeList childsOfChildOfChild = child_child.getChildNodes();
                for (int c_count_2 = 0; c_count_2 < childsOfChildOfChild.getLength(); ++c_count_2) {
                    Node child_child_child = childsOfChildOfChild.item(c_count_2);
                    if (child_child_child.getNodeType() != 1 || !child_child_child.getNodeName().equals("hyperlinkParameterExpression")) continue;
                    expression = ReportReader.readPCDATA(child_child_child);
                    break;
                }
                re.getLinkParameters().add(new JRLinkParameter(name, expression));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("anchorNameExpression")) {
                re.setAnchorNameExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("hyperlinkAnchorExpression")) {
                re.setHyperlinkAnchorExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("hyperlinkPageExpression")) {
                re.setHyperlinkPageExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("hyperlinkReferenceExpression")) {
                re.setHyperlinkReferenceExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("hyperlinkTooltipExpression")) continue;
            re.setTooltipExpression(ReportReader.readPCDATA(child_child));
        }
    }

    private void readCrosstabRowGroup(Node rowGroupXmlNode, CrosstabReportElement re) {
        CrosstabRowGroup group = new CrosstabRowGroup();
        NamedNodeMap nodeAttributes = rowGroupXmlNode.getAttributes();
        if (nodeAttributes.getNamedItem("name") != null) {
            group.setName(nodeAttributes.getNamedItem("name").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("width") != null) {
            try {
                group.setWidth(Integer.parseInt(nodeAttributes.getNamedItem("width").getNodeValue()));
            }
            catch (Exception ex) {
                System.out.println("Invalid width for crosstab row group " + group.getName());
            }
        }
        if (nodeAttributes.getNamedItem("totalPosition") != null) {
            group.setTotalPosition(nodeAttributes.getNamedItem("totalPosition").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("headerPosition") != null) {
            group.setHeaderPosition(nodeAttributes.getNamedItem("headerPosition").getNodeValue());
        }
        re.getRowGroups().add(group);
        NodeList list_child = rowGroupXmlNode.getChildNodes();
        for (int ck = 0; ck < list_child.getLength(); ++ck) {
            CrosstabCell cell;
            Node child = list_child.item(ck);
            NamedNodeMap subNodeAttributes = child.getAttributes();
            if (child.getNodeType() == 1 && child.getNodeName().equals("bucket")) {
                this.readBucket(child, group);
                continue;
            }
            if (child.getNodeType() == 1 && child.getNodeName().equals("crosstabRowHeader")) {
                cell = new CrosstabCell();
                cell.setName(group.getName() + " header");
                this.readCellContents(child, cell, re);
                group.setHeaderCell(cell);
                cell.setType(1);
                cell.setParent(re);
                re.getCells().add(cell);
                continue;
            }
            if (child.getNodeType() != 1 || !child.getNodeName().equals("crosstabTotalRowHeader")) continue;
            cell = new CrosstabCell();
            cell.setName(group.getName() + " total header");
            this.readCellContents(child, cell, re);
            group.setTotalCell(cell);
            cell.setType(1);
            cell.setParent(re);
            re.getCells().add(cell);
        }
        if (group.getHeaderCell() == null) {
            CrosstabCell cell = new CrosstabCell();
            cell.setName(group.getName() + " header");
            cell.setType(1);
            cell.setParent(re);
            cell.setWidth(group.getWidth());
            re.getCells().add(cell);
            group.setHeaderCell(cell);
        }
        if (group.getTotalCell() == null) {
            CrosstabCell cell = new CrosstabCell();
            cell.setType(1);
            cell.setName(group.getName() + " total header");
            cell.setParent(re);
            cell.setWidth(group.getWidth());
            re.getCells().add(cell);
            group.setTotalCell(cell);
        }
    }

    private void readCrosstabColumnGroup(Node columnGroupXmlNode, CrosstabReportElement re) {
        CrosstabColumnGroup group = new CrosstabColumnGroup();
        NamedNodeMap nodeAttributes = columnGroupXmlNode.getAttributes();
        if (nodeAttributes.getNamedItem("name") != null) {
            group.setName(nodeAttributes.getNamedItem("name").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("height") != null) {
            try {
                group.setHeight(Integer.parseInt(nodeAttributes.getNamedItem("height").getNodeValue()));
            }
            catch (Exception ex) {
                System.out.println("Invalid height for crosstab column group " + group.getName());
            }
        }
        if (nodeAttributes.getNamedItem("totalPosition") != null) {
            group.setTotalPosition(nodeAttributes.getNamedItem("totalPosition").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("headerPosition") != null) {
            group.setHeaderPosition(nodeAttributes.getNamedItem("headerPosition").getNodeValue());
        }
        re.getColumnGroups().add(group);
        NodeList list_child = columnGroupXmlNode.getChildNodes();
        for (int ck = 0; ck < list_child.getLength(); ++ck) {
            CrosstabCell cell;
            Node child = list_child.item(ck);
            NamedNodeMap subNodeAttributes = child.getAttributes();
            if (child.getNodeType() == 1 && child.getNodeName().equals("bucket")) {
                this.readBucket(child, group);
                continue;
            }
            if (child.getNodeType() == 1 && child.getNodeName().equals("crosstabColumnHeader")) {
                cell = new CrosstabCell();
                cell.setName(group.getName() + " header");
                this.readCellContents(child, cell, re);
                group.setHeaderCell(cell);
                cell.setType(1);
                cell.setParent(re);
                re.getCells().add(cell);
                continue;
            }
            if (child.getNodeType() != 1 || !child.getNodeName().equals("crosstabTotalColumnHeader")) continue;
            cell = new CrosstabCell();
            cell.setName(group.getName() + " total header");
            this.readCellContents(child, cell, re);
            group.setTotalCell(cell);
            cell.setType(1);
            cell.setParent(re);
            re.getCells().add(cell);
        }
        if (group.getHeaderCell() == null) {
            CrosstabCell cell = new CrosstabCell();
            cell.setName(group.getName() + " header");
            cell.setType(1);
            cell.setParent(re);
            cell.setHeight(group.getHeight());
            re.getCells().add(cell);
            group.setHeaderCell(cell);
        }
        if (group.getTotalCell() == null) {
            CrosstabCell cell = new CrosstabCell();
            cell.setType(1);
            cell.setName(group.getName() + " total header");
            cell.setParent(re);
            cell.setHeight(group.getHeight());
            re.getCells().add(cell);
            group.setTotalCell(cell);
        }
    }

    private void readCellContents(Node cellConetensNode, CrosstabCell cell, CrosstabReportElement re) {
        NamedNodeMap subNodeAttributes;
        Node child;
        int ck;
        NamedNodeMap nodeAttributes = cellConetensNode.getAttributes();
        if (nodeAttributes.getNamedItem("width") != null) {
            try {
                cell.setWidth(Integer.parseInt(nodeAttributes.getNamedItem("width").getNodeValue()));
            }
            catch (Exception ex) {
                System.out.println("Invalid width for crosstab cell");
            }
        }
        if (nodeAttributes.getNamedItem("height") != null) {
            try {
                cell.setHeight(Integer.parseInt(nodeAttributes.getNamedItem("height").getNodeValue()));
            }
            catch (Exception ex) {
                System.out.println("Invalid height for crosstab cell");
            }
        }
        if (nodeAttributes.getNamedItem("rowTotalGroup") != null) {
            cell.setRowTotalGroup(nodeAttributes.getNamedItem("rowTotalGroup").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("columnTotalGroup") != null) {
            cell.setColumnTotalGroup(nodeAttributes.getNamedItem("columnTotalGroup").getNodeValue());
        }
        Node cellContentsElementNode = null;
        NodeList list_child = cellConetensNode.getChildNodes();
        for (ck = 0; ck < list_child.getLength(); ++ck) {
            child = list_child.item(ck);
            subNodeAttributes = child.getAttributes();
            if (child.getNodeType() != 1 || !child.getNodeName().equals("cellContents")) continue;
            cellContentsElementNode = child;
            if (subNodeAttributes.getNamedItem("style") != null) {
                String sname = subNodeAttributes.getNamedItem("style").getNodeValue();
                for (int j = 0; j < this.getReport().getStyles().size(); ++j) {
                    Style sparent = (Style)this.getReport().getStyles().elementAt(j);
                    if (!sparent.getName().equals(sname)) continue;
                    cell.setStyle(sparent);
                    break;
                }
            }
            if (subNodeAttributes.getNamedItem("backcolor") != null) {
                this.getReport();
                cell.setBackcolor(Report.decodeColor(subNodeAttributes.getNamedItem("backcolor").getNodeValue()));
            }
            if (subNodeAttributes.getNamedItem("mode") == null) continue;
            cell.setMode(subNodeAttributes.getNamedItem("mode").getNodeValue());
        }
        if (cellContentsElementNode != null) {
            list_child = cellContentsElementNode.getChildNodes();
            for (ck = 0; ck < list_child.getLength(); ++ck) {
                child = list_child.item(ck);
                subNodeAttributes = child.getAttributes();
                if (child.getNodeType() != 1 || !child.getNodeName().equals("box")) continue;
                this.readBoxElement(child, cell);
            }
        }
        this.readBandElements("", cellContentsElementNode, null, null, re, cell);
    }

    private void readBucket(Node bucketXmlNode, CrosstabGroup grp) {
        NamedNodeMap nodeAttributes = bucketXmlNode.getAttributes();
        if (nodeAttributes.getNamedItem("order") != null) {
            grp.setBucketOrder(nodeAttributes.getNamedItem("order").getNodeValue());
        }
        NodeList list_child = bucketXmlNode.getChildNodes();
        for (int ck = 0; ck < list_child.getLength(); ++ck) {
            Node child = list_child.item(ck);
            NamedNodeMap subNodeAttributes = child.getAttributes();
            if (child.getNodeType() == 1 && child.getNodeName().equals("bucketExpression")) {
                if (subNodeAttributes.getNamedItem("class") != null) {
                    grp.setBucketExpressionClass(subNodeAttributes.getNamedItem("class").getNodeValue());
                }
                grp.setBucketExpression(ReportReader.readPCDATA(child));
                continue;
            }
            if (child.getNodeType() != 1 || !child.getNodeName().equals("comparatorExpression")) continue;
            grp.setBucketComparatorExpression(ReportReader.readPCDATA(child));
        }
    }

    private void readChartElement(Node xmlChart, ChartReportElement2 re) {
        NamedNodeMap nodeAttributes = xmlChart.getAttributes();
        if (nodeAttributes.getNamedItem("isShowLegend") != null) {
            re.getChart().setShowLegend(nodeAttributes.getNamedItem("isShowLegend").getNodeValue().equals("true"));
        }
        if (nodeAttributes.getNamedItem("evaluationTime") != null) {
            re.setEvaluationTime(nodeAttributes.getNamedItem("evaluationTime").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("evaluationGroup") != null) {
            re.setEvaluationGroup(nodeAttributes.getNamedItem("evaluationGroup").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("customizerClass") != null) {
            re.getChart().setCustomizerClass(nodeAttributes.getNamedItem("customizerClass").getNodeValue());
        }
        NodeList childsOfChild = xmlChart.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("printWhenExpression")) {
                re.setPrintWhenExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("reportElement")) {
                this.readXMLReportElement(child_child, re);
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("box")) {
                this.readBoxElement(child_child, re);
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("chartTitle")) {
                this.readChartTitleElement(child_child, re);
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("chartSubtitle")) {
                this.readChartSubTitleElement(child_child, re);
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("chartLegend")) continue;
            this.readChartLegendElement(child_child, re);
        }
        this.readHyperlink(xmlChart, re);
    }

    private void readChartTitleElement(Node xmlElement, ChartReportElement2 re) {
        NamedNodeMap nodeAttributes = xmlElement.getAttributes();
        if (nodeAttributes.getNamedItem("position") != null) {
            re.getChart().getTitle().setPosition(nodeAttributes.getNamedItem("position").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("color") != null) {
            re.getChart().getTitle().setColor(ReportReader.decodeColor("" + nodeAttributes.getNamedItem("color").getNodeValue()));
        }
        NodeList childsOfChild = xmlElement.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("titleExpression")) {
                re.getChart().getTitle().setTitleExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("font")) continue;
            re.getChart().getTitle().setFont(this.readFontElement(child_child));
        }
    }

    private void readChartLegendElement(Node xmlElement, ChartReportElement2 re) {
        NamedNodeMap nodeAttributes = xmlElement.getAttributes();
        if (nodeAttributes.getNamedItem("textColor") != null) {
            re.getChart().getLegend().setTextColor(ReportReader.decodeColor("" + nodeAttributes.getNamedItem("textColor").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("backgroundColor") != null) {
            re.getChart().getLegend().setBackgroundColor(ReportReader.decodeColor("" + nodeAttributes.getNamedItem("backgroundColor").getNodeValue()));
        }
        NodeList childsOfChild = xmlElement.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("font")) continue;
            re.getChart().getLegend().setFont(this.readFontElement(child_child));
        }
    }

    private IReportFont readFontElement(Node xmlElement) {
        NamedNodeMap nnm = xmlElement.getAttributes();
        IReportFont font = null;
        if (nnm.getNamedItem("reportFont") != null && (font = this.getReport().getReportFontByName(nnm.getNamedItem("reportFont").getNodeValue())) != null) {
            font = (IReportFont)font.clone();
            font.setReportFont(nnm.getNamedItem("reportFont").getNodeValue());
        }
        if (font == null) {
            font = this.getReport().getDefaultFont() != null ? (IReportFont)this.getReport().getDefaultFont().clone() : new IReportFont();
        }
        for (int kkk = 0; kkk < nnm.getLength(); ++kkk) {
            String propName = nnm.item(kkk).getNodeName();
            String propValue = nnm.item(kkk).getNodeValue();
            if (propName == null || propValue == null) continue;
            if (propName.equals("fontName")) {
                font.setFontName(propValue);
                continue;
            }
            if (propName.equals("pdfFontName")) {
                font.setPDFFontName(propValue);
                continue;
            }
            if (propName.equals("size")) {
                font.setFontSize(Integer.parseInt("" + propValue));
                continue;
            }
            if (propName.equals("isBold")) {
                font.setBold(new String("" + propValue).equalsIgnoreCase("true"));
                continue;
            }
            if (propName.equals("isItalic")) {
                font.setItalic(new String("" + propValue).equalsIgnoreCase("true"));
                continue;
            }
            if (propName.equals("isUnderline")) {
                font.setUnderline(new String("" + propValue).equalsIgnoreCase("true"));
                continue;
            }
            if (propName.equals("isStrikeThrough")) {
                font.setStrikeTrought(new String("" + propValue).equalsIgnoreCase("true"));
                continue;
            }
            if (propName.equals("isPdfEmbedded")) {
                font.setPdfEmbedded(new String("" + propValue).equalsIgnoreCase("true"));
                continue;
            }
            if (!propName.equals("pdfEncoding")) continue;
            font.setPdfEncoding("" + propValue);
        }
        return font;
    }

    private void readDataset(Node xmlNode, ChartReportElement2 re) {
        this.readDataset(xmlNode, re.getChart().getDataset());
    }

    private void readDataset(Node xmlNode, Dataset dataset) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        if (nodeAttributes.getNamedItem("resetType") != null) {
            dataset.setResetType(nodeAttributes.getNamedItem("resetType").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("resetGroup") != null) {
            dataset.setResetGroup(nodeAttributes.getNamedItem("resetGroup").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("incrementType") != null) {
            dataset.setIncrementType(nodeAttributes.getNamedItem("incrementType").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("incrementGroup") != null) {
            dataset.setIncrementGroup(nodeAttributes.getNamedItem("incrementGroup").getNodeValue());
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            NamedNodeMap subNodeAttributes = child_child.getAttributes();
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("incrementWhenExpression")) {
                dataset.setIncrementWhenExpression(ReportReader.readPCDATA(child_child));
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("datasetRun") || subNodeAttributes.getNamedItem("subDataset") == null) continue;
            String name = subNodeAttributes.getNamedItem("subDataset").getNodeValue();
            Enumeration enum_datasets = this.getReport().getSubDatasets().elements();
            while (enum_datasets.hasMoreElements()) {
                SubDataset subDataset = (SubDataset)enum_datasets.nextElement();
                if (!subDataset.getName().equals(name)) continue;
                dataset.setSubDataset(subDataset);
                break;
            }
            NodeList childsOfchild_child = child_child.getChildNodes();
            for (int c_count2 = 0; c_count2 < childsOfchild_child.getLength(); ++c_count2) {
                Node child_child2 = childsOfchild_child.item(c_count2);
                NamedNodeMap subNodeAttributes2 = child_child2.getAttributes();
                if (child_child2.getNodeType() == 1 && child_child2.getNodeName().equals("parametersMapExpression")) {
                    dataset.setParametersMapExpression(ReportReader.readPCDATA(child_child2));
                    continue;
                }
                if (child_child2.getNodeType() == 1 && child_child2.getNodeName().equals("datasetParameter")) {
                    name = "";
                    if (subNodeAttributes2.getNamedItem("name") != null) {
                        name = "" + subNodeAttributes2.getNamedItem("name").getNodeValue();
                    }
                    String expression = "";
                    NodeList childsOfChildOfChild = child_child2.getChildNodes();
                    for (int c_count_2 = 0; c_count_2 < childsOfChildOfChild.getLength(); ++c_count_2) {
                        Node child_child_child = childsOfChildOfChild.item(c_count_2);
                        if (child_child_child.getNodeType() != 1 || !child_child_child.getNodeName().equals("datasetParameterExpression")) continue;
                        expression = ReportReader.readPCDATA(child_child_child);
                        break;
                    }
                    dataset.getSubreportParameters().addElement(new JRSubreportParameter(name, expression));
                    continue;
                }
                if (child_child2.getNodeType() == 1 && child_child2.getNodeName().equals("connectionExpression")) {
                    dataset.setConnectionExpression(ReportReader.readPCDATA(child_child2));
                    dataset.setUseConnection(true);
                    continue;
                }
                if (child_child2.getNodeType() != 1 || !child_child2.getNodeName().equals("dataSourceExpression")) continue;
                dataset.setDataSourceExpression(ReportReader.readPCDATA(child_child2));
                dataset.setUseConnection(false);
            }
        }
    }

    private void readSectionItemHyperlink(Node elementNode, SectionItemHyperlink sih) {
        NodeList childsOfChild = elementNode.getChildNodes();
        NamedNodeMap nodeAttributes = elementNode.getAttributes();
        if (nodeAttributes.getNamedItem("hyperlinkType") != null) {
            sih.setHyperlinkType("" + nodeAttributes.getNamedItem("hyperlinkType").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("hyperlinkTarget") != null) {
            sih.setHyperlinkTarget("" + nodeAttributes.getNamedItem("hyperlinkTarget").getNodeValue());
        }
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            NamedNodeMap subNodeAttributes = child_child.getAttributes();
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("hyperlinkParameter")) {
                String name = "";
                if (subNodeAttributes.getNamedItem("name") != null) {
                    name = "" + subNodeAttributes.getNamedItem("name").getNodeValue();
                }
                String expression = "";
                NodeList childsOfChildOfChild = child_child.getChildNodes();
                for (int c_count_2 = 0; c_count_2 < childsOfChildOfChild.getLength(); ++c_count_2) {
                    Node child_child_child = childsOfChildOfChild.item(c_count_2);
                    if (child_child_child.getNodeType() != 1 || !child_child_child.getNodeName().equals("hyperlinkParameterExpression")) continue;
                    expression = ReportReader.readPCDATA(child_child_child);
                    break;
                }
                sih.getHyperlinkParameters().add(new JRLinkParameter(name, expression));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("hyperlinkAnchorExpression")) {
                sih.setHyperlinkAnchorExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("hyperlinkPageExpression")) {
                sih.setHyperlinkPageExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("hyperlinkReferenceExpression")) {
                sih.setHyperlinkReferenceExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("hyperlinkTooltipExpression")) continue;
            sih.setHyperlinkTooltipExpression(ReportReader.readPCDATA(child_child));
        }
    }

    private void readPieDataset(Node xmlNode, ChartReportElement2 re) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dataset")) {
                this.readDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("keyExpression")) {
                ((PieDataset)re.getChart().getDataset()).setKeyExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("valueExpression")) {
                ((PieDataset)re.getChart().getDataset()).setValueExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("labelExpression")) {
                ((PieDataset)re.getChart().getDataset()).setLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("sectionHyperlink")) continue;
            this.readSectionItemHyperlink(child_child, ((PieDataset)re.getChart().getDataset()).getSectionHyperLink());
        }
    }

    private void readCategoryDataset(Node xmlNode, ChartReportElement2 re) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        CategoryDataset cd = new CategoryDataset();
        re.getChart().setDataset(cd);
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dataset")) {
                this.readDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("categorySeries")) continue;
            CategorySeries cs = this.readCategorySeries(child_child);
            cd.getCategorySeries().add(cs);
        }
    }

    private void readTimePeriodDataset(Node xmlNode, ChartReportElement2 re) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        TimePeriodDataset cd = new TimePeriodDataset();
        re.getChart().setDataset(cd);
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dataset")) {
                this.readDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("timePeriodSeries")) continue;
            TimePeriodSeries cs = this.readTimePeriodSeries(child_child);
            cd.getTimePeriodSeries().add(cs);
        }
    }

    private void readXYDataset(Node xmlNode, ChartReportElement2 re) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        XYDataset cd = new XYDataset();
        re.getChart().setDataset(cd);
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dataset")) {
                this.readDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("xySeries")) continue;
            XYSeries cs = this.readXYSeries(child_child);
            cd.getXYSeries().add(cs);
        }
    }

    private void readXYZDataset(Node xmlNode, ChartReportElement2 re) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        XYZDataset cd = new XYZDataset();
        re.getChart().setDataset(cd);
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dataset")) {
                this.readDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("xyzSeries")) continue;
            XYZSeries cs = this.readXYZSeries(child_child);
            cd.getXYZSeries().add(cs);
        }
    }

    private void readTimeSeriesDataset(Node xmlNode, ChartReportElement2 re) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        NodeList childsOfChild = xmlNode.getChildNodes();
        TimeSeriesDataset cd = new TimeSeriesDataset();
        re.getChart().setDataset(cd);
        if (nodeAttributes.getNamedItem("timePeriod") != null) {
            cd.setTimePeriod(nodeAttributes.getNamedItem("timePeriod").getNodeValue());
        }
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dataset")) {
                this.readDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("timeSeries")) continue;
            TimeSeries cs = this.readTimeSeries(child_child);
            cd.getTimeSeries().add(cs);
        }
    }

    private void readHighLowDataset(Node xmlNode, ChartReportElement2 re) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        HighLowDataset cd = new HighLowDataset();
        re.getChart().setDataset(cd);
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dataset")) {
                this.readDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("seriesExpression")) {
                cd.setSeriesExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dateExpression")) {
                cd.setDateExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("highExpression")) {
                cd.setHighExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("lowExpression")) {
                cd.setLowExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("openExpression")) {
                cd.setOpenExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("closeExpression")) {
                cd.setCloseExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("volumeExpression")) {
                cd.setVolumeExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("itemHyperlink")) continue;
            this.readSectionItemHyperlink(child_child, cd.getItemHyperLink());
        }
    }

    private void readValueDataset(Node xmlNode, ChartReportElement2 re) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        ValueDataset cd = new ValueDataset();
        re.getChart().setDataset(cd);
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dataset")) {
                this.readDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("valueExpression")) continue;
            cd.setValueExpression(ReportReader.readPCDATA(child_child));
        }
    }

    private CategorySeries readCategorySeries(Node xmlNode) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        CategorySeries cs = new CategorySeries();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("seriesExpression")) {
                cs.setSeriesExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("categoryExpression")) {
                cs.setCategoryExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("valueExpression")) {
                cs.setValueExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("labelExpression")) {
                cs.setLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("itemHyperlink")) continue;
            this.readSectionItemHyperlink(child_child, cs.getSectionItemHyperlink());
        }
        return cs;
    }

    private TimePeriodSeries readTimePeriodSeries(Node xmlNode) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        TimePeriodSeries cs = new TimePeriodSeries();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("seriesExpression")) {
                cs.setSeriesExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("startDateExpression")) {
                cs.setStartDateExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("endDateExpression")) {
                cs.setEndDateExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("valueExpression")) {
                cs.setValueExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("labelExpression")) {
                cs.setLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("itemHyperlink")) continue;
            this.readSectionItemHyperlink(child_child, cs.getSectionItemHyperlink());
        }
        return cs;
    }

    private TimeSeries readTimeSeries(Node xmlNode) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        TimeSeries cs = new TimeSeries();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("seriesExpression")) {
                cs.setSeriesExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("timePeriodExpression")) {
                cs.setTimePeriodExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("valueExpression")) {
                cs.setValueExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("labelExpression")) {
                cs.setLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("itemHyperlink")) continue;
            this.readSectionItemHyperlink(child_child, cs.getSectionItemHyperlink());
        }
        return cs;
    }

    private XYSeries readXYSeries(Node xmlNode) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        XYSeries cs = new XYSeries();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("seriesExpression")) {
                cs.setSeriesExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("xValueExpression")) {
                cs.setXValueExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("yValueExpression")) {
                cs.setYValueExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("labelExpression")) {
                cs.setLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("itemHyperlink")) continue;
            this.readSectionItemHyperlink(child_child, cs.getSectionItemHyperlink());
        }
        return cs;
    }

    private XYZSeries readXYZSeries(Node xmlNode) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        XYZSeries cs = new XYZSeries();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("seriesExpression")) {
                cs.setSeriesExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("xValueExpression")) {
                cs.setXValueExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("yValueExpression")) {
                cs.setYValueExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("zValueExpression")) {
                cs.setZValueExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("itemHyperlink")) continue;
            this.readSectionItemHyperlink(child_child, cs.getSectionItemHyperlink());
        }
        return cs;
    }

    private void readPiePlot(Node xmlNode, PiePlot plot) {
        this.readPlot(xmlNode, plot);
    }

    private void readPie3DPlot(Node xmlNode, Pie3DPlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        if (nodeAttributes.getNamedItem("depthFactor") != null) {
            plot.setDepthFactor(Double.parseDouble(nodeAttributes.getNamedItem("depthFactor").getNodeValue()));
        }
        this.readPlot(xmlNode, plot);
    }

    private void readBarPlot(Node xmlNode, BarPlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        if (nodeAttributes.getNamedItem("isShowLabels") != null) {
            plot.setShowLabels(nodeAttributes.getNamedItem("isShowLabels").getNodeValue().equals("true"));
        }
        if (nodeAttributes.getNamedItem("isShowTickMarks") != null) {
            plot.setShowTickMarks(nodeAttributes.getNamedItem("isShowTickMarks").getNodeValue().equals("true"));
        }
        if (nodeAttributes.getNamedItem("isShowTickLabels") != null) {
            plot.setShowTickLabels(nodeAttributes.getNamedItem("isShowTickLabels").getNodeValue().equals("true"));
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("categoryAxisLabelExpression")) {
                plot.setCategoryAxisLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("valueAxisLabelExpression")) {
                plot.setValueAxisLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("categoryAxisFormat")) {
                plot.setCategoryAxisFormat(this.readAxisFormat(this.findChild(child_child, "axisFormat")));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("valueAxisFormat")) continue;
            plot.setValueAxisFormat(this.readAxisFormat(this.findChild(child_child, "axisFormat")));
        }
    }

    private void readBar3DPlot(Node xmlNode, Bar3DPlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        if (nodeAttributes.getNamedItem("isShowLabels") != null) {
            plot.setShowLabels(nodeAttributes.getNamedItem("isShowLabels").getNodeValue().equals("true"));
        }
        if (nodeAttributes.getNamedItem("xOffset") != null) {
            plot.setXOffset(Double.parseDouble(nodeAttributes.getNamedItem("xOffset").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("yOffset") != null) {
            plot.setYOffset(Double.parseDouble(nodeAttributes.getNamedItem("yOffset").getNodeValue()));
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("categoryAxisLabelExpression")) {
                plot.setCategoryAxisLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("valueAxisLabelExpression")) {
                plot.setValueAxisLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("categoryAxisFormat")) {
                plot.setCategoryAxisFormat(this.readAxisFormat(this.findChild(child_child, "axisFormat")));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("valueAxisFormat")) continue;
            plot.setValueAxisFormat(this.readAxisFormat(this.findChild(child_child, "axisFormat")));
        }
    }

    private void readLinePlot(Node xmlNode, LinePlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        if (nodeAttributes.getNamedItem("isShowLines") != null) {
            plot.setShowLines(nodeAttributes.getNamedItem("isShowLines").getNodeValue().equals("true"));
        }
        if (nodeAttributes.getNamedItem("isShowShapes") != null) {
            plot.setShowShapes(nodeAttributes.getNamedItem("isShowShapes").getNodeValue().equals("true"));
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("categoryAxisLabelExpression")) {
                plot.setCategoryAxisLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("valueAxisLabelExpression")) {
                plot.setValueAxisLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("categoryAxisFormat")) {
                plot.setCategoryAxisFormat(this.readAxisFormat(this.findChild(child_child, "axisFormat")));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("valueAxisFormat")) continue;
            plot.setValueAxisFormat(this.readAxisFormat(this.findChild(child_child, "axisFormat")));
        }
    }

    private AxisFormat readAxisFormat(Node xmlNode) {
        AxisFormat axisFormat = new AxisFormat();
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        if (nodeAttributes.getNamedItem("labelColor") != null) {
            axisFormat.setLabelColor(ReportReader.decodeColor("" + nodeAttributes.getNamedItem("labelColor").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("tickLabelColor") != null) {
            axisFormat.setTickLabelColor(ReportReader.decodeColor("" + nodeAttributes.getNamedItem("tickLabelColor").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("axisLineColor") != null) {
            axisFormat.setAxisLineColor(ReportReader.decodeColor("" + nodeAttributes.getNamedItem("axisLineColor").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("tickLabelMask") != null) {
            axisFormat.setTickLabelMask("" + nodeAttributes.getNamedItem("tickLabelMask").getNodeValue());
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node fontNode;
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("labelFont")) {
                fontNode = this.findChild(child_child, "font");
                if (fontNode == null) continue;
                axisFormat.setLabelFont(this.readFontElement(fontNode));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("tickLabelFont") || (fontNode = this.findChild(child_child, "font")) == null) continue;
            axisFormat.setTickLabelFont(this.readFontElement(fontNode));
        }
        return axisFormat;
    }

    private void readAreaPlot(Node xmlNode, AreaPlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("categoryAxisLabelExpression")) {
                plot.setCategoryAxisLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("valueAxisLabelExpression")) {
                plot.setValueAxisLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("categoryAxisFormat")) {
                plot.setCategoryAxisFormat(this.readAxisFormat(this.findChild(child_child, "axisFormat")));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("valueAxisFormat")) continue;
            plot.setValueAxisFormat(this.readAxisFormat(this.findChild(child_child, "axisFormat")));
        }
    }

    private void readScatterPlot(Node xmlNode, ScatterPlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        if (nodeAttributes.getNamedItem("isShowLines") != null) {
            plot.setShowLines(nodeAttributes.getNamedItem("isShowLines").getNodeValue().equals("true"));
        }
        if (nodeAttributes.getNamedItem("isShowShapes") != null) {
            plot.setShowShapes(nodeAttributes.getNamedItem("isShowShapes").getNodeValue().equals("true"));
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("xAxisLabelExpression")) {
                plot.setXAxisLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("yAxisLabelExpression")) {
                plot.setYAxisLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("xAxisFormat")) {
                plot.setXAxisFormat(this.readAxisFormat(this.findChild(child_child, "axisFormat")));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("yAxisFormat")) continue;
            plot.setYAxisFormat(this.readAxisFormat(this.findChild(child_child, "axisFormat")));
        }
    }

    private void readBubblePlot(Node xmlNode, BubblePlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        if (nodeAttributes.getNamedItem("scaleType") != null) {
            plot.setScaleType(nodeAttributes.getNamedItem("scaleType").getNodeValue());
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("xAxisLabelExpression")) {
                plot.setXAxisLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("yAxisLabelExpression")) {
                plot.setYAxisLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("xAxisFormat")) {
                plot.setXAxisFormat(this.readAxisFormat(this.findChild(child_child, "axisFormat")));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("yAxisFormat")) continue;
            plot.setYAxisFormat(this.readAxisFormat(this.findChild(child_child, "axisFormat")));
        }
    }

    private void readTimeSeriesPlot(Node xmlNode, TimeSeriesPlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        if (nodeAttributes.getNamedItem("isShowLines") != null) {
            plot.setShowLines(nodeAttributes.getNamedItem("isShowLines").getNodeValue().equals("true"));
        }
        if (nodeAttributes.getNamedItem("isShowShapes") != null) {
            plot.setShowShapes(nodeAttributes.getNamedItem("isShowShapes").getNodeValue().equals("true"));
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("timeAxisLabelExpression")) {
                plot.setTimeAxisLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("valueAxisLabelExpression")) {
                plot.setValueAxisLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("timeAxisFormat")) {
                plot.setTimeAxisFormat(this.readAxisFormat(this.findChild(child_child, "axisFormat")));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("valueAxisFormat")) continue;
            plot.setValueAxisFormat(this.readAxisFormat(this.findChild(child_child, "axisFormat")));
        }
    }

    private void readHighLowPlot(Node xmlNode, HighLowPlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        if (nodeAttributes.getNamedItem("isShowCloseTicks") != null) {
            plot.setShowCloseTicks(nodeAttributes.getNamedItem("isShowCloseTicks").getNodeValue().equals("true"));
        }
        if (nodeAttributes.getNamedItem("isShowOpenTicks") != null) {
            plot.setShowOpenTicks(nodeAttributes.getNamedItem("isShowOpenTicks").getNodeValue().equals("true"));
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("timeAxisLabelExpression")) {
                plot.setTimeAxisLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("valueAxisLabelExpression")) {
                plot.setValueAxisLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("timeAxisFormat")) {
                plot.setTimeAxisFormat(this.readAxisFormat(this.findChild(child_child, "axisFormat")));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("valueAxisFormat")) continue;
            plot.setValueAxisFormat(this.readAxisFormat(this.findChild(child_child, "axisFormat")));
        }
    }

    private void readCandlestickPlot(Node xmlNode, CandlestickPlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        if (nodeAttributes.getNamedItem("isShowVolume") != null) {
            plot.setShowVolume(nodeAttributes.getNamedItem("isShowVolume").getNodeValue().equals("true"));
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("timeAxisLabelExpression")) {
                plot.setTimeAxisLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("valueAxisLabelExpression")) {
                plot.setValueAxisLabelExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("timeAxisFormat")) {
                plot.setTimeAxisFormat(this.readAxisFormat(this.findChild(child_child, "axisFormat")));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("valueAxisFormat")) continue;
            plot.setValueAxisFormat(this.readAxisFormat(this.findChild(child_child, "axisFormat")));
        }
    }

    private void readMeterPlot(Node xmlNode, MeterPlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        if (nodeAttributes.getNamedItem("shape") != null) {
            plot.setShape(nodeAttributes.getNamedItem("shape").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("angle") != null) {
            try {
                plot.setAngle(Integer.parseInt(nodeAttributes.getNamedItem("angle").getNodeValue() + ""));
            }
            catch (Exception ex) {
                MainFrame.getMainInstance().logOnConsole(I18n.getString("reportReader.notValidAngle", "Not valid angle value for the MeterPlot tag."));
            }
        }
        if (nodeAttributes.getNamedItem("units") != null) {
            plot.setUnits(nodeAttributes.getNamedItem("units").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("tickInterval") != null) {
            try {
                plot.setTickInterval(Double.parseDouble(nodeAttributes.getNamedItem("tickInterval").getNodeValue() + ""));
            }
            catch (Exception ex) {
                MainFrame.getMainInstance().logOnConsole(I18n.getString("reportReader.notValidTickInterval", "Not valid tickInterval value for the MeterPlot tag."));
            }
        }
        if (nodeAttributes.getNamedItem("meterColor") != null) {
            plot.setMeterColor(ReportReader.decodeColor("" + nodeAttributes.getNamedItem("meterColor").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("needleColor") != null) {
            plot.setNeedleColor(ReportReader.decodeColor("" + nodeAttributes.getNamedItem("needleColor").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("tickColor") != null) {
            plot.setTickColor(ReportReader.decodeColor("" + nodeAttributes.getNamedItem("tickColor").getNodeValue()));
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("valueDisplay")) {
                plot.setValueDisplay(this.readValueDisplay(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dataRange")) {
                plot.setDataRange(this.readDataRange(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("meterInterval")) continue;
            plot.getMeterIntervals().add(this.readMeterInterval(child_child));
        }
    }

    private void readThermometerPlot(Node xmlNode, ThermometerPlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        if (nodeAttributes.getNamedItem("valueLocation") != null) {
            plot.setValueLocation(nodeAttributes.getNamedItem("valueLocation").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("isShowValueLines") != null) {
            plot.setShowValueLines(nodeAttributes.getNamedItem("isShowValueLines").getNodeValue().equals("true"));
        }
        if (nodeAttributes.getNamedItem("mercuryColor") != null) {
            plot.setMercuryColor(ReportReader.decodeColor("" + nodeAttributes.getNamedItem("mercuryColor").getNodeValue()));
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("valueDisplay")) {
                plot.setValueDisplay(this.readValueDisplay(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dataRange")) {
                plot.setDataRange(this.readDataRange(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("lowRange")) {
                plot.setLowRange(this.readDataRange(this.findChild(child_child, "dataRange")));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("mediumRange")) {
                plot.setMediumRange(this.readDataRange(this.findChild(child_child, "dataRange")));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("highRange")) continue;
            plot.setHighRange(this.readDataRange(this.findChild(child_child, "dataRange")));
        }
    }

    private ValueDisplay readValueDisplay(Node xmlNode) {
        ValueDisplay valueDisplay = new ValueDisplay();
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        if (nodeAttributes.getNamedItem("color") != null) {
            valueDisplay.setColor(ReportReader.decodeColor("" + nodeAttributes.getNamedItem("color").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("mask") != null) {
            valueDisplay.setMask("" + nodeAttributes.getNamedItem("mask").getNodeValue());
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("font")) continue;
            valueDisplay.setFont(this.readFontElement(child_child));
        }
        return valueDisplay;
    }

    private DataRange readDataRange(Node xmlNode) {
        DataRange dataRange = new DataRange();
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("lowExpression")) {
                dataRange.setLowExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("highExpression")) continue;
            dataRange.setHighExpression(ReportReader.readPCDATA(child_child));
        }
        return dataRange;
    }

    private MeterInterval readMeterInterval(Node xmlNode) {
        MeterInterval meterInterval = new MeterInterval();
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        if (nodeAttributes.getNamedItem("label") != null) {
            meterInterval.setLabel("" + nodeAttributes.getNamedItem("label").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("color") != null) {
            meterInterval.setColor(ReportReader.decodeColor("" + nodeAttributes.getNamedItem("color").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("alpha") != null) {
            try {
                meterInterval.setAlpha(Double.parseDouble(nodeAttributes.getNamedItem("alpha").getNodeValue() + ""));
            }
            catch (Exception ex) {
                MainFrame.getMainInstance().logOnConsole(I18n.getString("reportReader.notValidApha", "Not valid alpha value for the MeterPlot -> MeterInterval tag."));
            }
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("dataRange")) continue;
            meterInterval.setDataRange(this.readDataRange(child_child));
        }
        return meterInterval;
    }

    private void readPlot(Node xmlNodeParent, Plot plot) {
        NodeList childsOfChild = xmlNodeParent.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node xmlNode = childsOfChild.item(c_count);
            if (xmlNode.getNodeType() != 1 || !xmlNode.getNodeName().equals("plot")) continue;
            NamedNodeMap nodeAttributes = xmlNode.getAttributes();
            if (nodeAttributes.getNamedItem("backcolor") != null) {
                plot.setBackcolor(ReportReader.decodeColor("" + nodeAttributes.getNamedItem("backcolor").getNodeValue()));
            }
            if (nodeAttributes.getNamedItem("orientation") != null) {
                plot.setOrientation("" + nodeAttributes.getNamedItem("orientation").getNodeValue());
            }
            if (nodeAttributes.getNamedItem("backgroundAlpha") != null) {
                plot.setBackgroundAlpha(Double.parseDouble(nodeAttributes.getNamedItem("backgroundAlpha").getNodeValue()));
            }
            if (nodeAttributes.getNamedItem("foregroundAlpha") != null) {
                plot.setForegroundAlpha(Double.parseDouble(nodeAttributes.getNamedItem("foregroundAlpha").getNodeValue()));
            }
            if (nodeAttributes.getNamedItem("labelRotation") != null) {
                plot.setLabelRotation(Double.parseDouble(nodeAttributes.getNamedItem("labelRotation").getNodeValue()));
            }
            NodeList childsOfChildPlot = xmlNode.getChildNodes();
            for (int c_plot_count = 0; c_plot_count < childsOfChildPlot.getLength(); ++c_plot_count) {
                Node child_child_plot = childsOfChildPlot.item(c_plot_count);
                if (child_child_plot.getNodeType() != 1 || !child_child_plot.getNodeName().equals("seriesColor")) continue;
                NamedNodeMap nodeAttributes2 = child_child_plot.getAttributes();
                Color c = Color.red;
                int seriesOrder = 0;
                if (nodeAttributes2.getNamedItem("color") != null) {
                    c = ReportReader.decodeColor("" + nodeAttributes2.getNamedItem("color").getNodeValue());
                }
                if (nodeAttributes2.getNamedItem("seriesOrder") != null) {
                    try {
                        seriesOrder = Integer.parseInt("" + nodeAttributes2.getNamedItem("seriesOrder").getNodeValue());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                SeriesColor sc = new SeriesColor();
                sc.setSeriesOrder(seriesOrder);
                sc.setColor(c);
                plot.getSeriesColors().add(sc);
            }
            Object[] objs = plot.getSeriesColors().toArray();
            Arrays.sort(objs);
            plot.getSeriesColors().clear();
            for (int i = 0; i < objs.length; ++i) {
                plot.getSeriesColors().add(objs[i]);
            }
        }
    }

    private void readChartSubTitleElement(Node xmlElement, ChartReportElement2 re) {
        NamedNodeMap nodeAttributes = xmlElement.getAttributes();
        if (nodeAttributes.getNamedItem("color") != null) {
            re.getChart().getSubTitle().setColor(ReportReader.decodeColor("" + nodeAttributes.getNamedItem("color").getNodeValue()));
        }
        NodeList childsOfChild = xmlElement.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("subtitleExpression")) {
                re.getChart().getSubTitle().setTitleExpression(ReportReader.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("font")) continue;
            re.getChart().getSubTitle().setFont(this.readFontElement(child_child));
        }
    }

    private void readXMLReportElement(Node xmlReportElement, ReportElement re) {
        String color;
        NamedNodeMap nodeAttributes = xmlReportElement.getAttributes();
        if (nodeAttributes.getNamedItem("style") != null) {
            String sname = nodeAttributes.getNamedItem("style").getNodeValue();
            for (int j = 0; j < this.getReport().getStyles().size(); ++j) {
                Style sparent = (Style)this.getReport().getStyles().elementAt(j);
                if (!sparent.getName().equals(sname)) continue;
                re.setStyle(sparent);
                break;
            }
        }
        if (nodeAttributes.getNamedItem("x") != null) {
            re.getRelativePosition().x = re.getPosition().x = Integer.parseInt("" + nodeAttributes.getNamedItem("x").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("y") != null) {
            re.getRelativePosition().y = re.getPosition().y = Integer.parseInt("" + nodeAttributes.getNamedItem("y").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("width") != null) {
            re.setWidth(Integer.parseInt("" + nodeAttributes.getNamedItem("width").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("height") != null) {
            re.setHeight(Integer.parseInt("" + nodeAttributes.getNamedItem("height").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("key") != null) {
            re.setKey("" + nodeAttributes.getNamedItem("key").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("stretchType") != null) {
            re.setStretchType("" + nodeAttributes.getNamedItem("stretchType").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("isPrintRepeatedValues") != null) {
            re.setIsPrintRepeatedValues(("" + nodeAttributes.getNamedItem("isPrintRepeatedValues").getNodeValue()).equalsIgnoreCase("true"));
        }
        if (nodeAttributes.getNamedItem("positionType") != null) {
            re.setPositionType("" + nodeAttributes.getNamedItem("positionType").getNodeValue());
        } else {
            re.setPositionType("FixRelativeToTop");
        }
        if (nodeAttributes.getNamedItem("isPrintRepeatedValues") != null) {
            re.setIsPrintRepeatedValues(("" + nodeAttributes.getNamedItem("isPrintRepeatedValues").getNodeValue()).equalsIgnoreCase("true"));
        }
        if (nodeAttributes.getNamedItem("isRemoveLineWhenBlank") != null) {
            re.setIsRemoveLineWhenBlank(("" + nodeAttributes.getNamedItem("isRemoveLineWhenBlank").getNodeValue()).equalsIgnoreCase("true"));
        }
        if (nodeAttributes.getNamedItem("isPrintInFirstWholeBand") != null) {
            re.setIsPrintInFirstWholeBand(("" + nodeAttributes.getNamedItem("isPrintInFirstWholeBand").getNodeValue()).equalsIgnoreCase("true"));
        }
        if (nodeAttributes.getNamedItem("isPrintWhenDetailOverflows") != null) {
            re.setIsPrintWhenDetailOverflows(("" + nodeAttributes.getNamedItem("isPrintWhenDetailOverflows").getNodeValue()).equalsIgnoreCase("true"));
        }
        if (nodeAttributes.getNamedItem("printWhenGroupChanges") != null) {
            re.setPrintWhenGroupChanges("" + nodeAttributes.getNamedItem("printWhenGroupChanges").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("forecolor") != null) {
            color = "" + nodeAttributes.getNamedItem("forecolor").getNodeValue();
            re.setFgcolor(ReportReader.decodeColor(color));
        }
        if (nodeAttributes.getNamedItem("backcolor") != null) {
            color = "" + nodeAttributes.getNamedItem("backcolor").getNodeValue();
            re.setBgcolor(ReportReader.decodeColor(color));
        }
        if (nodeAttributes.getNamedItem("mode") != null) {
            re.setTransparent("" + nodeAttributes.getNamedItem("mode").getNodeValue());
        }
        NodeList childsOfChild = xmlReportElement.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("printWhenExpression")) continue;
            re.setPrintWhenExpression(ReportReader.readPCDATA(child_child));
        }
    }

    private void readBoxElement(Node xmlReportElement, BoxElement re) {
        String color;
        NamedNodeMap nodeAttributes = xmlReportElement.getAttributes();
        Box box = new Box();
        if (nodeAttributes.getNamedItem("border") != null) {
            box.setBorder("" + nodeAttributes.getNamedItem("border").getNodeValue());
            box.setLeftBorder("" + nodeAttributes.getNamedItem("border").getNodeValue());
            box.setRightBorder("" + nodeAttributes.getNamedItem("border").getNodeValue());
            box.setTopBorder("" + nodeAttributes.getNamedItem("border").getNodeValue());
            box.setBottomBorder("" + nodeAttributes.getNamedItem("border").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("padding") != null) {
            box.setPadding(Integer.parseInt("" + nodeAttributes.getNamedItem("padding").getNodeValue()));
            box.setLeftPadding(Integer.parseInt("" + nodeAttributes.getNamedItem("padding").getNodeValue()));
            box.setRightPadding(Integer.parseInt("" + nodeAttributes.getNamedItem("padding").getNodeValue()));
            box.setTopPadding(Integer.parseInt("" + nodeAttributes.getNamedItem("padding").getNodeValue()));
            box.setBottomPadding(Integer.parseInt("" + nodeAttributes.getNamedItem("padding").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("borderColor") != null) {
            color = "" + nodeAttributes.getNamedItem("borderColor").getNodeValue();
            Color colorObj = ReportReader.decodeColor(color);
            box.setBorderColor(new Color(colorObj.getRGB()));
            box.setLeftBorderColor(new Color(colorObj.getRGB()));
            box.setRightBorderColor(new Color(colorObj.getRGB()));
            box.setTopBorderColor(new Color(colorObj.getRGB()));
            box.setBottomBorderColor(new Color(colorObj.getRGB()));
        }
        if (nodeAttributes.getNamedItem("topBorder") != null) {
            box.setTopBorder("" + nodeAttributes.getNamedItem("topBorder").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("topPadding") != null) {
            box.setTopPadding(Integer.parseInt("" + nodeAttributes.getNamedItem("topPadding").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("topBorderColor") != null) {
            color = "" + nodeAttributes.getNamedItem("topBorderColor").getNodeValue();
            box.setTopBorderColor(ReportReader.decodeColor(color));
        }
        if (nodeAttributes.getNamedItem("leftBorder") != null) {
            box.setLeftBorder("" + nodeAttributes.getNamedItem("leftBorder").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("leftPadding") != null) {
            box.setLeftPadding(Integer.parseInt("" + nodeAttributes.getNamedItem("leftPadding").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("leftBorderColor") != null) {
            color = "" + nodeAttributes.getNamedItem("leftBorderColor").getNodeValue();
            box.setLeftBorderColor(ReportReader.decodeColor(color));
        }
        if (nodeAttributes.getNamedItem("rightBorder") != null) {
            box.setRightBorder("" + nodeAttributes.getNamedItem("rightBorder").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("rightPadding") != null) {
            box.setRightPadding(Integer.parseInt("" + nodeAttributes.getNamedItem("rightPadding").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("rightBorderColor") != null) {
            color = "" + nodeAttributes.getNamedItem("rightBorderColor").getNodeValue();
            box.setRightBorderColor(ReportReader.decodeColor(color));
        }
        if (nodeAttributes.getNamedItem("bottomBorder") != null) {
            box.setBottomBorder("" + nodeAttributes.getNamedItem("bottomBorder").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("bottomPadding") != null) {
            box.setBottomPadding(Integer.parseInt("" + nodeAttributes.getNamedItem("bottomPadding").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("bottomBorderColor") != null) {
            color = "" + nodeAttributes.getNamedItem("bottomBorderColor").getNodeValue();
            box.setBottomBorderColor(ReportReader.decodeColor(color));
        }
        if (re instanceof BoxElement) {
            re.setBox(box);
        }
    }

    static Color decodeColor(String colorString) {
        Color color = null;
        char firstChar = colorString.charAt(0);
        color = firstChar == '#' ? new Color(Integer.parseInt(colorString.substring(1), 16)) : ('0' <= firstChar && firstChar <= '9' ? new Color(Integer.parseInt(colorString)) : (JRXmlConstants.getColorMap().containsKey(colorString) ? (Color)JRXmlConstants.getColorMap().get(colorString) : Color.black));
        return color;
    }

    public static String readPCDATA(Node textNode) {
        return ReportReader.readPCDATA(textNode, true);
    }

    public static String readPCDATA(Node textNode, boolean trim) {
        NodeList list_child = textNode.getChildNodes();
        for (int ck = 0; ck < list_child.getLength(); ++ck) {
            short nt;
            Node child_child = list_child.item(ck);
            Node ns = child_child.getNextSibling();
            if (ns != null) {
                child_child = ns;
            }
            if ((nt = child_child.getNodeType()) != 4 && nt != 3) continue;
            if (trim) {
                return child_child.getNodeValue().trim();
            }
            return child_child.getNodeValue();
        }
        return "";
    }

    private void readXMLTextElement(Node xmlReportElement, TextReportElement re) {
        NamedNodeMap nodeAttributes = xmlReportElement.getAttributes();
        if (nodeAttributes.getNamedItem("textAlignment") != null) {
            re.setAlign("" + nodeAttributes.getNamedItem("textAlignment").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("verticalAlignment") != null) {
            re.setVerticalAlign("" + nodeAttributes.getNamedItem("verticalAlignment").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("lineSpacing") != null) {
            re.setLineSpacing("" + nodeAttributes.getNamedItem("lineSpacing").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("rotation") != null) {
            re.setRotate("" + nodeAttributes.getNamedItem("rotation").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("isStyledText") != null) {
            re.setIsStyledText(("" + nodeAttributes.getNamedItem("isStyledText").getNodeValue()).equals("true"));
        }
        NodeList childsOfChild = xmlReportElement.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("font")) continue;
            NamedNodeMap subNodeAttributes = child_child.getAttributes();
            if (subNodeAttributes.getNamedItem("reportFont") != null) {
                IReportFont baseFont = null;
                re.setReportFont(subNodeAttributes.getNamedItem("reportFont").getNodeValue());
                for (int fn = 0; !(fn >= this.getReport().getFonts().size() || (baseFont = (IReportFont)this.getReport().getFonts().elementAt(fn)) != null && baseFont.getReportFont().equals(re.getReportFont())); ++fn) {
                    baseFont = null;
                }
                if (baseFont != null) {
                    // empty if block
                }
            }
            for (int kkk = 0; kkk < subNodeAttributes.getLength(); ++kkk) {
                String propName = subNodeAttributes.item(kkk).getNodeName();
                String propValue = subNodeAttributes.item(kkk).getNodeValue();
                if (propName == null || propValue == null) continue;
                if (propName.equals("fontName")) {
                    re.setFontName(propValue);
                    continue;
                }
                if (propName.equals("pdfFontName")) {
                    re.setPDFFontName(propValue);
                    continue;
                }
                if (propName.equals("size")) {
                    re.setFontSize(Integer.parseInt("" + propValue));
                    continue;
                }
                if (propName.equals("isBold")) {
                    re.setBold(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (propName.equals("isItalic")) {
                    re.setItalic(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (propName.equals("isUnderline")) {
                    re.setUnderline(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (propName.equals("isStrikeThrough")) {
                    re.setStrikeTrought(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (propName.equals("isPdfEmbedded")) {
                    re.setPdfEmbedded(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (!propName.equals("pdfEncoding")) continue;
                re.setPdfEncoding("" + propValue);
            }
            re.setFont(null);
        }
    }

    private Node findNextNode(Node node) {
        int i;
        short type = node.getNodeType();
        if (type == 1) {
            return node;
        }
        NodeList children = node.getChildNodes();
        if (children != null && (i = 0) < children.getLength()) {
            return this.findNextNode(children.item(i));
        }
        return null;
    }

    private Node findChild(Node parent, String childName) {
        if (parent == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equals(childName)) continue;
                return node;
            }
            Node foundNode = null;
            for (int i = 0; foundNode == null && i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (node.getNodeType() != 1) continue;
                foundNode = this.findChild(node, childName);
            }
            return foundNode;
        }
        return null;
    }

    private void readChartReportElement(Node child, ChartReportElement2 re) {
        if (child.getNodeName().equals("pieChart")) {
            re.setChart(new PieChart());
        } else if (child.getNodeName().equals("pie3DChart")) {
            re.setChart(new Pie3DChart());
        } else if (child.getNodeName().equals("barChart")) {
            re.setChart(new BarChart());
        } else if (child.getNodeName().equals("bar3DChart")) {
            re.setChart(new Bar3DChart());
        } else if (child.getNodeName().equals("xyBarChart")) {
            re.setChart(new XYBarChart());
        } else if (child.getNodeName().equals("stackedBarChart")) {
            re.setChart(new StackedBarChart());
        } else if (child.getNodeName().equals("stackedBar3DChart")) {
            re.setChart(new StackedBar3DChart());
        } else if (child.getNodeName().equals("lineChart")) {
            re.setChart(new LineChart());
        } else if (child.getNodeName().equals("xyLineChart")) {
            re.setChart(new XYLineChart());
        } else if (child.getNodeName().equals("areaChart")) {
            re.setChart(new AreaChart());
        } else if (child.getNodeName().equals("stackedAreaChart")) {
            re.setChart(new StackedAreaChart());
        } else if (child.getNodeName().equals("xyAreaChart")) {
            re.setChart(new XYAreaChart());
        } else if (child.getNodeName().equals("scatterChart")) {
            re.setChart(new ScatterChart());
        } else if (child.getNodeName().equals("bubbleChart")) {
            re.setChart(new BubbleChart());
        } else if (child.getNodeName().equals("timeSeriesChart")) {
            re.setChart(new TimeSeriesChart());
        } else if (child.getNodeName().equals("highLowChart")) {
            re.setChart(new HighLowChart());
        } else if (child.getNodeName().equals("candlestickChart")) {
            re.setChart(new CandlestickChart());
        } else if (child.getNodeName().equals("meterChart")) {
            re.setChart(new MeterChart());
        } else if (child.getNodeName().equals("thermometerChart")) {
            re.setChart(new ThermometerChart());
        } else if (child.getNodeName().equals("multiAxisChart")) {
            re.setChart(new MultiAxisChart());
        }
        NodeList childsOfChild = child.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            NamedNodeMap subNodeAttributes = child_child.getAttributes();
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("chart")) {
                this.readChartElement(child_child, re);
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("pieDataset")) {
                this.readPieDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("categoryDataset")) {
                this.readCategoryDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("timePeriodDataset")) {
                this.readTimePeriodDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("timeSeriesDataset")) {
                this.readTimeSeriesDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("xyDataset")) {
                this.readXYDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("xyzDataset")) {
                this.readXYZDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("highLowDataset")) {
                this.readHighLowDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("valueDataset")) {
                this.readValueDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("piePlot")) {
                this.readPiePlot(child_child, (PiePlot)re.getChart().getPlot());
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("pie3DPlot")) {
                this.readPie3DPlot(child_child, (Pie3DPlot)re.getChart().getPlot());
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("barPlot")) {
                this.readBarPlot(child_child, (BarPlot)re.getChart().getPlot());
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("bar3DPlot")) {
                this.readBar3DPlot(child_child, (Bar3DPlot)re.getChart().getPlot());
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("linePlot")) {
                this.readLinePlot(child_child, (LinePlot)re.getChart().getPlot());
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("areaPlot")) {
                this.readAreaPlot(child_child, (AreaPlot)re.getChart().getPlot());
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("scatterPlot")) {
                this.readScatterPlot(child_child, (ScatterPlot)re.getChart().getPlot());
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("bubblePlot")) {
                this.readBubblePlot(child_child, (BubblePlot)re.getChart().getPlot());
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("timeSeriesPlot")) {
                this.readTimeSeriesPlot(child_child, (TimeSeriesPlot)re.getChart().getPlot());
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("highLowPlot")) {
                this.readHighLowPlot(child_child, (HighLowPlot)re.getChart().getPlot());
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("candlestickPlot")) {
                this.readCandlestickPlot(child_child, (CandlestickPlot)re.getChart().getPlot());
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("meterPlot")) {
                this.readMeterPlot(child_child, (MeterPlot)re.getChart().getPlot());
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("thermometerPlot")) {
                this.readThermometerPlot(child_child, (ThermometerPlot)re.getChart().getPlot());
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("multiAxisPlot")) continue;
            this.readMultiAxisPlot(child_child, (MultiAxisPlot)re.getChart().getPlot());
        }
    }

    private void readMultiAxisPlot(Node xmlNode, MultiAxisPlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("axis")) continue;
            plot.getAxis().add(this.readAxis(child_child));
        }
    }

    private Axis readAxis(Node xmlNode) {
        Axis axis = new Axis();
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        if (nodeAttributes.getNamedItem("position") != null) {
            axis.setPosition("" + nodeAttributes.getNamedItem("position").getNodeValue());
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child = childsOfChild.item(c_count);
            if (!(child.getNodeType() == 1 && child.getNodeName().equals("pieChart") || child.getNodeType() == 1 && child.getNodeName().equals("pie3DChart") || child.getNodeType() == 1 && child.getNodeName().equals("barChart") || child.getNodeType() == 1 && child.getNodeName().equals("bar3DChart") || child.getNodeType() == 1 && child.getNodeName().equals("xyBarChart") || child.getNodeType() == 1 && child.getNodeName().equals("stackedBarChart") || child.getNodeType() == 1 && child.getNodeName().equals("stackedBar3DChart") || child.getNodeType() == 1 && child.getNodeName().equals("lineChart") || child.getNodeType() == 1 && child.getNodeName().equals("xyLineChart") || child.getNodeType() == 1 && child.getNodeName().equals("areaChart") || child.getNodeType() == 1 && child.getNodeName().equals("xyAreaChart") || child.getNodeType() == 1 && child.getNodeName().equals("scatterChart") || child.getNodeType() == 1 && child.getNodeName().equals("bubbleChart") || child.getNodeType() == 1 && child.getNodeName().equals("timeSeriesChart") || child.getNodeType() == 1 && child.getNodeName().equals("highLowChart") || child.getNodeType() == 1 && child.getNodeName().equals("candlestickChart") || child.getNodeType() == 1 && child.getNodeName().equals("meterChart") || child.getNodeType() == 1 && child.getNodeName().equals("thermometerChart")) && (child.getNodeType() != 1 || !child.getNodeName().equals("multiAxisChart"))) continue;
            ChartReportElement2 re = new ChartReportElement2(0, 0, 0, 0);
            this.readChartReportElement(child, re);
            axis.setChartReportElement(re);
        }
        return axis;
    }
}

