/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.IReportHashMapBean;
import it.businesslogic.ireport.TextReportElement;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Map;

public class IReportFont
extends IReportHashMapBean {
    public static final String IS_DEFAULT_FONT = "defaultFont";
    public static final String REPORT_FONT = "reportFont";
    public static final String FONT_NAME = "fontName";
    public static final String PDF_FONT_NAME = "PDFFontName";
    public static final String FONT_SIZE = "fontSize";
    public static final String TTF_FONT_NAME = "PDFFontName";
    public static final String IS_BOLD = "bold";
    public static final String IS_UNDERLINE = "underline";
    public static final String IS_ITALIC = "italic";
    public static final String IS_STRIKETROUGHT = "strikeTrought";
    public static final String IS_PDF_EMBEDDED = "pdfEmbedded";
    public static final String PDF_ENCODING = "pdfEncoding";
    public static final boolean DEFAULT_IS_DEFAULT_FONT = false;
    public static final String DEFAULT_REPORT_FONT = "";
    public static final String DEFAULT_FONT_NAME = "SansSerif";
    public static final String DEFAULT_PDF_FONT_NAME = "Helvetica";
    public static final int DEFAULT_FONT_SIZE = 10;
    public static final String DEFAULT_TTF_FONT_NAME = "";
    public static final boolean DEFAULT_IS_BOLD = false;
    public static final boolean DEFAULT_IS_UNDERLINE = false;
    public static final boolean DEFAULT_IS_ITALIC = false;
    public static final boolean DEFAULT_IS_STRIKETROUGHT = false;
    public static final boolean DEFAULT_IS_PDF_EMBEDDED = false;
    public static final String DEFAULT_PDF_ENCODING = "Cp1252";

    public Object clone() {
        IReportFont newBean = new IReportFont();
        return super.clone(newBean);
    }

    public boolean isBold() {
        return this.getBooleanValue(IS_BOLD, false);
    }

    public boolean isSet(String property) {
        return this.getBeanProperties().get(property) != null;
    }

    public void setBold(boolean bold) {
        this.getBeanProperties().put(IS_BOLD, "" + bold);
    }

    public String getFontName() {
        return this.getStringValue(FONT_NAME, DEFAULT_FONT_NAME);
    }

    public void setFontName(String fontName) {
        this.getBeanProperties().put(FONT_NAME, fontName);
    }

    public int getFontSize() {
        return this.getIntValue(FONT_SIZE, 10);
    }

    public void setFontSize(int fontSize) {
        this.getBeanProperties().put(FONT_SIZE, "" + fontSize);
    }

    public boolean isItalic() {
        return this.getBooleanValue(IS_ITALIC, false);
    }

    public void setItalic(boolean italic) {
        this.getBeanProperties().put(IS_ITALIC, "" + italic);
    }

    public boolean isPdfEmbedded() {
        return this.getBooleanValue(IS_PDF_EMBEDDED, false);
    }

    public void setPdfEmbedded(boolean pdfEmbedded) {
        this.getBeanProperties().put(IS_PDF_EMBEDDED, "" + pdfEmbedded);
    }

    public String getPdfEncoding() {
        return this.getStringValue(PDF_ENCODING, DEFAULT_PDF_ENCODING);
    }

    public void setPdfEncoding(String pdfEncoding) {
        this.getBeanProperties().put(PDF_ENCODING, "" + pdfEncoding);
    }

    public String getPDFFontName() {
        return this.getStringValue("PDFFontName", DEFAULT_PDF_FONT_NAME);
    }

    public void setPDFFontName(String PDFFontName) {
        this.getBeanProperties().put("PDFFontName", "" + PDFFontName);
        if (PDFFontName != null && PDFFontName.toUpperCase().endsWith(".TTF")) {
            this.getBeanProperties().put("PDFFontName", "" + PDFFontName);
        }
    }

    public String getReportFont() {
        return this.getStringValue(REPORT_FONT, "");
    }

    public void setReportFont(String reportFont) {
        this.getBeanProperties().put(REPORT_FONT, "" + reportFont);
    }

    public boolean isStrikeTrought() {
        return this.getBooleanValue(IS_STRIKETROUGHT, false);
    }

    public void setStrikeTrought(boolean strikeTrought) {
        this.getBeanProperties().put(IS_STRIKETROUGHT, "" + strikeTrought);
    }

    public String getTTFFont() {
        return this.getStringValue("PDFFontName", "");
    }

    public void setTTFFont(String TTFFont) {
        this.getBeanProperties().put("PDFFontName", "" + TTFFont);
    }

    public boolean isUnderline() {
        return this.getBooleanValue(IS_UNDERLINE, false);
    }

    public void setUnderline(boolean underline) {
        this.getBeanProperties().put(IS_UNDERLINE, "" + underline);
    }

    public String toString() {
        return this.getReportFont();
    }

    public String getDescription() {
        return this.getFontName() + " " + this.getFontSize();
    }

    public boolean isDefaultFont() {
        return this.getBooleanValue(IS_DEFAULT_FONT, false);
    }

    public void setDefaultFont(boolean defaultFont) {
        this.getBeanProperties().put(IS_DEFAULT_FONT, "" + defaultFont);
    }

    public Font getJavaAWTFont() {
        int style = 0;
        style &= this.isBold() ? 1 : 0;
        Font font = new Font(this.getFontName(), style &= this.isItalic() ? 2 : 0, this.getFontSize());
        Map<TextAttribute, ?> fontAttributes = font.getAttributes();
        if (this.isUnderline()) {
            fontAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (this.isStrikeTrought()) {
            fontAttributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return new Font(fontAttributes);
    }

    public void setJavaAWTFont(Font font) {
        this.setFontName(font.getFontName());
        this.setFontSize(font.getSize());
        int style = font.getStyle();
        this.setBold((style & 1) > 0);
        this.setItalic((style & 2) > 0);
        Map<TextAttribute, ?> fontAttributes = font.getAttributes();
        this.setUnderline(fontAttributes.containsKey(TextAttribute.UNDERLINE) && fontAttributes.get(TextAttribute.UNDERLINE).equals(TextAttribute.UNDERLINE_ON));
        this.setStrikeTrought(fontAttributes.containsKey(TextAttribute.STRIKETHROUGH) && fontAttributes.get(TextAttribute.STRIKETHROUGH).equals(TextAttribute.STRIKETHROUGH_ON));
    }

    public static boolean isTTFFont(String fontName) {
        if (fontName.equals(DEFAULT_PDF_FONT_NAME)) {
            return false;
        }
        if (fontName.equals("Helvetica-Bold")) {
            return false;
        }
        if (fontName.equals("Helvetica-BoldOblique")) {
            return false;
        }
        if (fontName.equals("Helvetica-Oblique")) {
            return false;
        }
        if (fontName.equals("Courier")) {
            return false;
        }
        if (fontName.equals("Courier-Bold")) {
            return false;
        }
        if (fontName.equals("Courier-BoldOblique")) {
            return false;
        }
        if (fontName.equals("Courier-Oblique")) {
            return false;
        }
        if (fontName.equals("Symbol")) {
            return false;
        }
        if (fontName.equals("Times-Roman")) {
            return false;
        }
        if (fontName.equals("Times-Bold")) {
            return false;
        }
        if (fontName.equals("Times-BoldItalic")) {
            return false;
        }
        if (fontName.equals("Times-Italic")) {
            return false;
        }
        if (fontName.equals("ZapfDingbats")) {
            return false;
        }
        if (fontName.equals("STSong-Light")) {
            return false;
        }
        if (fontName.equals("MHei-Medium")) {
            return false;
        }
        if (fontName.equals("MSung-Light")) {
            return false;
        }
        if (fontName.equals("HeiseiKakuGo-W5")) {
            return false;
        }
        if (fontName.equals("HeiseiMin-W3")) {
            return false;
        }
        if (fontName.equals("HYGoThic-Medium")) {
            return false;
        }
        return !fontName.equals("HYSMyeongJo-Medium");
    }

    public static String matchFont(String fontName, boolean bold, boolean italic) {
        if (!IReportFont.isTTFFont(fontName)) {
            if (fontName.startsWith(DEFAULT_PDF_FONT_NAME) && !bold && !italic) {
                return DEFAULT_PDF_FONT_NAME;
            }
            if (fontName.startsWith(DEFAULT_PDF_FONT_NAME) && bold && !italic) {
                return "Helvetica-Bold";
            }
            if (fontName.startsWith(DEFAULT_PDF_FONT_NAME) && bold && italic) {
                return "Helvetica-BoldOblique";
            }
            if (fontName.startsWith(DEFAULT_PDF_FONT_NAME) && !bold && italic) {
                return "Helvetica-Oblique";
            }
            if (fontName.startsWith("Courier") && !bold && !italic) {
                return "Courier";
            }
            if (fontName.startsWith("Courier") && bold && !italic) {
                return "Courier-Bold";
            }
            if (fontName.startsWith("Courier") && bold && italic) {
                return "Courier-BoldOblique";
            }
            if (fontName.startsWith("Courier") && !bold && italic) {
                return "Courier-Oblique";
            }
            if (fontName.startsWith("Times") && !bold && !italic) {
                return "Times-Roman";
            }
            if (fontName.startsWith("Times") && bold && !italic) {
                return "Times-Bold";
            }
            if (fontName.startsWith("Times") && bold && italic) {
                return "Times-BoldItalic";
            }
            if (fontName.startsWith("Times") && !bold && italic) {
                return "Times-Italic";
            }
        }
        return fontName;
    }

    public static boolean adjustPdfFontName(TextReportElement element) {
        String newPdfFontName = IReportFont.matchFont(element.getPDFFontName(), element.isBold(), element.isItalic());
        if (newPdfFontName != null && !newPdfFontName.equals(element.getPDFFontName())) {
            element.setPDFFontName(newPdfFontName);
            return true;
        }
        return false;
    }
}

