/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import be.savat.components.PagesFrame;
import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.ReportClassLoader;
import it.businesslogic.ireport.compiler.ErrorsCollector;
import it.businesslogic.ireport.compiler.ExtendedJRJdtCompiler;
import it.businesslogic.ireport.compiler.xml.SourceTraceDigester;
import it.businesslogic.ireport.connection.EJBQLConnection;
import it.businesslogic.ireport.connection.JRDataSourceProviderConnection;
import it.businesslogic.ireport.connection.JRHibernateConnection;
import it.businesslogic.ireport.connection.MondrianConnection;
import it.businesslogic.ireport.export.JRTxtExporter;
import it.businesslogic.ireport.export.JRTxtExporterParameter;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.locale.TimeZoneWrapper;
import it.businesslogic.ireport.gui.logpane.LogTextArea;
import it.businesslogic.ireport.gui.logpane.ProblemItem;
import it.businesslogic.ireport.gui.prompt.Prompter;
import it.businesslogic.ireport.gui.queryexecuters.QueryExecuterDef;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRJdk13Compiler;
import net.sf.jasperreports.engine.design.JRValidationException;
import net.sf.jasperreports.engine.design.JRValidationFault;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.fill.JRFileVirtualizer;
import net.sf.jasperreports.engine.fill.JRGzipVirtualizer;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.util.JRSwapFile;
import net.sf.jasperreports.engine.xml.JRXmlDigesterFactory;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.view.JasperViewer;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

public class IReportCompiler
implements Runnable,
JRExportProgressMonitor {
    public static final int CMD_COMPILE = 1;
    public static final int CMD_EXPORT = 2;
    public static final int CMD_COMPILE_SCRIPTLET = 4;
    public static final String OUTPUT_DIRECTORY = "OUTPUT_DIRECTORY";
    public static final String OUTPUT_FORMAT = "OUTPUT_FORMAT";
    public static final String USE_EMPTY_DATASOURCE = "USE_EMPTY_DATASOURCE";
    public static final String USE_CONNECTION = "USE_CONNECTION";
    public static final String CONNECTION = "CONNECTION";
    public static final String SCRIPTLET_OUTPUT_DIRECTORY = "SCRIPTLET_OUTPUT_DIRECTORY";
    public static final String COMPILER = "COMPILER";
    public static final String EMPTY_DATASOURCE_RECORDS = "EMPTY_DATASOURCE_RECORDS";
    private String constTabTitle = "";
    private JList threadList = null;
    static PrintStream myPrintStream = null;
    int filledpage = 0;
    private String status = "Starting";
    private IReportConnection iReportConnection;
    private int statusLevel = 0;
    private JReportFrame jrf;
    private int maxBufferSize = 100000;
    private MainFrame mainFrame;
    private int command = 0;
    private HashMap properties = new HashMap();
    private Thread thread;
    private LogTextArea logTextArea = null;
    private String javaFile = "";
    private static StringBuffer outputBuffer = new StringBuffer();
    private static Vector compileListener = new Vector();
    public static final int CL_COMPILE_OK = 1;
    public static final int CL_COMPILE_FAIL = 2;
    public static final String CLS_COMPILE_OK = "compileok";
    public static final String CLS_COMPILE_SCRIPTLET_FAIL = "scriptletfail";
    public static final String CLS_COMPILE_SOURCE_FAIL = "sourcefail";

    public IReportCompiler() {
        try {
            this.maxBufferSize = Integer.parseInt(System.getProperty("ireport.maxbufsize", "100000"));
        }
        catch (Exception ex) {
            this.maxBufferSize = 1000000;
        }
    }

    public void stopThread() {
        this.command = 0;
        if (this.thread != null && this.thread.isAlive()) {
            try {
                this.thread.interrupt();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.removeThread();
        this.getLogTextArea().setTitle("Killed" + this.constTabTitle);
        this.getLogTextArea().setRemovable(true);
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void run() {
        if (this.threadList != null) {
            var1_1 = this.threadList;
            synchronized (var1_1) {
                dlm = (DefaultListModel)this.threadList.getModel();
                dlm.addElement(this);
                this.threadList.updateUI();
            }
        }
        out = System.out;
        err = System.err;
        try {
            block250: {
                block247: {
                    block245: {
                        block246: {
                            block251: {
                                block249: {
                                    block244: {
                                        digester = null;
                                        errorsCollector = new ErrorsCollector();
                                        f_report_title = new File(this.getJrf().getReport().getFilename());
                                        this.constTabTitle = " [" + f_report_title.getName() + "]";
                                        queryLanguage = this.jrf.getReport().getQueryLanguage();
                                        this.logTextArea = this.getMainFrame().getLogPane().createNewLog();
                                        this.status = I18n.getString("iReportCompiler.status.starting", "Starting");
                                        this.logTextArea.setTitle(this.status + this.constTabTitle);
                                        backupJRClasspath = JRProperties.getProperty((String)"net.sf.jasperreports.compiler.classpath");
                                        backupSystemClasspath = System.getProperty("java.class.path");
                                        configuredExecuters = MainFrame.getMainInstance().getQueryExecuters();
                                        for (k = 0; k < configuredExecuters.size(); ++k) {
                                            qe = (QueryExecuterDef)configuredExecuters.get(k);
                                            if (!qe.getLanguage().equals(queryLanguage)) continue;
                                            JRProperties.setProperty((String)("net.sf.jasperreports.query.executer.factory." + qe.getLanguage()), (String)qe.getClassName());
                                            this.getLogTextArea().logOnConsole(I18n.getFormattedString("iReportCompiler.settingQueryExecuter", "Setting {0} as Query Executer Factory for language: {1}\n", new Object[]{qe.getClassName(), "" + qe.getLanguage()}));
                                            break;
                                        }
                                        compilation_ok = true;
                                        start = System.currentTimeMillis();
                                        if (IReportCompiler.myPrintStream == null) {
                                            IReportCompiler.myPrintStream = new PrintStream(new FilteredStream(new ByteArrayOutputStream()));
                                        }
                                        if (out != IReportCompiler.myPrintStream) {
                                            System.setOut(IReportCompiler.myPrintStream);
                                        }
                                        if (err != IReportCompiler.myPrintStream) {
                                            System.setErr(IReportCompiler.myPrintStream);
                                        }
                                        IReportCompiler.outputBuffer = new StringBuffer();
                                        fileName = this.jrf.getReport().getFilename();
                                        srcFileName = this.jrf.getReport().getFilename();
                                        fileName = Misc.changeFileExtension(fileName, "jasper");
                                        f = new File(fileName);
                                        if (this.properties.get("OUTPUT_DIRECTORY") != null) {
                                            fileName = (String)this.properties.get("OUTPUT_DIRECTORY");
                                            if (!fileName.endsWith(File.separator)) {
                                                fileName = fileName + File.separator;
                                            }
                                            fileName = fileName + f.getName();
                                        }
                                        scriptletFileName = this.jrf.getReport().getFilename();
                                        srcScriptletFileName = this.jrf.getReport().getFilename();
                                        srcScriptletFileName = scriptletFileName = srcScriptletFileName.substring(0, scriptletFileName.length() - 1) + "Scriptlet.java";
                                        f2 = new File(scriptletFileName);
                                        if (this.properties.get("SCRIPTLET_OUTPUT_DIRECTORY") != null) {
                                            scriptletFileName = (String)this.properties.get("SCRIPTLET_OUTPUT_DIRECTORY") + File.separatorChar + f2.getName();
                                        }
                                        reportDirectory = new File(this.jrf.getReport().getFilename()).getParent();
                                        classpath = JRProperties.getProperty((String)"net.sf.jasperreports.compiler.classpath");
                                        if (classpath != null) {
                                            classpath = classpath + File.pathSeparator + reportDirectory;
                                            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)classpath);
                                        } else if (System.getProperty("java.class.path") != null) {
                                            classpath = System.getProperty("java.class.path");
                                            classpath = classpath + File.pathSeparator + reportDirectory;
                                            System.setProperty("java.class.path", classpath);
                                        }
                                        reportDirectory = reportDirectory.replace('\\', '/');
                                        if (!reportDirectory.endsWith("/")) {
                                            reportDirectory = reportDirectory + "/";
                                        }
                                        if (!reportDirectory.startsWith("/")) {
                                            reportDirectory = "/" + reportDirectory;
                                        }
                                        reportClassLoader = new ReportClassLoader(this.mainFrame.getReportClassLoader());
                                        reportClassLoader.setRelodablePaths(reportDirectory);
                                        reportClassLoader.rescanLibDirectory();
                                        try {
                                            Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[]{new URL("file://" + reportDirectory)}, (ClassLoader)reportClassLoader));
                                        }
                                        catch (MalformedURLException mue) {
                                            mue.printStackTrace();
                                        }
                                        if ((this.command & 4) != 0) {
                                            this.status = I18n.getString("iReportCompiler.status.compilingScriptlet", "Compiling scriptlet");
                                            this.updateThreadList();
                                            start = System.currentTimeMillis();
                                            oldCompileTemp = tempDirStr = JRProperties.getProperty((String)"net.sf.jasperreports.compiler.temp.dir");
                                            if (tempDirStr == null || tempDirStr.length() == 0 || this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                                tempDirStr = this.mainFrame.getTranslatedCompileDirectory();
                                            }
                                            tempDirFile = new File(tempDirStr);
                                            this.javaFile = srcScriptletFileName;
                                            this.javaFile = new File(tempDirFile, this.javaFile).getPath();
                                            this.javaFile = this.jrf.getReport().getScriptletFileName();
                                            if (Misc.getLastWriteTime(this.javaFile) > Misc.getLastWriteTime(Misc.changeFileExtension(this.javaFile, "class"))) {
                                                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\">" + I18n.getFormattedString("iReportCompiler.compilingScriptlet", "Compiling scriptlet source file... {0}", new Object[]{this.javaFile}) + "</font>", true);
                                                try {
                                                    compiler = new JRJdk13Compiler();
                                                    errors = compiler.compileClass(new File(this.javaFile), Misc.getClassPath());
                                                    if (errors != null && errors.length() > 0) {
                                                        this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>" + I18n.getFormattedString("iReportCompiler.errorsCompilingScriptlet", "Errors compiling {0}!", new Object[]{this.javaFile}) + "</b></font>", true);
                                                        this.getLogTextArea().logOnConsole(errors);
                                                        compilation_ok = false;
                                                    }
                                                }
                                                catch (Exception ex) {
                                                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>" + I18n.getString("iReportCompiler.errorsCompilingScriptletJavaSource", "Error compiling the Scriptlet java source!") + "</b></font>", true);
                                                    sw = new StringWriter(0);
                                                    ex.printStackTrace(new PrintWriter(sw));
                                                    IReportCompiler.myPrintStream.flush();
                                                    this.parseException(IReportCompiler.outputBuffer.toString() + sw.getBuffer() + "", null);
                                                    compilation_ok = false;
                                                }
                                                catch (Throwable ext) {
                                                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>" + I18n.getString("iReportCompiler.errorsCompilingScriptletJavaSource", "Error compiling the Scriptlet java source!") + "</b></font>", true);
                                                    sw = new StringWriter(0);
                                                    ext.printStackTrace(new PrintWriter(sw));
                                                    IReportCompiler.myPrintStream.flush();
                                                    this.parseException(IReportCompiler.outputBuffer.toString() + sw.getBuffer() + "", null);
                                                    compilation_ok = false;
                                                }
                                                finally {
                                                    if (this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                                        // empty if block
                                                    }
                                                }
                                                this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer.toString());
                                                IReportCompiler.outputBuffer = new StringBuffer();
                                                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\"><b>" + I18n.getFormattedString("iReportCompiler.compilationRunningTime", "Compilation running time: {0,number}!", new Object[]{new Long(System.currentTimeMillis() - start)}) + "</b></font><hr>", true);
                                            }
                                        }
                                        if (!compilation_ok) {
                                            IReportCompiler.fireCompileListner(this, 2, "scriptletfail");
                                            this.removeThread();
                                            return;
                                        }
                                        if ((this.command & 1) == 0) break block249;
                                        this.status = I18n.getString("iReportCompiler.status.compilingReport", "Compiling report");
                                        this.updateThreadList();
                                        if (this.mainFrame.getProperties().getProperty("KeepJavaFile", "true").equals("false")) {
                                            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.keep.java.file", (boolean)false);
                                        } else {
                                            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.keep.java.file", (boolean)true);
                                        }
                                        this.javaFile = this.jrf.getReport().getName() + ".java";
                                        oldCompileTemp = tempDirStr = JRProperties.getProperty((String)"net.sf.jasperreports.compiler.temp.dir");
                                        if (tempDirStr == null || tempDirStr.length() == 0 || this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                            tempDirStr = this.mainFrame.getTranslatedCompileDirectory();
                                        }
                                        tempDirFile = new File(tempDirStr);
                                        this.javaFile = new File(tempDirFile, this.javaFile).getPath();
                                        img_url_comp = this.getClass().getResource("/it/businesslogic/ireport/icons/comp1_mini.jpg");
                                        this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url_comp + "\"> &nbsp;" + I18n.getFormattedString("iReportCompiler.compilingToFile", "Compiling to file... {0} -> {1}", new Object[]{fileName, this.javaFile}) + "</font>", true);
                                        old_jr_classpath = Misc.nvl(JRProperties.getProperty((String)"net.sf.jasperreports.compiler.classpath"), "");
                                        old_defaul_compiler = Misc.nvl(JRProperties.getProperty((String)"net.sf.jasperreports.compiler.class"), "");
                                        try {
                                            block243: {
                                                if (this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                                    JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)tempDirStr);
                                                }
                                                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)(Misc.nvl(new File(fileName).getParent(), ".") + File.pathSeparator + Misc.getClassPath()));
                                                compiler_name = I18n.getString("iReportCompiler.defaultCompiler", "JasperReports default compiler");
                                                compiler_code = this.mainFrame.getProperties().getProperty("DefaultCompiler");
                                                jdtCompiler = null;
                                                if (this.getProperties().get("COMPILER") != null) {
                                                    JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)("" + this.getProperties().get("COMPILER")));
                                                    compiler_name = I18n.getFormattedString("iReportCompiler.specialLanguageCompiler", "Special language compiler ({0})", new Object[]{this.getProperties().get("COMPILER")});
                                                } else if (compiler_code != null && !compiler_code.equals("0") && !compiler_code.equals("")) {
                                                    if (compiler_code.equals("1")) {
                                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)"net.sf.jasperreports.engine.design.JRJdk13Compiler");
                                                        compiler_name = I18n.getString("iReportCompiler.javaCompiler", "Java Compiler");
                                                    } else if (compiler_code.equals("2")) {
                                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)"it.businesslogic.ireport.compiler.ExtendedJRJdtCompiler");
                                                        compiler_name = I18n.getString("iReportCompiler.jdtCompiler", "JDT Compiler");
                                                        cl = this.getClassLoader();
                                                        System.out.println(cl);
                                                        jdtCompiler = new ExtendedJRJdtCompiler();
                                                    } else if (compiler_code.equals("3")) {
                                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)"net.sf.jasperreports.compilers.JRBshCompiler");
                                                        compiler_name = I18n.getString("iReportCompiler.beanShellCompiler", "BeanShell Compiler");
                                                    } else if (compiler_code.equals("4")) {
                                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)"net.sf.jasperreports.engine.design.JRJikesCompiler");
                                                        compiler_name = I18n.getString("iReportCompiler.jikesCompiler", "Jikes Compiler");
                                                    }
                                                } else {
                                                    JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)"it.businesslogic.ireport.compiler.ExtendedJRJdtCompiler");
                                                    Thread.currentThread().setContextClassLoader(reportClassLoader);
                                                    cl = this.getClassLoader();
                                                    jdtCompiler = new ExtendedJRJdtCompiler();
                                                }
                                                start = System.currentTimeMillis();
                                                digester = IReportCompiler.createDigester();
                                                jd = IReportCompiler.loadJasperDesign(new FileInputStream(srcFileName), digester);
                                                if (jdtCompiler != null) {
                                                    jdtCompiler.setDigester(digester);
                                                    jdtCompiler.setErrorHandler(errorsCollector);
                                                    finalJR = jdtCompiler.compileReport(jd);
                                                    if (errorsCollector.getProblemItems().size() > 0 || finalJR == null) {
                                                        throw new JRException("");
                                                    }
                                                    JRSaver.saveObject((Object)finalJR, (String)fileName);
                                                } else {
                                                    JasperCompileManager.compileReportToFile((JasperDesign)jd, (String)fileName);
                                                }
                                                if (errorsCollector == null) break block243;
                                                this.getJrf().setReportProblems(errorsCollector.getProblemItems());
                                                MainFrame.getMainInstance().getLogPane().getProblemsPanel().updateProblemsList();
                                            }
                                            var34_66 = null;
                                        }
                                        catch (Throwable var33_75) {
                                            var34_67 = null;
                                            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)old_jr_classpath);
                                            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)old_defaul_compiler);
                                            if (this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                                if (oldCompileTemp != null) {
                                                    System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                                                    JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)oldCompileTemp);
                                                } else {
                                                    System.setProperty("jasper.reports.compile.temp", "");
                                                    JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)"");
                                                }
                                                javaSrcFile = new File(this.javaFile);
                                                if (javaSrcFile.exists() && this.mainFrame.getProperties().getProperty("KeepJavaFile", "true").equals("false")) {
                                                    javaSrcFile.delete();
                                                }
                                            }
                                            throw var33_75;
                                        }
                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)old_jr_classpath);
                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)old_defaul_compiler);
                                        if (!this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) break block244;
                                        if (oldCompileTemp != null) {
                                            System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                                            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)oldCompileTemp);
                                        } else {
                                            System.setProperty("jasper.reports.compile.temp", "");
                                            JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)"");
                                        }
                                        javaSrcFile = new File(this.javaFile);
                                        if (javaSrcFile.exists() && this.mainFrame.getProperties().getProperty("KeepJavaFile", "true").equals("false")) {
                                            javaSrcFile.delete();
                                        }
                                        break block244;
                                        {
                                            catch (JRValidationException e) {
                                                compilation_ok = false;
                                                it = e.getFaults().iterator();
                                                while (it.hasNext()) {
                                                    fault = (JRValidationFault)it.next();
                                                    source = fault.getSource();
                                                    sl = digester.getLocation(source);
                                                    if (sl == null) {
                                                        errorsCollector.getProblemItems().add(new ProblemItem(1, fault.getMessage(), sl, null));
                                                        continue;
                                                    }
                                                    errorsCollector.getProblemItems().add(new ProblemItem(1, fault.getMessage(), sl, sl.getXPath()));
                                                    System.out.println(fault + " " + fault.getMessage() + "\nLine: " + sl.getLineNumber() + ", Column: " + sl.getColumnNumber() + " JRXML Element: " + sl.getXPath());
                                                }
                                                this.getJrf().setReportProblems(errorsCollector.getProblemItems());
                                                MainFrame.getMainInstance().getLogPane().getProblemsPanel().updateProblemsList();
                                                sw = new StringWriter(0);
                                                e.printStackTrace(new PrintWriter(sw));
                                                System.out.println("\n\n\n");
                                                IReportCompiler.myPrintStream.flush();
                                                this.parseException(IReportCompiler.outputBuffer.toString() + sw.getBuffer() + "", null);
                                                var34_66 = null;
                                                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)old_jr_classpath);
                                                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)old_defaul_compiler);
                                                if (this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                                    if (oldCompileTemp != null) {
                                                        System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)oldCompileTemp);
                                                    } else {
                                                        System.setProperty("jasper.reports.compile.temp", "");
                                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)"");
                                                    }
                                                    javaSrcFile = new File(this.javaFile);
                                                    if (javaSrcFile.exists() && this.mainFrame.getProperties().getProperty("KeepJavaFile", "true").equals("false")) {
                                                        javaSrcFile.delete();
                                                    }
                                                }
                                                break block244;
                                            }
                                            catch (JRException jrex) {
                                                if (errorsCollector != null && errorsCollector.getProblemItems() != null) {
                                                    this.getJrf().setReportProblems(errorsCollector.getProblemItems());
                                                    MainFrame.getMainInstance().getLogPane().getProblemsPanel().updateProblemsList();
                                                }
                                                compilation_ok = false;
                                                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>" + I18n.getFormattedString("iReportCompiler.errorsCompiling", "Errors compiling {0}!", new Object[]{fileName}) + "</b></font>", true);
                                                sw = new StringWriter(0);
                                                jrex.printStackTrace(new PrintWriter(sw));
                                                System.out.println("\n\n\n");
                                                IReportCompiler.myPrintStream.flush();
                                                this.parseException(IReportCompiler.outputBuffer.toString() + sw.getBuffer() + "", null);
                                                var34_66 = null;
                                                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)old_jr_classpath);
                                                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)old_defaul_compiler);
                                                if (this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                                    if (oldCompileTemp != null) {
                                                        System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)oldCompileTemp);
                                                    } else {
                                                        System.setProperty("jasper.reports.compile.temp", "");
                                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)"");
                                                    }
                                                    javaSrcFile = new File(this.javaFile);
                                                    if (javaSrcFile.exists() && this.mainFrame.getProperties().getProperty("KeepJavaFile", "true").equals("false")) {
                                                        javaSrcFile.delete();
                                                    }
                                                }
                                                break block244;
                                            }
                                            catch (Exception ex) {
                                                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>" + I18n.getString("iReportCompiler.errorsCompilingReportJavaSource", "Error compiling the report java source!") + "</b></font>", true);
                                                sw = new StringWriter(0);
                                                ex.printStackTrace(new PrintWriter(sw));
                                                IReportCompiler.myPrintStream.flush();
                                                this.parseException(IReportCompiler.outputBuffer.toString() + sw.getBuffer() + "", null);
                                                compilation_ok = false;
                                                var34_66 = null;
                                                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)old_jr_classpath);
                                                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)old_defaul_compiler);
                                                if (this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                                    if (oldCompileTemp != null) {
                                                        System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)oldCompileTemp);
                                                    } else {
                                                        System.setProperty("jasper.reports.compile.temp", "");
                                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)"");
                                                    }
                                                    javaSrcFile = new File(this.javaFile);
                                                    if (javaSrcFile.exists() && this.mainFrame.getProperties().getProperty("KeepJavaFile", "true").equals("false")) {
                                                        javaSrcFile.delete();
                                                    }
                                                }
                                                break block244;
                                            }
                                            catch (Throwable ext) {
                                                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>" + I18n.getString("iReportCompiler.errorsCompilingReportJavaSource", "Error compiling the report java source!") + "</b></font>", true);
                                                sw = new StringWriter(0);
                                                ext.printStackTrace(new PrintWriter(sw));
                                                IReportCompiler.myPrintStream.flush();
                                                this.parseException(IReportCompiler.outputBuffer.toString() + sw.getBuffer() + "", null);
                                                compilation_ok = false;
                                                var34_66 = null;
                                                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)old_jr_classpath);
                                                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)old_defaul_compiler);
                                                if (this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                                    if (oldCompileTemp != null) {
                                                        System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)oldCompileTemp);
                                                    } else {
                                                        System.setProperty("jasper.reports.compile.temp", "");
                                                        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.temp.dir", (String)"");
                                                    }
                                                    javaSrcFile = new File(this.javaFile);
                                                    if (javaSrcFile.exists() && this.mainFrame.getProperties().getProperty("KeepJavaFile", "true").equals("false")) {
                                                        javaSrcFile.delete();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer.toString());
                                    IReportCompiler.outputBuffer = new StringBuffer();
                                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\"><b>" + I18n.getFormattedString("iReportCompiler.compilationRunningTime", "Compilation running time: {0,number}!", new Object[]{new Long(System.currentTimeMillis() - start)}) + "</b></font><hr>", true);
                                    if (errorsCollector != null && errorsCollector.getProblemItems().size() > 0) {
                                        try {
                                            SwingUtilities.invokeAndWait(new Runnable(){

                                                public void run() {
                                                    MainFrame.getMainInstance().getLogPane().setActiveLogComponent(MainFrame.getMainInstance().getLogPane().getProblemsPanel());
                                                }
                                            });
                                        }
                                        catch (InvocationTargetException ex) {
                                            ex.printStackTrace();
                                        }
                                        catch (InterruptedException ex) {
                                            ex.printStackTrace();
                                        }
                                    }
                                }
                                if (!compilation_ok) {
                                    IReportCompiler.fireCompileListner(this, 2, "sourcefail");
                                    this.removeThread();
                                    return;
                                }
                                if ((this.command & 2) == 0) break block250;
                                this.status = I18n.getString("iReportCompiler.status.generatingReport", "Generating report");
                                this.updateThreadList();
                                print = null;
                                img_url = this.getClass().getResource("/it/businesslogic/ireport/icons/rundb1_mini.jpg");
                                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;" + I18n.getString("iReportCompiler.fillingReport", "Filling report...") + "</font>", true);
                                this.statusLevel = 5;
                                hm = Prompter.promptForParameters(this.getJrf().getReport());
                                hm.put("REPORT_LOCALE", (JRGzipVirtualizer)Misc.getLocaleFromString(this.mainFrame.getProperties().getProperty("reportLocale")));
                                img_url = this.getClass().getResource("/it/businesslogic/ireport/icons/world.png");
                                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;" + I18n.getFormattedString("iReportCompiler.locale", "Locale: <b>{0}</b>", new Object[]{Misc.getLocaleFromString(this.mainFrame.getProperties().getProperty("reportLocale")).getDisplayName()}) + "</font>", true);
                                reportTimeZoneId = this.mainFrame.getProperties().getProperty("reportTimeZoneId");
                                timeZoneName = I18n.getString("timezone.default", "Default");
                                if (reportTimeZoneId != null && reportTimeZoneId.length() > 0) {
                                    tz = TimeZone.getTimeZone(reportTimeZoneId);
                                    hm.put("REPORT_TIME_ZONE", (JRGzipVirtualizer)tz);
                                    timeZoneName = new TimeZoneWrapper(tz) + "";
                                }
                                img_url = this.getClass().getResource("/it/businesslogic/ireport/icons/timezone.png");
                                this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;" + I18n.getFormattedString("iReportCompiler.timeZone", "Time zone: <b>{0}</b>", new Object[]{timeZoneName}) + "</font>", true);
                                reportMaxCount = 0;
                                try {
                                    reportMaxCount = Integer.parseInt(this.mainFrame.getProperties().getProperty("maxRecords", "0"));
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                if (reportMaxCount > 0) {
                                    img_url = this.getClass().getResource("/it/businesslogic/ireport/icons/file-info.png");
                                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;" + I18n.getFormattedString("iReportCompiler.maxRecords", "Max number of records: <b>{0,number}</b>", new Object[]{new Integer(reportMaxCount)}) + "</font>", true);
                                    hm.put("REPORT_MAX_COUNT", (JRGzipVirtualizer)new Integer(reportMaxCount));
                                }
                                if (MainFrame.getMainInstance().isIgnorePagination()) {
                                    hm.put("IS_IGNORE_PAGINATION", (JRGzipVirtualizer)Boolean.TRUE);
                                    img_url = this.getClass().getResource("/it/businesslogic/ireport/icons/file-info.png");
                                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;" + I18n.getString("iReportCompiler.ignoringPagination", "Ignoring pagination") + "</font>", true);
                                }
                                if (MainFrame.getMainInstance().isUseReportVirtualizer()) {
                                    try {
                                        virtualizer = null;
                                        rvName = this.mainFrame.getProperties().getProperty("ReportVirtualizer", "JRFileVirtualizer");
                                        vrTmpDirectory = this.mainFrame.getProperties().getProperty("ReportVirtualizerDirectory", this.mainFrame.getTranslatedCompileDirectory());
                                        vrSize = Integer.parseInt(this.mainFrame.getProperties().getProperty("ReportVirtualizerSize", "100"));
                                        msg = "";
                                        if (rvName.equals("JRGzipVirtualizer")) {
                                            msg = I18n.getFormattedString("iReportCompiler.JRGzipVirtualizer", "JRGzipVirtualizer Size: {0,number}<br>", new Object[]{new Integer(vrSize)});
                                            virtualizer = new JRGzipVirtualizer(vrSize);
                                        } else if (rvName.equals("JRSwapFileVirtualizer")) {
                                            msg = I18n.getFormattedString("iReportCompiler.JRSwapFileVirtualizer", "JRSwapFileVirtualizer Size: {0,number} Swap directory: {1};<br>  ReportVirtualizerBlockSize: {2}<br>ReportVirtualizerGrownCount: {3}<br>", new Object[]{new Integer(vrSize), vrTmpDirectory, this.mainFrame.getProperties().getProperty("ReportVirtualizerBlockSize", "100"), this.mainFrame.getProperties().getProperty("ReportVirtualizerGrownCount", "100")});
                                            swapFile = new JRSwapFile(vrTmpDirectory, Integer.parseInt(this.mainFrame.getProperties().getProperty("ReportVirtualizerBlockSize", "100")), Integer.parseInt(this.mainFrame.getProperties().getProperty("ReportVirtualizerGrownCount", "100")));
                                            virtualizer = new JRSwapFileVirtualizer(vrSize, swapFile);
                                        } else {
                                            msg = I18n.getFormattedString("iReportCompiler.JRFileVirtualizer", "JRFileVirtualizer Size: {0,number} Swap directory: {1};<br>", new Object[]{new Integer(vrSize), vrTmpDirectory});
                                            virtualizer = new JRFileVirtualizer(vrSize, vrTmpDirectory);
                                        }
                                        img_url = this.getClass().getResource("/it/businesslogic/ireport/icons/file-info.png");
                                        this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#000000\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;" + I18n.getString("iReportCompiler.usingVirtualizer", "Using report virtualizer... ") + msg + "</font>", true);
                                        hm.put("REPORT_VIRTUALIZER", virtualizer);
                                    }
                                    catch (Throwable ex) {
                                        this.getLogTextArea().logOnConsole("<font face=\"SansSerif\" size=\"3\" color=\"#660000\">" + I18n.getString("iReportCompiler.virtualizerNotAvailable", "WARNING: Report virtualizer not available.") + "</font>", true);
                                    }
                                }
                                start = System.currentTimeMillis();
                                if (this.properties.get("USE_EMPTY_DATASOURCE") == null || !this.properties.get("USE_EMPTY_DATASOURCE").equals("true")) break block251;
                                try {
                                    records = 1;
                                    try {
                                        records = (Integer)this.properties.get("EMPTY_DATASOURCE_RECORDS");
                                    }
                                    catch (Exception ex) {
                                        records = 1;
                                    }
                                    print = JasperFillManager.fillReport((String)fileName, (Map)hm, (JRDataSource)new JREmptyDataSource(records));
                                }
                                catch (OutOfMemoryError ex) {
                                    this.getLogTextArea().logOnConsole(I18n.getString("iReportCompiler.outOfMemory", "Out of memory exception!\n"));
                                }
                                catch (Exception ex) {
                                    this.getLogTextArea().logOnConsole(I18n.getFormattedString("iReportCompiler.errorFillingPrint", "Error filling print... {0}\n", new Object[]{ex.getMessage()}));
                                    ex.printStackTrace();
                                    this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer.toString());
                                    IReportCompiler.outputBuffer = new StringBuffer();
                                }
                                break block247;
                            }
                            if (this.properties.get("USE_CONNECTION") == null || !this.properties.get("USE_CONNECTION").equals("true")) break block247;
                            connection = (IReportConnection)this.properties.get("CONNECTION");
                            hm = connection.getSpecialParameters(hm);
                            hm = MainFrame.getMainInstance().getSpecialParameters(hm, this.jrf.getReport());
                            if (connection.isJDBCConnection()) {
                                print = JasperFillManager.fillReport((String)fileName, (Map)hm, (Connection)connection.getConnection());
                                break block245;
                            }
                            if (!connection.isJRDataSource()) ** GOTO lbl496
                            ds = null;
                            if (!(connection instanceof JRDataSourceProviderConnection)) ** GOTO lbl493
                            jasper_report_obj = JasperManager.loadReport((String)fileName);
                            ds = ((JRDataSourceProviderConnection)connection).getJRDataSource(jasper_report_obj);
                            if (ds != null) break block246;
                            connection.disposeSpecialParameters(hm);
                            if (connection != null && connection instanceof JRDataSourceProviderConnection) {
                                try {
                                    ((JRDataSourceProviderConnection)connection).disposeDataSource();
                                }
                                catch (Exception ex) {
                                    this.getLogTextArea().logOnConsole(I18n.getFormattedString("iReportCompiler.errorClosingDatasource", "Error closing datasource: {0}\n", new Object[]{ex.getMessage()}));
                                }
                            }
                            return;
                        }
                        try {
                            print = JasperFillManager.fillReport((JasperReport)jasper_report_obj, (Map)hm, (JRDataSource)ds);
                            try {
                                ((JRDataSourceProviderConnection)connection).disposeDataSource();
                            }
                            catch (Exception ex) {
                                this.getLogTextArea().logOnConsole(I18n.getFormattedString("iReportCompiler.errorClosingDatasource", "Error closing datasource: {0}\n", new Object[]{ex.getMessage()}));
                            }
                            break block245;
lbl493:
                            // 1 sources

                            ds = connection.getJRDataSource();
                            print = JasperFillManager.fillReport((String)fileName, (Map)hm, (JRDataSource)ds);
                            break block245;
lbl496:
                            // 1 sources

                            if (connection instanceof JRHibernateConnection) {
                                session = null;
                                transaction = null;
                                System.out.println();
                                this.getLogTextArea().logOnConsole(I18n.getString("iReportCompiler.HibernateSessionOpened", "Hibernate session opened"));
                                try {
                                    session = ((JRHibernateConnection)connection).createSession();
                                    transaction = session.beginTransaction();
                                    hm.put("HIBERNATE_SESSION", (JRGzipVirtualizer)session);
                                    print = JasperFillManager.fillReport((String)fileName, hm);
                                    break block245;
                                }
                                catch (Exception ex) {
                                    throw ex;
                                }
                                finally {
                                    if (transaction != null) {
                                        try {
                                            transaction.rollback();
                                        }
                                        catch (Exception ex) {}
                                    }
                                    if (transaction != null) {
                                        try {
                                            session.close();
                                        }
                                        catch (Exception ex) {}
                                    }
                                }
                            }
                            if (connection instanceof EJBQLConnection) {
                                em = null;
                                try {
                                    this.getLogTextArea().logOnConsole(I18n.getString("iReportCompiler.CreatingEntityManager", "Creating entity manager"));
                                    em = ((EJBQLConnection)connection).getEntityManager();
                                    hm.put("JPA_ENTITY_MANAGER", (JRGzipVirtualizer)em);
                                    Thread.currentThread().setContextClassLoader(reportClassLoader);
                                    print = JasperFillManager.fillReport((String)fileName, hm);
                                    break block245;
                                }
                                catch (Exception ex) {
                                    throw ex;
                                }
                                finally {
                                    this.getLogTextArea().logOnConsole(I18n.getString("iReportCompiler.ClosingEntityManager", "Closing entity manager"));
                                    ((EJBQLConnection)connection).closeEntityManager();
                                }
                            }
                            if (connection instanceof MondrianConnection) {
                                mCon = null;
                                try {
                                    this.getLogTextArea().logOnConsole(I18n.getString("iReportCompiler.OpeningMondrianConnection", "Opening Mondrian connection"));
                                    mCon = ((MondrianConnection)connection).getMondrianConnection();
                                    hm.put("MONDRIAN_CONNECTION", (JRGzipVirtualizer)mCon);
                                    Thread.currentThread().setContextClassLoader(reportClassLoader);
                                    print = JasperFillManager.fillReport((String)fileName, hm);
                                    break block245;
                                }
                                catch (Exception ex) {
                                    throw ex;
                                }
                                finally {
                                    this.getLogTextArea().logOnConsole(I18n.getString("iReportCompiler.ClosingMondrianConnection", "Closing Mondrian connection"));
                                    ((MondrianConnection)connection).closeMondrianConnection();
                                }
                            }
                            Thread.currentThread().setContextClassLoader(reportClassLoader);
                            print = JasperFillManager.fillReport((String)fileName, (Map)hm);
                        }
                        catch (Exception ex) {
                            this.getLogTextArea().logOnConsole(I18n.getFormattedString("iReportCompiler.errorFillingPrint", "Error filling print... {0}\n", new Object[]{ex.getMessage()}));
                            ex.printStackTrace();
                            this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer.toString());
                            IReportCompiler.outputBuffer = new StringBuffer();
                            connection.disposeSpecialParameters(hm);
                            if (connection != null && connection instanceof JRDataSourceProviderConnection) {
                                try {
                                    ((JRDataSourceProviderConnection)connection).disposeDataSource();
                                }
                                catch (Exception ex) {
                                    this.getLogTextArea().logOnConsole(I18n.getFormattedString("iReportCompiler.errorClosingDatasource", "Error closing datasource: {0}\n", new Object[]{ex.getMessage()}));
                                }
                            }
                            break block247;
                        }
                        catch (Throwable ext) {
                            this.getLogTextArea().logOnConsole(I18n.getFormattedString("iReportCompiler.errorFillingPrint", "Error filling print... {0}\n", new Object[]{ext + " " + ext.getCause()}));
                            ext.printStackTrace();
                            this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer.toString());
                            IReportCompiler.outputBuffer = new StringBuffer();
                            connection.disposeSpecialParameters(hm);
                            {
                                catch (Throwable var40_85) {
                                    connection.disposeSpecialParameters(hm);
                                    if (connection != null && connection instanceof JRDataSourceProviderConnection) {
                                        try {
                                            ((JRDataSourceProviderConnection)connection).disposeDataSource();
                                        }
                                        catch (Exception ex) {
                                            this.getLogTextArea().logOnConsole(I18n.getFormattedString("iReportCompiler.errorClosingDatasource", "Error closing datasource: {0}\n", new Object[]{ex.getMessage()}));
                                        }
                                    }
                                    throw var40_85;
                                }
                            }
                            if (connection != null && connection instanceof JRDataSourceProviderConnection) {
                                try {
                                    ((JRDataSourceProviderConnection)connection).disposeDataSource();
                                }
                                catch (Exception ex) {
                                    this.getLogTextArea().logOnConsole(I18n.getFormattedString("iReportCompiler.errorClosingDatasource", "Error closing datasource: {0}\n", new Object[]{ex.getMessage()}));
                                }
                            } else {
                                ** GOTO lbl607
                            }
                        }
                    }
                    connection.disposeSpecialParameters(hm);
                    if (connection != null && connection instanceof JRDataSourceProviderConnection) {
                        try {
                            ((JRDataSourceProviderConnection)connection).disposeDataSource();
                        }
                        catch (Exception ex) {
                            this.getLogTextArea().logOnConsole(I18n.getFormattedString("iReportCompiler.errorClosingDatasource", "Error closing datasource: {0}\n", new Object[]{ex.getMessage()}));
                        }
                    }
                }
                jrv = null;
                exporter /* !! */  = null;
                this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer.toString());
                IReportCompiler.outputBuffer = new StringBuffer();
                if (print != null) {
                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\">" + I18n.getFormattedString("iReportCompiler.fillingRunningTime", "<b>Report fill running time: {0,number}!</b> (pages generated: {1,number})", new Object[]{new Long(System.currentTimeMillis() - start), new Integer(print.getPages().size())}) + "</font><hr>", true);
                    this.status = I18n.getString("iReportCompiler.status.exportingReport", "Exporting report");
                    this.updateThreadList();
                    start = System.currentTimeMillis();
                    format = Misc.nvl(this.properties.get("OUTPUT_FORMAT"), "pdf");
                    viewer_program = "";
                    this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer.toString());
                    IReportCompiler.outputBuffer = new StringBuffer();
                    exportingMessage = "";
                    try {
                        if (format.equalsIgnoreCase("pdf")) {
                            exporter /* !! */  = new JRPdfExporter();
                            if (this.getMainFrame().getProperties().getProperty("PDF_IS_ENCRYPTED") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRPdfExporterParameter.IS_ENCRYPTED, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("PDF_IS_ENCRYPTED")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("PDF_IS_128_BIT_KEY") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRPdfExporterParameter.IS_128_BIT_KEY, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("PDF_IS_128_BIT_KEY")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("PDF_USER_PASSWORD") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRPdfExporterParameter.USER_PASSWORD, (Object)this.getMainFrame().getProperties().getProperty("PDF_USER_PASSWORD"));
                            }
                            if (this.getMainFrame().getProperties().getProperty("PDF_OWNER_PASSWORD") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRPdfExporterParameter.OWNER_PASSWORD, (Object)this.getMainFrame().getProperties().getProperty("PDF_OWNER_PASSWORD"));
                            }
                            if (this.getMainFrame().getProperties().getProperty("PDF_PERMISSIONS") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRPdfExporterParameter.PERMISSIONS, (Object)new Integer(this.getMainFrame().getProperties().getProperty("PDF_PERMISSIONS")));
                            }
                            fileName = Misc.changeFileExtension(fileName, "pdf");
                            exportingMessage = I18n.getFormattedString("iReportCompiler.exportingMessage.pdf", "Exporting pdf to file (using iText)...  {0}!", new Object[]{fileName});
                            viewer_program = this.mainFrame.getProperties().getProperty("ExternalPDFViewer");
                        } else if (format.equalsIgnoreCase("csv")) {
                            exporter /* !! */  = new JRCsvExporter();
                            if (this.getMainFrame().getProperties().getProperty("CSV_FIELD_DELIMITER") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, (Object)this.getMainFrame().getProperties().getProperty("CSV_FIELD_DELIMITER"));
                            }
                            fileName = Misc.changeFileExtension(fileName, "csv");
                            exportingMessage = I18n.getFormattedString("iReportCompiler.exportingMessage.csv", "Exporting CSV to file... {0}!", new Object[]{fileName});
                            viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalCSVViewer"), "");
                        } else if (format.equalsIgnoreCase("html")) {
                            exporter /* !! */  = new JRHtmlExporter();
                            if (this.getMainFrame().getProperties().getProperty("HTML_IMAGES_DIR_NAME") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_DIR_NAME, (Object)this.getMainFrame().getProperties().getProperty("HTML_IMAGES_DIR_NAME"));
                            }
                            if (this.getMainFrame().getProperties().getProperty("HTML_IS_OUTPUT_IMAGES_TO_DIR") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("HTML_IS_OUTPUT_IMAGES_TO_DIR")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("HTML_IMAGES_URI") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)this.getMainFrame().getProperties().getProperty("HTML_IMAGES_URI"));
                            }
                            if (this.getMainFrame().getProperties().getProperty("HTML_HTML_HEADER") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_HEADER, (Object)this.getMainFrame().getProperties().getProperty("HTML_HTML_HEADER"));
                            }
                            if (this.getMainFrame().getProperties().getProperty("HTML_BETWEEN_PAGES_HTML") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRHtmlExporterParameter.BETWEEN_PAGES_HTML, (Object)this.getMainFrame().getProperties().getProperty("HTML_BETWEEN_PAGES_HTML"));
                            }
                            if (this.getMainFrame().getProperties().getProperty("HTML_HTML_FOOTER") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_FOOTER, (Object)this.getMainFrame().getProperties().getProperty("HTML_HTML_FOOTER"));
                            }
                            if (this.getMainFrame().getProperties().getProperty("HTML_IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("HTML_IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("HTML_IS_WHITE_PAGE_BACKGROUND") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("HTML_IS_WHITE_PAGE_BACKGROUND")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("HTML_IS_USING_IMAGES_TO_ALIGN") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("HTML_IS_USING_IMAGES_TO_ALIGN")));
                            }
                            fileName = Misc.changeFileExtension(fileName, "html");
                            exportingMessage = I18n.getFormattedString("iReportCompiler.exportingMessage.html", "Exporting HTML to file... {0}!", new Object[]{fileName});
                            viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalHTMLViewer"), "");
                        } else if (format.equalsIgnoreCase("xls")) {
                            exporter /* !! */  = new JRXlsExporter();
                            if (this.getMainFrame().getProperties().getProperty("XLS_IS_ONE_PAGE_PER_SHEET") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("XLS_IS_ONE_PAGE_PER_SHEET")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("XLS_IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("XLS_IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("XLS_IS_WHITE_PAGE_BACKGROUND") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("XLS_IS_WHITE_PAGE_BACKGROUND")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("XLS_IS_DETECT_CELL_TYPE") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("XLS_IS_DETECT_CELL_TYPE")));
                            }
                            fileName = Misc.changeFileExtension(fileName, "xls");
                            exportingMessage = I18n.getFormattedString("iReportCompiler.exportingMessage.xls", "Exporting xls to file (using POI)... {0}!", new Object[]{fileName});
                            viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalXLSViewer"), "");
                        } else if (format.equalsIgnoreCase("xls2")) {
                            exporter /* !! */  = new JExcelApiExporter();
                            if (this.getMainFrame().getProperties().getProperty("XLS_IS_ONE_PAGE_PER_SHEET") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("XLS_IS_ONE_PAGE_PER_SHEET")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("XLS_IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("XLS_IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("XLS_IS_WHITE_PAGE_BACKGROUND") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("XLS_IS_WHITE_PAGE_BACKGROUND")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("XLS_IS_DETECT_CELL_TYPE") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("XLS_IS_DETECT_CELL_TYPE")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("XLS2_IS_FONT_SIZE_FIX_ENABLED") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JExcelApiExporterParameter.IS_FONT_SIZE_FIX_ENABLED, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("XLS2_IS_FONT_SIZE_FIX_ENABLED")));
                            }
                            fileName = Misc.changeFileExtension(fileName, "xls");
                            exportingMessage = I18n.getFormattedString("iReportCompiler.exportingMessage.xls2", "Exporting xls to file (using JExcelApi)... {0}!", new Object[]{fileName});
                            viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalXLSViewer"), "");
                        } else if (format.equalsIgnoreCase("java2D")) {
                            exportingMessage = I18n.getString("iReportCompiler.exportingMessage.java2D", "Exporting to Java2D...");
                            viewer_program = null;
                        } else if (format.equalsIgnoreCase("jrviewer")) {
                            exportingMessage = I18n.getString("iReportCompiler.exportingMessage.jrviewer", "Viewing with JasperReports Viewer");
                            exporter /* !! */  = null;
                            viewer_program = null;
                        } else if (format.equalsIgnoreCase("txt")) {
                            exporter /* !! */  = new JRTxtExporter();
                            if (this.getMainFrame().getProperties().getProperty("TXT_PAGE_ROWS") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRTxtExporterParameter.PAGE_ROWS, (Object)this.getMainFrame().getProperties().getProperty("TXT_PAGE_ROWS"));
                            }
                            if (this.getMainFrame().getProperties().getProperty("TXT_PAGE_COLUMNS") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRTxtExporterParameter.PAGE_COLUMNS, (Object)this.getMainFrame().getProperties().getProperty("TXT_PAGE_COLUMNS"));
                            }
                            if (this.getMainFrame().getProperties().getProperty("TXT_ADD_FORM_FEED") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRTxtExporterParameter.ADD_FORM_FEED, (Object)new Boolean(this.getMainFrame().getProperties().getProperty("TXT_ADD_FORM_FEED")));
                            }
                            fileName = Misc.changeFileExtension(fileName, "txt");
                            exportingMessage = I18n.getFormattedString("iReportCompiler.exportingMessage.txt", "Exporting txt (iReport) to file... {0}!", new Object[]{fileName});
                            viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalTXTViewer"), "");
                        } else if (format.equalsIgnoreCase("txtjr")) {
                            exporter /* !! */  = new JRTextExporter();
                            if (this.getMainFrame().getProperties().getProperty("JRTXT_PAGE_WIDTH") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_WIDTH, (Object)new Integer(this.getMainFrame().getProperties().getProperty("JRTXT_PAGE_WIDTH")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("JRTXT_PAGE_HEIGHT") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_HEIGHT, (Object)new Integer(this.getMainFrame().getProperties().getProperty("JRTXT_PAGE_HEIGHT")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("JRTXT_CHARACTER_WIDTH") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_WIDTH, (Object)new Integer(this.getMainFrame().getProperties().getProperty("JRTXT_CHARACTER_WIDTH")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("JRTXT_CHARACTER_HEIGHT") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_HEIGHT, (Object)new Integer(this.getMainFrame().getProperties().getProperty("JRTXT_CHARACTER_HEIGHT")));
                            }
                            if (this.getMainFrame().getProperties().getProperty("JRTXT_BETWEEN_PAGES_TEXT") != null) {
                                exporter /* !! */ .setParameter((JRExporterParameter)JRTextExporterParameter.BETWEEN_PAGES_TEXT, (Object)this.getMainFrame().getProperties().getProperty("JRTXT_BETWEEN_PAGES_TEXT"));
                            }
                            fileName = Misc.changeFileExtension(fileName, "txt");
                            exportingMessage = I18n.getFormattedString("iReportCompiler.exportingMessage.txtjr", "Exporting txt (jasperReports) to file... {0}!", new Object[]{fileName});
                            viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalTXTViewer"), "");
                        } else if (format.equalsIgnoreCase("rtf")) {
                            exporter /* !! */  = new JRRtfExporter();
                            fileName = Misc.changeFileExtension(fileName, "rtf");
                            exportingMessage = I18n.getFormattedString("iReportCompiler.exportingMessage.rtf", "Exporting RTF to file... {0}!", new Object[]{fileName});
                            viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalRTFViewer"), "");
                        } else if (format.equalsIgnoreCase("odf")) {
                            exporter /* !! */  = new JROdtExporter();
                            fileName = Misc.changeFileExtension(fileName, "odf");
                            exportingMessage = I18n.getFormattedString("iReportCompiler.exportingMessage.odf", "Exporting OpenOffice documento to file... {0}!", new Object[]{fileName});
                            viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalODFViewer"), "");
                        }
                        img_url = this.getClass().getResource("/it/businesslogic/ireport/icons/printer_mini.png");
                        this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\"><img align=\"right\" src=\"" + img_url + "\"> &nbsp;" + exportingMessage + "</font>", true);
                        if (exporter /* !! */  != null) {
                            exporter /* !! */ .setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)fileName);
                            exporter /* !! */ .setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
                            exporter /* !! */ .setParameter(JRExporterParameter.PROGRESS_MONITOR, (Object)this);
                            exporter /* !! */ .exportReport();
                            this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer.toString());
                            IReportCompiler.outputBuffer = new StringBuffer();
                        } else if (format.equalsIgnoreCase("java2D")) {
                            if (print.getPages().size() == 0) {
                                try {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getString("documentHasNoPages", "The document has no pages"));
                                        }
                                    });
                                }
                                catch (Exception ex) {}
                            } else {
                                pd = new PagesFrame(print);
                                pd.setVisible(true);
                            }
                        } else if (format.equalsIgnoreCase("jrviewer")) {
                            if (print.getPages().size() == 0) {
                                try {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getString("documentHasNoPages", "The document has no pages"));
                                        }
                                    });
                                }
                                catch (Exception ex) {}
                            } else {
                                jasperViewer = new JasperViewer(print, false);
                                jasperViewer.setTitle("iReport JasperViewer");
                                jasperViewer.setVisible(true);
                            }
                        }
                    }
                    catch (Throwable ex2) {
                        this.getLogTextArea().logOnConsole(I18n.getFormattedString("iReportCompiler.errorExportingPrint", "Error exporting print... {0}\n", new Object[]{ex2.getMessage()}));
                        ex2.printStackTrace();
                        this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer.toString());
                        IReportCompiler.outputBuffer = new StringBuffer();
                    }
                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\"><b>" + I18n.getFormattedString("iReportCompiler.exportRunningTime", "Export running time: {0,number}!", new Object[]{new Long(System.currentTimeMillis() - start), new Integer(print.getPages().size())}) + "</b></font><hr>", true);
                    rt = Runtime.getRuntime();
                    if (viewer_program == null || viewer_program.equals("")) {
                        if (!format.equalsIgnoreCase("jrviewer") && !format.equalsIgnoreCase("java2D")) {
                            this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\">" + I18n.getString("iReportCompiler.noExternalViewer", "No external viewer specified for this type of print. Set it in the options frame!") + "</font>", true);
                        }
                    } else {
                        try {
                            execute_string = viewer_program + " " + fileName + "";
                            this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\">" + I18n.getFormattedString("iReportCompiler.executingString", "Executing: {0}", new Object[]{execute_string}) + "</font>", true);
                            rt.exec(execute_string);
                        }
                        catch (Exception ex) {
                            this.getLogTextArea().logOnConsole("Error viewing report...\n");
                            ex.printStackTrace();
                            this.getLogTextArea().logOnConsole(IReportCompiler.outputBuffer.toString());
                            IReportCompiler.outputBuffer = new StringBuffer();
                        }
                    }
                } else {
                    this.getLogTextArea().logOnConsole("<font face=\"SansSerif\"  size=\"3\">" + I18n.getString("iReportCompiler.printNotFilled", "Print not filled. Try to use an EmptyDataSource...") + "</font>", true);
                    this.getLogTextArea().logOnConsole("\n");
                }
            }
            IReportCompiler.fireCompileListner(this, 1, "compileok");
            this.removeThread();
            if (backupJRClasspath != null) {
                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)backupJRClasspath);
            } else {
                JRProperties.restoreProperties();
            }
            if (backupSystemClasspath != null) {
                System.setProperty("java.class.path", backupSystemClasspath);
            } else {
                System.getProperties().remove("java.class.path");
            }
        }
        finally {
            System.gc();
            System.setOut(out);
            System.setErr(err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThread() {
        if (this.threadList != null) {
            JList jList = this.threadList;
            synchronized (jList) {
                DefaultListModel dlm = (DefaultListModel)this.threadList.getModel();
                dlm.removeElement(this);
                this.threadList.updateUI();
                this.getLogTextArea().setTitle(I18n.getString("iReportCompiler.status.finished", "Finished") + this.constTabTitle);
                this.getLogTextArea().setRemovable(true);
            }
        }
    }

    public int getCommand() {
        return this.command;
    }

    public void setCommand(int command) {
        this.command = command;
    }

    public IReportConnection getIReportConnection() {
        return this.iReportConnection;
    }

    public void setIReportConnection(IReportConnection iReportConnection) {
        this.iReportConnection = iReportConnection;
    }

    public JReportFrame getJrf() {
        return this.jrf;
    }

    public void setJrf(JReportFrame jrf) {
        this.jrf = jrf;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap properties) {
        this.properties = properties;
    }

    public String toString() {
        return this.status;
    }

    public void start() {
        this.thread = new Thread(this);
        try {
            String reportDirectory = new File(this.jrf.getReport().getFilename()).getParent();
            String classpath = JRProperties.getProperty((String)"net.sf.jasperreports.compiler.classpath");
            if (classpath != null) {
                classpath = classpath + File.pathSeparator + reportDirectory;
                JRProperties.setProperty((String)"net.sf.jasperreports.compiler.classpath", (String)classpath);
            } else if (System.getProperty("java.class.path") != null) {
                classpath = System.getProperty("java.class.path");
                classpath = classpath + File.pathSeparator + reportDirectory;
                System.setProperty("java.class.path", classpath);
            }
            if (MainFrame.getMainInstance().isUsingWS()) {
                try {
                    Enumeration<URL> e = MainFrame.getMainInstance().getReportClassLoader().getResources("META-INF/MANIFEST.MF");
                    while (e.hasMoreElements()) {
                        URL url = e.nextElement();
                        String newJar = "" + url.getFile();
                        if (newJar.endsWith("!/META-INF/MANIFEST.MF")) {
                            newJar = newJar.substring(0, newJar.length() - "!/META-INF/MANIFEST.MF".length());
                            newJar = URLDecoder.decode(newJar, "UTF-8");
                            MainFrame.getMainInstance().logOnConsole("JX:" + newJar);
                            newJar = newJar.replace('\\', '/');
                            if (newJar.startsWith("file://")) {
                                newJar = newJar.substring(7);
                            }
                            if (newJar.startsWith("file:")) {
                                newJar = newJar.substring(5);
                            }
                            if (!newJar.startsWith("/")) {
                                newJar = "/" + newJar;
                            }
                        }
                        if (classpath.indexOf(newJar + File.pathSeparator) >= 0 || classpath.endsWith(newJar)) continue;
                        classpath = classpath + File.pathSeparator + newJar;
                    }
                }
                catch (Exception exc) {
                    MainFrame.getMainInstance().logOnConsole("exception ex:" + exc.getMessage());
                    exc.printStackTrace();
                }
                System.setProperty("java.class.path", classpath);
            }
            if (!(reportDirectory = reportDirectory.replace('\\', '/')).endsWith("/")) {
                reportDirectory = reportDirectory + "/";
            }
            if (!reportDirectory.startsWith("/")) {
                reportDirectory = "/" + reportDirectory;
            }
            this.thread.setContextClassLoader(new URLClassLoader(new URL[]{new URL("file://" + reportDirectory)}, (ClassLoader)MainFrame.getMainInstance().getReportClassLoader()));
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        this.thread.start();
    }

    public void parseException(String exception, Vector sourceLines) {
        String outString = "";
        StringTokenizer st = new StringTokenizer(exception, "\n");
        while (st.hasMoreElements()) {
            String line = st.nextToken();
            if (line.startsWith(this.javaFile)) {
                String lineCode;
                outString = outString + Misc.toHTML(line + "\n");
                String lineNumber = line.substring(this.javaFile.length() + 1);
                int ln = Integer.parseInt(lineNumber = lineNumber.substring(0, lineNumber.indexOf(58)));
                if (ln >= 3) {
                    ln -= 3;
                }
                String reference = "";
                if (sourceLines.size() >= ln && (lineCode = (String)sourceLines.elementAt(ln)).indexOf("            case") == 0 && lineCode.indexOf(" : // ") > 0) {
                    reference = lineCode.substring(lineCode.indexOf(" : // ") + 6).trim();
                }
                if (!st.hasMoreElements()) continue;
                try {
                    String error_line = st.nextToken();
                    if (error_line.startsWith("found")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    if (error_line.startsWith("required")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    if (error_line.startsWith("symbol")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    if (error_line.startsWith("location")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    String html = "";
                    for (int i = 0; i < error_line.length() && error_line.charAt(i) == ' '; ++i) {
                        html = html + "&nbsp;";
                    }
                    error_line = error_line.trim();
                    html = html + "<a href=\"http://error:" + this.jrf.getWindowID() + "/" + reference + "\">" + Misc.toHTML(error_line) + "</a>";
                    outString = outString + html;
                }
                catch (Exception ex) {
                    outString = outString + Misc.toHTML("Error parsing\n!");
                }
                continue;
            }
            if (line.startsWith("Warning :") && line.indexOf("y=") > 0 && line.indexOf("height=") > 0 && line.indexOf("band-height=") > 0) {
                outString = outString + "<a href=\"http://warning:" + this.jrf.getWindowID() + "\">" + Misc.toHTML(line) + "</a>";
                continue;
            }
            outString = outString + Misc.toHTML(line + "\n");
        }
        this.getLogTextArea().logOnConsole(outString, true);
        outputBuffer = new StringBuffer();
    }

    public JComponent searchButton(JComponent root, String text) {
        if (root instanceof JButton && ((JButton)root).getText() != null && ((JButton)root).getText().equals(text)) {
            return root;
        }
        for (int i = 0; i < root.getComponentCount(); ++i) {
            if (!(root.getComponent(i) instanceof JComponent)) continue;
            this.getLogTextArea().logOnConsole("" + (JComponent)root.getComponent(i) + "\n");
            JComponent res = this.searchButton((JComponent)root.getComponent(i), text);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public void afterPageExport() {
        ++this.filledpage;
        if (this.command == 0) {
            // empty if block
        }
    }

    public JList getThreadList() {
        return this.threadList;
    }

    public void setThreadList(JList threadList) {
        this.threadList = threadList;
    }

    public void updateThreadList() {
        this.getLogTextArea().setTitle(this.status + this.constTabTitle);
        try {
            if (this.threadList != null) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        JList jList = IReportCompiler.this.threadList;
                        synchronized (jList) {
                            IReportCompiler.this.threadList.updateUI();
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            // empty if block
        }
        if (classLoader == null) {
            // empty if block
        }
        return classLoader;
    }

    public LogTextArea getLogTextArea() {
        return this.logTextArea;
    }

    public void setLogTextArea(LogTextArea logTextArea) {
        this.logTextArea = logTextArea;
    }

    public static void addCompileListener(ActionListener listener) {
        if (!compileListener.contains(listener)) {
            compileListener.add(listener);
        }
    }

    public static void removeCompileListener(ActionListener listener) {
        compileListener.remove(listener);
    }

    public static void fireCompileListner(IReportCompiler ireportCompiler, int id, String status) {
        ActionListener[] list = compileListener.toArray(new ActionListener[compileListener.size()]);
        ActionEvent e = new ActionEvent(ireportCompiler, id, status);
        for (int i = 0; i < list.length; ++i) {
            ActionListener listener = list[i];
            listener.actionPerformed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JasperDesign loadJasperDesign(InputStream fileStream, SourceTraceDigester digester) throws JRException {
        JRXmlLoader xmlLoader = new JRXmlLoader((Digester)digester);
        try {
            JasperDesign jasperDesign;
            JasperDesign jasperDesign2 = jasperDesign = xmlLoader.loadXML(fileStream);
            return jasperDesign2;
        }
        finally {
            try {
                fileStream.close();
            }
            catch (IOException e) {}
        }
    }

    public static SourceTraceDigester createDigester() throws JRException {
        SourceTraceDigester digester = new SourceTraceDigester();
        try {
            JRXmlDigesterFactory.configureDigester((Digester)digester);
        }
        catch (SAXException e) {
            throw new JRException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new JRException((Throwable)e);
        }
        return digester;
    }

    class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream aStream) {
            super(aStream);
        }

        public void write(byte[] b) throws IOException {
            String aString = new String(b);
            outputBuffer.append(aString);
            if (outputBuffer.length() > IReportCompiler.this.maxBufferSize) {
                outputBuffer = outputBuffer.delete(0, outputBuffer.length() - IReportCompiler.this.maxBufferSize);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            String aString = new String(b, off, len);
            outputBuffer.append(aString);
            if (outputBuffer.length() > IReportCompiler.this.maxBufferSize) {
                outputBuffer = outputBuffer.delete(0, outputBuffer.length() - IReportCompiler.this.maxBufferSize);
            }
        }
    }
}

