/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.span;

import com.tonbeller.jpivot.olap.model.MemberPropertyMeta;
import com.tonbeller.jpivot.olap.model.Property;
import com.tonbeller.jpivot.olap.model.impl.PropertyImpl;
import com.tonbeller.tbutils.res.Resources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class PropertyUtils {
    private static final String delimiter = ".";
    private static final char delimiterChar = '.';
    private static final String INLINE_PREFIX = "jsp.jpivot.inline.property.";
    public static final String STYLE_PROPERTY = "style";
    static Map inlineProps;

    private PropertyUtils() {
    }

    public static boolean isNested(String propertyName) {
        return propertyName.indexOf(46) > 0;
    }

    public static String getRootName(String propertyName) {
        int pos = propertyName.indexOf(46);
        if (pos >= 0) {
            return propertyName.substring(0, pos);
        }
        return propertyName;
    }

    public static boolean isInline(String propertyName) {
        if (propertyName.startsWith("$")) {
            return true;
        }
        String name = propertyName.toLowerCase();
        return inlineProps.containsKey(name);
    }

    public static boolean isStyleProperty(String propertyName) {
        String name = propertyName.toLowerCase();
        String value = (String)inlineProps.get(name);
        return STYLE_PROPERTY.equals(value);
    }

    public static Property[] normalize(Property[] properties) {
        if (!PropertyUtils.needsNormalization(properties)) {
            return properties;
        }
        HashMap<String, PropertyImpl> map = new HashMap<String, PropertyImpl>();
        ArrayList<PropertyImpl> result = new ArrayList<PropertyImpl>();
        for (int i = 0; i < properties.length; ++i) {
            Property src = properties[i];
            PropertyImpl parent = null;
            StringBuffer nameBuffer = new StringBuffer();
            StringTokenizer st = new StringTokenizer(src.getName(), delimiter);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                nameBuffer.append('.').append(token);
                String name = nameBuffer.toString();
                PropertyImpl child = (PropertyImpl)map.get(name);
                if (child == null) {
                    child = new PropertyImpl();
                    child.setName(token);
                    child.setLabel(token);
                    child.setValue("");
                    map.put(name, child);
                    if (parent == null) {
                        result.add(child);
                    } else {
                        parent.addProperty(child);
                    }
                }
                parent = child;
            }
            parent.setValue(src.getValue());
            parent.setLabel(src.getLabel());
            parent.setAlignment(src.getAlignment());
        }
        return result.toArray(new Property[result.size()]);
    }

    private static boolean needsNormalization(Property[] properties) {
        if (properties == null || properties.length < 2) {
            return false;
        }
        for (int i = 0; i < properties.length; ++i) {
            Property p = properties[i];
            if (!p.isNormalizable() || p.getName().indexOf(delimiter) <= 0) continue;
            return true;
        }
        return false;
    }

    public static void addProperties(Element target, Property[] properties) {
        properties = PropertyUtils.normalize(properties);
        PropertyUtils.recurseAddProperties(target, properties, false);
    }

    public static void addInlineProperties(Element target, Property[] properties) {
        if (properties.length > 0) {
            ArrayList<Property> list = new ArrayList<Property>();
            for (int i = 0; i < properties.length; ++i) {
                if (!PropertyUtils.isInline(properties[i].getName())) continue;
                list.add(properties[i]);
            }
            properties = list.toArray(new Property[list.size()]);
            properties = PropertyUtils.normalize(properties);
            PropertyUtils.recurseAddProperties(target, properties, true);
        }
    }

    private static void recurseAddProperties(Element parent, Property[] properties, boolean inline) {
        if (properties == null) {
            return;
        }
        for (int i = 0; i < properties.length; ++i) {
            Property p = properties[i];
            Element elem = parent.getOwnerDocument().createElement("property");
            parent.appendChild(elem);
            if (inline) {
                String name = p.getName().toLowerCase();
                name = (String)inlineProps.get(name);
                elem.setAttribute("name", name);
            } else {
                elem.setAttribute("name", p.getName());
            }
            elem.setAttribute("label", p.getLabel());
            elem.setAttribute("value", p.getValue());
            PropertyUtils.recurseAddProperties(elem, p.getProperties(), inline);
        }
    }

    public static MemberPropertyMeta[] getRootMetas(MemberPropertyMeta[] metas) {
        String name;
        int i;
        HashSet<String> nameSet = new HashSet<String>();
        ArrayList<MemberPropertyMeta> roots = new ArrayList<MemberPropertyMeta>();
        for (i = 0; i < metas.length; ++i) {
            name = metas[i].getName();
            if (PropertyUtils.isNested(name)) continue;
            nameSet.add(name);
            roots.add(metas[i]);
        }
        for (i = 0; i < metas.length; ++i) {
            String rootName;
            name = metas[i].getName();
            if (!PropertyUtils.isNested(name) || nameSet.contains(rootName = PropertyUtils.getRootName(name))) continue;
            nameSet.add(rootName);
            String label = PropertyUtils.getRootName(metas[i].getLabel());
            String scope = metas[i].getScope();
            roots.add(new MemberPropertyMeta(label, rootName, scope));
        }
        return roots.toArray(new MemberPropertyMeta[roots.size()]);
    }

    public static Property getInlineProperty(Property[] props, String name) {
        name = (String)inlineProps.get(name.toLowerCase());
        for (int i = 0; i < props.length; ++i) {
            String s = props[i].getName().toLowerCase();
            if ((s = (String)inlineProps.get(s)) == null || !s.equals(name)) continue;
            return props[i];
        }
        return null;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        int prefixLength = INLINE_PREFIX.length();
        Resources res = Resources.instance(PropertyUtils.class);
        for (String key : res.keySet()) {
            if (!key.startsWith(INLINE_PREFIX)) continue;
            String value = res.getString(key);
            key = key.substring(prefixLength);
            map.put(key, value);
        }
        inlineProps = Collections.unmodifiableMap(map);
    }
}

