/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.navigator.hierarchy;

import com.tonbeller.jpivot.core.ModelChangeEvent;
import com.tonbeller.jpivot.core.ModelChangeListener;
import com.tonbeller.jpivot.navigator.hierarchy.AbstractCategory;
import com.tonbeller.jpivot.navigator.hierarchy.AxisCategory;
import com.tonbeller.jpivot.navigator.hierarchy.HierarchyItem;
import com.tonbeller.jpivot.navigator.hierarchy.HierarchyItemClickHandler;
import com.tonbeller.jpivot.navigator.hierarchy.HierarchyItemRenderer;
import com.tonbeller.jpivot.navigator.hierarchy.SlicerCategory;
import com.tonbeller.jpivot.navigator.member.MemberSelectionModel;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.Result;
import com.tonbeller.jpivot.olap.navi.ChangeSlicer;
import com.tonbeller.jpivot.olap.navi.MemberDeleter;
import com.tonbeller.jpivot.olap.navi.PlaceHierarchiesOnAxes;
import com.tonbeller.jpivot.olap.navi.PlaceMembersOnAxes;
import com.tonbeller.jpivot.ui.Available;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.catedit.CategoryEditor;
import com.tonbeller.wcf.catedit.CategoryModel;
import com.tonbeller.wcf.catedit.CategoryModelSupport;
import com.tonbeller.wcf.catedit.ItemElementRenderer;
import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.controller.Dispatcher;
import com.tonbeller.wcf.controller.DispatcherSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HierarchyNavigator
extends CategoryEditor
implements ModelChangeListener,
Available {
    private String acceptButtonId;
    private String cancelButtonId;
    private RequestListener acceptHandler;
    private RequestListener revertHandler;
    private String okButtonId;
    private String revertButtonId;
    private List categories = new ArrayList();
    private Resources resources;
    private boolean editing;
    private HierarchyItemClickHandler hierarchyItemClickHandler;
    private OlapModel olapModel;
    private CategoryModelSupport categoryModel;
    private Dispatcher tempDispatcher;
    private SlicerCategory slicerCategory;
    private static Logger logger = Logger.getLogger(HierarchyNavigator.class);

    public HierarchyNavigator(String id, Component parent, OlapModel olapModel) {
        super(id, parent);
        Resources.instance();
        this.resources = Resources.instance((Locale)Resources.instance().getLocaleContextHolderLocale());
        this.editing = false;
        this.tempDispatcher = new DispatcherSupport();
        logger.info((Object)(this.resources.getString("jpivot.HierarchyNavigator.message.createInstance") + this));
        this.acceptButtonId = id + ".accept";
        this.cancelButtonId = id + ".cancel";
        this.okButtonId = id + ".ok";
        this.revertButtonId = id + ".revert";
        this.olapModel = olapModel;
        olapModel.addModelChangeListener(this);
        this.acceptHandler = new OkHandler(false);
        this.revertHandler = new CancelHandler(false);
        super.getDispatcher().addRequestListener(this.acceptButtonId, null, this.acceptHandler);
        super.getDispatcher().addRequestListener(this.revertButtonId, null, this.revertHandler);
        super.getDispatcher().addRequestListener(this.okButtonId, null, (RequestListener)new OkHandler(true));
        super.getDispatcher().addRequestListener(this.cancelButtonId, null, (RequestListener)new CancelHandler(true));
        super.getDispatcher().addRequestListener(null, null, (RequestListener)this.tempDispatcher);
        this.categoryModel = new CategoryModelSupport(){

            public List getCategories() {
                return HierarchyNavigator.this.categories;
            }
        };
        super.setModel((CategoryModel)this.categoryModel);
        super.setItemRenderer((ItemElementRenderer)new HierarchyItemRenderer());
    }

    public void initialize(RequestContext context) throws Exception {
        super.initialize(context);
        this.resources = Resources.instance();
        if (this.resources == null) {
            this.resources = context.getResources(HierarchyNavigator.class);
        }
    }

    public PlaceHierarchiesOnAxes getHierarchyExtension() {
        return (PlaceHierarchiesOnAxes)this.olapModel.getExtension("hierarchiesOnAxes");
    }

    public HierarchyItemClickHandler getHierarchyItemClickHandler() {
        return this.hierarchyItemClickHandler;
    }

    public PlaceMembersOnAxes getMemberExtension() {
        return (PlaceMembersOnAxes)this.olapModel.getExtension("membersOnAxes");
    }

    public MemberDeleter getDeleterExtension() {
        return (MemberDeleter)this.olapModel.getExtension("memberDeleter");
    }

    public OlapModel getOlapModel() {
        return this.olapModel;
    }

    public ChangeSlicer getSlicerExtension() {
        return (ChangeSlicer)this.olapModel.getExtension("changeSlicer");
    }

    Dispatcher getTempDispatcher() {
        return this.tempDispatcher;
    }

    void initializeCategories() throws OlapException {
        this.categories.clear();
        Result result = this.olapModel.getResult();
        Axis[] axes = result.getAxes();
        for (int index = 0; index < axes.length; ++index) {
            Axis axis = axes[index];
            String name = this.resources.getString("jsp.jpivot.axis." + index + ".name");
            String icon = this.resources.getString("jsp.jpivot.axis." + index + ".icon");
            String title = this.resources.getString("jsp.jpivot.axis." + index + ".title");
            AxisCategory axisCat = new AxisCategory(this, axis, name, icon, title);
            this.categories.add(axisCat);
        }
        String name = this.resources.getString("jsp.jpivot.slicer.name");
        String icon = this.resources.getString("jsp.jpivot.slicer.icon");
        String title = this.resources.getString("jsp.jpivot.slicer.title");
        this.slicerCategory = new SlicerCategory(this, name, icon, title);
        this.categories.add(this.slicerCategory);
    }

    public boolean isEditing() {
        return this.editing;
    }

    void itemClicked(RequestContext context, HierarchyItem item, MemberSelectionModel selection, boolean allowChangeOrder) {
        if (this.hierarchyItemClickHandler != null) {
            this.hierarchyItemClickHandler.itemClicked(context, item, selection, allowChangeOrder);
        }
    }

    public Element render(RequestContext context, Document factory) throws Exception {
        if (!this.editing) {
            this.tempDispatcher.clear();
            this.initializeCategories();
        }
        Element elem = super.render(context, factory);
        elem.setAttribute("accept-id", this.acceptButtonId);
        elem.setAttribute("accept-title", this.resources.getString("jsp.jpivot.accept.title"));
        elem.setAttribute("revert-id", this.revertButtonId);
        elem.setAttribute("revert-title", this.resources.getString("jsp.jpivot.revert.title"));
        elem.setAttribute("ok-id", this.okButtonId);
        elem.setAttribute("ok-title", this.resources.getString("jsp.jpivot.ok.title"));
        elem.setAttribute("cancel-id", this.cancelButtonId);
        elem.setAttribute("cancel-title", this.resources.getString("jsp.jpivot.cancel.title"));
        elem.setAttribute("close-title", this.resources.getString("jsp.jpivot.close.title"));
        return elem;
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
    }

    public void setHierarchyItemClickHandler(HierarchyItemClickHandler hierarchyItemClickHandler) {
        this.hierarchyItemClickHandler = hierarchyItemClickHandler;
    }

    public void modelChanged(ModelChangeEvent e) {
        this.editing = false;
    }

    public void structureChanged(ModelChangeEvent e) {
        logger.info((Object)this.resources.getString("jpivot.HierarchyNavigator.message.cleanUp"));
        this.setEditing(false);
        this.tempDispatcher.clear();
        this.categories.clear();
        this.categoryModel.fireModelChanged();
    }

    public HierarchyItem findHierarchyItem(Hierarchy hier) {
        for (AbstractCategory ac : this.categoryModel.getCategories()) {
            for (HierarchyItem hi : ac.getItems()) {
                if (!hi.getHierarchy().equals(hier)) continue;
                return hi;
            }
        }
        return null;
    }

    public RequestListener getAcceptHandler() {
        return this.acceptHandler;
    }

    public RequestListener getRevertHandler() {
        return this.revertHandler;
    }

    public Set getSlicerDimensions() {
        HashSet<Dimension> set = new HashSet<Dimension>();
        for (HierarchyItem hi : this.slicerCategory.getItems()) {
            set.add(hi.getHierarchy().getDimension());
        }
        return set;
    }

    public Resources getRes() {
        return this.resources;
    }

    public boolean isAvailable() {
        return this.getHierarchyExtension() != null;
    }

    public class OkHandler
    implements RequestListener {
        private boolean hide;

        public OkHandler(boolean hide) {
            this.hide = hide;
        }

        public void request(RequestContext context) throws Exception {
            HierarchyNavigator.this.editing = false;
            boolean valid = HierarchyNavigator.this.validate(context);
            try {
                Iterator it = HierarchyNavigator.this.categories.iterator();
                while (it.hasNext()) {
                    ((AbstractCategory)it.next()).deleteDeleted();
                }
                it = HierarchyNavigator.this.categories.iterator();
                while (it.hasNext()) {
                    ((AbstractCategory)it.next()).prepareApplyChanges();
                }
                it = HierarchyNavigator.this.categories.iterator();
                while (it.hasNext()) {
                    ((AbstractCategory)it.next()).applyChanges();
                }
            }
            catch (Exception e) {
                if (e.getMessage().startsWith("Internal error: Illegal access")) {
                    return;
                }
                throw new OlapException(e);
            }
            if (valid && this.hide) {
                HierarchyNavigator.this.setVisible(false);
            }
        }
    }

    public class CancelHandler
    implements RequestListener {
        private boolean hide;

        public CancelHandler(boolean hide) {
            this.hide = hide;
        }

        public void request(RequestContext context) throws Exception {
            HierarchyNavigator.this.editing = false;
            HierarchyNavigator.this.revert(context);
            if (this.hide) {
                HierarchyNavigator.this.setVisible(false);
            }
        }
    }
}

