/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.mondrian.MondrianDimension;
import com.tonbeller.jpivot.mondrian.MondrianHierarchy;
import com.tonbeller.jpivot.mondrian.MondrianLevel;
import com.tonbeller.jpivot.mondrian.MondrianMember;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.mondrian.MondrianUtil;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.query.Quax;
import com.tonbeller.jpivot.olap.query.QuaxUti;
import com.tonbeller.jpivot.olap.query.SetExp;
import com.tonbeller.tbutils.res.Resources;
import java.util.ArrayList;
import java.util.List;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Exp;
import mondrian.olap.FunCall;
import mondrian.olap.OlapElement;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import org.apache.log4j.Logger;

public class MondrianQuaxUti
implements QuaxUti {
    static Logger logger = Logger.getLogger(MondrianQuaxUti.class);
    private MondrianModel model = null;
    private SchemaReader scr;

    MondrianQuaxUti(MondrianModel model) {
        this.model = model;
        this.scr = model.getSchemaReader();
    }

    private static boolean isCallTo(FunCall f, String name) {
        return Resources.instance().getCollator().compare(f.getFunName().toLowerCase(), name.toLowerCase()) == 0;
    }

    public boolean isFunCallNotTopLevel(Object oFun) throws Quax.CannotHandleException {
        FunCall f = (FunCall)oFun;
        if (MondrianQuaxUti.isCallTo(f, "Children")) {
            return true;
        }
        if (MondrianQuaxUti.isCallTo(f, "Descendants")) {
            return true;
        }
        if (MondrianQuaxUti.isCallTo(f, "Members")) {
            mondrian.olap.Level lev = MondrianQuaxUti.getLevelArg(f, 0);
            return lev.getDepth() > 0;
        }
        if (MondrianQuaxUti.isCallTo(f, "Union")) {
            if (this.isFunCallNotTopLevel(f.getArg(0))) {
                return true;
            }
            return this.isFunCallNotTopLevel(f.getArg(1));
        }
        if (MondrianQuaxUti.isCallTo(f, "{}")) {
            for (int i = 0; i < f.getArgs().length; ++i) {
                if (this.isMemberOnToplevel(MondrianQuaxUti.getMemberArg(f, i))) continue;
                return true;
            }
            return false;
        }
        throw new Quax.CannotHandleException(f.getFunName());
    }

    public boolean isMemberOnToplevel(Object oMem) {
        mondrian.olap.Member m = ((MondrianMember)oMem).getMonMember();
        return this.isMemberOnToplevel(m);
    }

    private boolean isMemberOnToplevel(mondrian.olap.Member m) {
        return m.getLevel().getDepth() <= 0;
    }

    public boolean isMemberInFunCall(Object oFun, Member member) throws Quax.CannotHandleException {
        FunCall f = (FunCall)oFun;
        mondrian.olap.Member m = ((MondrianMember)member).getMonMember();
        return this.isMemberInFunCall(f, m);
    }

    private boolean isMemberInFunCall(FunCall f, mondrian.olap.Member m) throws Quax.CannotHandleException {
        if (MondrianQuaxUti.isCallTo(f, "Children")) {
            return this.isMemberInChildren(f, m);
        }
        if (MondrianQuaxUti.isCallTo(f, "Descendants")) {
            return this.isMemberInDescendants(f, m);
        }
        if (MondrianQuaxUti.isCallTo(f, "Members")) {
            return this.isMemberInLevel(f, m);
        }
        if (MondrianQuaxUti.isCallTo(f, "Union")) {
            return this.isMemberInUnion(f, m);
        }
        if (MondrianQuaxUti.isCallTo(f, "{}")) {
            return this.isMemberInSet(f, m);
        }
        throw new Quax.CannotHandleException(f.getFunName());
    }

    private boolean isMemberInChildren(FunCall f, mondrian.olap.Member mSearch) {
        if (mSearch.isCalculatedInQuery()) {
            return false;
        }
        mondrian.olap.Member parent = MondrianQuaxUti.getMemberArg(f, 0);
        return parent.equals(mSearch.getParentMember());
    }

    private boolean isMemberInDescendants(FunCall f, mondrian.olap.Member mSearch) {
        if (mSearch.isCalculatedInQuery()) {
            return false;
        }
        mondrian.olap.Member ancestor = MondrianQuaxUti.getMemberArg(f, 0);
        mondrian.olap.Level level = MondrianQuaxUti.getLevelArg(f, 1);
        if (mSearch.equals(ancestor)) {
            return false;
        }
        if (!mSearch.isChildOrEqualTo(ancestor)) {
            return false;
        }
        return level.equals(mSearch.getLevel());
    }

    private boolean isMemberInLevel(FunCall f, mondrian.olap.Member mSearch) {
        if (mSearch.isCalculatedInQuery()) {
            return false;
        }
        mondrian.olap.Level level = MondrianQuaxUti.getLevelArg(f, 0);
        return level.equals(mSearch.getLevel());
    }

    private boolean isMemberInSet(FunCall f, mondrian.olap.Member mSearch) {
        for (int i = 0; i < f.getArgs().length; ++i) {
            mondrian.olap.Member m = MondrianQuaxUti.getMemberArg(f, i);
            if (!m.equals(mSearch)) continue;
            return true;
        }
        return false;
    }

    private boolean isMemberInUnion(FunCall f, mondrian.olap.Member mSearch) throws Quax.CannotHandleException {
        for (int i = 0; i < 2; ++i) {
            FunCall fChild = (FunCall)f.getArg(i);
            if (!this.isMemberInFunCall(fChild, mSearch)) continue;
            return true;
        }
        return false;
    }

    public boolean isChildOfMemberInFunCall(Object oFun, Member member) throws Quax.CannotHandleException {
        FunCall f = (FunCall)oFun;
        mondrian.olap.Member m = ((MondrianMember)member).getMonMember();
        if (MondrianQuaxUti.isCallTo(f, "Children")) {
            return MondrianQuaxUti.getMemberArg(f, 0).equals(m);
        }
        if (MondrianQuaxUti.isCallTo(f, "Descendants")) {
            mondrian.olap.Member ancestor = MondrianQuaxUti.getMemberArg(f, 0);
            mondrian.olap.Level lev = MondrianQuaxUti.getLevelArg(f, 1);
            mondrian.olap.Level parentLevel = lev.getParentLevel();
            if (parentLevel != null && m.getLevel().equals(parentLevel)) {
                return m.isChildOrEqualTo(ancestor);
            }
            return false;
        }
        if (MondrianQuaxUti.isCallTo(f, "Members")) {
            mondrian.olap.Level lev = MondrianQuaxUti.getLevelArg(f, 0);
            mondrian.olap.Level parentLevel = lev.getParentLevel();
            return parentLevel != null && m.getLevel().equals(parentLevel);
        }
        if (MondrianQuaxUti.isCallTo(f, "Union")) {
            if (this.isChildOfMemberInFunCall(f.getArg(0), member)) {
                return true;
            }
            return this.isChildOfMemberInFunCall(f.getArg(1), member);
        }
        if (MondrianQuaxUti.isCallTo(f, "{}")) {
            for (int i = 0; i < f.getArgs().length; ++i) {
                mondrian.olap.Member mmp;
                mondrian.olap.Member mm = MondrianQuaxUti.getMemberArg(f, i);
                if (mm.isCalculatedInQuery() || (mmp = mm.getParentMember()) == null || !mmp.equals(m)) continue;
                return true;
            }
            return false;
        }
        throw new Quax.CannotHandleException(f.getFunName());
    }

    private static mondrian.olap.Level getLevelArg(FunCall f, int index) {
        return ((LevelExpr)f.getArg(index)).getLevel();
    }

    private static mondrian.olap.Member getMemberArg(FunCall f, int index) {
        return ((MemberExpr)f.getArg(index)).getMember();
    }

    public boolean isDescendantOfMemberInFunCall(Object oFun, Member member) throws Quax.CannotHandleException {
        FunCall f = (FunCall)oFun;
        mondrian.olap.Member m = ((MondrianMember)member).getMonMember();
        if (MondrianQuaxUti.isCallTo(f, "Children")) {
            mondrian.olap.Member mExp = MondrianQuaxUti.getMemberArg(f, 0);
            return mExp.isChildOrEqualTo(m);
        }
        if (MondrianQuaxUti.isCallTo(f, "Descendants")) {
            mondrian.olap.Member mExp = MondrianQuaxUti.getMemberArg(f, 0);
            return mExp.isChildOrEqualTo(m);
        }
        if (MondrianQuaxUti.isCallTo(f, "Members")) {
            mondrian.olap.Level levExp = MondrianQuaxUti.getLevelArg(f, 0);
            return levExp.getDepth() > m.getLevel().getDepth();
        }
        if (MondrianQuaxUti.isCallTo(f, "Union")) {
            if (this.isDescendantOfMemberInFunCall(f.getArg(0), member)) {
                return true;
            }
            return this.isDescendantOfMemberInFunCall(f.getArg(1), member);
        }
        if (MondrianQuaxUti.isCallTo(f, "{}")) {
            for (int i = 0; i < f.getArgs().length; ++i) {
                mondrian.olap.Member mExp = MondrianQuaxUti.getMemberArg(f, i);
                if (mExp.isCalculatedInQuery() || m.equals(mExp) || !mExp.isChildOrEqualTo(m)) continue;
                return true;
            }
            return false;
        }
        throw new Quax.CannotHandleException(f.getFunName());
    }

    public Object removeDescendantsFromFunCall(Object oFun, Member member) throws Quax.CannotHandleException {
        FunCall f = (FunCall)oFun;
        mondrian.olap.Member m = ((MondrianMember)member).getMonMember();
        if (MondrianQuaxUti.isCallTo(f, "Children")) {
            return null;
        }
        if (MondrianQuaxUti.isCallTo(f, "Descendants")) {
            return null;
        }
        if (MondrianQuaxUti.isCallTo(f, "Members")) {
            mondrian.olap.Level levExp = MondrianQuaxUti.getLevelArg(f, 0);
            List members = this.scr.getLevelMembers(levExp, false);
            ArrayList<mondrian.olap.Member> remainder = new ArrayList<mondrian.olap.Member>();
            for (int i = 0; i < members.size(); ++i) {
                mondrian.olap.Member currMember = (mondrian.olap.Member)members.get(i);
                if (currMember.isChildOrEqualTo(m)) continue;
                remainder.add(currMember);
            }
            return this.createMemberSet(remainder);
        }
        if (MondrianQuaxUti.isCallTo(f, "{}")) {
            ArrayList<mondrian.olap.Member> remainder = new ArrayList<mondrian.olap.Member>();
            for (int i = 0; i < f.getArgs().length; ++i) {
                mondrian.olap.Member mExp = MondrianQuaxUti.getMemberArg(f, i);
                if (mExp.isCalculatedInQuery() || !mExp.equals(m) && mExp.isChildOrEqualTo(m)) continue;
                remainder.add(mExp);
            }
            return this.createMemberSet(remainder);
        }
        if (MondrianQuaxUti.isCallTo(f, "Union")) {
            Exp e;
            Exp[] uargs = new Exp[]{(Exp)this.removeDescendantsFromFunCall(f.getArg(0), member), (Exp)this.removeDescendantsFromFunCall(f.getArg(1), member)};
            if (uargs[0] == null && uargs[1] == null) {
                return null;
            }
            if (uargs[1] == null) {
                return uargs[0];
            }
            if (uargs[0] == null) {
                return uargs[1];
            }
            if (uargs[0] instanceof mondrian.olap.Member) {
                e = uargs[0];
                uargs[0] = new UnresolvedFunCall("{}", Syntax.Braces, new Exp[]{e});
            }
            if (uargs[1] instanceof mondrian.olap.Member) {
                e = uargs[1];
                uargs[1] = new UnresolvedFunCall("{}", Syntax.Braces, new Exp[]{e});
            }
            return new UnresolvedFunCall("Union", uargs);
        }
        throw new Quax.CannotHandleException(f.getFunName());
    }

    public Object createMemberSet(List mList) {
        if (mList.size() == 0) {
            return null;
        }
        if (mList.size() == 1) {
            return mList.get(0);
        }
        Exp[] remExps = mList.toArray(new Exp[0]);
        return new UnresolvedFunCall("{}", Syntax.Braces, remExps);
    }

    static FunCall removeChildrenFromUnion(FunCall f, mondrian.olap.Member monMember) {
        FunCall f1 = (FunCall)f.getArg(0);
        FunCall f2 = (FunCall)f.getArg(1);
        if (MondrianQuaxUti.isCallTo(f1, "Children") && MondrianQuaxUti.getMemberArg(f1, 0).equals(monMember)) {
            return f2;
        }
        if (MondrianQuaxUti.isCallTo(f2, "Children") && MondrianQuaxUti.getMemberArg(f1, 0).equals(monMember)) {
            return f1;
        }
        FunCall f1New = f1;
        if (MondrianQuaxUti.isCallTo(f1, "Union")) {
            f1New = MondrianQuaxUti.removeChildrenFromUnion(f1, monMember);
        }
        FunCall f2New = f2;
        if (MondrianQuaxUti.isCallTo(f2, "Union")) {
            f2New = MondrianQuaxUti.removeChildrenFromUnion(f2, monMember);
        }
        if (f1 == f1New && f2 == f2New) {
            return f;
        }
        return new UnresolvedFunCall("Union", new Exp[]{f1New, f2New});
    }

    public Member memberForObj(Object oExp) {
        mondrian.olap.Member monMember = this.toMember(oExp);
        Member member = this.model.lookupMemberByUName(monMember.getUniqueName());
        return member;
    }

    public Object objForMember(Member member) {
        return ((MondrianMember)member).getMonMember();
    }

    public Object objForDim(Dimension dim) {
        return ((MondrianDimension)dim).getMonDimension();
    }

    public Dimension dimForMember(Member member) {
        mondrian.olap.Member m = ((MondrianMember)member).getMonMember();
        mondrian.olap.Dimension monDim = m.getDimension();
        return this.model.lookupDimension(monDim.getUniqueName());
    }

    public Hierarchy hierForMember(Member member) {
        mondrian.olap.Member m = ((MondrianMember)member).getMonMember();
        mondrian.olap.Hierarchy monHier = m.getHierarchy();
        return this.model.lookupHierarchy(monHier.getUniqueName());
    }

    public Level LevelForObj(Object oLevel) {
        if (oLevel instanceof LevelExpr) {
            oLevel = ((LevelExpr)oLevel).getLevel();
        }
        mondrian.olap.Level monLevel = (mondrian.olap.Level)oLevel;
        return this.model.lookupLevel(monLevel.getUniqueName());
    }

    public int funCallArgCount(Object oFun) {
        FunCall f = (FunCall)oFun;
        return f.getArgs().length;
    }

    public Object funCallArg(Object oFun, int index) {
        FunCall f = (FunCall)oFun;
        Exp arg = f.getArg(index);
        OlapElement element = this.fromExp(arg);
        return element == null ? arg : element;
    }

    public String funCallName(Object oFun) {
        return ((FunCall)oFun).getFunName();
    }

    public void addMemberDescendants(List list, Member member, Level level, int[] maxLevel) {
        block4: {
            mondrian.olap.Member m = ((MondrianMember)member).getMonMember();
            mondrian.olap.Level lev = ((MondrianLevel)level).getMonLevel();
            int parentLevel = lev.getDepth() + 1;
            if (parentLevel < maxLevel[0]) {
                return;
            }
            if (parentLevel > maxLevel[0]) {
                maxLevel[0] = parentLevel;
                list.clear();
            }
            if (parentLevel > 0) {
                for (Exp exp : list) {
                    FunCall f;
                    if (!(exp instanceof FunCall) || !MondrianQuaxUti.isCallTo(f = (FunCall)exp, "Descendants") || !MondrianQuaxUti.getMemberArg(f, 0).equals(m)) continue;
                    break block4;
                }
                UnresolvedFunCall fChildren = new UnresolvedFunCall("Descendants", Syntax.Function, new Exp[]{new MemberExpr(m), new LevelExpr(lev)});
                list.add(fChildren);
            }
        }
    }

    public Member getParentMember(Object oExp) {
        mondrian.olap.Member m = this.toMember(oExp);
        mondrian.olap.Member monParent = m.getParentMember();
        if (monParent == null) {
            return null;
        }
        Member parent = this.model.lookupMemberByUName(monParent.getUniqueName());
        return parent;
    }

    public Object createFunCall(String function, Object[] args, int funType) {
        Syntax syntax;
        Exp[] expArgs = new Exp[args.length];
        for (int i = 0; i < expArgs.length; ++i) {
            expArgs[i] = this.toExp(args[i]);
        }
        switch (funType) {
            case 2: {
                syntax = Syntax.Braces;
                break;
            }
            case 1: {
                syntax = Syntax.Property;
                break;
            }
            case 3: {
                syntax = Syntax.Parentheses;
                break;
            }
            case 4: {
                syntax = Syntax.Infix;
                break;
            }
            default: {
                syntax = Syntax.Function;
            }
        }
        return new UnresolvedFunCall(function, syntax, expArgs);
    }

    public boolean isFunCallTo(Object oExp, String function) {
        return MondrianQuaxUti.isCallTo((FunCall)oExp, function);
    }

    public boolean checkParent(Member pMember, Object cMemObj) {
        mondrian.olap.Member mc = this.toMember(cMemObj);
        if (mc.isCalculatedInQuery()) {
            return false;
        }
        mondrian.olap.Member mp = mc.getParentMember();
        if (mp == null) {
            return false;
        }
        return mp.equals(((MondrianMember)pMember).getMonMember());
    }

    public boolean checkChild(Member cMember, Object pMemObj) {
        mondrian.olap.Member mc = ((MondrianMember)cMember).getMonMember();
        if (mc.isCalculatedInQuery()) {
            return false;
        }
        mondrian.olap.Member mp = mc.getParentMember();
        if (mp == null) {
            return false;
        }
        return mp.equals(pMemObj);
    }

    public boolean checkDescendantM(Member aMember, Member dMember) {
        mondrian.olap.Member monMember = ((MondrianMember)aMember).getMonMember();
        mondrian.olap.Member monDesc = ((MondrianMember)dMember).getMonMember();
        if (monDesc.isCalculatedInQuery() || monDesc.equals(monMember)) {
            return false;
        }
        return monDesc.isChildOrEqualTo(monMember);
    }

    public boolean checkDescendantO(Member aMember, Object oMember) {
        mondrian.olap.Member monMember = ((MondrianMember)aMember).getMonMember();
        mondrian.olap.Member monDesc = this.toMember(oMember);
        if (monDesc.isCalculatedInQuery() || monDesc.equals(monMember)) {
            return false;
        }
        return monDesc.isChildOrEqualTo(monMember);
    }

    public void addLevelMembers(List list, Level level, int[] maxLevel) {
        block4: {
            mondrian.olap.Level lev = ((MondrianLevel)level).getMonLevel();
            int iLevel = lev.getDepth();
            if (iLevel < maxLevel[0]) {
                return;
            }
            if (iLevel > maxLevel[0]) {
                maxLevel[0] = iLevel;
                list.clear();
            }
            if (iLevel > 0) {
                for (Exp exp : list) {
                    FunCall f;
                    if (!(exp instanceof FunCall) || !MondrianQuaxUti.isCallTo(f = (FunCall)exp, "Members")) continue;
                    break block4;
                }
                UnresolvedFunCall fMembers = new UnresolvedFunCall("Members", Syntax.Property, new Exp[]{new LevelExpr(lev)});
                list.add(fMembers);
            }
        }
    }

    public Hierarchy hierForExp(Object exp) throws Quax.CannotHandleException {
        if (exp instanceof MemberExpr) {
            exp = ((MemberExpr)exp).getMember();
        } else if (exp instanceof LevelExpr) {
            exp = ((LevelExpr)exp).getLevel();
        } else if (exp instanceof HierarchyExpr) {
            exp = ((HierarchyExpr)exp).getHierarchy();
        } else if (exp instanceof DimensionExpr) {
            exp = ((DimensionExpr)exp).getDimension();
        }
        if (exp instanceof OlapElement) {
            return this.model.lookupHierarchy(((OlapElement)exp).getHierarchy().getUniqueName());
        }
        if (exp instanceof SetExp) {
            SetExp set = (SetExp)exp;
            return set.getHier();
        }
        FunCall f = (FunCall)exp;
        if (MondrianQuaxUti.isCallTo(f, "Children")) {
            mondrian.olap.Member m = MondrianQuaxUti.getMemberArg(f, 0);
            return this.model.lookupHierarchy(m.getHierarchy().getUniqueName());
        }
        if (MondrianQuaxUti.isCallTo(f, "Descendants")) {
            mondrian.olap.Member m = MondrianQuaxUti.getMemberArg(f, 0);
            return this.model.lookupHierarchy(m.getHierarchy().getUniqueName());
        }
        if (MondrianQuaxUti.isCallTo(f, "Members")) {
            mondrian.olap.Level lev = MondrianQuaxUti.getLevelArg(f, 0);
            return this.model.lookupHierarchy(lev.getHierarchy().getUniqueName());
        }
        if (MondrianQuaxUti.isCallTo(f, "Union")) {
            return this.hierForExp(f.getArg(0));
        }
        if (MondrianQuaxUti.isCallTo(f, "{}")) {
            mondrian.olap.Member m = MondrianQuaxUti.getMemberArg(f, 0);
            return this.model.lookupHierarchy(m.getHierarchy().getUniqueName());
        }
        if (MondrianQuaxUti.isCallTo(f, "TopCount") || MondrianQuaxUti.isCallTo(f, "BottomCount") || MondrianQuaxUti.isCallTo(f, "TopPercent") || MondrianQuaxUti.isCallTo(f, "BottomPercent") || MondrianQuaxUti.isCallTo(f, "Filter")) {
            return this.hierForExp(f.getArg(0));
        }
        throw new Quax.CannotHandleException(f.getFunName());
    }

    public int levelDepthForMember(Object oExp) {
        mondrian.olap.Member m = this.toMember(oExp);
        mondrian.olap.Level level = m.getLevel();
        return level.getDepth();
    }

    public Object topLevelMembers(Hierarchy hier, boolean expandAllMember) {
        return MondrianUtil.topLevelMembers(((MondrianHierarchy)hier).getMonHierarchy(), expandAllMember, this.scr);
    }

    public Level getParentLevel(Level level) {
        mondrian.olap.Level monLevel = ((MondrianLevel)level).getMonLevel();
        mondrian.olap.Level monParentLevel = monLevel.getParentLevel();
        return this.model.lookupLevel(monParentLevel.getUniqueName());
    }

    public Exp toExp(Object o) {
        if (o instanceof OlapElement) {
            if (o instanceof mondrian.olap.Member) {
                return new MemberExpr((mondrian.olap.Member)o);
            }
            if (o instanceof mondrian.olap.Level) {
                return new LevelExpr((mondrian.olap.Level)o);
            }
            if (o instanceof mondrian.olap.Hierarchy) {
                return new HierarchyExpr((mondrian.olap.Hierarchy)o);
            }
            return new DimensionExpr((mondrian.olap.Dimension)o);
        }
        return (Exp)o;
    }

    private OlapElement fromExp(Exp e) {
        if (e instanceof MemberExpr) {
            MemberExpr memberExpr = (MemberExpr)e;
            return memberExpr.getMember();
        }
        if (e instanceof LevelExpr) {
            LevelExpr levelExpr = (LevelExpr)e;
            return levelExpr.getLevel();
        }
        if (e instanceof HierarchyExpr) {
            HierarchyExpr hierarchyExpr = (HierarchyExpr)e;
            return hierarchyExpr.getHierarchy();
        }
        if (e instanceof DimensionExpr) {
            DimensionExpr dimensionExpr = (DimensionExpr)e;
            return dimensionExpr.getDimension();
        }
        return null;
    }

    public boolean isMember(Object oExp) {
        return oExp instanceof mondrian.olap.Member || oExp instanceof MemberExpr;
    }

    private mondrian.olap.Member toMember(Object cMemObj) {
        if (cMemObj instanceof mondrian.olap.Member) {
            return (mondrian.olap.Member)cMemObj;
        }
        MemberExpr memberExpr = (MemberExpr)cMemObj;
        return memberExpr.getMember();
    }

    public boolean isFunCall(Object oExp) {
        return oExp instanceof FunCall;
    }

    public void addMemberSiblings(List list, Member member, int[] maxLevel) {
        block4: {
            mondrian.olap.Member m = ((MondrianMember)member).getMonMember();
            int level = m.getLevel().getDepth();
            if (level < maxLevel[0]) {
                return;
            }
            if (level > maxLevel[0]) {
                maxLevel[0] = level;
                list.clear();
            }
            if (level > 0) {
                mondrian.olap.Member parent = m.getParentMember();
                for (Exp exp : list) {
                    FunCall f;
                    if (!this.isFunCall(exp) || !MondrianQuaxUti.isCallTo(f = (FunCall)exp, "Children") || !MondrianQuaxUti.getMemberArg(f, 0).equals(parent)) continue;
                    break block4;
                }
                UnresolvedFunCall fSiblings = new UnresolvedFunCall("Children", Syntax.Property, new Exp[]{new MemberExpr(parent)});
                list.add(fSiblings);
            }
        }
    }

    public void addMemberChildren(List list, Member member, int[] maxLevel) {
        block4: {
            mondrian.olap.Member m = ((MondrianMember)member).getMonMember();
            int childLevel = m.getLevel().getDepth() + 1;
            if (childLevel < maxLevel[0]) {
                return;
            }
            if (childLevel > maxLevel[0]) {
                maxLevel[0] = childLevel;
                list.clear();
            }
            if (childLevel > 0) {
                for (Exp exp : list) {
                    FunCall f;
                    if (!this.isFunCall(exp) || !MondrianQuaxUti.isCallTo(f = (FunCall)exp, "Children") || !MondrianQuaxUti.getMemberArg(f, 0).equals(m)) continue;
                    break block4;
                }
                UnresolvedFunCall fChildren = new UnresolvedFunCall("Children", Syntax.Property, new Exp[]{new MemberExpr(m)});
                list.add(fChildren);
            }
        }
    }

    public void addMemberUncles(List list, Member member, int[] maxLevel) {
        block4: {
            mondrian.olap.Member m = ((MondrianMember)member).getMonMember();
            int parentLevel = m.getLevel().getDepth() - 1;
            if (parentLevel < maxLevel[0]) {
                return;
            }
            if (parentLevel > maxLevel[0]) {
                maxLevel[0] = parentLevel;
                list.clear();
            }
            if (parentLevel > 0) {
                mondrian.olap.Member parent = m.getParentMember();
                mondrian.olap.Member grandPa = parent.getParentMember();
                for (Exp exp : list) {
                    FunCall f;
                    if (!this.isFunCall(exp) || !MondrianQuaxUti.isCallTo(f = (FunCall)exp, "Children") || !MondrianQuaxUti.getMemberArg(f, 0).equals(grandPa)) continue;
                    break block4;
                }
                UnresolvedFunCall fUncles = new UnresolvedFunCall("Children", Syntax.Property, new Exp[]{new MemberExpr(grandPa)});
                list.add(fUncles);
            }
        }
    }

    public String getMemberUniqueName(Object oExp) {
        mondrian.olap.Member m = this.toMember(oExp);
        return m.getUniqueName();
    }

    public StringBuffer funString(Object oFun) {
        FunCall f = (FunCall)oFun;
        StringBuffer buf = new StringBuffer();
        if (MondrianQuaxUti.isCallTo(f, "Children")) {
            mondrian.olap.Member m = MondrianQuaxUti.getMemberArg(f, 0);
            buf.append(m.getUniqueName());
            buf.append(".children");
        } else if (MondrianQuaxUti.isCallTo(f, "Descendants")) {
            mondrian.olap.Member m = MondrianQuaxUti.getMemberArg(f, 0);
            mondrian.olap.Level lev = MondrianQuaxUti.getLevelArg(f, 1);
            buf.append("Descendants(");
            buf.append(m.getUniqueName());
            buf.append(",");
            buf.append(lev.getUniqueName());
            buf.append(")");
        } else if (MondrianQuaxUti.isCallTo(f, "members")) {
            mondrian.olap.Level lev = MondrianQuaxUti.getLevelArg(f, 0);
            buf.append(lev.getUniqueName());
            buf.append(".Members");
        } else if (MondrianQuaxUti.isCallTo(f, "Union")) {
            buf.append("Union(");
            FunCall f1 = (FunCall)f.getArg(0);
            buf.append(this.funString(f1));
            buf.append(",");
            FunCall f2 = (FunCall)f.getArg(1);
            buf.append(this.funString(f2));
            buf.append(")");
        } else if (MondrianQuaxUti.isCallTo(f, "{}")) {
            buf.append("{");
            for (int i = 0; i < f.getArgs().length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                mondrian.olap.Member m = MondrianQuaxUti.getMemberArg(f, i);
                buf.append(m.getUniqueName());
            }
            buf.append("}");
        } else if (MondrianQuaxUti.isCallTo(f, "TopCount") || MondrianQuaxUti.isCallTo(f, "BottomCount") || MondrianQuaxUti.isCallTo(f, "TopPercent") || MondrianQuaxUti.isCallTo(f, "BottomPercent")) {
            buf.append(f.getFunName());
            buf.append("(");
            FunCall f1 = (FunCall)f.getArg(0);
            buf.append(this.funString(f1));
            buf.append(")");
        }
        return buf;
    }

    public String memberString(Member[] mPath) {
        if (mPath == null || mPath.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mPath.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            mondrian.olap.Member m = ((MondrianMember)mPath[i]).getMonMember();
            sb.append(m.getUniqueName());
        }
        return sb.toString();
    }

    public boolean equalMember(Object oExp, Member member) {
        mondrian.olap.Member m = ((MondrianMember)member).getMonMember();
        mondrian.olap.Member oMon = this.toMember(oExp);
        return m.equals(oMon);
    }

    public boolean canHandle(Object oExp) {
        if (this.isMember(oExp)) {
            return true;
        }
        FunCall f = (FunCall)oExp;
        if (MondrianQuaxUti.isCallTo(f, "children")) {
            return true;
        }
        if (MondrianQuaxUti.isCallTo(f, "descendants")) {
            return true;
        }
        if (MondrianQuaxUti.isCallTo(f, "members")) {
            return true;
        }
        if (MondrianQuaxUti.isCallTo(f, "{}")) {
            return true;
        }
        if (MondrianQuaxUti.isCallTo(f, "union")) {
            for (int i = 0; i < f.getArgs().length; ++i) {
                if (this.canHandle(f.getArg(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object[] getChildren(Object oMember) {
        List members = this.scr.getMemberChildren(this.toMember(oMember));
        return members.toArray(new mondrian.olap.Member[0]);
    }

    public Object[] getLevelMembers(Level level) {
        mondrian.olap.Level monLevel = ((MondrianLevel)level).getMonLevel();
        List members = this.scr.getLevelMembers(monLevel, false);
        return members.toArray(new mondrian.olap.Member[0]);
    }
}

