/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.format;

import com.tonbeller.wcf.format.BasicTypes;
import com.tonbeller.wcf.format.FormatHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Formatter
implements BasicTypes {
    List handlerList = new ArrayList();
    Map handlerMap = new HashMap();
    Locale locale;

    public void setLocale(Locale locale) {
        this.locale = locale;
        for (FormatHandler fh : this.handlerList) {
            fh.setLocale(locale);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void addHandler(FormatHandler newHandler) {
        String type = newHandler.getName();
        FormatHandler oldHandler = (FormatHandler)this.handlerMap.get(type);
        if (oldHandler != null) {
            this.handlerMap.remove(type);
            this.handlerList.remove(oldHandler);
        }
        this.handlerMap.put(type, newHandler);
        this.handlerList.add(newHandler);
    }

    public FormatHandler getHandler(String type) {
        if (type == null || type.length() == 0) {
            type = "string";
        }
        return (FormatHandler)this.handlerMap.get(type);
    }

    public String format(String type, Object value, String userPattern) {
        FormatHandler fh = this.getHandler(type);
        if (fh == null) {
            return String.valueOf(value);
        }
        return fh.format(value, userPattern);
    }

    public Object parse(String type, String value, String userPattern) {
        FormatHandler fh = this.getHandler(type);
        if (fh == null) {
            return value;
        }
        return fh.parse(value, userPattern);
    }

    public FormatHandler guessHandler(Object value) {
        for (FormatHandler fh : this.handlerList) {
            if (!fh.canHandle(value)) continue;
            return fh;
        }
        return null;
    }
}

