/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.util.spring;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class EagerPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer
implements InitializingBean {
    private ConfigurableListableBeanFactory beanFactory;
    private boolean processingCompleted = false;

    public void afterPropertiesSet() throws Exception {
        if (this.beanFactory != null) {
            super.postProcessBeanFactory(this.beanFactory);
            this.processingCompleted = true;
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory instanceof ConfigurableListableBeanFactory ? (ConfigurableListableBeanFactory)beanFactory : null;
        super.setBeanFactory(beanFactory);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (!this.processingCompleted) {
            super.postProcessBeanFactory(beanFactory);
            this.processingCompleted = true;
        }
    }
}

