/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.service.impl;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;

public abstract class BaseClassMappings {
    protected final Comparator itfComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Class itf1 = (Class)o1;
            Class itf2 = (Class)o2;
            if (itf1.equals(itf2)) {
                return 0;
            }
            if (itf2.isAssignableFrom(itf1)) {
                return -1;
            }
            if (itf1.isAssignableFrom(itf2)) {
                return 1;
            }
            return itf1.getName().compareTo(itf2.getName());
        }
    };

    protected final Object getClassMapping(Map classMappings, Class itfClass) {
        Object mapping;
        if (classMappings == null) {
            return null;
        }
        TreeSet<Class> interfaces = new TreeSet<Class>(this.itfComparator);
        for (String itfName : classMappings.keySet()) {
            Class itf = this.resolveClass(itfName);
            if (!itf.isAssignableFrom(itfClass)) continue;
            interfaces.add(itf);
        }
        if (interfaces.isEmpty()) {
            mapping = null;
        } else {
            Class itf = (Class)interfaces.iterator().next();
            mapping = classMappings.get(itf.getName());
        }
        return mapping;
    }

    protected Class resolveClass(String name) {
        try {
            return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    protected final Object getClassMapping(Map classMappings, String itfClassName) {
        return this.getClassMapping(classMappings, this.resolveClass(itfClassName));
    }
}

