/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.domain.impl;

import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrorFilter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class SimpleValidationErrorFilter
implements ValidationErrorFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Set codesToInclude = new HashSet();
    private final Set codesToExclude = new HashSet();
    private final Set fieldsToInclude = new HashSet();
    private final Set fieldsToExclude = new HashSet();

    public boolean matchError(ValidationError error) {
        return this.matchErrorCode(error.getErrorCode());
    }

    public boolean matchErrorCode(String code) {
        return !(!this.codesToInclude.isEmpty() && !this.codesToInclude.contains(code) || !this.codesToExclude.isEmpty() && this.codesToExclude.contains(code));
    }

    public boolean matchErrorField(String field) {
        return !(!this.fieldsToInclude.isEmpty() && !this.fieldsToInclude.contains(field) || !this.codesToExclude.isEmpty() && this.fieldsToExclude.contains(field));
    }

    public void addErrorCodeToInclude(String code) {
        this.codesToInclude.add(code);
        this.codesToExclude.remove(code);
    }

    public void addErrorCodeToExclude(String code) {
        this.codesToExclude.add(code);
        this.codesToInclude.remove(code);
    }

    public void addErrorFieldToInclude(String field) {
        this.fieldsToInclude.add(field);
        this.fieldsToExclude.remove(field);
    }

    public void addErrorFieldToExclude(String field) {
        this.fieldsToExclude.add(field);
        this.fieldsToInclude.remove(field);
    }
}

