/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.vote;

import java.util.Vector;
import junit.framework.TestCase;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.TestingAuthenticationToken;
import org.springframework.security.vote.DenyAgainVoter;
import org.springframework.security.vote.DenyVoter;
import org.springframework.security.vote.RoleVoter;
import org.springframework.security.vote.UnanimousBased;

public class UnanimousBasedTests
extends TestCase {
    private UnanimousBased makeDecisionManager() {
        UnanimousBased decisionManager = new UnanimousBased();
        RoleVoter roleVoter = new RoleVoter();
        DenyVoter denyForSureVoter = new DenyVoter();
        DenyAgainVoter denyAgainForSureVoter = new DenyAgainVoter();
        Vector<Object> voters = new Vector<Object>();
        voters.add(roleVoter);
        voters.add(denyForSureVoter);
        voters.add(denyAgainForSureVoter);
        decisionManager.setDecisionVoters(voters);
        return decisionManager;
    }

    private UnanimousBased makeDecisionManagerWithFooBarPrefix() {
        UnanimousBased decisionManager = new UnanimousBased();
        RoleVoter roleVoter = new RoleVoter();
        roleVoter.setRolePrefix("FOOBAR_");
        DenyVoter denyForSureVoter = new DenyVoter();
        DenyAgainVoter denyAgainForSureVoter = new DenyAgainVoter();
        Vector<Object> voters = new Vector<Object>();
        voters.add(roleVoter);
        voters.add(denyForSureVoter);
        voters.add(denyAgainForSureVoter);
        decisionManager.setDecisionVoters(voters);
        return decisionManager;
    }

    private TestingAuthenticationToken makeTestToken() {
        return new TestingAuthenticationToken((Object)"somebody", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_1"), new GrantedAuthorityImpl("ROLE_2")});
    }

    private TestingAuthenticationToken makeTestTokenWithFooBarPrefix() {
        return new TestingAuthenticationToken((Object)"somebody", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("FOOBAR_1"), new GrantedAuthorityImpl("FOOBAR_2")});
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testOneAffirmativeVoteOneDenyVoteOneAbstainVoteDeniesAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        UnanimousBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition(new String[]{"ROLE_1", "DENY_FOR_SURE"});
        try {
            mgr.decide((Authentication)auth, new Object(), config);
            UnanimousBasedTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            UnanimousBasedTests.assertTrue((boolean)true);
        }
    }

    public void testOneAffirmativeVoteTwoAbstainVotesGrantsAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        UnanimousBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition("ROLE_2");
        mgr.decide((Authentication)auth, new Object(), config);
        UnanimousBasedTests.assertTrue((boolean)true);
    }

    public void testOneDenyVoteTwoAbstainVotesDeniesAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        UnanimousBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition("ROLE_WE_DO_NOT_HAVE");
        try {
            mgr.decide((Authentication)auth, new Object(), config);
            UnanimousBasedTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            UnanimousBasedTests.assertTrue((boolean)true);
        }
    }

    public void testRoleVoterPrefixObserved() throws Exception {
        TestingAuthenticationToken auth = this.makeTestTokenWithFooBarPrefix();
        UnanimousBased mgr = this.makeDecisionManagerWithFooBarPrefix();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition(new String[]{"FOOBAR_1", "FOOBAR_2"});
        mgr.decide((Authentication)auth, new Object(), config);
        UnanimousBasedTests.assertTrue((boolean)true);
    }

    public void testThreeAbstainVotesDeniesAccessWithDefault() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        UnanimousBased mgr = this.makeDecisionManager();
        UnanimousBasedTests.assertTrue((!mgr.isAllowIfAllAbstainDecisions() ? 1 : 0) != 0);
        ConfigAttributeDefinition config = new ConfigAttributeDefinition("IGNORED_BY_ALL");
        try {
            mgr.decide((Authentication)auth, new Object(), config);
            UnanimousBasedTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            UnanimousBasedTests.assertTrue((boolean)true);
        }
    }

    public void testThreeAbstainVotesGrantsAccessWithoutDefault() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        UnanimousBased mgr = this.makeDecisionManager();
        mgr.setAllowIfAllAbstainDecisions(true);
        UnanimousBasedTests.assertTrue((boolean)mgr.isAllowIfAllAbstainDecisions());
        ConfigAttributeDefinition config = new ConfigAttributeDefinition("IGNORED_BY_ALL");
        mgr.decide((Authentication)auth, new Object(), config);
        UnanimousBasedTests.assertTrue((boolean)true);
    }

    public void testTwoAffirmativeVotesTwoAbstainVotesGrantsAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        UnanimousBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition(new String[]{"ROLE_1", "ROLE_2"});
        mgr.decide((Authentication)auth, new Object(), config);
        UnanimousBasedTests.assertTrue((boolean)true);
    }
}

