/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.memory;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.userdetails.memory.UserMap;
import org.springframework.security.userdetails.memory.UserMapEditor;

public class UserMapEditorTests
extends TestCase {
    public UserMapEditorTests() {
    }

    public UserMapEditorTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(UserMapEditorTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testConvertedIntoUserSuccessfullyWhenDisabled() {
        UserMapEditor editor = new UserMapEditor();
        editor.setAsText("rod=koala,ROLE_ONE,ROLE_TWO,disabled");
        UserMap map = (UserMap)editor.getValue();
        UserMapEditorTests.assertTrue((!map.getUser("rod").isEnabled() ? 1 : 0) != 0);
    }

    public void testConvertedIntoUserSuccessfullyWhenEnabled() {
        UserMapEditor editor = new UserMapEditor();
        editor.setAsText("rod=koala,ROLE_ONE,ROLE_TWO");
        UserMap map = (UserMap)editor.getValue();
        UserMapEditorTests.assertEquals((String)"rod", (String)map.getUser("rod").getUsername());
        UserMapEditorTests.assertEquals((String)"koala", (String)map.getUser("rod").getPassword());
        UserMapEditorTests.assertEquals((String)"ROLE_ONE", (String)map.getUser("rod").getAuthorities()[0].getAuthority());
        UserMapEditorTests.assertEquals((String)"ROLE_TWO", (String)map.getUser("rod").getAuthorities()[1].getAuthority());
        UserMapEditorTests.assertTrue((boolean)map.getUser("rod").isEnabled());
    }

    public void testEmptyStringReturnsEmptyMap() {
        UserMapEditor editor = new UserMapEditor();
        editor.setAsText("");
        UserMap map = (UserMap)editor.getValue();
        UserMapEditorTests.assertEquals((int)0, (int)map.getUserCount());
    }

    public void testMalformedStringReturnsEmptyMap() {
        UserMapEditor editor = new UserMapEditor();
        editor.setAsText("MALFORMED_STRING");
        UserMap map = (UserMap)editor.getValue();
        UserMapEditorTests.assertEquals((int)0, (int)map.getUserCount());
    }

    public void testMultiUserParsing() {
        UserMapEditor editor = new UserMapEditor();
        editor.setAsText("rod=koala,ROLE_ONE,ROLE_TWO,enabled\r\nscott=wombat,ROLE_ONE,ROLE_TWO,enabled");
        UserMap map = (UserMap)editor.getValue();
        UserMapEditorTests.assertEquals((String)"rod", (String)map.getUser("rod").getUsername());
        UserMapEditorTests.assertEquals((String)"scott", (String)map.getUser("scott").getUsername());
    }

    public void testNullReturnsEmptyMap() {
        UserMapEditor editor = new UserMapEditor();
        editor.setAsText(null);
        UserMap map = (UserMap)editor.getValue();
        UserMapEditorTests.assertEquals((int)0, (int)map.getUserCount());
    }
}

