/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.preauth.j2ee;

import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.ui.preauth.j2ee.J2eePreAuthenticatedProcessingFilter;

public class J2eePreAuthenticatedProcessingFilterTests
extends TestCase {
    public final void testGetPreAuthenticatedPrincipal() {
        String user = "testUser";
        J2eePreAuthenticatedProcessingFilterTests.assertEquals((Object)user, (Object)new J2eePreAuthenticatedProcessingFilter().getPreAuthenticatedPrincipal(this.getRequest(user, new String[0])));
    }

    public final void testGetPreAuthenticatedCredentials() {
        J2eePreAuthenticatedProcessingFilterTests.assertEquals((Object)"N/A", (Object)new J2eePreAuthenticatedProcessingFilter().getPreAuthenticatedCredentials(this.getRequest("testUser", new String[0])));
    }

    private final HttpServletRequest getRequest(final String aUserName, final String[] aRoles) {
        MockHttpServletRequest req = new MockHttpServletRequest(){
            private Set roles;
            {
                this.roles = new HashSet<String>(Arrays.asList(aRoles));
            }

            public boolean isUserInRole(String arg0) {
                return this.roles.contains(arg0);
            }
        };
        req.setRemoteUser(aUserName);
        req.setUserPrincipal(new Principal(){

            public String getName() {
                return aUserName;
            }
        });
        return req;
    }
}

