/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.basicauth;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.jmock.Mock;
import org.jmock.MockObjectTestCase;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.MockApplicationEventPublisher;
import org.springframework.security.MockAuthenticationEntryPoint;
import org.springframework.security.MockAuthenticationManager;
import org.springframework.security.MockFilterChain;
import org.springframework.security.MockFilterConfig;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.ProviderManager;
import org.springframework.security.providers.dao.DaoAuthenticationProvider;
import org.springframework.security.ui.AuthenticationEntryPoint;
import org.springframework.security.ui.basicauth.BasicProcessingFilter;
import org.springframework.security.ui.basicauth.BasicProcessingFilterEntryPoint;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.memory.InMemoryDaoImpl;
import org.springframework.security.userdetails.memory.UserMap;
import org.springframework.security.userdetails.memory.UserMapEditor;

public class BasicProcessingFilterTests
extends MockObjectTestCase {
    private BasicProcessingFilter filter;

    public BasicProcessingFilterTests() {
    }

    public BasicProcessingFilterTests(String arg0) {
        super(arg0);
    }

    private MockHttpServletResponse executeFilterInContainerSimulator(Filter filter, ServletRequest request, boolean expectChainToProceed) throws ServletException, IOException {
        filter.init((FilterConfig)new MockFilterConfig());
        MockHttpServletResponse response = new MockHttpServletResponse();
        Mock mockChain = this.mock(FilterChain.class);
        FilterChain chain = (FilterChain)mockChain.proxy();
        mockChain.expects(expectChainToProceed ? this.once() : this.never()).method("doFilter");
        filter.doFilter(request, (ServletResponse)response, chain);
        filter.destroy();
        return response;
    }

    protected void setUp() throws Exception {
        super.setUp();
        SecurityContextHolder.clearContext();
        InMemoryDaoImpl dao = new InMemoryDaoImpl();
        UserMapEditor editor = new UserMapEditor();
        editor.setAsText("rod=koala,ROLE_ONE,ROLE_TWO,enabled\r\n");
        dao.setUserMap((UserMap)editor.getValue());
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)dao);
        ProviderManager manager = new ProviderManager();
        manager.setProviders(Arrays.asList(provider));
        manager.setApplicationEventPublisher((ApplicationEventPublisher)new MockApplicationEventPublisher());
        manager.afterPropertiesSet();
        this.filter = new BasicProcessingFilter();
        this.filter.setAuthenticationManager((AuthenticationManager)manager);
        this.filter.setAuthenticationEntryPoint((AuthenticationEntryPoint)new BasicProcessingFilterEntryPoint());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SecurityContextHolder.clearContext();
    }

    public void testDoFilterWithNonHttpServletRequestDetected() throws Exception {
        BasicProcessingFilter filter = new BasicProcessingFilter();
        try {
            filter.doFilter(null, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
            BasicProcessingFilterTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            BasicProcessingFilterTests.assertEquals((String)"Can only process HttpServletRequest", (String)expected.getMessage());
        }
    }

    public void testDoFilterWithNonHttpServletResponseDetected() throws Exception {
        BasicProcessingFilter filter = new BasicProcessingFilter();
        try {
            filter.doFilter((ServletRequest)new MockHttpServletRequest(null, null), null, (FilterChain)new MockFilterChain());
            BasicProcessingFilterTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            BasicProcessingFilterTests.assertEquals((String)"Can only process HttpServletResponse", (String)expected.getMessage());
        }
    }

    public void testFilterIgnoresRequestsContainingNoAuthorizationHeader() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/some_file.html");
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)request, true);
        BasicProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testGettersSetters() {
        BasicProcessingFilter filter = new BasicProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        BasicProcessingFilterTests.assertTrue((filter.getAuthenticationManager() != null ? 1 : 0) != 0);
        filter.setAuthenticationEntryPoint((AuthenticationEntryPoint)new MockAuthenticationEntryPoint("sx"));
        BasicProcessingFilterTests.assertTrue((filter.getAuthenticationEntryPoint() != null ? 1 : 0) != 0);
    }

    public void testInvalidBasicAuthorizationTokenIsIgnored() throws Exception {
        String token = "NOT_A_VALID_TOKEN_AS_MISSING_COLON";
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBase64((byte[])token.getBytes()))));
        request.setServletPath("/some_file.html");
        request.setSession((HttpSession)new MockHttpSession());
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)request, false);
        BasicProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testNormalOperation() throws Exception {
        String token = "rod:koala";
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBase64((byte[])token.getBytes()))));
        request.setServletPath("/some_file.html");
        request.setSession((HttpSession)new MockHttpSession());
        BasicProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)request, true);
        BasicProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        BasicProcessingFilterTests.assertEquals((String)"rod", (String)((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername());
    }

    public void testOtherAuthorizationSchemeIsIgnored() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("Authorization", (Object)"SOME_OTHER_AUTHENTICATION_SCHEME");
        request.setServletPath("/some_file.html");
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)request, true);
        BasicProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testStartupDetectsMissingAuthenticationEntryPoint() throws Exception {
        try {
            BasicProcessingFilter filter = new BasicProcessingFilter();
            filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
            filter.afterPropertiesSet();
            BasicProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicProcessingFilterTests.assertEquals((String)"An AuthenticationEntryPoint is required", (String)expected.getMessage());
        }
    }

    public void testStartupDetectsMissingAuthenticationManager() throws Exception {
        try {
            BasicProcessingFilter filter = new BasicProcessingFilter();
            filter.setAuthenticationEntryPoint((AuthenticationEntryPoint)new MockAuthenticationEntryPoint("x"));
            filter.afterPropertiesSet();
            BasicProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicProcessingFilterTests.assertEquals((String)"An AuthenticationManager is required", (String)expected.getMessage());
        }
    }

    public void testSuccessLoginThenFailureLoginResultsInSessionLosingToken() throws Exception {
        String token = "rod:koala";
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBase64((byte[])token.getBytes()))));
        request.setServletPath("/some_file.html");
        request.setSession((HttpSession)new MockHttpSession());
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)request, true);
        BasicProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        BasicProcessingFilterTests.assertEquals((String)"rod", (String)((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername());
        token = "otherUser:WRONG_PASSWORD";
        request = new MockHttpServletRequest();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBase64((byte[])token.getBytes()))));
        request.setServletPath("/some_file.html");
        request.setSession((HttpSession)new MockHttpSession());
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)request, false);
        BasicProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        BasicProcessingFilterTests.assertEquals((int)401, (int)response.getStatus());
    }

    public void testWrongPasswordContinuesFilterChainIfIgnoreFailureIsTrue() throws Exception {
        String token = "rod:WRONG_PASSWORD";
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBase64((byte[])token.getBytes()))));
        request.setServletPath("/some_file.html");
        request.setSession((HttpSession)new MockHttpSession());
        this.filter.setIgnoreFailure(true);
        BasicProcessingFilterTests.assertTrue((boolean)this.filter.isIgnoreFailure());
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)request, true);
        BasicProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testWrongPasswordReturnsForbiddenIfIgnoreFailureIsFalse() throws Exception {
        String token = "rod:WRONG_PASSWORD";
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBase64((byte[])token.getBytes()))));
        request.setServletPath("/some_file.html");
        request.setSession((HttpSession)new MockHttpSession());
        BasicProcessingFilterTests.assertFalse((boolean)this.filter.isIgnoreFailure());
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)request, false);
        BasicProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        BasicProcessingFilterTests.assertEquals((int)401, (int)response.getStatus());
    }
}

