/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.token;

import java.security.SecureRandom;
import junit.framework.Assert;
import org.junit.Test;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.token.SecureRandomFactoryBean;

public class SecureRandomFactoryBeanTests {
    @Test
    public void testObjectType() {
        SecureRandomFactoryBean factory = new SecureRandomFactoryBean();
        Assert.assertEquals(SecureRandom.class, (Object)factory.getObjectType());
    }

    @Test
    public void testIsSingleton() {
        SecureRandomFactoryBean factory = new SecureRandomFactoryBean();
        Assert.assertFalse((boolean)factory.isSingleton());
    }

    @Test
    public void testCreatesUsingDefaults() throws Exception {
        SecureRandomFactoryBean factory = new SecureRandomFactoryBean();
        Object result = factory.getObject();
        Assert.assertTrue((boolean)(result instanceof SecureRandom));
        int rnd = ((SecureRandom)result).nextInt();
        Assert.assertTrue((rnd != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreatesUsingSeed() throws Exception {
        SecureRandomFactoryBean factory = new SecureRandomFactoryBean();
        ClassPathResource resource = new ClassPathResource("org/springframework/security/token/SecureRandomFactoryBeanTests.class");
        Assert.assertNotNull((Object)resource);
        factory.setSeed((Resource)resource);
        Object result = factory.getObject();
        Assert.assertTrue((boolean)(result instanceof SecureRandom));
        int rnd = ((SecureRandom)result).nextInt();
        Assert.assertTrue((rnd != 0 ? 1 : 0) != 0);
    }
}

