/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.securechannel;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.MockFilterChain;
import org.springframework.security.SecurityConfig;
import org.springframework.security.intercept.web.FilterInvocation;
import org.springframework.security.securechannel.SecureChannelProcessor;

public class SecureChannelProcessorTests
extends TestCase {
    public void testDecideDetectsAcceptableChannel() throws Exception {
        ConfigAttributeDefinition cad = new ConfigAttributeDefinition(new String[]{"SOME_IGNORED_ATTRIBUTE", "REQUIRES_SECURE_CHANNEL"});
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("info=true");
        request.setServerName("localhost");
        request.setContextPath("/bigapp");
        request.setServletPath("/servlet");
        request.setScheme("https");
        request.setSecure(true);
        request.setServerPort(8443);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        SecureChannelProcessor processor = new SecureChannelProcessor();
        processor.decide(fi, cad);
        SecureChannelProcessorTests.assertFalse((boolean)fi.getResponse().isCommitted());
    }

    public void testDecideDetectsUnacceptableChannel() throws Exception {
        ConfigAttributeDefinition cad = new ConfigAttributeDefinition(new String[]{"SOME_IGNORED_ATTRIBUTE", "REQUIRES_SECURE_CHANNEL"});
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("info=true");
        request.setServerName("localhost");
        request.setContextPath("/bigapp");
        request.setServletPath("/servlet");
        request.setScheme("http");
        request.setServerPort(8080);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        SecureChannelProcessor processor = new SecureChannelProcessor();
        processor.decide(fi, cad);
        SecureChannelProcessorTests.assertTrue((boolean)fi.getResponse().isCommitted());
    }

    public void testDecideRejectsNulls() throws Exception {
        SecureChannelProcessor processor = new SecureChannelProcessor();
        processor.afterPropertiesSet();
        try {
            processor.decide(null, null);
            SecureChannelProcessorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            SecureChannelProcessorTests.assertTrue((boolean)true);
        }
    }

    public void testGettersSetters() {
        SecureChannelProcessor processor = new SecureChannelProcessor();
        SecureChannelProcessorTests.assertEquals((String)"REQUIRES_SECURE_CHANNEL", (String)processor.getSecureKeyword());
        processor.setSecureKeyword("X");
        SecureChannelProcessorTests.assertEquals((String)"X", (String)processor.getSecureKeyword());
        SecureChannelProcessorTests.assertTrue((processor.getEntryPoint() != null ? 1 : 0) != 0);
        processor.setEntryPoint(null);
        SecureChannelProcessorTests.assertTrue((processor.getEntryPoint() == null ? 1 : 0) != 0);
    }

    public void testMissingEntryPoint() throws Exception {
        SecureChannelProcessor processor = new SecureChannelProcessor();
        processor.setEntryPoint(null);
        try {
            processor.afterPropertiesSet();
            SecureChannelProcessorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            SecureChannelProcessorTests.assertEquals((String)"entryPoint required", (String)expected.getMessage());
        }
    }

    public void testMissingSecureChannelKeyword() throws Exception {
        SecureChannelProcessor processor = new SecureChannelProcessor();
        processor.setSecureKeyword(null);
        try {
            processor.afterPropertiesSet();
            SecureChannelProcessorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            SecureChannelProcessorTests.assertEquals((String)"secureKeyword required", (String)expected.getMessage());
        }
        processor.setSecureKeyword("");
        try {
            processor.afterPropertiesSet();
            SecureChannelProcessorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            SecureChannelProcessorTests.assertEquals((String)"secureKeyword required", (String)expected.getMessage());
        }
    }

    public void testSupports() {
        SecureChannelProcessor processor = new SecureChannelProcessor();
        SecureChannelProcessorTests.assertTrue((boolean)processor.supports((ConfigAttribute)new SecurityConfig("REQUIRES_SECURE_CHANNEL")));
        SecureChannelProcessorTests.assertFalse((boolean)processor.supports(null));
        SecureChannelProcessorTests.assertFalse((boolean)processor.supports((ConfigAttribute)new SecurityConfig("NOT_SUPPORTED")));
    }
}

