/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.securechannel;

import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.MockPortResolver;
import org.springframework.security.securechannel.RetryWithHttpsEntryPoint;
import org.springframework.security.util.PortMapper;
import org.springframework.security.util.PortMapperImpl;
import org.springframework.security.util.PortResolver;

public class RetryWithHttpsEntryPointTests
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(RetryWithHttpsEntryPointTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDetectsMissingPortMapper() throws Exception {
        RetryWithHttpsEntryPoint ep = new RetryWithHttpsEntryPoint();
        try {
            ep.setPortMapper(null);
            RetryWithHttpsEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDetectsMissingPortResolver() throws Exception {
        RetryWithHttpsEntryPoint ep = new RetryWithHttpsEntryPoint();
        try {
            ep.setPortResolver(null);
            RetryWithHttpsEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGettersSetters() {
        RetryWithHttpsEntryPoint ep = new RetryWithHttpsEntryPoint();
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(8080, 8443));
        RetryWithHttpsEntryPointTests.assertTrue((ep.getPortMapper() != null ? 1 : 0) != 0);
        RetryWithHttpsEntryPointTests.assertTrue((ep.getPortResolver() != null ? 1 : 0) != 0);
    }

    public void testNormalOperation() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("open=true");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServletPath("/hello");
        request.setPathInfo("/pathInfo.html");
        request.setServerPort(80);
        MockHttpServletResponse response = new MockHttpServletResponse();
        RetryWithHttpsEntryPoint ep = new RetryWithHttpsEntryPoint();
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        ep.commence((ServletRequest)request, (ServletResponse)response);
        RetryWithHttpsEntryPointTests.assertEquals((String)"https://www.example.com/bigWebApp/hello/pathInfo.html?open=true", (String)response.getRedirectedUrl());
    }

    public void testNormalOperationWithNullPathInfoAndNullQueryString() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServletPath("/hello");
        request.setPathInfo(null);
        request.setServerPort(80);
        MockHttpServletResponse response = new MockHttpServletResponse();
        RetryWithHttpsEntryPoint ep = new RetryWithHttpsEntryPoint();
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        ep.commence((ServletRequest)request, (ServletResponse)response);
        RetryWithHttpsEntryPointTests.assertEquals((String)"https://www.example.com/bigWebApp/hello", (String)response.getRedirectedUrl());
    }

    public void testOperationWhenTargetPortIsUnknown() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("open=true");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServletPath("/hello");
        request.setPathInfo("/pathInfo.html");
        request.setServerPort(8768);
        MockHttpServletResponse response = new MockHttpServletResponse();
        RetryWithHttpsEntryPoint ep = new RetryWithHttpsEntryPoint();
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(8768, 1234));
        ep.commence((ServletRequest)request, (ServletResponse)response);
        RetryWithHttpsEntryPointTests.assertEquals((String)"/bigWebApp", (String)response.getRedirectedUrl());
    }

    public void testOperationWithNonStandardPort() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("open=true");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServletPath("/hello");
        request.setPathInfo("/pathInfo.html");
        request.setServerPort(8888);
        MockHttpServletResponse response = new MockHttpServletResponse();
        PortMapperImpl portMapper = new PortMapperImpl();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("8888", "9999");
        portMapper.setPortMappings(map);
        RetryWithHttpsEntryPoint ep = new RetryWithHttpsEntryPoint();
        ep.setPortResolver((PortResolver)new MockPortResolver(8888, 9999));
        ep.setPortMapper((PortMapper)portMapper);
        ep.commence((ServletRequest)request, (ServletResponse)response);
        RetryWithHttpsEntryPointTests.assertEquals((String)"https://www.example.com:9999/bigWebApp/hello/pathInfo.html?open=true", (String)response.getRedirectedUrl());
    }
}

