/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.runas;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.Authentication;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.TestingAuthenticationToken;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.runas.RunAsImplAuthenticationProvider;
import org.springframework.security.runas.RunAsUserToken;

public class RunAsImplAuthenticationProviderTests
extends TestCase {
    public RunAsImplAuthenticationProviderTests() {
    }

    public RunAsImplAuthenticationProviderTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(RunAsImplAuthenticationProviderTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAuthenticationFailDueToWrongKey() {
        RunAsUserToken token = new RunAsUserToken("WRONG_PASSWORD", (Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, UsernamePasswordAuthenticationToken.class);
        RunAsImplAuthenticationProvider provider = new RunAsImplAuthenticationProvider();
        provider.setKey("hello_world");
        try {
            provider.authenticate((Authentication)token);
            RunAsImplAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            RunAsImplAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticationSuccess() {
        RunAsUserToken token = new RunAsUserToken("my_password", (Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, UsernamePasswordAuthenticationToken.class);
        RunAsImplAuthenticationProvider provider = new RunAsImplAuthenticationProvider();
        provider.setKey("my_password");
        Authentication result = provider.authenticate((Authentication)token);
        if (!(result instanceof RunAsUserToken)) {
            RunAsImplAuthenticationProviderTests.fail((String)"Should have returned RunAsUserToken");
        }
        RunAsUserToken resultCast = (RunAsUserToken)result;
        RunAsImplAuthenticationProviderTests.assertEquals((int)"my_password".hashCode(), (int)resultCast.getKeyHash());
    }

    public void testStartupFailsIfNoKey() throws Exception {
        RunAsImplAuthenticationProvider provider = new RunAsImplAuthenticationProvider();
        try {
            provider.afterPropertiesSet();
            RunAsImplAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RunAsImplAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testStartupSuccess() throws Exception {
        RunAsImplAuthenticationProvider provider = new RunAsImplAuthenticationProvider();
        provider.setKey("hello_world");
        RunAsImplAuthenticationProviderTests.assertEquals((String)"hello_world", (String)provider.getKey());
        provider.afterPropertiesSet();
        RunAsImplAuthenticationProviderTests.assertTrue((boolean)true);
    }

    public void testSupports() {
        RunAsImplAuthenticationProvider provider = new RunAsImplAuthenticationProvider();
        RunAsImplAuthenticationProviderTests.assertTrue((boolean)provider.supports(RunAsUserToken.class));
        RunAsImplAuthenticationProviderTests.assertTrue((!provider.supports(TestingAuthenticationToken.class) ? 1 : 0) != 0);
    }
}

