/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.preauth;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthoritiesContainer;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.providers.preauth.PreAuthenticatedGrantedAuthoritiesUserDetailsService;
import org.springframework.security.userdetails.UserDetails;

public class PreAuthenticatedGrantedAuthoritiesUserDetailsServiceTests
extends TestCase {
    public final void testGetUserDetailsInvalidType() {
        PreAuthenticatedGrantedAuthoritiesUserDetailsService svc = new PreAuthenticatedGrantedAuthoritiesUserDetailsService();
        PreAuthenticatedAuthenticationToken token = new PreAuthenticatedAuthenticationToken((Object)"dummy", (Object)"dummy");
        token.setDetails(new Object());
        try {
            svc.loadUserDetails((Authentication)token);
            PreAuthenticatedGrantedAuthoritiesUserDetailsServiceTests.fail((String)"Expected exception didn't occur");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public final void testGetUserDetailsNoDetails() {
        PreAuthenticatedGrantedAuthoritiesUserDetailsService svc = new PreAuthenticatedGrantedAuthoritiesUserDetailsService();
        PreAuthenticatedAuthenticationToken token = new PreAuthenticatedAuthenticationToken((Object)"dummy", (Object)"dummy");
        token.setDetails(null);
        try {
            svc.loadUserDetails((Authentication)token);
            PreAuthenticatedGrantedAuthoritiesUserDetailsServiceTests.fail((String)"Expected exception didn't occur");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public final void testGetUserDetailsEmptyAuthorities() {
        String userName = "dummyUser";
        GrantedAuthority[] gas = new GrantedAuthority[]{};
        this.testGetUserDetails("dummyUser", gas);
    }

    public final void testGetUserDetailsWithAuthorities() {
        String userName = "dummyUser";
        GrantedAuthority[] gas = new GrantedAuthority[]{new GrantedAuthorityImpl("Role1"), new GrantedAuthorityImpl("Role2")};
        this.testGetUserDetails("dummyUser", gas);
    }

    private void testGetUserDetails(String userName, final GrantedAuthority[] gas) {
        PreAuthenticatedGrantedAuthoritiesUserDetailsService svc = new PreAuthenticatedGrantedAuthoritiesUserDetailsService();
        PreAuthenticatedAuthenticationToken token = new PreAuthenticatedAuthenticationToken((Object)userName, (Object)"dummy");
        token.setDetails((Object)new GrantedAuthoritiesContainer(){

            public GrantedAuthority[] getGrantedAuthorities() {
                return gas;
            }
        });
        UserDetails ud = svc.loadUserDetails((Authentication)token);
        PreAuthenticatedGrantedAuthoritiesUserDetailsServiceTests.assertTrue((boolean)ud.isAccountNonExpired());
        PreAuthenticatedGrantedAuthoritiesUserDetailsServiceTests.assertTrue((boolean)ud.isAccountNonLocked());
        PreAuthenticatedGrantedAuthoritiesUserDetailsServiceTests.assertTrue((boolean)ud.isCredentialsNonExpired());
        PreAuthenticatedGrantedAuthoritiesUserDetailsServiceTests.assertTrue((boolean)ud.isEnabled());
        PreAuthenticatedGrantedAuthoritiesUserDetailsServiceTests.assertEquals((String)ud.getUsername(), (String)userName);
        List<GrantedAuthority> expectedColl = Arrays.asList(gas);
        List<GrantedAuthority> resultColl = Arrays.asList(ud.getAuthorities());
        PreAuthenticatedGrantedAuthoritiesUserDetailsServiceTests.assertTrue((String)("GrantedAuthority collections do not match; result: " + resultColl + ", expected: " + expectedColl), (expectedColl.containsAll(resultColl) && resultColl.containsAll(expectedColl) ? 1 : 0) != 0);
    }
}

