/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.anonymous;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;

public class AnonymousAuthenticationTokenTests
extends TestCase {
    public AnonymousAuthenticationTokenTests() {
    }

    public AnonymousAuthenticationTokenTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(AnonymousAuthenticationTokenTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testConstructorRejectsNulls() {
        try {
            new AnonymousAuthenticationToken(null, (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            AnonymousAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AnonymousAuthenticationTokenTests.assertTrue((boolean)true);
        }
        try {
            new AnonymousAuthenticationToken("key", null, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            AnonymousAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AnonymousAuthenticationTokenTests.assertTrue((boolean)true);
        }
        try {
            new AnonymousAuthenticationToken("key", (Object)"Test", null);
            AnonymousAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AnonymousAuthenticationTokenTests.assertTrue((boolean)true);
        }
        try {
            new AnonymousAuthenticationToken("key", (Object)"Test", new GrantedAuthority[]{null});
            AnonymousAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AnonymousAuthenticationTokenTests.assertTrue((boolean)true);
        }
        try {
            new AnonymousAuthenticationToken("key", (Object)"Test", new GrantedAuthority[0]);
            AnonymousAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AnonymousAuthenticationTokenTests.assertTrue((boolean)true);
        }
    }

    public void testEqualsWhenEqual() {
        AnonymousAuthenticationToken token1 = new AnonymousAuthenticationToken("key", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        AnonymousAuthenticationToken token2 = new AnonymousAuthenticationToken("key", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        AnonymousAuthenticationTokenTests.assertEquals((Object)token1, (Object)token2);
    }

    public void testGetters() {
        AnonymousAuthenticationToken token = new AnonymousAuthenticationToken("key", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        AnonymousAuthenticationTokenTests.assertEquals((int)"key".hashCode(), (int)token.getKeyHash());
        AnonymousAuthenticationTokenTests.assertEquals((Object)"Test", (Object)token.getPrincipal());
        AnonymousAuthenticationTokenTests.assertEquals((Object)"", (Object)token.getCredentials());
        AnonymousAuthenticationTokenTests.assertEquals((String)"ROLE_ONE", (String)token.getAuthorities()[0].getAuthority());
        AnonymousAuthenticationTokenTests.assertEquals((String)"ROLE_TWO", (String)token.getAuthorities()[1].getAuthority());
        AnonymousAuthenticationTokenTests.assertTrue((boolean)token.isAuthenticated());
    }

    public void testNoArgConstructorDoesntExist() {
        Class<AnonymousAuthenticationToken> clazz = AnonymousAuthenticationToken.class;
        try {
            clazz.getDeclaredConstructor(null);
            AnonymousAuthenticationTokenTests.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (NoSuchMethodException expected) {
            AnonymousAuthenticationTokenTests.assertTrue((boolean)true);
        }
    }

    public void testNotEqualsDueToAbstractParentEqualsCheck() {
        AnonymousAuthenticationToken token1 = new AnonymousAuthenticationToken("key", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        AnonymousAuthenticationToken token2 = new AnonymousAuthenticationToken("key", (Object)"DIFFERENT_PRINCIPAL", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        AnonymousAuthenticationTokenTests.assertFalse((boolean)token1.equals((Object)token2));
    }

    public void testNotEqualsDueToDifferentAuthenticationClass() {
        AnonymousAuthenticationToken token1 = new AnonymousAuthenticationToken("key", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        UsernamePasswordAuthenticationToken token2 = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        AnonymousAuthenticationTokenTests.assertFalse((boolean)token1.equals((Object)token2));
    }

    public void testNotEqualsDueToKey() {
        AnonymousAuthenticationToken token1 = new AnonymousAuthenticationToken("key", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        AnonymousAuthenticationToken token2 = new AnonymousAuthenticationToken("DIFFERENT_KEY", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        AnonymousAuthenticationTokenTests.assertFalse((boolean)token1.equals((Object)token2));
    }

    public void testSetAuthenticatedIgnored() {
        AnonymousAuthenticationToken token = new AnonymousAuthenticationToken("key", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        AnonymousAuthenticationTokenTests.assertTrue((boolean)token.isAuthenticated());
        token.setAuthenticated(false);
        AnonymousAuthenticationTokenTests.assertTrue((!token.isAuthenticated() ? 1 : 0) != 0);
    }
}

