/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.intercept.web.FilterInvocation;
import org.springframework.security.intercept.web.MockFilterInvocationDefinitionSource;

public class AbstractFilterInvocationDefinitionSourceTests
extends TestCase {
    public AbstractFilterInvocationDefinitionSourceTests() {
    }

    public AbstractFilterInvocationDefinitionSourceTests(String arg0) {
        super(arg0);
    }

    public void testDoesNotSupportAnotherObject() {
        MockFilterInvocationDefinitionSource mfis = new MockFilterInvocationDefinitionSource(false, true);
        AbstractFilterInvocationDefinitionSourceTests.assertFalse((boolean)mfis.supports(String.class));
    }

    public void testGetAttributesForANonFilterInvocation() {
        MockFilterInvocationDefinitionSource mfis = new MockFilterInvocationDefinitionSource(false, true);
        try {
            mfis.getAttributes(new String());
            AbstractFilterInvocationDefinitionSourceTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractFilterInvocationDefinitionSourceTests.assertTrue((boolean)true);
        }
    }

    public void testGetAttributesForANullObject() {
        MockFilterInvocationDefinitionSource mfis = new MockFilterInvocationDefinitionSource(false, true);
        try {
            mfis.getAttributes(null);
            AbstractFilterInvocationDefinitionSourceTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractFilterInvocationDefinitionSourceTests.assertTrue((boolean)true);
        }
    }

    public void testGetAttributesForFilterInvocationSuccess() {
        MockFilterInvocationDefinitionSource mfis = new MockFilterInvocationDefinitionSource(false, true);
        try {
            mfis.getAttributes(new FilterInvocation((ServletRequest)new MockHttpServletRequest(null, null), (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain()));
            AbstractFilterInvocationDefinitionSourceTests.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException expected) {
            AbstractFilterInvocationDefinitionSourceTests.assertTrue((boolean)true);
        }
    }

    public void testSupportsFilterInvocation() {
        MockFilterInvocationDefinitionSource mfis = new MockFilterInvocationDefinitionSource(false, true);
        AbstractFilterInvocationDefinitionSourceTests.assertTrue((boolean)mfis.supports(FilterInvocation.class));
    }

    private class MockFilterChain
    implements FilterChain {
        private MockFilterChain() {
        }

        public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
            throw new UnsupportedOperationException("mock method not implemented");
        }
    }
}

