/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.method;

import java.lang.reflect.Method;
import junit.framework.Assert;
import org.junit.Test;
import org.springframework.metadata.Attributes;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.ITargetObject;
import org.springframework.security.intercept.method.MethodDefinitionAttributes;
import org.springframework.security.intercept.method.MockAttributes;

public class MethodDefinitionAttributesTests {
    private MethodDefinitionAttributes build() {
        MethodDefinitionAttributes mda = new MethodDefinitionAttributes();
        mda.setAttributes((Attributes)new MockAttributes());
        return mda;
    }

    @Test
    public void testMethodsReturned() throws Exception {
        Class<ITargetObject> clazz = ITargetObject.class;
        Method method = clazz.getMethod("countLength", String.class);
        ConfigAttributeDefinition result = this.build().findAttributes(method, ITargetObject.class);
        Assert.assertEquals((int)1, (int)result.getConfigAttributes().size());
    }

    @Test
    public void testClassesReturned() throws Exception {
        Class<ITargetObject> clazz = ITargetObject.class;
        ConfigAttributeDefinition result = this.build().findAttributes(ITargetObject.class);
        Assert.assertEquals((int)1, (int)result.getConfigAttributes().size());
    }
}

