/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.concurrent.ConcurrentSessionController;
import org.springframework.security.util.FieldUtils;
import org.springframework.security.util.InMemoryXmlApplicationContext;

public class SessionRegistryInjectionBeanPostProcessorTests {
    private AbstractXmlApplicationContext appContext;

    @After
    public void closeAppContext() {
        if (this.appContext != null) {
            this.appContext.close();
            this.appContext = null;
        }
    }

    private void setContext(String context) {
        this.appContext = new InMemoryXmlApplicationContext(context);
    }

    @Test
    public void sessionRegistryIsSetOnFiltersWhenUsingCustomControllerWithInternalRegistryBean() throws Exception {
        this.setContext("<http auto-config='true'/><b:bean id='sc' class='org.springframework.security.concurrent.ConcurrentSessionControllerImpl'>  <b:property name='sessionRegistry'>      <b:bean class='org.springframework.security.concurrent.SessionRegistryImpl'/>  </b:property></b:bean><authentication-manager alias='authManager' session-controller-ref='sc'/>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        Assert.assertNotNull((Object)FieldUtils.getFieldValue((Object)this.appContext.getBean("_sessionFixationProtectionFilter"), (String)"sessionRegistry"));
        Assert.assertNotNull((Object)FieldUtils.getFieldValue((Object)this.appContext.getBean("_formLoginFilter"), (String)"sessionRegistry"));
    }

    @Test
    public void sessionRegistryIsSetOnFiltersWhenUsingCustomControllerWithNonStandardController() throws Exception {
        this.setContext("<http auto-config='true'/><b:bean id='sc' class='org.springframework.security.config.SessionRegistryInjectionBeanPostProcessorTests$MockConcurrentSessionController'/><b:bean id='sessionRegistry' class='org.springframework.security.concurrent.SessionRegistryImpl'/><authentication-manager alias='authManager' session-controller-ref='sc'/>    <authentication-provider>        <user-service id='us'>            <user name='bob' password='bobspassword' authorities='ROLE_A,ROLE_B' />            <user name='bill' password='billspassword' authorities='ROLE_A,ROLE_B,AUTH_OTHER' />            <user name='admin' password='password' authorities='ROLE_ADMIN,ROLE_USER' />            <user name='user' password='password' authorities='ROLE_USER' />        </user-service>    </authentication-provider>");
        Assert.assertNotNull((Object)FieldUtils.getFieldValue((Object)this.appContext.getBean("_sessionFixationProtectionFilter"), (String)"sessionRegistry"));
        Assert.assertNotNull((Object)FieldUtils.getFieldValue((Object)this.appContext.getBean("_formLoginFilter"), (String)"sessionRegistry"));
    }

    public static class MockConcurrentSessionController
    implements ConcurrentSessionController {
        public void checkAuthenticationAllowed(Authentication request) throws AuthenticationException {
        }

        public void registerSuccessfulAuthentication(Authentication authentication) {
        }
    }
}

