/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.ldap.InetOrgPerson;
import org.springframework.security.userdetails.ldap.Person;
import org.springframework.security.util.AuthorityUtils;
import org.springframework.security.util.InMemoryXmlApplicationContext;

public class LdapUserServiceBeanDefinitionParserTests {
    private InMemoryXmlApplicationContext appCtx;

    @After
    public void closeAppContext() {
        if (this.appCtx != null) {
            this.appCtx.close();
            this.appCtx = null;
        }
    }

    @Test
    public void minimalConfigurationIsParsedOk() throws Exception {
        this.setContext("<ldap-user-service user-search-filter='(uid={0})' /><ldap-server url='ldap://127.0.0.1:343/dc=springframework,dc=org' />");
    }

    @Test
    public void userServiceReturnsExpectedData() throws Exception {
        this.setContext("<ldap-user-service id='ldapUDS' user-search-filter='(uid={0})' group-search-filter='member={0}' /><ldap-server />");
        UserDetailsService uds = (UserDetailsService)this.appCtx.getBean("ldapUDS");
        UserDetails ben = uds.loadUserByUsername("ben");
        Set authorities = AuthorityUtils.authorityArrayToSet((GrantedAuthority[])ben.getAuthorities());
        Assert.assertEquals((long)3L, (long)authorities.size());
        Assert.assertTrue((boolean)authorities.contains("ROLE_DEVELOPERS"));
    }

    @Test
    public void differentUserSearchBaseWorksAsExpected() throws Exception {
        this.setContext("<ldap-user-service id='ldapUDS'        user-search-base='ou=otherpeople'        user-search-filter='(cn={0})'        group-search-filter='member={0}' /><ldap-server />");
        UserDetailsService uds = (UserDetailsService)this.appCtx.getBean("ldapUDS");
        UserDetails joe = uds.loadUserByUsername("Joe Smeth");
        Assert.assertEquals((Object)"Joe Smeth", (Object)joe.getUsername());
    }

    @Test
    public void rolePrefixIsSupported() throws Exception {
        this.setContext("<ldap-user-service id='ldapUDS'      user-search-filter='(uid={0})'      group-search-filter='member={0}' role-prefix='PREFIX_'/><ldap-user-service id='ldapUDSNoPrefix'      user-search-filter='(uid={0})'      group-search-filter='member={0}' role-prefix='none'/><ldap-server />");
        UserDetailsService uds = (UserDetailsService)this.appCtx.getBean("ldapUDS");
        UserDetails ben = uds.loadUserByUsername("ben");
        Assert.assertTrue((boolean)AuthorityUtils.authorityArrayToSet((GrantedAuthority[])ben.getAuthorities()).contains("PREFIX_DEVELOPERS"));
        uds = (UserDetailsService)this.appCtx.getBean("ldapUDSNoPrefix");
        ben = uds.loadUserByUsername("ben");
        Assert.assertTrue((boolean)AuthorityUtils.authorityArrayToSet((GrantedAuthority[])ben.getAuthorities()).contains("DEVELOPERS"));
    }

    @Test
    public void differentGroupRoleAttributeWorksAsExpected() throws Exception {
        this.setContext("<ldap-user-service id='ldapUDS' user-search-filter='(uid={0})' group-role-attribute='ou' group-search-filter='member={0}' /><ldap-server />");
        UserDetailsService uds = (UserDetailsService)this.appCtx.getBean("ldapUDS");
        UserDetails ben = uds.loadUserByUsername("ben");
        Set authorities = AuthorityUtils.authorityArrayToSet((GrantedAuthority[])ben.getAuthorities());
        Assert.assertEquals((long)3L, (long)authorities.size());
        Assert.assertTrue((boolean)authorities.contains(new GrantedAuthorityImpl("ROLE_DEVELOPER")));
    }

    @Test
    public void isSupportedByAuthenticationProviderElement() {
        this.setContext("<ldap-server url='ldap://127.0.0.1:343/dc=springframework,dc=org'/><authentication-provider>    <ldap-user-service user-search-filter='(uid={0})' /></authentication-provider>");
    }

    @Test
    public void personContextMapperIsSupported() {
        this.setContext("<ldap-server /><ldap-user-service id='ldapUDS' user-search-filter='(uid={0})' user-details-class='person'/>");
        UserDetailsService uds = (UserDetailsService)this.appCtx.getBean("ldapUDS");
        UserDetails ben = uds.loadUserByUsername("ben");
        Assert.assertTrue((boolean)(ben instanceof Person));
    }

    @Test
    public void inetOrgContextMapperIsSupported() {
        this.setContext("<ldap-server id='someServer'/><ldap-user-service id='ldapUDS' user-search-filter='(uid={0})' user-details-class='inetOrgPerson'/>");
        UserDetailsService uds = (UserDetailsService)this.appCtx.getBean("ldapUDS");
        UserDetails ben = uds.loadUserByUsername("ben");
        Assert.assertTrue((boolean)(ben instanceof InetOrgPerson));
    }

    private void setContext(String context) {
        this.appCtx = new InMemoryXmlApplicationContext(context);
    }
}

