/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;

public class DataSourcePopulator
implements InitializingBean {
    JdbcTemplate template;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.template, (String)"dataSource required");
        this.template.execute("CREATE TABLE USERS(USERNAME VARCHAR_IGNORECASE(50) NOT NULL PRIMARY KEY,PASSWORD VARCHAR_IGNORECASE(50) NOT NULL,ENABLED BOOLEAN NOT NULL);");
        this.template.execute("CREATE TABLE AUTHORITIES(USERNAME VARCHAR_IGNORECASE(50) NOT NULL,AUTHORITY VARCHAR_IGNORECASE(50) NOT NULL,CONSTRAINT FK_AUTHORITIES_USERS FOREIGN KEY(USERNAME) REFERENCES USERS(USERNAME));");
        this.template.execute("CREATE UNIQUE INDEX IX_AUTH_USERNAME ON AUTHORITIES(USERNAME,AUTHORITY);");
        this.template.execute("INSERT INTO USERS VALUES('rod','koala',TRUE);");
        this.template.execute("INSERT INTO USERS VALUES('dianne','65d15fe9156f9c4bbffd98085992a44e',TRUE);");
        this.template.execute("INSERT INTO USERS VALUES('scott','2b58af6dddbd072ed27ffc86725d7d3a',TRUE);");
        this.template.execute("INSERT INTO USERS VALUES('peter','22b5c9accc6e1ba628cedc63a72d57f8',FALSE);");
        this.template.execute("INSERT INTO USERS VALUES('bill','2b58af6dddbd072ed27ffc86725d7d3a',TRUE);");
        this.template.execute("INSERT INTO USERS VALUES('bob','2b58af6dddbd072ed27ffc86725d7d3a',TRUE);");
        this.template.execute("INSERT INTO USERS VALUES('jane','2b58af6dddbd072ed27ffc86725d7d3a',TRUE);");
        this.template.execute("INSERT INTO AUTHORITIES VALUES('rod','ROLE_USER');");
        this.template.execute("INSERT INTO AUTHORITIES VALUES('rod','ROLE_SUPERVISOR');");
        this.template.execute("INSERT INTO AUTHORITIES VALUES('dianne','ROLE_USER');");
        this.template.execute("INSERT INTO AUTHORITIES VALUES('scott','ROLE_USER');");
        this.template.execute("INSERT INTO AUTHORITIES VALUES('peter','ROLE_USER');");
        this.template.execute("INSERT INTO AUTHORITIES VALUES('bill','ROLE_USER');");
        this.template.execute("INSERT INTO AUTHORITIES VALUES('bob','ROLE_USER');");
        this.template.execute("INSERT INTO AUTHORITIES VALUES('jane','ROLE_USER');");
    }

    public void setDataSource(DataSource dataSource) {
        this.template = new JdbcTemplate(dataSource);
    }
}

