/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.afterinvocation;

import junit.framework.TestCase;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.MockAclManager;
import org.springframework.security.acl.AclEntry;
import org.springframework.security.acl.AclManager;
import org.springframework.security.acl.basic.AclObjectIdentity;
import org.springframework.security.acl.basic.MockAclObjectIdentity;
import org.springframework.security.acl.basic.SimpleAclEntry;
import org.springframework.security.afterinvocation.BasicAclEntryAfterInvocationProvider;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.util.SimpleMethodInvocation;

public class BasicAclEntryAfterInvocationProviderTests
extends TestCase {
    public void testCorrectOperationWhenPrincipalHasIncorrectPermissionToDomainObject() throws Exception {
        MockAclManager aclManager = new MockAclManager("belmont", "scott", new AclEntry[]{new SimpleAclEntry((Object)"scott", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION)});
        BasicAclEntryAfterInvocationProvider provider = new BasicAclEntryAfterInvocationProvider();
        provider.setAclManager((AclManager)aclManager);
        provider.afterPropertiesSet();
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"scott", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("AFTER_ACL_READ");
        try {
            provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, (Object)"belmont");
            BasicAclEntryAfterInvocationProviderTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            BasicAclEntryAfterInvocationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testCorrectOperationWhenPrincipalHasNoPermissionToDomainObject() throws Exception {
        MockAclManager aclManager = new MockAclManager("belmont", "rod", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryAfterInvocationProvider provider = new BasicAclEntryAfterInvocationProvider();
        provider.setAclManager((AclManager)aclManager);
        provider.afterPropertiesSet();
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"scott", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("AFTER_ACL_READ");
        try {
            provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, (Object)"belmont");
            BasicAclEntryAfterInvocationProviderTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            BasicAclEntryAfterInvocationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testCorrectOperationWhenPrincipalIsAuthorised() throws Exception {
        MockAclManager aclManager = new MockAclManager("belmont", "rod", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryAfterInvocationProvider provider = new BasicAclEntryAfterInvocationProvider();
        provider.setAclManager((AclManager)aclManager);
        BasicAclEntryAfterInvocationProviderTests.assertEquals((Object)aclManager, (Object)provider.getAclManager());
        provider.afterPropertiesSet();
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("AFTER_ACL_READ");
        BasicAclEntryAfterInvocationProviderTests.assertEquals((Object)"belmont", (Object)provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, (Object)"belmont"));
    }

    public void testGrantsAccessIfReturnedObjectIsNull() throws Exception {
        MockAclManager aclManager = new MockAclManager("belmont", "rod", new AclEntry[]{new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE), new MockAclEntry()});
        BasicAclEntryAfterInvocationProvider provider = new BasicAclEntryAfterInvocationProvider();
        provider.setAclManager((AclManager)aclManager);
        provider.afterPropertiesSet();
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("AFTER_ACL_READ");
        BasicAclEntryAfterInvocationProviderTests.assertNull((Object)provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, null));
    }

    public void testRespectsModificationsToProcessConfigAttribute() throws Exception {
        MockAclManager aclManager = new MockAclManager("sydney", "rod", new AclEntry[]{new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new MockAclEntry()});
        BasicAclEntryAfterInvocationProvider provider = new BasicAclEntryAfterInvocationProvider();
        provider.setAclManager((AclManager)aclManager);
        BasicAclEntryAfterInvocationProviderTests.assertEquals((String)"AFTER_ACL_READ", (String)provider.getProcessConfigAttribute());
        provider.setProcessConfigAttribute("AFTER_ACL_ADMIN");
        BasicAclEntryAfterInvocationProviderTests.assertEquals((String)"AFTER_ACL_ADMIN", (String)provider.getProcessConfigAttribute());
        provider.afterPropertiesSet();
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("AFTER_ACL_READ");
        BasicAclEntryAfterInvocationProviderTests.assertEquals((Object)"sydney", (Object)provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, (Object)"sydney"));
        attr = new ConfigAttributeDefinition("AFTER_ACL_ADMIN");
        BasicAclEntryAfterInvocationProviderTests.assertEquals((Object)"sydney", (Object)provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, (Object)"sydney"));
    }

    public void testRespectsModificationsToRequirePermissions() throws Exception {
        MockAclManager aclManager = new MockAclManager("sydney", "rod", new AclEntry[]{new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new MockAclEntry()});
        BasicAclEntryAfterInvocationProvider provider = new BasicAclEntryAfterInvocationProvider();
        provider.setAclManager((AclManager)aclManager);
        BasicAclEntryAfterInvocationProviderTests.assertEquals((int)SimpleAclEntry.READ, (int)provider.getRequirePermission()[0]);
        provider.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION});
        BasicAclEntryAfterInvocationProviderTests.assertEquals((int)SimpleAclEntry.ADMINISTRATION, (int)provider.getRequirePermission()[0]);
        provider.afterPropertiesSet();
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"NOT_USED");
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("AFTER_ACL_READ");
        BasicAclEntryAfterInvocationProviderTests.assertEquals((Object)"sydney", (Object)provider.decide((Authentication)auth, (Object)new SimpleMethodInvocation(), attr, (Object)"sydney"));
    }

    public void testStartupDetectsMissingAclManager() throws Exception {
        BasicAclEntryAfterInvocationProvider provider = new BasicAclEntryAfterInvocationProvider();
        try {
            provider.afterPropertiesSet();
            BasicAclEntryAfterInvocationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclEntryAfterInvocationProviderTests.assertEquals((String)"An aclManager is mandatory", (String)expected.getMessage());
        }
    }

    public void testStartupDetectsMissingProcessConfigAttribute() throws Exception {
        BasicAclEntryAfterInvocationProvider provider = new BasicAclEntryAfterInvocationProvider();
        MockAclManager aclManager = new MockAclManager("sydney", "rod", new AclEntry[]{new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new MockAclEntry()});
        provider.setAclManager((AclManager)aclManager);
        provider.setProcessConfigAttribute(null);
        try {
            provider.afterPropertiesSet();
            BasicAclEntryAfterInvocationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclEntryAfterInvocationProviderTests.assertEquals((String)"A processConfigAttribute is mandatory", (String)expected.getMessage());
        }
    }

    public void testStartupDetectsMissingRequirePermission() throws Exception {
        BasicAclEntryAfterInvocationProvider provider = new BasicAclEntryAfterInvocationProvider();
        MockAclManager aclManager = new MockAclManager("sydney", "rod", new AclEntry[]{new SimpleAclEntry((Object)"rod", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new MockAclEntry()});
        provider.setAclManager((AclManager)aclManager);
        provider.setRequirePermission(null);
        try {
            provider.afterPropertiesSet();
            BasicAclEntryAfterInvocationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclEntryAfterInvocationProviderTests.assertEquals((String)"One or more requirePermission entries is mandatory", (String)expected.getMessage());
        }
    }

    public void testSupportsAnything() {
        BasicAclEntryAfterInvocationProviderTests.assertTrue((boolean)new BasicAclEntryAfterInvocationProvider().supports(String.class));
    }

    private class MockAclEntry
    implements AclEntry {
        private MockAclEntry() {
        }
    }
}

