/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acl.basic.cache;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.security.acl.basic.AclObjectIdentity;
import org.springframework.security.acl.basic.BasicAclEntry;
import org.springframework.security.acl.basic.NamedEntityObjectIdentity;
import org.springframework.security.acl.basic.SimpleAclEntry;
import org.springframework.security.acl.basic.cache.EhCacheBasedAclEntryCache;

public class EhCacheBasedAclEntryCacheTests {
    private static final AclObjectIdentity OBJECT_100 = new NamedEntityObjectIdentity("OBJECT", "100");
    private static final AclObjectIdentity OBJECT_200 = new NamedEntityObjectIdentity("OBJECT", "200");
    private static final BasicAclEntry OBJECT_100_ROD = new SimpleAclEntry((Object)"rod", OBJECT_100, null, 2);
    private static final BasicAclEntry OBJECT_100_SCOTT = new SimpleAclEntry((Object)"scott", OBJECT_100, null, 4);
    private static final BasicAclEntry OBJECT_200_PETER = new SimpleAclEntry((Object)"peter", OBJECT_200, null, 4);
    private static CacheManager cacheManager;

    @BeforeClass
    public static void initCacheManaer() {
        cacheManager = new CacheManager();
        cacheManager.addCache(new Cache("ehcachebasedacltests", 500, false, false, 30L, 30L));
    }

    @AfterClass
    public static void shutdownCacheManager() {
        cacheManager.removalAll();
        cacheManager.shutdown();
    }

    private Ehcache getCache() {
        Cache cache = cacheManager.getCache("ehcachebasedacltests");
        cache.removeAll();
        return cache;
    }

    @Test
    public void cacheOperationSucceeds() throws Exception {
        EhCacheBasedAclEntryCache cache = new EhCacheBasedAclEntryCache();
        cache.setCache(this.getCache());
        cache.afterPropertiesSet();
        cache.putEntriesInCache(new BasicAclEntry[]{OBJECT_100_SCOTT, OBJECT_100_ROD});
        cache.putEntriesInCache(new BasicAclEntry[]{OBJECT_200_PETER});
        Assert.assertEquals((Object)OBJECT_100_SCOTT, (Object)cache.getEntriesFromCache((AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"))[0]);
        Assert.assertEquals((Object)OBJECT_100_ROD, (Object)cache.getEntriesFromCache((AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"))[1]);
        Assert.assertEquals((Object)OBJECT_200_PETER, (Object)cache.getEntriesFromCache((AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "200"))[0]);
        Assert.assertNull((Object)cache.getEntriesFromCache((AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "NOT_IN_CACHE")));
        cache.removeEntriesFromCache((AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"));
        Assert.assertNull((Object)cache.getEntriesFromCache((AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100")));
    }

    @Test
    public void startupDetectsMissingCache() throws Exception {
        EhCacheBasedAclEntryCache cache = new EhCacheBasedAclEntryCache();
        try {
            cache.afterPropertiesSet();
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertTrue((boolean)true);
        }
        Ehcache myCache = this.getCache();
        cache.setCache(myCache);
        Assert.assertEquals((Object)myCache, (Object)cache.getCache());
    }
}

