/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acl.basic;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.acl.AclEntry;
import org.springframework.security.acl.basic.AclObjectIdentity;
import org.springframework.security.acl.basic.GrantedAuthorityEffectiveAclsResolver;
import org.springframework.security.acl.basic.NamedEntityObjectIdentity;
import org.springframework.security.acl.basic.SimpleAclEntry;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.userdetails.User;

public class GrantedAuthorityEffectiveAclsResolverTests
extends TestCase {
    private SimpleAclEntry entry100RoleEverybody = new SimpleAclEntry((Object)"ROLE_EVERYBODY", (AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"), null, 14);
    private SimpleAclEntry entry100RoleOne = new SimpleAclEntry((Object)"ROLE_ONE", (AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"), null, 0);
    private SimpleAclEntry entry100RoleTwo = new SimpleAclEntry((Object)"ROLE_TWO", (AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"), null, 2);
    private UsernamePasswordAuthenticationToken scott = new UsernamePasswordAuthenticationToken((Object)"scott", (Object)"not used", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_EVERYBODY"), new GrantedAuthorityImpl("ROLE_TWO")});
    private SimpleAclEntry entry100Scott = new SimpleAclEntry(this.scott.getPrincipal(), (AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"), null, 4);
    private UsernamePasswordAuthenticationToken dianne = new UsernamePasswordAuthenticationToken((Object)"dianne", (Object)"not used");
    private UsernamePasswordAuthenticationToken rod = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"not used", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_EVERYBODY"), new GrantedAuthorityImpl("ROLE_ONE")});
    private SimpleAclEntry entry100rod = new SimpleAclEntry(this.rod.getPrincipal(), (AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"), null, 2);
    private UsernamePasswordAuthenticationToken scottWithUserDetails = new UsernamePasswordAuthenticationToken((Object)new User("scott", "NOT_USED", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_EVERYBODY")}), (Object)"not used", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_EVERYBODY"), new GrantedAuthorityImpl("ROLE_TWO")});
    private SimpleAclEntry[] acls = new SimpleAclEntry[]{this.entry100rod, this.entry100Scott, this.entry100RoleEverybody, this.entry100RoleOne, this.entry100RoleTwo};

    public GrantedAuthorityEffectiveAclsResolverTests() {
    }

    public GrantedAuthorityEffectiveAclsResolverTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(GrantedAuthorityEffectiveAclsResolverTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testResolveAclsForDianneWhoHasANullForAuthorities() {
        GrantedAuthorityEffectiveAclsResolver resolver = new GrantedAuthorityEffectiveAclsResolver();
        GrantedAuthorityEffectiveAclsResolverTests.assertNull((Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.dianne));
    }

    public void testResolveAclsForrod() {
        GrantedAuthorityEffectiveAclsResolver resolver = new GrantedAuthorityEffectiveAclsResolver();
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((int)3, (int)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.rod).length);
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((Object)this.entry100rod, (Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.rod)[0]);
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((Object)this.entry100RoleEverybody, (Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.rod)[1]);
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((Object)this.entry100RoleOne, (Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.rod)[2]);
    }

    public void testResolveAclsForScottWithStringObjectAsPrincipal() {
        GrantedAuthorityEffectiveAclsResolver resolver = new GrantedAuthorityEffectiveAclsResolver();
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((int)3, (int)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.scott).length);
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((Object)this.entry100Scott, (Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.scott)[0]);
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((Object)this.entry100RoleEverybody, (Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.scott)[1]);
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((Object)this.entry100RoleTwo, (Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.scott)[2]);
    }

    public void testResolveAclsForScottWithUserDetailsObjectAsPrincipal() {
        GrantedAuthorityEffectiveAclsResolver resolver = new GrantedAuthorityEffectiveAclsResolver();
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((int)3, (int)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.scottWithUserDetails).length);
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((Object)this.entry100Scott, (Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.scottWithUserDetails)[0]);
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((Object)this.entry100RoleEverybody, (Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.scottWithUserDetails)[1]);
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((Object)this.entry100RoleTwo, (Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.scottWithUserDetails)[2]);
    }

    public void testResolveAclsReturnsNullIfNoAclsInFirstPlace() {
        GrantedAuthorityEffectiveAclsResolver resolver = new GrantedAuthorityEffectiveAclsResolver();
        GrantedAuthorityEffectiveAclsResolverTests.assertNull((Object)resolver.resolveEffectiveAcls(null, (Authentication)this.scott));
    }

    public void testSkipsNonBasicAclEntryObjects() {
        GrantedAuthorityEffectiveAclsResolver resolver = new GrantedAuthorityEffectiveAclsResolver();
        AclEntry[] basicAcls = new AclEntry[]{this.entry100rod, this.entry100Scott, this.entry100RoleEverybody, this.entry100RoleOne, new MockAcl(), this.entry100RoleTwo};
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((int)3, (int)resolver.resolveEffectiveAcls(basicAcls, (Authentication)this.rod).length);
    }

    private class MockAcl
    implements AclEntry {
        private MockAcl() {
        }
    }
}

