/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security;

import junit.framework.Assert;
import org.junit.Test;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.SecurityConfig;

public class SecurityConfigTests {
    @Test
    public void testHashCode() {
        SecurityConfig config = new SecurityConfig("TEST");
        Assert.assertEquals((int)"TEST".hashCode(), (int)config.hashCode());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCannotConstructWithNullAttribute() {
        new SecurityConfig(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCannotConstructWithEmptyAttribute() {
        new SecurityConfig("");
    }

    @Test(expected=NoSuchMethodException.class)
    public void testNoArgConstructorDoesntExist() throws Exception {
        SecurityConfig.class.getDeclaredConstructor(null);
    }

    @Test
    public void testObjectEquals() throws Exception {
        SecurityConfig security1 = new SecurityConfig("TEST");
        SecurityConfig security2 = new SecurityConfig("TEST");
        Assert.assertEquals((Object)security1, (Object)security2);
        String securityString1 = "TEST";
        Assert.assertNotSame((Object)security1, (Object)securityString1);
        String securityString2 = "NOT_EQUAL";
        Assert.assertTrue((!security1.equals((Object)securityString2) ? 1 : 0) != 0);
        SecurityConfig security3 = new SecurityConfig("NOT_EQUAL");
        Assert.assertTrue((!security1.equals((Object)security3) ? 1 : 0) != 0);
        MockConfigAttribute mock1 = new MockConfigAttribute("TEST");
        Assert.assertEquals((Object)security1, (Object)mock1);
        MockConfigAttribute mock2 = new MockConfigAttribute("NOT_EQUAL");
        Assert.assertTrue((!security1.equals((Object)mock2) ? 1 : 0) != 0);
        Integer int1 = new Integer(987);
        Assert.assertTrue((!security1.equals((Object)int1) ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        SecurityConfig config = new SecurityConfig("TEST");
        Assert.assertEquals((String)"TEST", (String)config.toString());
    }

    private class MockConfigAttribute
    implements ConfigAttribute {
        private String attribute;

        public MockConfigAttribute(String configuration) {
            this.attribute = configuration;
        }

        public String getAttribute() {
            return this.attribute;
        }
    }
}

