/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.XlsExportParametersBean;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.Output;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportOutput;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionException;

public class XlsxReportOutput
implements Output {
    private static final Log log = LogFactory.getLog(XlsxReportOutput.class);
    private XlsExportParametersBean exportParams;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReportOutput getOutput(EngineService engineService, ExecutionContext executionContext, String reportUnitURI, DataContainer xlsxData, JRHyperlinkProducerFactory hyperlinkProducerFactory, RepositoryService repositoryService, JasperPrint jasperPrint, String baseFilename, Locale locale, String characterEncoding) throws JobExecutionException {
        try {
            JRXlsxExporter exporter = new JRXlsxExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            boolean close = false;
            OutputStream xlsxDataOut = xlsxData.getOutputStream();
            try {
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)xlsxDataOut);
                exporter.setParameter(JExcelApiExporterParameter.CREATE_CUSTOM_PALETTE, (Object)Boolean.TRUE);
                if (this.exportParams != null) {
                    if (this.exportParams.getOnePagePerSheet() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)this.exportParams.getOnePagePerSheet());
                    if (this.exportParams.getDetectCellType() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)this.exportParams.getDetectCellType());
                    if (this.exportParams.getRemoveEmptySpaceBetweenRows() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)this.exportParams.getRemoveEmptySpaceBetweenRows());
                    if (this.exportParams.getRemoveEmptySpaceBetweenColumns() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)this.exportParams.getRemoveEmptySpaceBetweenColumns());
                    if (this.exportParams.getWhitePageBackground() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)this.exportParams.getWhitePageBackground());
                    if (this.exportParams.getIgnoreGraphics() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_GRAPHICS, (Object)this.exportParams.getIgnoreGraphics());
                    if (this.exportParams.getCollapseRowSpan() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_COLLAPSE_ROW_SPAN, (Object)this.exportParams.getCollapseRowSpan());
                    if (this.exportParams.getIgnoreCellBorder() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_CELL_BORDER, (Object)this.exportParams.getIgnoreCellBorder());
                    if (this.exportParams.getFontSizeFixEnabled() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_FONT_SIZE_FIX_ENABLED, (Object)this.exportParams.getFontSizeFixEnabled());
                    if (this.exportParams.getMaximumRowsPerSheet() != null) {
                        // empty if block
                    }
                    exporter.setParameter(JRXlsExporterParameter.MAXIMUM_ROWS_PER_SHEET, (Object)this.exportParams.getMaximumRowsPerSheet());
                    if (this.exportParams.getXlsFormatPatternsMap() == null || !this.exportParams.getXlsFormatPatternsMap().isEmpty()) {
                        // empty if block
                    }
                    exporter.setParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP, (Object)this.exportParams.getXlsFormatPatternsMap());
                }
                exporter.exportReport();
                close = false;
                xlsxDataOut.close();
                String filename = baseFilename + ".xlsx";
                ReportOutput reportOutput = new ReportOutput(xlsxData, "xlsx", filename);
                return reportOutput;
            }
            catch (IOException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
            finally {
                if (close) {
                    try {
                        xlsxDataOut.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing stream", (Throwable)e);
                    }
                }
            }
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    public XlsExportParametersBean getExportParams() {
        return this.exportParams;
    }

    public void setExportParams(XlsExportParametersBean exportParams) {
        this.exportParams = exportParams;
    }
}

