/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.JSSchedulerFactory;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.LocalThreadRunner;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.NullTaskExecutor;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.NullThreadRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.spi.ThreadRunner;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class JSSchedulerFactoryBean
extends SchedulerFactoryBean {
    private static final Log log = LogFactory.getLog(JSSchedulerFactoryBean.class);
    private ThreadRunner threadRunner;

    public JSSchedulerFactoryBean() {
        this.setSchedulerFactoryClass(JSSchedulerFactory.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Scheduler createScheduler(SchedulerFactory schedulerFactory, String schedulerName) throws SchedulerException {
        try {
            if (this.threadRunner != null) {
                if (!(schedulerFactory instanceof JSSchedulerFactory)) {
                    throw new RuntimeException("A JSSchedulerFactory scheduler factory is required");
                }
                LocalThreadRunner.setLocalThreadRunner(this.threadRunner);
                JSSchedulerFactory factory = (JSSchedulerFactory)schedulerFactory;
                factory.getInitProps().setProperty("org.quartz.threadRunner.class", LocalThreadRunner.class.getName());
                factory.reinit();
            }
            Scheduler scheduler = super.createScheduler(schedulerFactory, schedulerName);
            return scheduler;
        }
        finally {
            if (this.threadRunner != null) {
                LocalThreadRunner.setLocalThreadRunner(null);
            }
        }
    }

    public ThreadRunner getThreadRunner() {
        return this.threadRunner;
    }

    public void setThreadRunner(ThreadRunner threadRunner) {
        if (threadRunner instanceof NullThreadRunner) {
            threadRunner = null;
        }
        this.threadRunner = threadRunner;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        if (taskExecutor instanceof NullTaskExecutor) {
            taskExecutor = null;
        }
        super.setTaskExecutor(taskExecutor);
    }
}

