/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import java.util.Date;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.quartz.TriggerUtils;

public class JRTimezoneResultSetDataSource
implements JRDataSource {
    private TimeZone timezone;
    private JRDataSource dataSource;

    public JRTimezoneResultSetDataSource(JRDataSource dataSource, TimeZone timezone) {
        this.dataSource = dataSource;
        this.timezone = timezone;
    }

    public boolean next() throws JRException {
        boolean hasNext = false;
        if (this.dataSource != null) {
            try {
                hasNext = this.dataSource.next();
            }
            catch (JRException e) {
                throw new JRException("Unable to get next record.", (Throwable)e);
            }
        }
        return hasNext;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (field != null && this.dataSource != null) {
            value = this.dataSource.getFieldValue(field);
            if (value instanceof Date && this.timezone != null) {
                Date initialDate = (Date)value;
                Date date = TriggerUtils.translateTime((Date)initialDate, (TimeZone)TimeZone.getTimeZone("GMT"), (TimeZone)this.timezone);
                initialDate.setTime(date.getTime());
                return initialDate;
            }
            return value;
        }
        return value;
    }
}

