/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.base.JRBaseDataset;
import net.sf.jasperreports.engine.base.JRBaseField;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.base.JRBaseParameter;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactory;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;
import net.sf.jasperreports.engine.util.JRQueryExecuterUtils;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRQueryExecuterAdapter {
    private static final Log log = LogFactory.getLog(JRQueryExecuterAdapter.class);

    public static JRParameter makeParameter(String name, Class type) {
        JRDesignParameter parameter = new JRDesignParameter();
        parameter.setName(name);
        parameter.setValueClass(type);
        parameter.setForPrompting(false);
        return parameter;
    }

    public static OrderedMap executeQuery(Query query, String keyColumn, String[] resultColumns, Map parameterValues) {
        return JRQueryExecuterAdapter.executeQuery(query, keyColumn, resultColumns, parameterValues, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OrderedMap executeQuery(Query query, String keyColumn, String[] resultColumns, Map parameterValues, List additionalParameters) {
        LinkedMap linkedMap;
        JRQueryExecuterFactory queryExecuterFactory = JRQueryExecuterUtils.getQueryExecuterFactory((String)query.getLanguage());
        JRParameter[] dsParameters = JRQueryExecuterAdapter.getDatasetParameters(queryExecuterFactory, parameterValues, additionalParameters);
        JRField[] fields = JRQueryExecuterAdapter.getDatasetFields(keyColumn, resultColumns);
        JRQuery dsQuery = JRQueryExecuterAdapter.makeReportQuery(query);
        JSDataset dataset = new JSDataset(query.getName(), dsParameters, fields, dsQuery);
        HashMap<String, JRParameter> parametersMap = new HashMap<String, JRParameter>();
        for (int i = 0; i < dsParameters.length; ++i) {
            JRParameter parameter = dsParameters[i];
            parametersMap.put(parameter.getName(), parameter);
        }
        JRQueryExecuter executer = queryExecuterFactory.createQueryExecuter((JRDataset)dataset, parametersMap);
        try {
            JRDataSource ds = executer.createDatasource();
            LinkedMap values = new LinkedMap();
            while (ds.next()) {
                Object valueColumn = ds.getFieldValue(dataset.getField(keyColumn));
                String[] visibleColumnValues = new String[resultColumns.length];
                for (int idx = 0; idx < resultColumns.length; ++idx) {
                    Object fieldValue = ds.getFieldValue(dataset.getField(resultColumns[idx]));
                    visibleColumnValues[idx] = fieldValue == null ? null : fieldValue.toString();
                }
                values.put(valueColumn, (Object)visibleColumnValues);
            }
            linkedMap = values;
        }
        catch (Throwable throwable) {
            try {
                executer.close();
                throw throwable;
            }
            catch (JRException e) {
                log.error((Object)"Error while executing query", (Throwable)e);
                throw new JSExceptionWrapper((Exception)((Object)e));
            }
        }
        executer.close();
        return linkedMap;
    }

    protected static JRQuery makeReportQuery(Query query) {
        JRDesignQuery reportQuery = new JRDesignQuery();
        reportQuery.setLanguage(query.getLanguage());
        reportQuery.setText(query.getSql());
        return reportQuery;
    }

    protected static JRField[] getDatasetFields(String keyColumn, String[] resultColumns) {
        ArrayList<ColumnField> fields = new ArrayList<ColumnField>(resultColumns.length + 1);
        fields.add(new ColumnField(keyColumn, Object.class));
        for (int idx = 0; idx < resultColumns.length; ++idx) {
            String resultColumn = resultColumns[idx];
            if (resultColumn.equals(keyColumn)) continue;
            fields.add(new ColumnField(resultColumn, String.class));
        }
        return fields.toArray(new JRField[fields.size()]);
    }

    protected static JRParameter[] getDatasetParameters(JRQueryExecuterFactory queryExecuterFactory, Map parameterValues, List additionalParameters) {
        Object[] builtinParameters;
        boolean jdbcConnectionParam = parameterValues.containsKey("REPORT_CONNECTION");
        ArrayList<ValueParameter> dsParameters = new ArrayList<ValueParameter>();
        dsParameters.add(new ValueParameter("REPORT_PARAMETERS_MAP", Map.class, parameterValues));
        for (Map.Entry o : parameterValues.entrySet()) {
            Map.Entry entry = o;
            if (entry.getValue() == null) continue;
            dsParameters.add(new ValueParameter((String)entry.getKey(), entry.getValue().getClass(), entry.getValue()));
        }
        dsParameters.add(new ValueParameter("REPORT_MAX_COUNT", Integer.class, parameterValues.get("REPORT_MAX_COUNT")));
        if (jdbcConnectionParam) {
            Object value = parameterValues.get("REPORT_CONNECTION");
            dsParameters.add(new ValueParameter("REPORT_CONNECTION", Connection.class, value));
        }
        if ((builtinParameters = queryExecuterFactory.getBuiltinParameters()) != null) {
            for (int i = 0; i < builtinParameters.length - 1; i += 2) {
                String name = (String)builtinParameters[i];
                Class type = (Class)builtinParameters[i + 1];
                Object value = parameterValues.get(name);
                dsParameters.add(new ValueParameter(name, type, value));
            }
        }
        if (additionalParameters != null && !additionalParameters.isEmpty()) {
            for (JRParameter parameter : additionalParameters) {
                Object value = parameterValues.get(parameter.getName());
                dsParameters.add(new ValueParameter(parameter, value));
            }
        }
        JRParameter[] params = new JRParameter[dsParameters.size()];
        return dsParameters.toArray(params);
    }

    public static JRQueryExecuter createQueryExecuter(JasperReport report, Map parameterValues, Query query) {
        try {
            JRQueryExecuterFactory queryExecuterFactory = JRQueryExecuterUtils.getQueryExecuterFactory((String)query.getLanguage());
            ReportQueryDataset dataset = new ReportQueryDataset(report, query, queryExecuterFactory);
            ShallowJRObjectFactory jrObjectFactory = new ShallowJRObjectFactory((JRDefaultStyleProvider)report);
            HashMap<String, ParameterValueDecorator> parametersMap = new HashMap<String, ParameterValueDecorator>();
            JRParameter[] parameters = dataset.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                JRParameter parameter = parameters[i];
                Object value = parameterValues.get(parameter.getName());
                ParameterValueDecorator parameterValue = new ParameterValueDecorator(parameter, value, jrObjectFactory);
                parametersMap.put(parameter.getName(), parameterValue);
            }
            JRQueryExecuter executer = queryExecuterFactory.createQueryExecuter((JRDataset)dataset, parametersMap);
            return executer;
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected static class ShallowJRObjectFactory
    extends JRBaseObjectFactory {
        protected ShallowJRObjectFactory(JRDefaultStyleProvider defaultStyleProvider) {
            super(defaultStyleProvider);
        }

        public JRExpression getExpression(JRExpression expression) {
            return expression;
        }
    }

    protected static class ParameterValueDecorator
    extends JRBaseParameter
    implements JRValueParameter {
        private Object value;

        public ParameterValueDecorator(JRParameter parameter, Object value, JRBaseObjectFactory jrObjectFactory) {
            super(parameter, jrObjectFactory);
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    protected static class ReportQueryDataset
    implements JRDataset {
        private final JRDataset reportDataset;
        private final JRParameter[] parameters;
        private final JRQuery query;

        public ReportQueryDataset(JasperReport report, Query query, JRQueryExecuterFactory queryExecuterFactory) {
            this.reportDataset = report.getMainDataset();
            this.query = this.getQuery(query);
            this.parameters = this.getParams(queryExecuterFactory);
        }

        private JRQuery getQuery(Query query) {
            JRDesignQuery designQuery = new JRDesignQuery();
            designQuery.setLanguage(query.getLanguage());
            designQuery.setText(query.getSql());
            return designQuery;
        }

        private JRParameter[] getParams(JRQueryExecuterFactory queryExecuterFactory) {
            JRParameter[] paramArray;
            Object[] builtinParameters = queryExecuterFactory.getBuiltinParameters();
            if (builtinParameters == null || builtinParameters.length == 0) {
                paramArray = this.reportDataset.getParameters();
            } else {
                int i;
                JRParameter[] reportParams = this.reportDataset.getParameters();
                ArrayList<Object> params = new ArrayList<Object>(reportParams.length + builtinParameters.length / 2);
                HashSet<String> paramNames = new HashSet<String>();
                for (i = 0; i < reportParams.length; ++i) {
                    JRParameter parameter = reportParams[i];
                    params.add(parameter);
                    paramNames.add(parameter.getName());
                }
                for (i = 0; i < builtinParameters.length - 1; i += 2) {
                    String name = (String)builtinParameters[i];
                    if (paramNames.contains(name)) continue;
                    Class type = (Class)builtinParameters[i + 1];
                    params.add((Object)new ValueParameter(name, type, null));
                }
                paramArray = new JRParameter[params.size()];
                paramArray = params.toArray(paramArray);
            }
            return paramArray;
        }

        public String getName() {
            return this.reportDataset.getName();
        }

        public String getScriptletClass() {
            return this.reportDataset.getScriptletClass();
        }

        public JRParameter[] getParameters() {
            return this.parameters;
        }

        public JRQuery getQuery() {
            return this.query;
        }

        public JRScriptlet[] getScriptlets() {
            return this.reportDataset.getScriptlets();
        }

        public JRField[] getFields() {
            return this.reportDataset.getFields();
        }

        public JRVariable[] getVariables() {
            return this.reportDataset.getVariables();
        }

        public JRGroup[] getGroups() {
            return this.reportDataset.getGroups();
        }

        public boolean isMainDataset() {
            return true;
        }

        public String getResourceBundle() {
            return this.reportDataset.getResourceBundle();
        }

        public byte getWhenResourceMissingType() {
            return this.reportDataset.getWhenResourceMissingType();
        }

        public WhenResourceMissingTypeEnum getWhenResourceMissingTypeValue() {
            return this.reportDataset.getWhenResourceMissingTypeValue();
        }

        public void setWhenResourceMissingType(byte type) {
        }

        public void setWhenResourceMissingType(WhenResourceMissingTypeEnum type) {
        }

        public JRPropertiesMap getPropertiesMap() {
            return this.reportDataset.getPropertiesMap();
        }

        public JRPropertiesHolder getParentProperties() {
            return this.reportDataset.getParentProperties();
        }

        public boolean hasProperties() {
            return this.reportDataset.hasProperties();
        }

        public JRExpression getFilterExpression() {
            return this.reportDataset.getFilterExpression();
        }

        public JRSortField[] getSortFields() {
            return this.reportDataset.getSortFields();
        }

        public Object clone() {
            throw new JSException("Clone not supported");
        }
    }

    protected static class ValueParameter
    extends JRBaseParameter
    implements JRValueParameter {
        private Object value;

        public ValueParameter(JRParameter parameter, Object value) {
            this(parameter.getName(), parameter.getValueClass(), value);
        }

        public ValueParameter(String name, Class type, Object value) {
            this.name = name;
            this.valueClass = type;
            this.valueClassName = type.getName();
            this.isSystemDefined = true;
            this.isForPrompting = false;
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    protected static class JSDataset
    extends JRBaseDataset {
        private final Map fieldsMap;

        public JSDataset(String name, JRParameter[] parameters, JRField[] fields, JRQuery query) {
            super(false);
            this.name = name;
            this.parameters = parameters;
            this.fields = fields;
            this.query = query;
            this.fieldsMap = new HashMap();
            for (int i = 0; i < fields.length; ++i) {
                JRField field = fields[i];
                this.fieldsMap.put(field.getName(), field);
            }
        }

        public JRField getField(String column) {
            return (JRField)this.fieldsMap.get(column);
        }
    }

    protected static class ColumnField
    extends JRBaseField {
        public ColumnField(String column, Class type) {
            this.name = column;
            this.valueClass = type;
            this.valueClassName = type.getName();
        }
    }
}

