/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.user;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.engine.common.user.UserPersistenceHandler;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoUser;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.UserAuthorityPersistenceService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StandardUserPersistenceHandler
implements UserPersistenceHandler {
    private static final Log log = LogFactory.getLog(StandardUserPersistenceHandler.class);
    private SecurityContextProvider securityContextProvider;
    private UserAuthorityPersistenceService userPersistenceService;

    public SecurityContextProvider getSecurityContextProvider() {
        return this.securityContextProvider;
    }

    public void setSecurityContextProvider(SecurityContextProvider securityContextProvider) {
        this.securityContextProvider = securityContextProvider;
    }

    public UserAuthorityPersistenceService getUserPersistenceService() {
        return this.userPersistenceService;
    }

    public void setUserPersistenceService(UserAuthorityPersistenceService userPersistenceService) {
        this.userPersistenceService = userPersistenceService;
    }

    public String getClientUsername(RepoUser user) {
        return user == null ? null : user.getUsername();
    }

    public RepoUser getPersistentUserFromUsername(String username) {
        return this.loadPersistentUser(username);
    }

    public RepoUser getPersistentUserFromContext() {
        String contextUsername = this.getContextUsername();
        if (contextUsername == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No context user found");
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found context user " + contextUsername));
        }
        return this.loadPersistentUser(contextUsername);
    }

    protected String getContextUsername() {
        return this.getSecurityContextProvider().getContextUsername();
    }

    protected RepoUser loadPersistentUser(String username) {
        RepoUser persistentUser = this.userPersistenceService.getPersistentUser(username);
        if (persistentUser == null) {
            throw new JSException("jsexception.no.such.user", new Object[]{username});
        }
        return persistentUser;
    }
}

