/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.service.impl;

import com.jaspersoft.jasperserver.api.engine.common.service.ActionModelSupport;
import com.jaspersoft.jasperserver.api.engine.common.service.impl.ActionModel;
import com.jaspersoft.jasperserver.api.engine.common.service.impl.ActionModelServiceImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContext;
import org.springframework.security.context.SecurityContextHolder;

public class NavigationActionModelSupport
implements ActionModelSupport,
InitializingBean {
    private static String action_model_context;
    private MessageSource messages;
    private static NavigationActionModelSupport _single_ton;
    private static final String ARGUMENT_DELIMITER = "@@";
    private static final String NO_TENANT_ID = "null";
    private static final String LICENSE_MANAGER = "com.jaspersoft.ji.license.LicenseManager";
    private static Log log;

    private NavigationActionModelSupport() {
        log.info((Object)"Creating NavigationActionModelSupport singleton object.");
    }

    public static synchronized NavigationActionModelSupport getInstance() {
        return _single_ton;
    }

    public String getClientActionModelDocument(String context) {
        String json = "";
        if (context == null || context.length() <= 0) {
            log.error((Object)("Unable to create " + context + " menu. Most likely programmer error"));
            throw new RuntimeException("Unable to create menu.");
        }
        action_model_context = context;
        json = this.getClientActionModelDocument();
        return json;
    }

    public String getClientActionModelDocument() {
        String data;
        Document document = ActionModelServiceImpl.getInstance().getActionModelMenu(action_model_context);
        try {
            data = ActionModel.getInstance().generateClientActionModel(this, document);
        }
        catch (Exception e) {
            log.error((Object)"Unable to create navigation menu");
            e.printStackTrace();
            data = "";
        }
        return data;
    }

    public boolean isProVersion() {
        boolean isPro;
        block3: {
            isPro = false;
            try {
                Class<?> clazz = Class.forName(LICENSE_MANAGER);
                if (clazz != null) {
                    isPro = true;
                }
            }
            catch (ClassNotFoundException e) {
                if (!log.isDebugEnabled()) break block3;
                log.info((Object)"This is not a pro version. Access is denied");
            }
        }
        return isPro;
    }

    public boolean isCEVersion() {
        return !this.isProVersion();
    }

    public boolean isAvailableProFeature(String id) {
        boolean isAvailable;
        block5: {
            isAvailable = false;
            if (this.isProVersion()) {
                try {
                    Method method;
                    Class<?> clazz = Class.forName(LICENSE_MANAGER);
                    Field field = clazz.getField("ANALYSIS_FEATURES");
                    String fid = (String)field.get(clazz);
                    if (id != null && id.equals(fid)) {
                        method = clazz.getDeclaredMethod("isAnalysisFeatureSupported", new Class[0]);
                        isAvailable = (Boolean)method.invoke(method.getDeclaringClass(), new Object[0]);
                    }
                    field = clazz.getField("MULTITENANCY_FEATURES");
                    fid = (String)field.get(clazz);
                    if (id != null && id.equals(fid)) {
                        method = clazz.getDeclaredMethod("isMultitenancyFeatureSupported", new Class[0]);
                        isAvailable = (Boolean)method.invoke(method.getDeclaringClass(), new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block5;
                    log.info((Object)"This is not a pro version. Access is denied");
                }
            }
        }
        return isAvailable;
    }

    private Set getAuthenticationRoles() {
        SecurityContext secContext = SecurityContextHolder.getContext();
        Authentication authentication = secContext.getAuthentication();
        User principal = (User)authentication.getPrincipal();
        if (principal == null) {
            log.error((Object)"Authentication is null.");
            throw new RuntimeException("[Error]: Authentication is null.");
        }
        return principal.getRoles();
    }

    public boolean checkAuthenticationRoles(String allowedRoles) {
        String[] roles;
        for (String role : roles = allowedRoles.split(ARGUMENT_DELIMITER)) {
            if (!this.checkRole(role)) continue;
            return true;
        }
        return false;
    }

    private boolean checkRole(String role) {
        String[] tenantIdArray = role.split("\\|");
        String expectedTenantId = tenantIdArray.length > 1 ? tenantIdArray[1] : NO_TENANT_ID;
        String expectedRole = tenantIdArray[0];
        Set userRoles = this.getAuthenticationRoles();
        for (Object obj : userRoles) {
            String roleName = ((Role)obj).getRoleName();
            String roleTenantId = ((Role)obj).getTenantId();
            if (roleTenantId == null) {
                roleTenantId = NO_TENANT_ID;
            }
            if (!roleTenantId.equals(expectedTenantId) || !roleName.equals(expectedRole)) continue;
            return true;
        }
        return false;
    }

    public int getFunctionId() {
        return 3;
    }

    public String getMessage(String label) {
        return this.messages.getMessage(label, null, LocaleContextHolder.getLocale());
    }

    public void setDefaultMessageSource(MessageSource messages) {
        this.messages = messages;
    }

    public MessageSource getDefaultMessageSource() {
        return this.messages;
    }

    public void afterPropertiesSet() throws Exception {
        _single_ton = this;
    }

    static {
        log = LogFactory.getLog(NavigationActionModelSupport.class);
    }
}

