/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.LogEvent;
import com.jaspersoft.jasperserver.api.common.domain.impl.RepoLogEvent;
import com.jaspersoft.jasperserver.api.engine.common.service.LoggingService;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.engine.common.user.UserPersistenceHandler;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class HibernateLoggingService
extends HibernateDaoSupport
implements LoggingService {
    private static final Log log = LogFactory.getLog(HibernateLoggingService.class);
    private static final long EVENT_ID_NEW = 0L;
    private SecurityContextProvider securityContextProvider;
    private int maximumAge;
    private ResourceFactory objectFactory;
    private UserPersistenceHandler userHandler;

    public UserPersistenceHandler getUserHandler() {
        return this.userHandler;
    }

    public void setUserHandler(UserPersistenceHandler userHandler) {
        this.userHandler = userHandler;
    }

    public ResourceFactory getObjectMappingFactory() {
        return this.objectFactory;
    }

    public void setObjectMappingFactory(ResourceFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public SecurityContextProvider getSecurityContextProvider() {
        return this.securityContextProvider;
    }

    public void setSecurityContextProvider(SecurityContextProvider securityContextProvider) {
        this.securityContextProvider = securityContextProvider;
    }

    public int getMaximumAge() {
        return this.maximumAge;
    }

    public void setMaximumAge(int days) {
        this.maximumAge = days;
    }

    public LogEvent instantiateLogEvent() {
        return this.createLogEvent();
    }

    protected LogEvent createLogEvent() {
        return new RepoLogEvent();
    }

    public void log(LogEvent event) {
        this.prepareForSave(event);
        this.getHibernateTemplate().save((Object)event);
    }

    public void update(LogEvent event) {
        RepoLogEvent repoLogEvent = this.getRepoLogEvent(null, event.getId());
        repoLogEvent.copyFromClient(event);
        this.getHibernateTemplate().saveOrUpdate((Object)repoLogEvent);
    }

    protected void prepareForSave(LogEvent event) {
        event.setId(0L);
        if (event.getOccurrenceDate() == null) {
            event.setOccurrenceDate(new Date());
        }
        RepoLogEvent repoLogEvent = (RepoLogEvent)event;
        RepoUser persistentUser = this.userHandler.getPersistentUserFromContext();
        repoLogEvent.setUser((User)persistentUser);
    }

    public void purge() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -this.getMaximumAge());
        Date last = cal.getTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Purging log events older than " + last));
        }
        this.getHibernateTemplate().bulkUpdate("delete RepoLogEvent e where e.occurrenceDate < ?", (Object)last);
    }

    public void delete(ExecutionContext context, long[] eventIds) {
        for (int i = 0; i < eventIds.length; ++i) {
            RepoLogEvent event = this.getRepoLogEvent(context, eventIds[i]);
            this.getHibernateTemplate().delete((Object)event);
        }
    }

    public List getUserEvents(ExecutionContext context) {
        List events;
        RepoUser user = this.userHandler.getPersistentUserFromContext();
        if (user != null) {
            DetachedCriteria criteria = DetachedCriteria.forClass(RepoLogEvent.class);
            criteria.add((Criterion)Restrictions.eq((String)"user", (Object)user));
            criteria.addOrder(Order.desc((String)"occurrenceDate"));
            events = this.getHibernateTemplate().findByCriteria(criteria);
        } else {
            events = Collections.emptyList();
        }
        return this.getClientEvents(events);
    }

    private List getClientEvents(List repoEvents) {
        ArrayList<LogEvent> events = new ArrayList<LogEvent>();
        for (int i = 0; i < repoEvents.size(); ++i) {
            events.add(((RepoLogEvent)repoEvents.get(i)).toClient(this.objectFactory));
        }
        return events;
    }

    public List getUnreadEvents(ExecutionContext context) {
        List events;
        RepoUser user = this.userHandler.getPersistentUserFromContext();
        if (user != null) {
            DetachedCriteria criteria = DetachedCriteria.forClass(RepoLogEvent.class);
            criteria.add((Criterion)Restrictions.eq((String)"state", (Object)new Byte(1)));
            criteria.add((Criterion)Restrictions.eq((String)"user", (Object)user));
            criteria.addOrder(Order.desc((String)"occurrenceDate"));
            events = this.getHibernateTemplate().findByCriteria(criteria);
        } else {
            events = Collections.emptyList();
        }
        return this.getClientEvents(events);
    }

    public LogEvent getLogEvent(ExecutionContext context, long id) {
        return this.getRepoLogEvent(context, id).toClient(this.objectFactory);
    }

    public RepoLogEvent getRepoLogEvent(ExecutionContext context, long id) {
        RepoLogEvent event = (RepoLogEvent)this.getHibernateTemplate().get(RepoLogEvent.class, (Serializable)new Long(id));
        if (event == null) {
            log.debug((Object)("Log event with id " + id + " not found"));
        } else {
            User user = this.securityContextProvider.getContextUser();
            if (event.getUser() == null) {
                log.debug((Object)("Log event with id " + id + " has no user."));
            } else {
                User eventUser = (User)((RepoUser)event.getUser()).toClient(this.objectFactory);
                if (!(user.getTenantId() != null || eventUser.getUsername().equals(user.getUsername()) && eventUser.getTenantId() == null)) {
                    log.debug((Object)("Log event with id " + id + " does not belongs to user [username=\"" + user.getUsername() + "\", tenantId=\"" + user.getTenantId() + "\"."));
                    event = null;
                }
            }
        }
        return event;
    }

    public int getUserEventsCount(ExecutionContext context) {
        String username = this.securityContextProvider.getContextUsername();
        List result = this.getHibernateTemplate().find("select count(*) from RepoLogEvent where state=?", (Object)new Byte(1));
        if (result != null) {
            Integer size = (Integer)result.get(0);
            return size;
        }
        return 0;
    }
}

