/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.validation;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationDetail;
import com.jaspersoft.jasperserver.api.common.domain.ValidationResult;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapClientConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapConnectionService;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.OlapUnitWrapper;
import java.util.List;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class OlapUnitValidator
implements Validator {
    private RepositoryService repository;
    private OlapConnectionService mConnectionService;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public boolean supports(Class clazz) {
        return OlapUnitWrapper.class.isAssignableFrom(clazz);
    }

    public void validate(Object o, Errors errors) {
        OlapUnitWrapper olapDetails = (OlapUnitWrapper)o;
        this.validateNameLabelDesc(olapDetails, errors);
    }

    public void validateNameLabelDesc(OlapUnitWrapper ouWrapper, Errors errors) {
        if (ouWrapper.getOlapUnitLabel() == null || ouWrapper.getOlapUnitLabel().trim().length() == 0) {
            errors.rejectValue("olapUnitLabel", "OlapUnitValidator.error.not.empty");
        } else if (ouWrapper.getOlapUnitLabel().length() > 100) {
            errors.rejectValue("olapUnitLabel", "OlapUnitValidator.error.too.long");
        } else if (!JasperServerUtil.regExValidateLabel(ouWrapper.getOlapUnitLabel())) {
            errors.rejectValue("olapUnitLabel", "OlapUnitValidator.error.invalid.chars");
        }
        if (ouWrapper.getOlapUnitName() == null || ouWrapper.getOlapUnitName().trim().length() == 0) {
            errors.rejectValue("olapUnitName", "OlapUnitValidator.error.not.empty");
        } else if (ouWrapper.getOlapUnitName().length() > 100) {
            errors.rejectValue("olapUnitName", "OlapUnitValidator.error.too.long");
        } else if (!JasperServerUtil.regExValidateName(ouWrapper.getOlapUnitName())) {
            errors.rejectValue("olapUnitName", "OlapUnitValidator.error.invalid.chars");
        } else if (ouWrapper.isAloneNewMode()) {
            OlapUnit olapUnit = ouWrapper.getOlapUnit();
            olapUnit.setName(ouWrapper.getOlapUnitName());
            if (this.repository.repositoryPathExists(null, ouWrapper.getOlapUnit().getURIString())) {
                errors.rejectValue("olapUnitName", "OlapUnitValidator.error.duplicate");
            }
        }
        if (ouWrapper.getOlapUnitDescription() != null && ouWrapper.getOlapUnitDescription().length() > 250) {
            errors.rejectValue("olapUnitDescription", "OlapUnitValidator.error.too.long", new Object[]{new Integer(250)}, null);
        }
    }

    public void validateMdxQuery(OlapUnitWrapper ouWrapper, Errors errors) {
        ouWrapper.getOlapUnit().setMdxQuery(ouWrapper.getOlapUnitMdxQuery());
        if (ouWrapper.isNewMode()) {
            ouWrapper.getOlapUnit().setOlapClientConnection(ouWrapper.getOlapClientConnection());
        }
        if (ouWrapper.getOlapUnitMdxQuery() == null || ouWrapper.getOlapUnitMdxQuery().trim().length() == 0) {
            errors.rejectValue("olapUnitMdxQuery", "OlapUnitValidator.error.not.empty");
        } else if (ouWrapper.getOlapUnitMdxQuery() != null && ouWrapper.getOlapUnitMdxQuery().length() > 65536) {
            errors.rejectValue("olapUnitMdxQuery", "OlapUnitValidator.error.too.long");
        } else {
            OlapUnit ou = ouWrapper.getOlapUnit();
            ExecutionContextImpl executionContext = new ExecutionContextImpl();
            FileResource schema = ouWrapper.getOlapClientSchema();
            OlapClientConnection conn = ouWrapper.getOlapClientConnection();
            ReportDataSource datasource = ouWrapper.getOlapClientDatasource();
            ValidationResult result = null;
            try {
                result = this.getConnectionService().validate((ExecutionContext)executionContext, ouWrapper.getOlapUnit(), schema, conn, datasource);
                ouWrapper.setResult(result.getValidationState().equals("VALID"));
            }
            catch (Exception e) {
                ouWrapper.setResult(result.getValidationState().equals("ERROR"));
            }
            ouWrapper.setOlapUnit(ou);
            if (result.getValidationState().equals("ERROR")) {
                List details = result.getResults();
                String causeMsg = null;
                for (int i = 0; i < details.size(); ++i) {
                    ValidationDetail detail = (ValidationDetail)details.get(i);
                    for (Throwable e = detail.getException(); e != null; e = e.getCause()) {
                        causeMsg = e.getMessage();
                    }
                }
                errors.rejectValue("olapUnitMdxQuery", "OlapUnitValidator.error.invalid.olapUnitMdxQuery", new Object[]{causeMsg}, null);
            }
        }
    }

    public void validateURIString(OlapUnitWrapper ouWrapper, Errors errors) {
        if (ouWrapper.getSource() == null) {
            errors.rejectValue("source", "OlapUnitValidator.error.invalid.schema");
        } else if (ouWrapper.getSource().equals("CONTENT_REPOSITORY") && (ouWrapper.getSchemaUri() == null || ouWrapper.getSchemaUri().length() == 0)) {
            errors.rejectValue("schemaUri", "OlapUnitValidator.error.not.reusable");
        }
    }

    public void validateConnectionType(OlapUnitWrapper ouWrapper, Errors errors) {
        if (ouWrapper.getSource() == null) {
            errors.rejectValue("source", "OlapUnitValidator.error.no.connection.type");
        }
    }

    public void validateConnectionSource(OlapUnitWrapper wrapper, Errors errors) {
        if (wrapper.getType() == null) {
            errors.rejectValue("source", "OlapUnitValidator.error.no.connection.source");
        }
    }

    public OlapConnectionService getConnectionService() {
        return this.mConnectionService;
    }

    public void setConnectionService(OlapConnectionService cs) {
        this.mConnectionService = cs;
    }
}

