/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.validation;

import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.DataTypeWrapper;
import com.jaspersoft.jasperserver.war.util.MessagesCalendarFormatProvider;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.regex.Pattern;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class DataTypeValidator
implements Validator {
    private RepositoryService repository;
    private MessagesCalendarFormatProvider calendarFormatProvider;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public boolean supports(Class klass) {
        return DataTypeWrapper.class.isAssignableFrom(klass);
    }

    public void validate(Object object, Errors errors) {
        DataTypeWrapper wrapper = (DataTypeWrapper)object;
        DataType dataType = wrapper.getDataType();
        if (dataType.getName() == null || dataType.getName().trim().length() == 0) {
            errors.rejectValue("dataType.name", "DataTypeValidator.error.not.empty");
        } else {
            if (!JasperServerUtil.regExValidateName(dataType.getName())) {
                errors.rejectValue("dataType.name", "DataTypeValidator.error.invalid.chars");
            }
            if (dataType.getName().length() > 100) {
                errors.rejectValue("dataType.name", "DataTypeValidator.error.too.long");
            }
            if (wrapper.isAloneNewMode() && this.repository.repositoryPathExists(null, dataType.getURIString())) {
                errors.rejectValue("dataType.name", "DataTypeValidator.error.duplicate");
            }
        }
        if (dataType.getLabel() == null || dataType.getLabel().trim().length() == 0) {
            errors.rejectValue("dataType.label", "DataTypeValidator.error.not.empty");
        } else {
            if (!JasperServerUtil.regExValidateLabel(dataType.getLabel())) {
                errors.rejectValue("dataType.label", "DataTypeValidator.error.invalid.chars");
            }
            if (dataType.getLabel().length() > 100) {
                errors.rejectValue("dataType.label", "DataTypeValidator.error.too.long");
            }
        }
        if (dataType.getDescription() != null && dataType.getDescription().length() > 250) {
            errors.rejectValue("dataType.description", "DataTypeValidator.error.too.long");
        }
        String strMinValue = null;
        String strMaxValue = null;
        if (dataType.getType() == 3 || dataType.getType() == 4) {
            strMinValue = wrapper.getMinValueText();
            strMaxValue = wrapper.getMaxValueText();
        } else {
            strMinValue = (String)((Object)dataType.getMinValue());
            strMaxValue = (String)((Object)dataType.getMaxValue());
        }
        if (strMinValue != null && strMinValue.length() == 0) {
            dataType.setMinValue(null);
        }
        if (strMaxValue != null && strMaxValue.length() == 0) {
            dataType.setMaxValue(null);
        }
        if (strMinValue != null && strMinValue.length() > 100) {
            errors.rejectValue("dataType.minValue", "DataTypeValidator.error.too.long");
        }
        if (strMaxValue != null && strMaxValue.length() > 100) {
            errors.rejectValue("dataType.maxValue", "DataTypeValidator.error.too.long");
        }
        if (dataType.getRegularExpr() != null && dataType.getRegularExpr().length() > 100) {
            errors.rejectValue("dataType.regularExpr", "DataTypeValidator.error.too.long");
        }
        if (dataType.getType() == 2) {
            BigDecimal maxValue;
            BigDecimal minValue;
            block29: {
                block28: {
                    minValue = null;
                    maxValue = null;
                    try {
                        minValue = new BigDecimal(strMinValue);
                    }
                    catch (NumberFormatException e) {
                        if (strMinValue.length() <= 0) break block28;
                        errors.rejectValue("dataType.minValue", "DataTypeValidator.error.invalid.number");
                    }
                }
                try {
                    maxValue = new BigDecimal(strMaxValue);
                }
                catch (NumberFormatException e) {
                    if (strMaxValue.length() <= 0) break block29;
                    errors.rejectValue("dataType.maxValue", "DataTypeValidator.error.invalid.number");
                }
            }
            if (minValue != null && maxValue != null && minValue.compareTo(maxValue) >= 0) {
                errors.rejectValue("dataType.minValue", "DataTypeValidator.error.larger.than.max");
            }
        }
        DateFormat df = null;
        if (dataType.getType() == 3) {
            df = this.calendarFormatProvider.getDateFormat();
            this.validateDateTime(df, strMinValue, strMaxValue, "DataTypeValidator.error.invalid.date.format", errors);
        }
        if (dataType.getType() == 4) {
            df = this.calendarFormatProvider.getDatetimeFormat();
            this.validateDateTime(df, strMinValue, strMaxValue, "DataTypeValidator.error.invalid.date.time.format", errors);
        }
        if (dataType.getType() == 1 && dataType.getRegularExpr() != null && dataType.getRegularExpr().trim().length() > 0) {
            if (strMinValue != null && strMinValue.trim().length() > 0 && !Pattern.matches(dataType.getRegularExpr(), strMinValue)) {
                errors.rejectValue("dataType.minValue", "DataTypeValidator.error.pattern");
            }
            if (strMaxValue != null && strMaxValue.trim().length() > 0 && !Pattern.matches(dataType.getRegularExpr(), strMaxValue)) {
                errors.rejectValue("dataType.maxValue", "DataTypeValidator.error.pattern");
            }
        }
    }

    private void validateDateTime(DateFormat df, String strMinValue, String strMaxValue, String invalidFormatMessage, Errors errors) {
        Date maxValue;
        Date minValue;
        block6: {
            block5: {
                minValue = null;
                maxValue = null;
                df.setLenient(false);
                try {
                    minValue = df.parse(strMinValue);
                }
                catch (ParseException e) {
                    if (strMinValue == null || strMinValue.length() <= 0) break block5;
                    errors.rejectValue("minValueText", invalidFormatMessage);
                }
            }
            try {
                maxValue = df.parse(strMaxValue);
            }
            catch (ParseException e) {
                if (strMaxValue == null || strMaxValue.length() <= 0) break block6;
                errors.rejectValue("maxValueText", invalidFormatMessage);
            }
        }
        if (minValue != null && maxValue != null && minValue.compareTo(maxValue) >= 0) {
            errors.rejectValue("minValueText", "DataTypeValidator.error.larger.than.max");
        }
    }

    public MessagesCalendarFormatProvider getCalendarFormatProvider() {
        return this.calendarFormatProvider;
    }

    public void setCalendarFormatProvider(MessagesCalendarFormatProvider calendarFormatProvider) {
        this.calendarFormatProvider = calendarFormatProvider;
    }
}

