/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.tags;

import com.jaspersoft.jasperserver.api.metadata.user.domain.TenantQualified;
import javax.servlet.jsp.JspException;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.taglibs.authz.AuthorizeTag;

public class TenantAwareAuthorizeTag
extends AuthorizeTag {
    public int doStartTag() throws JspException {
        if (super.getIfAllGranted() != null && super.getIfAllGranted().contains("|*")) {
            String tagRoles = this.getIfAllGranted();
            super.setIfAllGranted(tagRoles.replace("|*", ""));
            int act = super.doStartTag();
            if (act == 0 || act == 5) {
                super.setIfAllGranted(tagRoles.replace("|*", "|" + this.getTenantId()));
                return super.doStartTag();
            }
            return act;
        }
        if (super.getIfNotGranted() != null && super.getIfNotGranted().contains("|*")) {
            String tagRoles = this.getIfNotGranted();
            String rootRoles = tagRoles.replace("|*", "");
            String orgRoles = tagRoles.replace("|*", "|" + this.getTenantId());
            super.setIfNotGranted(rootRoles + "," + orgRoles);
        } else if (super.getIfAnyGranted() != null && super.getIfAnyGranted().contains("|*")) {
            String tagRoles = this.getIfAnyGranted();
            String rootRoles = tagRoles.replace("|*", "");
            String orgRoles = tagRoles.replace("|*", "|" + this.getTenantId());
            super.setIfAnyGranted(rootRoles + "," + orgRoles);
        }
        return super.doStartTag();
    }

    private String getTenantId() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (principal != null && principal instanceof TenantQualified) {
            return ((TenantQualified)principal).getTenantId();
        }
        return "";
    }
}

