/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.dto;

import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import com.jaspersoft.jasperserver.war.dto.BaseDTO;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class InputControlWrapper
extends BaseDTO {
    public static final String TYPE_DESCRIPTION_BOOLEAN = "input.control.type.boolean";
    public static final String TYPE_DESCRIPTION_SINGLE_VALUE = "input.control.type.single.value";
    public static final String TYPE_DESCRIPTION_SINGLE_SELECT_LOV = "input.control.type.single.select.lov";
    public static final String TYPE_DESCRIPTION_SINGLE_SELECT_LOV_RADIO = "input.control.type.single.select.lov.radio";
    public static final String TYPE_DESCRIPTION_SINGLE_SELECT_QUERY = "input.control.type.single.select.query";
    public static final String TYPE_DESCRIPTION_SINGLE_SELECT_QUERY_RADIO = "input.control.type.single.select.query.radio";
    public static final String TYPE_DESCRIPTION_MULTI_VALUE = "input.control.type.multi.value";
    public static final String TYPE_DESCRIPTION_MULTI_SELECT_LOV = "input.control.type.multi.select.lov";
    public static final String TYPE_DESCRIPTION_MULTI_SELECT_LOV_CHECKBOX = "input.control.type.multi.select.lov.checkbox";
    public static final String TYPE_DESCRIPTION_MULTI_SELECT_QUERY = "input.control.type.multi.select.query";
    public static final String TYPE_DESCRIPTION_MULTI_SELECT_QUERY_CHECKBOX = "input.control.type.multi.select.query.checkbox";
    private InputControl inputControl;
    private ResourceReference inputControlURI;
    private String oldInputControlURI;
    private String source;
    private List existingPathList;
    private String existingPath;
    private String listItemLabel;
    private String listItemValue;
    private String[] itemsToDelete;
    private static Map supportedControlTypes;
    private static Map supportedDataTypes;
    private String visibleColumns;
    private String dtMaxLength;
    private String dtDecimals;
    private boolean located;
    private boolean suggested;
    private Object parentFlowObject;
    private String newVisibleColumn;
    private List allResources;

    public List getAllResources() {
        return this.allResources;
    }

    public void setAllResources(List allResources) {
        this.allResources = allResources;
    }

    public Object getParentFlowObject() {
        return this.parentFlowObject;
    }

    public void setParentFlowObject(Object parentFlowObject) {
        this.parentFlowObject = parentFlowObject;
    }

    public boolean isLocated() {
        return this.located;
    }

    public void setLocated(boolean located) {
        this.located = located;
    }

    public boolean isSuggested() {
        return this.suggested;
    }

    public void setSuggested(boolean suggested) {
        this.suggested = suggested;
    }

    public InputControlWrapper() {
    }

    public InputControlWrapper(InputControl inputControl) {
        this.inputControl = inputControl;
    }

    public Map getSupportedControlTypes() {
        if (supportedControlTypes == null) {
            supportedControlTypes = new LinkedHashMap();
            supportedControlTypes.put(String.valueOf(1), TYPE_DESCRIPTION_BOOLEAN);
            supportedControlTypes.put(String.valueOf(2), TYPE_DESCRIPTION_SINGLE_VALUE);
            supportedControlTypes.put(String.valueOf(3), TYPE_DESCRIPTION_SINGLE_SELECT_LOV);
            supportedControlTypes.put(String.valueOf(8), TYPE_DESCRIPTION_SINGLE_SELECT_LOV_RADIO);
            supportedControlTypes.put(String.valueOf(6), TYPE_DESCRIPTION_MULTI_SELECT_LOV);
            supportedControlTypes.put(String.valueOf(10), TYPE_DESCRIPTION_MULTI_SELECT_LOV_CHECKBOX);
            supportedControlTypes.put(String.valueOf(4), TYPE_DESCRIPTION_SINGLE_SELECT_QUERY);
            supportedControlTypes.put(String.valueOf(9), TYPE_DESCRIPTION_SINGLE_SELECT_QUERY_RADIO);
            supportedControlTypes.put(String.valueOf(7), TYPE_DESCRIPTION_MULTI_SELECT_QUERY);
            supportedControlTypes.put(String.valueOf(11), TYPE_DESCRIPTION_MULTI_SELECT_QUERY_CHECKBOX);
        }
        return supportedControlTypes;
    }

    public Map getSupportedDataTypes() {
        if (supportedDataTypes == null) {
            supportedDataTypes = new LinkedHashMap();
            supportedDataTypes.put(String.valueOf(1), JasperServerConstImpl.getTypeText());
            supportedDataTypes.put(String.valueOf(2), JasperServerConstImpl.getTypeNumber());
            supportedDataTypes.put(String.valueOf(3), JasperServerConstImpl.getTypeDate());
            supportedDataTypes.put(String.valueOf(4), JasperServerConstImpl.getTypeDateTime());
        }
        return supportedDataTypes;
    }

    public InputControl getInputControl() {
        return this.inputControl;
    }

    public void setInputControl(InputControl inputControl) {
        this.inputControl = inputControl;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public List getExistingPathList() {
        return this.existingPathList;
    }

    public void setExistingPathList(List existingPathList) {
        this.existingPathList = existingPathList;
    }

    public String getExistingPath() {
        return this.existingPath;
    }

    public void setExistingPath(String existingPath) {
        this.existingPath = existingPath;
    }

    public String getListItemLabel() {
        return this.listItemLabel;
    }

    public void setListItemLabel(String listItemLabel) {
        this.listItemLabel = listItemLabel;
    }

    public String getListItemValue() {
        return this.listItemValue;
    }

    public void setListItemValue(String listItemValue) {
        this.listItemValue = listItemValue;
    }

    public String[] getItemsToDelete() {
        return this.itemsToDelete;
    }

    public void setItemsToDelete(String[] itemsToDelete) {
        this.itemsToDelete = itemsToDelete;
    }

    public String getVisibleColumns() {
        return this.visibleColumns;
    }

    public void setVisibleColumns(String visibleColumns) {
        this.visibleColumns = visibleColumns;
    }

    public String getDtDecimals() {
        return this.dtDecimals;
    }

    public void setDtDecimals(String dtDecimals) {
        this.dtDecimals = dtDecimals;
        int decimals = 0;
        try {
            decimals = Integer.parseInt(this.dtMaxLength);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ((DataType)this.inputControl.getDataType().getLocalResource()).setDecimals(new Integer(decimals));
    }

    public String getDtMaxLength() {
        return this.dtMaxLength;
    }

    public void setDtMaxLength(String dtMaxLength) {
        this.dtMaxLength = dtMaxLength;
        int maxLength = 0;
        try {
            maxLength = Integer.parseInt(dtMaxLength);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ((DataType)this.inputControl.getDataType().getLocalResource()).setMaxLength(new Integer(maxLength));
    }

    public boolean isLovType() {
        return this.isMultiSelectLovType() || this.isSingleSelectLovType();
    }

    public boolean isQueryType() {
        return this.isSingleSelectQueryType() || this.isMultiSelectQueryType();
    }

    public boolean isDataType() {
        return this.isSingleValueType() || this.isMultiValueType();
    }

    public boolean isBooleanType() {
        return 1 == this.inputControl.getType();
    }

    public boolean isMultiSelectLovType() {
        return 6 == this.inputControl.getType() || this.inputControl.getType() == 10;
    }

    public boolean isSingleSelectLovType() {
        return 3 == this.inputControl.getType() || 8 == this.inputControl.getType();
    }

    public boolean isMultiSelectQueryType() {
        return 7 == this.inputControl.getType() || this.inputControl.getType() == 11;
    }

    public boolean isMultiValueType() {
        return 5 == this.inputControl.getType();
    }

    public boolean isMulti() {
        return this.isMultiValueType() || this.isMultiSelectLovType() || this.isMultiSelectQueryType();
    }

    public boolean isSingleSelectQueryType() {
        return 4 == this.inputControl.getType() || 9 == this.inputControl.getType();
    }

    public boolean isSingleValueType() {
        return 2 == this.inputControl.getType();
    }

    public ResourceReference getInputControlURI() {
        return this.inputControlURI;
    }

    public void setInputControlURI(ResourceReference inputControlURI) {
        this.inputControlURI = inputControlURI;
    }

    public String getOldInputControlURI() {
        return this.oldInputControlURI;
    }

    public void setOldInputControlURI(String oldInputControlURI) {
        this.oldInputControlURI = oldInputControlURI;
    }

    public String getNewVisibleColumn() {
        return this.newVisibleColumn;
    }

    public void setNewVisibleColumn(String newVisibleColumn) {
        this.newVisibleColumn = newVisibleColumn;
    }
}

