/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.cache;

import com.jaspersoft.jasperserver.war.cascade.cache.CacheCleaner;
import com.jaspersoft.jasperserver.war.cascade.cache.DelegatorCacheManager;
import com.jaspersoft.jasperserver.war.cascade.cache.SessionCache;
import com.jaspersoft.jasperserver.war.cascade.cache.SessionCacheImpl;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatorCacheManagerImpl
implements DelegatorCacheManager {
    private long cacheCleanTriggerTime = 300000L;
    private long userCacheTimeout = 120000L;

    public long getCacheCleanTriggerTime() {
        return this.cacheCleanTriggerTime / 1000L;
    }

    public void setCacheCleanTriggerTime(long cacheCleanTriggerTime) {
        this.cacheCleanTriggerTime = cacheCleanTriggerTime * 1000L;
    }

    public long getUserCacheTimeout() {
        return this.userCacheTimeout / 1000L;
    }

    public void setUserCacheTimeout(long userCacheTimeout) {
        this.userCacheTimeout = userCacheTimeout * 1000L;
    }

    @Override
    public void initialize(Map<String, SessionCache> sessionCachePool) {
        Timer cascadeCacheCleanerTimer = new Timer("CascadeCacheCleaner", true);
        CacheCleaner cacheCleanerTimerTask = new CacheCleaner(sessionCachePool, this.userCacheTimeout);
        cascadeCacheCleanerTimer.scheduleAtFixedRate((TimerTask)cacheCleanerTimerTask, this.cacheCleanTriggerTime, this.cacheCleanTriggerTime);
    }

    @Override
    public SessionCache createSessionCache(String key) {
        return new SessionCacheImpl(key);
    }
}

