/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade;

import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import com.jaspersoft.jasperserver.war.cascade.ControlLogic;
import com.jaspersoft.jasperserver.war.cascade.Delegator;
import com.jaspersoft.jasperserver.war.cascade.EventEnvelope;
import com.jaspersoft.jasperserver.war.cascade.cache.DelegatorCacheManager;
import com.jaspersoft.jasperserver.war.cascade.cache.SessionCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.directwebremoting.WebContextFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlLogicDelegator
implements Delegator,
InitializingBean {
    private HashMap<String, ControlLogic> controlLogicPool = new HashMap();
    private HashMap<String, String> controlLogicMap = new HashMap();
    private String defaultControlLogic = "TokenControlLogic";
    private DelegatorCacheManager delegatorCacheManager;
    private Map<String, SessionCache> sessionCachePool;

    public HashMap<String, ControlLogic> getControlLogicPool() {
        return this.controlLogicPool;
    }

    public void setControlLogicPool(HashMap<String, ControlLogic> controlLogicPool) {
        this.controlLogicPool = controlLogicPool;
    }

    public DelegatorCacheManager getDelegatorCacheManager() {
        return this.delegatorCacheManager;
    }

    public void setDelegatorCacheManager(DelegatorCacheManager delegatorCacheManager) {
        this.delegatorCacheManager = delegatorCacheManager;
    }

    public HashMap<String, String> getControlLogicMap() {
        return this.controlLogicMap;
    }

    public void setControlLogicMap(HashMap<String, String> controlLogicMap) {
        this.controlLogicMap = controlLogicMap;
    }

    public String getDefaultControlLogic() {
        return this.defaultControlLogic;
    }

    public void setDefaultControlLogic(String defaultControlLogic) {
        this.defaultControlLogic = defaultControlLogic;
    }

    public void afterPropertiesSet() throws Exception {
        this.sessionCachePool = Collections.synchronizedMap(new HashMap());
        this.delegatorCacheManager.initialize(this.sessionCachePool);
    }

    @Override
    public List<EventEnvelope> initialize(String reportUri, List<EventEnvelope> envelopes) throws SecurityException {
        ControlLogic relControlLogic = this.resolveControlLogic(reportUri);
        return relControlLogic.initialize(reportUri, envelopes, this.getSessionCache());
    }

    @Override
    public List<EventEnvelope> handleEvents(String reportUri, List<EventEnvelope> envelopes) throws SecurityException {
        ControlLogic relControlLogic = this.resolveControlLogic(reportUri);
        return relControlLogic.handleEvents(reportUri, envelopes, this.getSessionCache());
    }

    @Override
    public List<EventEnvelope> autoPopulate(String reportUri, List<EventEnvelope> envelopes, String lookupKey) throws SecurityException {
        ControlLogic relControlLogic = this.resolveControlLogic(reportUri);
        return relControlLogic.autoPopulate(reportUri, envelopes, lookupKey, this.getSessionCache());
    }

    @Override
    public boolean isOptionAvailable(String reportName, String inputControlName, String option) {
        return true;
    }

    private ControlLogic resolveControlLogic(String reportUri) {
        String specControlLogic = this.controlLogicMap.get(reportUri);
        if (specControlLogic != null) {
            return this.controlLogicPool.get(specControlLogic);
        }
        return this.controlLogicPool.get(this.defaultControlLogic);
    }

    private SessionCache getSessionCache() throws SecurityException {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null || auth.getPrincipal().equals("anonymousUser")) {
            throw new SecurityException("Session expired.");
        }
        MetadataUserDetails userDetails = (MetadataUserDetails)auth.getPrincipal();
        String sessionId = WebContextFactory.get().getSession().getId();
        StringBuffer cacheKey = new StringBuffer();
        cacheKey.append(userDetails.getUsername().replace('|', '.'));
        if (userDetails.getTenantId() != null) {
            cacheKey.append("|").append(userDetails.getTenantId().replace('|', '.'));
        }
        cacheKey.append(sessionId);
        SessionCache cache = this.sessionCachePool.get(cacheKey.toString());
        if (cache == null) {
            cache = this.delegatorCacheManager.createSessionCache(cacheKey.toString());
            this.sessionCachePool.put(cacheKey.toString(), cache);
        }
        return cache;
    }
}

