/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action.tree;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.core.util.CipherUtil;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.model.TreeDataProvider;
import com.jaspersoft.jasperserver.war.model.TreeDataProviderFactory;
import com.jaspersoft.jasperserver.war.model.TreeHelper;
import com.jaspersoft.jasperserver.war.model.TreeNode;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.AccessDeniedException;
import org.springframework.web.util.HtmlUtils;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class TreeAction
extends MultiAction {
    public static final String AJAX_REPORT_MODEL = "ajaxResponseModel";
    public static final String PROVIDER = "provider";
    public static final String URI = "uri";
    public static final String URIS = "uris";
    public static final String DEPTH = "depth";
    public static final String PREFETCH = "prefetch";
    public static final String MESSAGE_ID = "messageId";
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private TreeDataProviderFactory treeDataProviderFactory;
    private MessageSource messageSource;
    private ConfigurationBean configurationBean;

    public Event getMessage(RequestContext context) {
        String messageId = context.getRequestParameters().get(MESSAGE_ID);
        String defaultMessage = HtmlUtils.htmlEscape((String)messageId);
        String message = this.messageSource.getMessage(messageId, null, defaultMessage, LocaleContextHolder.getLocale());
        context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)message);
        return this.success();
    }

    public Event getNode(RequestContext context) {
        TreeNode treeNode;
        String providerId = context.getRequestParameters().get(PROVIDER);
        String uri = context.getRequestParameters().get(URI);
        String depth = context.getRequestParameters().get(DEPTH);
        String prefetchNodesList = context.getRequestParameters().get(PREFETCH);
        int d = 0;
        if (depth != null && depth.length() > 0) {
            try {
                d = Integer.parseInt(depth);
                if (d < 0) {
                    d = 0;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Invalid parameter : depth : " + depth), (Throwable)e);
            }
        }
        List<String> prefetchList = null;
        if (prefetchNodesList != null && prefetchNodesList.length() > 0) {
            prefetchList = Arrays.asList(prefetchNodesList.split(","));
        }
        TreeDataProvider treeDataProvider = this.findProvider(context, providerId);
        if (prefetchList == null) {
            try {
                treeNode = treeDataProvider.getNode(this.exContext(context), uri, d);
            }
            catch (AccessDeniedException e) {
                treeNode = treeDataProvider.getNode(this.exContext(context), this.configurationBean.getPublicFolderUri(), d);
            }
        } else {
            try {
                treeNode = TreeHelper.getSubtree(this.exContext(context), treeDataProvider, uri, prefetchList, d);
            }
            catch (AccessDeniedException e) {
                treeNode = TreeHelper.getSubtree(this.exContext(context), treeDataProvider, this.configurationBean.getPublicFolderUri(), prefetchList, d);
            }
        }
        String model = "";
        if (treeNode != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("<div id='treeNodeText'>");
            sb.append(treeNode.toJSONString());
            sb.append("</div>");
            model = sb.toString();
        }
        context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)model);
        return this.success();
    }

    public Event getChildren(RequestContext context) {
        String providerId = context.getRequestParameters().get(PROVIDER);
        String uri = CipherUtil.uriDecode((String)context.getRequestParameters().get(URI));
        TreeDataProvider treeDataProvider = this.findProvider(context, providerId);
        TreeNode treeNode = treeDataProvider.getNode(this.exContext(context), uri, 1);
        String model = "";
        if (treeNode != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("<div id='treeNodeText'>");
            sb.append('[');
            Iterator i = treeNode.getChildren().iterator();
            while (i.hasNext()) {
                TreeNode n = (TreeNode)i.next();
                sb.append(n.toJSONString());
                if (!i.hasNext()) continue;
                sb.append(',');
            }
            sb.append(']');
            sb.append("</div>");
            model = sb.toString();
        }
        context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)model);
        return this.success();
    }

    public Event getMultipleChildren(RequestContext context) {
        String providerId = context.getRequestParameters().get(PROVIDER);
        String uriParam = CipherUtil.uriDecode((String)context.getRequestParameters().get(URIS));
        String[] uris = uriParam.split(",");
        TreeDataProvider treeDataProvider = this.findProvider(context, providerId);
        String model = "";
        StringBuffer sb = new StringBuffer();
        sb.append("<div id='treeNodeText'>");
        sb.append('[');
        boolean empty = true;
        for (String uri : uris) {
            TreeNode treeNode = treeDataProvider.getNode(this.exContext(context), uri, 1);
            if (treeNode == null) continue;
            if (empty) {
                empty = false;
            } else {
                sb.append(',');
            }
            sb.append("{\"parentUri\":\"").append(treeNode.getUriString()).append("\",\"children\":[");
            Iterator i = treeNode.getChildren().iterator();
            while (i.hasNext()) {
                TreeNode n = (TreeNode)i.next();
                sb.append(n.toJSONString());
                if (!i.hasNext()) continue;
                sb.append(',');
            }
            sb.append("]}");
        }
        sb.append(']');
        sb.append("</div>");
        model = sb.toString();
        context.getRequestScope().put(AJAX_REPORT_MODEL, (Object)model);
        return this.success();
    }

    private TreeDataProvider findProvider(RequestContext context, String providerId) {
        TreeDataProvider treeDataProvider = null;
        treeDataProvider = (TreeDataProvider)context.getExternalContext().getSessionMap().get(providerId);
        if (treeDataProvider == null) {
            treeDataProvider = this.treeDataProviderFactory.getDataProvider(providerId);
        }
        if (treeDataProvider == null) {
            this.log.error((Object)("Cannot find tree data provider with id : " + providerId));
            throw new IllegalArgumentException("Cannot find tree data provider with id : " + providerId);
        }
        return treeDataProvider;
    }

    public TreeDataProviderFactory getTreeDataProviderFactory() {
        return this.treeDataProviderFactory;
    }

    public void setTreeDataProviderFactory(TreeDataProviderFactory treeDataProviderFactory) {
        this.treeDataProviderFactory = treeDataProviderFactory;
    }

    private ExecutionContext exContext(RequestContext rContext) {
        return JasperServerUtil.getExecutionContext(rContext);
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setConfigurationBean(ConfigurationBean configurationBean) {
        this.configurationBean = configurationBean;
    }
}

