/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.FolderWrapper;
import java.beans.PropertyEditor;
import java.util.List;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class EditFolderAction
extends FormAction {
    private static final String FORM_OBJECT_KEY = "folderWrapper";
    private static final String PARENT_FOLDER_ATTR = "parentFolder";
    private static final String CURRENT_FOLDER_ATTR = "currentFolder";
    private static final String IS_EDIT_FOLDER = "isEdit";
    private RepositoryService repository;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
        binder.registerCustomEditor(byte[].class, (PropertyEditor)new ByteArrayMultipartFileEditor());
    }

    public EditFolderAction() {
        this.setFormObjectClass(FolderWrapper.class);
        this.setFormObjectName(FORM_OBJECT_KEY);
        this.setFormObjectScope(ScopeType.FLOW);
    }

    public Object createFormObject(RequestContext context) {
        FolderWrapper wrapper;
        String isEditFolder = (String)context.getFlowScope().get(IS_EDIT_FOLDER);
        if (isEditFolder == null) {
            isEditFolder = context.getRequestParameters().get(IS_EDIT_FOLDER);
            context.getFlowScope().put(IS_EDIT_FOLDER, (Object)isEditFolder);
        }
        if (isEditFolder != null) {
            Folder folder;
            ExecutionContextImpl executionContext = new ExecutionContextImpl();
            String currentFolder = (String)context.getFlowScope().get(CURRENT_FOLDER_ATTR);
            if (currentFolder == null) {
                currentFolder = context.getRequestParameters().get("CurrentFolder");
                context.getFlowScope().put(CURRENT_FOLDER_ATTR, (Object)currentFolder);
            }
            if ((folder = this.repository.getFolder((ExecutionContext)executionContext, currentFolder)) == null) {
                throw new JSException("jsexception.folder.not.found.at", new Object[]{currentFolder});
            }
            wrapper = new FolderWrapper(folder);
            wrapper.setEdit(true);
        } else {
            FolderImpl folder = new FolderImpl();
            String parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            if (parentFolder == null) {
                parentFolder = context.getRequestParameters().get("ParentFolderUri");
                context.getFlowScope().put(PARENT_FOLDER_ATTR, (Object)parentFolder);
            }
            if (parentFolder == null || parentFolder.trim().length() == 0) {
                parentFolder = "/";
            }
            folder.setParentFolder(parentFolder);
            wrapper = new FolderWrapper((Folder)folder);
            List folders = this.repository.getSubFolders(JasperServerUtil.getExecutionContext(context), parentFolder);
            wrapper.setAllFolders(folders);
        }
        return wrapper;
    }

    public Event saveFolder(RequestContext context) throws Exception {
        FolderWrapper wrapper = (FolderWrapper)this.getFormObject(context);
        try {
            this.repository.saveFolder(null, wrapper.getActualFolder());
        }
        catch (JSDuplicateResourceException e) {
            this.getFormErrors(context).rejectValue("actualFolder.name", "FolderValidator.error.duplicate");
            return this.error();
        }
        return this.success();
    }

    public Event setupEditForm(RequestContext context) throws Exception {
        MutableAttributeMap rs = context.getRequestScope();
        rs.put(FORM_OBJECT_KEY, this.getFormObject(context));
        return this.success();
    }
}

