/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OlapGetChart
extends HttpServlet {
    private static final Log logger = LogFactory.getLog(OlapGetChart.class);
    String basePath;
    static final String fileNotFound = "/WEB-INF/jpivot/img_not_found.gif";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destroy() {
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String filename = request.getParameter("filename");
        logger.debug((Object)("GetChart called: filename=" + filename));
        if (filename == null) {
            throw new ServletException("Parameter 'filename' must be supplied");
        }
        filename = OlapGetChart.searchReplace(filename, "..", "");
        File file = new File(System.getProperty("java.io.tmpdir"), filename);
        if (!file.exists()) {
            URI uri;
            logger.error((Object)("File '" + file.getAbsolutePath() + "' does not exist"));
            URL url = ((Object)((Object)this)).getClass().getResource(fileNotFound);
            try {
                uri = new URI(url.toString());
            }
            catch (URISyntaxException e) {
                throw new ServletException((Throwable)e);
            }
            file = new File(uri.getPath());
        } else {
            OlapGetChart.sendTempFile(file, response);
        }
    }

    public static void sendTempFile(File file, HttpServletResponse response) throws IOException, FileNotFoundException {
        String mimeType = null;
        String filename = file.getName();
        if (filename.length() > 5) {
            if (filename.substring(filename.length() - 5, filename.length()).equals(".jpeg") || filename.substring(filename.length() - 5, filename.length()).equals(".jpg")) {
                mimeType = "image/jpeg";
            } else if (filename.substring(filename.length() - 4, filename.length()).equals(".png")) {
                mimeType = "image/png";
            } else if (filename.substring(filename.length() - 4, filename.length()).equals(".gif")) {
                mimeType = "image/gif";
            }
        }
        OlapGetChart.sendTempFile(file, response, mimeType);
    }

    public static void sendTempFile(File file, HttpServletResponse response, String mimeType) throws IOException, FileNotFoundException {
        BufferedOutputStream bos;
        BufferedInputStream bis;
        if (file.exists()) {
            bis = new BufferedInputStream(new FileInputStream(file));
            if (mimeType != null) {
                response.setHeader("Content-Type", mimeType);
            }
            response.setHeader("Content-Length", String.valueOf(file.length()));
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            response.setHeader("Last-Modified", sdf.format(new Date(file.lastModified())));
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] input = new byte[1024];
            boolean eof = false;
            while (!eof) {
                int length = bis.read(input);
                if (length == -1) {
                    eof = true;
                    continue;
                }
                bos.write(input, 0, length);
            }
        } else {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        bos.flush();
        bis.close();
        bos.close();
    }

    public static String searchReplace(String inputString, String searchString, String replaceString) {
        int i = inputString.indexOf(searchString);
        if (i == -1) {
            return inputString;
        }
        String r = "";
        r = r + inputString.substring(0, i) + replaceString;
        if (i + searchString.length() < inputString.length()) {
            r = r + OlapGetChart.searchReplace(inputString.substring(i + searchString.length()), searchString, replaceString);
        }
        return r;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Serve up charts for OLAP";
    }
}

