/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.tiles.Definition;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.impl.BasicTilesContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyedDefinitionsFactoryTilesContainer
extends BasicTilesContainer {
    public static final String DEFINITIONS_CONFIG_PREFIX = "org.apache.tiles.impl.KeyedDefinitionsFactoryTilesContainer.DEFINITIONS_CONFIG@";
    protected Map<String, DefinitionsFactory> key2definitionsFactory = new HashMap<String, DefinitionsFactory>();
    protected KeyExtractor keyExtractor;

    public DefinitionsFactory getDefinitionsFactory(String key) {
        DefinitionsFactory retValue = null;
        if (key != null) {
            retValue = this.key2definitionsFactory.get(key);
        }
        if (retValue == null) {
            retValue = this.getDefinitionsFactory();
        }
        return retValue;
    }

    public DefinitionsFactory getProperDefinitionsFactory(String key) {
        DefinitionsFactory retValue = null;
        if (key != null) {
            retValue = this.key2definitionsFactory.get(key);
        }
        return retValue;
    }

    @Deprecated
    public void setDefinitionsFactory(String key, DefinitionsFactory definitionsFactory, Map<String, String> initParameters) {
        this.setDefinitionsFactory(key, definitionsFactory);
        if (key != null) {
            this.initializeDefinitionsFactory(definitionsFactory, this.getResourceString(initParameters), initParameters);
        }
    }

    public void setDefinitionsFactory(String key, DefinitionsFactory definitionsFactory) {
        if (key != null) {
            this.key2definitionsFactory.put(key, definitionsFactory);
        } else {
            this.setDefinitionsFactory(definitionsFactory);
        }
    }

    public void setKeyExtractor(KeyExtractor keyExtractor) {
        this.keyExtractor = keyExtractor;
    }

    @Override
    protected Definition getDefinition(String definitionName, TilesRequestContext request) {
        DefinitionsFactory definitionsFactory;
        Definition retValue = null;
        String key = this.getDefinitionsFactoryKey(request);
        if (key != null && (definitionsFactory = this.key2definitionsFactory.get(key)) != null) {
            retValue = definitionsFactory.getDefinition(definitionName, request);
        }
        if (retValue == null) {
            retValue = super.getDefinition(definitionName, request);
        }
        return retValue;
    }

    protected String getDefinitionsFactoryKey(TilesRequestContext request) {
        if (this.keyExtractor == null) {
            this.keyExtractor = new DefaultKeyExtractor();
        }
        return this.keyExtractor.getDefinitionsFactoryKey(request);
    }

    public static class DefaultKeyExtractor
    implements KeyExtractor {
        public static final String DEFINITIONS_FACTORY_KEY_ATTRIBUTE_NAME = "org.apache.tiles.impl.KeyedDefinitionsFactoryTilesContainer.DefaultKeyExtractor.KEY";

        public String getDefinitionsFactoryKey(TilesRequestContext request) {
            String retValue = null;
            Map<String, Object> requestScope = request.getRequestScope();
            if (requestScope != null) {
                retValue = (String)requestScope.get(DEFINITIONS_FACTORY_KEY_ATTRIBUTE_NAME);
            }
            return retValue;
        }
    }

    public static interface KeyExtractor {
        public String getDefinitionsFactoryKey(TilesRequestContext var1);
    }
}

