/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.dummy;

import org.unitils.mock.dummy.DummyObject;
import org.unitils.mock.mockbehavior.MockBehavior;
import org.unitils.mock.mockbehavior.impl.DefaultValueReturningMockBehavior;
import org.unitils.mock.proxy.ProxyInvocation;
import org.unitils.mock.proxy.ProxyInvocationHandler;
import org.unitils.mock.proxy.ProxyUtil;
import org.unitils.util.MethodUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DummyObjectUtil {
    public static <T> T createDummy(Class<T> type) {
        Class[] interfaces;
        Class superClass;
        if (type.isInterface()) {
            superClass = Object.class;
            interfaces = new Class[]{type, DummyObject.class, Cloneable.class};
        } else {
            superClass = type;
            interfaces = new Class[]{DummyObject.class, Cloneable.class};
        }
        return (T)ProxyUtil.createProxy(superClass, interfaces, new DummyObjectInvocationHandler(type));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DummyObjectInvocationHandler
    implements ProxyInvocationHandler {
        private Class<?> dummyObjectClass;
        private Integer dummyObjectHashCode = new Object().hashCode();
        private MockBehavior dummyObjectBehavior = new DefaultValueReturningMockBehavior();

        public DummyObjectInvocationHandler(Class<?> dummyObjectClass) {
            this.dummyObjectClass = dummyObjectClass;
        }

        @Override
        public Object handleInvocation(ProxyInvocation invocation) throws Throwable {
            if (MethodUtils.isEqualsMethod(invocation.getMethod())) {
                Object other = invocation.getArguments().get(0);
                return invocation.getProxy() == other;
            }
            if (MethodUtils.isHashCodeMethod(invocation.getMethod())) {
                return this.dummyObjectHashCode;
            }
            if (MethodUtils.isCloneMethod(invocation.getMethod())) {
                return invocation.getProxy();
            }
            if (MethodUtils.isToStringMethod(invocation.getMethod())) {
                return "DUMMY " + this.dummyObjectClass.getSimpleName() + "@" + Integer.toHexString(this.dummyObjectHashCode);
            }
            return this.dummyObjectBehavior.execute(invocation);
        }
    }
}

