/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.clean.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.UnitilsException;
import org.unitils.core.dbsupport.DbSupport;
import org.unitils.core.util.StoredIdentifierCase;
import org.unitils.dbmaintainer.clean.DBClearer;
import org.unitils.dbmaintainer.util.BaseDatabaseAccessor;
import org.unitils.util.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDBClearer
extends BaseDatabaseAccessor
implements DBClearer {
    public static final String PROPKEY_PRESERVE_SCHEMAS = "dbMaintainer.preserve.schemas";
    public static final String PROPKEY_PRESERVE_TABLES = "dbMaintainer.preserve.tables";
    public static final String PROPKEY_PRESERVE_VIEWS = "dbMaintainer.preserve.views";
    public static final String PROPKEY_PRESERVE_MATERIALIZED_VIEWS = "dbMaintainer.preserve.materializedViews";
    public static final String PROPKEY_PRESERVE_SYNONYMS = "dbMaintainer.preserve.synonyms";
    public static final String PROPKEY_PRESERVE_SEQUENCES = "dbMaintainer.preserve.sequences";
    public static final String PROPKEY_PRESERVE_TRIGGERS = "dbMaintainer.preserve.triggers";
    public static final String PROPKEY_PRESERVE_TYPES = "dbMaintainer.preserve.types";
    public static final String PROPKEY_VERSION_TABLE_NAME = "dbMaintainer.executedScriptsTableName";
    private static Log logger = LogFactory.getLog(DefaultDBClearer.class);
    protected Set<String> schemasToPreserve;
    protected Map<String, Set<String>> tablesToPreserve;
    protected Map<String, Set<String>> viewsToPreserve;
    protected Map<String, Set<String>> materializedViewsToPreserve;
    protected Map<String, Set<String>> synonymsToPreserve;
    protected Map<String, Set<String>> sequencesToPreserve;
    protected Map<String, Set<String>> triggersToPreserve;
    protected Map<String, Set<String>> typesToPreserve;

    @Override
    protected void doInit(Properties configuration) {
        this.schemasToPreserve = this.getSchemasToPreserve(configuration);
        this.tablesToPreserve = this.getTablesToPreserve();
        this.viewsToPreserve = this.getViewsToPreserve();
        this.materializedViewsToPreserve = this.getMaterializedViewsToPreserve();
        this.sequencesToPreserve = this.getSequencesToPreserve();
        this.synonymsToPreserve = this.getSynonymsToPreserve();
        this.triggersToPreserve = this.getTriggersToPreserve();
        this.typesToPreserve = this.getTypesToPreserve();
    }

    @Override
    public void clearSchemas() {
        for (DbSupport dbSupport : this.dbSupports) {
            if (this.schemasToPreserve.contains(dbSupport.getSchemaName())) continue;
            logger.info((Object)("Clearing (dropping) database schema " + dbSupport.getSchemaName()));
            this.dropSynonyms(dbSupport);
            this.dropViews(dbSupport);
            this.dropMaterializedViews(dbSupport);
            this.dropSequences(dbSupport);
            this.dropTables(dbSupport);
            this.dropTriggers(dbSupport);
            this.dropTypes(dbSupport);
        }
    }

    protected void dropTables(DbSupport dbSupport) {
        Set<String> tableNames = dbSupport.getTableNames();
        Set<String> schemaTablesToPreserve = this.tablesToPreserve.get(dbSupport.getSchemaName());
        for (String tableName : tableNames) {
            if (this.isItemToPreserve(tableName, schemaTablesToPreserve)) continue;
            logger.debug((Object)("Dropping table " + tableName + " in database schema " + dbSupport.getSchemaName()));
            dbSupport.dropTable(tableName);
        }
    }

    protected void dropViews(DbSupport dbSupport) {
        Set<String> viewNames = dbSupport.getViewNames();
        Set<String> schemaViewsToPreserve = this.viewsToPreserve.get(dbSupport.getSchemaName());
        for (String viewName : viewNames) {
            if (this.isItemToPreserve(viewName, schemaViewsToPreserve)) continue;
            logger.debug((Object)("Dropping view " + viewName + " in database schema " + dbSupport.getSchemaName()));
            dbSupport.dropView(viewName);
        }
    }

    protected void dropMaterializedViews(DbSupport dbSupport) {
        if (!dbSupport.supportsMaterializedViews()) {
            return;
        }
        Set<String> materializedViewNames = dbSupport.getMaterializedViewNames();
        Set<String> schemaMaterializedViewsToPreserve = this.materializedViewsToPreserve.get(dbSupport.getSchemaName());
        for (String materializedViewName : materializedViewNames) {
            if (this.isItemToPreserve(materializedViewName, schemaMaterializedViewsToPreserve)) continue;
            logger.debug((Object)("Dropping materialized view " + materializedViewName + " in database schema " + dbSupport.getSchemaName()));
            dbSupport.dropMaterializedView(materializedViewName);
        }
    }

    protected void dropSynonyms(DbSupport dbSupport) {
        if (!dbSupport.supportsSynonyms()) {
            return;
        }
        Set<String> synonymNames = dbSupport.getSynonymNames();
        Set<String> schemaSynonymsToPreserve = this.synonymsToPreserve.get(dbSupport.getSchemaName());
        for (String synonymName : synonymNames) {
            if (this.isItemToPreserve(synonymName, schemaSynonymsToPreserve)) continue;
            logger.debug((Object)("Dropping synonym " + synonymName + " in database schema " + dbSupport.getSchemaName()));
            dbSupport.dropSynonym(synonymName);
        }
    }

    protected void dropSequences(DbSupport dbSupport) {
        if (!dbSupport.supportsSequences()) {
            return;
        }
        Set<String> sequenceNames = dbSupport.getSequenceNames();
        Set<String> schemaSequencesToPreserve = this.sequencesToPreserve.get(dbSupport.getSchemaName());
        for (String sequenceName : sequenceNames) {
            if (this.isItemToPreserve(sequenceName, schemaSequencesToPreserve)) continue;
            logger.debug((Object)("Dropping sequence " + sequenceName + " in database schema " + dbSupport.getSchemaName()));
            dbSupport.dropSequence(sequenceName);
        }
    }

    protected void dropTriggers(DbSupport dbSupport) {
        if (!dbSupport.supportsTriggers()) {
            return;
        }
        Set<String> triggerNames = dbSupport.getTriggerNames();
        Set<String> schemaTriggersToPreserve = this.triggersToPreserve.get(dbSupport.getSchemaName());
        for (String triggerName : triggerNames) {
            if (this.isItemToPreserve(triggerName, schemaTriggersToPreserve)) continue;
            logger.debug((Object)("Dropping trigger " + triggerName + " in database schema " + dbSupport.getSchemaName()));
            dbSupport.dropTrigger(triggerName);
        }
    }

    protected void dropTypes(DbSupport dbSupport) {
        if (!dbSupport.supportsTypes()) {
            return;
        }
        Set<String> typeNames = dbSupport.getTypeNames();
        Set<String> schemaTypesToPreserve = this.typesToPreserve.get(dbSupport.getSchemaName());
        for (String typeName : typeNames) {
            if (this.isItemToPreserve(typeName, schemaTypesToPreserve)) continue;
            logger.debug((Object)("Dropping type " + typeName + " in database schema " + dbSupport.getSchemaName()));
            dbSupport.dropType(typeName);
        }
    }

    protected Set<String> getSchemasToPreserve(Properties configuration) {
        HashSet<String> result = new HashSet<String>();
        List<String> schemasToPreserve = PropertyUtils.getStringList(PROPKEY_PRESERVE_SCHEMAS, configuration);
        for (String schemaToPreserve : schemasToPreserve) {
            boolean found = false;
            for (DbSupport dbSupport : this.dbSupports) {
                if (this.defaultDbSupport.getStoredIdentifierCase() == StoredIdentifierCase.MIXED_CASE) {
                    schemaToPreserve = schemaToPreserve.toUpperCase();
                }
                String correctCaseSchemaToPreserve = dbSupport.toCorrectCaseIdentifier(schemaToPreserve);
                if (!dbSupport.getSchemaName().equals(correctCaseSchemaToPreserve)) continue;
                found = true;
                result.add(correctCaseSchemaToPreserve);
                break;
            }
            if (found) continue;
            throw new UnitilsException("Schema to preserve does not exist: " + schemaToPreserve + ".\nUnitils cannot determine which schemas need to be preserved. To assure nothing is dropped by mistake, no schemas will be dropped.\nPlease fix the configuration of the " + PROPKEY_PRESERVE_SCHEMAS + " property.");
        }
        return result;
    }

    protected Map<String, Set<String>> getTablesToPreserve() {
        Map<String, Set<String>> tablesToPreserve = this.getItemsToPreserve(PROPKEY_PRESERVE_TABLES);
        for (Map.Entry<String, Set<String>> entry : tablesToPreserve.entrySet()) {
            String schemaName = entry.getKey();
            Set<String> tableNames = this.getDbSupport(schemaName).getTableNames();
            for (String tableToPreserve : entry.getValue()) {
                if (this.itemToPreserveExists(tableToPreserve, tableNames)) continue;
                throw new UnitilsException("Table to preserve does not exist: " + tableToPreserve + " in schema: " + schemaName + ".\nUnitils cannot determine which tables need to be preserved. To assure nothing is dropped by mistake, no tables will be dropped.\nPlease fix the configuration of the " + PROPKEY_PRESERVE_TABLES + " property.");
            }
        }
        Map<String, Set<String>> dbVersionTablesToPreserve = this.getItemsToPreserve(PROPKEY_VERSION_TABLE_NAME);
        for (Map.Entry<String, Set<String>> entry : dbVersionTablesToPreserve.entrySet()) {
            String schemaName = entry.getKey();
            Set<String> dbVersionTableNames = entry.getValue();
            Set<String> tableNames = tablesToPreserve.get(schemaName);
            if (tableNames == null) {
                tablesToPreserve.put(schemaName, dbVersionTableNames);
                continue;
            }
            tableNames.addAll(dbVersionTableNames);
        }
        return tablesToPreserve;
    }

    protected Map<String, Set<String>> getViewsToPreserve() {
        Map<String, Set<String>> viewsToPreserve = this.getItemsToPreserve(PROPKEY_PRESERVE_VIEWS);
        for (Map.Entry<String, Set<String>> entry : viewsToPreserve.entrySet()) {
            String schemaName = entry.getKey();
            Set<String> viewNames = this.getDbSupport(schemaName).getViewNames();
            for (String viewToPreserve : entry.getValue()) {
                if (this.itemToPreserveExists(viewToPreserve, viewNames)) continue;
                throw new UnitilsException("View to preserve does not exist: " + viewToPreserve + " in schema: " + schemaName + ".\nUnitils cannot determine which views need to be preserved. To assure nothing is dropped by mistake, no views will be dropped.\nPlease fix the configuration of the " + PROPKEY_PRESERVE_VIEWS + " property.");
            }
        }
        return viewsToPreserve;
    }

    protected Map<String, Set<String>> getMaterializedViewsToPreserve() {
        Map<String, Set<String>> materializedViewsToPreserve = this.getItemsToPreserve(PROPKEY_PRESERVE_MATERIALIZED_VIEWS);
        for (Map.Entry<String, Set<String>> entry : materializedViewsToPreserve.entrySet()) {
            String schemaName = entry.getKey();
            DbSupport dbSupport = this.getDbSupport(schemaName);
            Set<String> materializedViewNames = !dbSupport.supportsMaterializedViews() ? new HashSet<String>() : dbSupport.getMaterializedViewNames();
            for (String materializedViewToPreserve : entry.getValue()) {
                if (this.itemToPreserveExists(materializedViewToPreserve, materializedViewNames)) continue;
                throw new UnitilsException("Materialized view to preserve does not exist: " + materializedViewToPreserve + " in schema: " + schemaName + ".\nUnitils cannot determine which materialized views need to be preserved. To assure nothing is dropped by mistake, no views will be dropped.\nPlease fix the configuration of the " + PROPKEY_PRESERVE_MATERIALIZED_VIEWS + " property.");
            }
        }
        return materializedViewsToPreserve;
    }

    protected Map<String, Set<String>> getSequencesToPreserve() {
        Map<String, Set<String>> sequencesToPreserve = this.getItemsToPreserve(PROPKEY_PRESERVE_SEQUENCES);
        for (Map.Entry<String, Set<String>> entry : sequencesToPreserve.entrySet()) {
            String schemaName = entry.getKey();
            DbSupport dbSupport = this.getDbSupport(schemaName);
            Set<String> sequenceNames = !dbSupport.supportsSequences() ? new HashSet<String>() : dbSupport.getSequenceNames();
            for (String sequenceToPreserve : entry.getValue()) {
                if (this.itemToPreserveExists(sequenceToPreserve, sequenceNames)) continue;
                throw new UnitilsException("Sequence to preserve does not exist: " + sequenceToPreserve + " in schema: " + schemaName + ".\nUnitils cannot determine which sequences need to be preserved. To assure nothing is dropped by mistake, no sequences will be dropped.\nPlease fix the configuration of the " + PROPKEY_PRESERVE_SEQUENCES + " property.");
            }
        }
        return sequencesToPreserve;
    }

    protected Map<String, Set<String>> getSynonymsToPreserve() {
        Map<String, Set<String>> synonymsToPreserve = this.getItemsToPreserve(PROPKEY_PRESERVE_SYNONYMS);
        for (Map.Entry<String, Set<String>> entry : synonymsToPreserve.entrySet()) {
            String schemaName = entry.getKey();
            DbSupport dbSupport = this.getDbSupport(schemaName);
            Set<String> synonymNames = !dbSupport.supportsSynonyms() ? new HashSet<String>() : dbSupport.getSynonymNames();
            for (String synonymToPreserve : entry.getValue()) {
                if (this.itemToPreserveExists(synonymToPreserve, synonymNames)) continue;
                throw new UnitilsException("Synonym to preserve does not exist: " + synonymToPreserve + " in schema: " + schemaName + ".\nUnitils cannot determine which synonyms need to be preserved. To assure nothing is dropped by mistake, no synonyms will be dropped.\nPlease fix the configuration of the " + PROPKEY_PRESERVE_SYNONYMS + " property.");
            }
        }
        return synonymsToPreserve;
    }

    protected Map<String, Set<String>> getTriggersToPreserve() {
        Map<String, Set<String>> triggersToPreserve = this.getItemsToPreserve(PROPKEY_PRESERVE_TRIGGERS);
        for (Map.Entry<String, Set<String>> entry : triggersToPreserve.entrySet()) {
            String schemaName = entry.getKey();
            DbSupport dbSupport = this.getDbSupport(schemaName);
            Set<String> triggerNames = !dbSupport.supportsTriggers() ? new HashSet<String>() : dbSupport.getTriggerNames();
            for (String triggerToPreserve : entry.getValue()) {
                if (this.itemToPreserveExists(triggerToPreserve, triggerNames)) continue;
                throw new UnitilsException("Trigger to preserve does not exist: " + triggerToPreserve + " in schema: " + schemaName + ".\nUnitils cannot determine which triggers need to be preserved. To assure nothing is dropped by mistake, no triggers will be dropped.\nPlease fix the configuration of the " + PROPKEY_PRESERVE_TRIGGERS + " property.");
            }
        }
        return triggersToPreserve;
    }

    protected Map<String, Set<String>> getTypesToPreserve() {
        Map<String, Set<String>> typesToPreserve = this.getItemsToPreserve(PROPKEY_PRESERVE_TYPES);
        for (Map.Entry<String, Set<String>> entry : typesToPreserve.entrySet()) {
            String schemaName = entry.getKey();
            DbSupport dbSupport = this.getDbSupport(schemaName);
            Set<String> typeNames = !dbSupport.supportsTypes() ? new HashSet<String>() : dbSupport.getTypeNames();
            for (String typeToPreserve : entry.getValue()) {
                if (this.itemToPreserveExists(typeToPreserve, typeNames)) continue;
                throw new UnitilsException("Type to preserve does not exist: " + typeToPreserve + " in schema: " + schemaName + ".\nUnitils cannot determine which types need to be preserved. To assure nothing is dropped by mistake, no types will be dropped.\nPlease fix the configuration of the " + PROPKEY_PRESERVE_TYPES + " property.");
            }
        }
        return typesToPreserve;
    }

    protected boolean isItemToPreserve(String item, Set<String> itemsToPreserve) {
        if (itemsToPreserve == null) {
            return false;
        }
        if (this.defaultDbSupport.getStoredIdentifierCase() == StoredIdentifierCase.MIXED_CASE) {
            item = item.toUpperCase();
        }
        return itemsToPreserve.contains(item);
    }

    protected boolean itemToPreserveExists(String itemToPreserve, Set<String> items) {
        if (this.defaultDbSupport.getStoredIdentifierCase() == StoredIdentifierCase.MIXED_CASE) {
            for (String item : items) {
                if (!itemToPreserve.equalsIgnoreCase(item)) continue;
                return true;
            }
            return false;
        }
        return items.contains(itemToPreserve);
    }

    protected Map<String, Set<String>> getItemsToPreserve(String propertyName) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        List<String> itemsToPreserve = PropertyUtils.getStringList(propertyName, this.configuration);
        for (String itemToPreserve : itemsToPreserve) {
            DbSupport dbSupport;
            int index = itemToPreserve.indexOf(46);
            if (itemToPreserve.indexOf(46) == -1) {
                dbSupport = this.defaultDbSupport;
            } else {
                String schemaName = itemToPreserve.substring(0, index);
                dbSupport = this.getDbSupport(schemaName);
                itemToPreserve = itemToPreserve.substring(index + 1);
            }
            if (dbSupport.getStoredIdentifierCase() == StoredIdentifierCase.MIXED_CASE) {
                itemToPreserve = itemToPreserve.toUpperCase();
            }
            String correctCaseItemToPreserve = dbSupport.toCorrectCaseIdentifier(itemToPreserve);
            HashSet<String> schemaItems = (HashSet<String>)result.get(dbSupport.getSchemaName());
            if (schemaItems == null) {
                schemaItems = new HashSet<String>();
                result.put(dbSupport.getSchemaName(), schemaItems);
            }
            schemaItems.add(correctCaseItemToPreserve);
        }
        return result;
    }
}

