/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer;

import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.UnitilsException;
import org.unitils.core.dbsupport.SQLHandler;
import org.unitils.core.util.ConfigUtils;
import org.unitils.dbmaintainer.clean.DBCleaner;
import org.unitils.dbmaintainer.clean.DBClearer;
import org.unitils.dbmaintainer.script.ExecutedScript;
import org.unitils.dbmaintainer.script.Script;
import org.unitils.dbmaintainer.script.ScriptRunner;
import org.unitils.dbmaintainer.script.ScriptSource;
import org.unitils.dbmaintainer.structure.ConstraintsDisabler;
import org.unitils.dbmaintainer.structure.DataSetStructureGenerator;
import org.unitils.dbmaintainer.structure.SequenceUpdater;
import org.unitils.dbmaintainer.util.DatabaseModuleConfigUtils;
import org.unitils.dbmaintainer.version.ExecutedScriptInfoSource;
import org.unitils.dbmaintainer.version.Version;
import org.unitils.util.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBMaintainer {
    private static Log logger = LogFactory.getLog(DBMaintainer.class);
    public static final String PROPKEY_DB_CLEANER_ENABLED = "dbMaintainer.cleanDb.enabled";
    public static final String PROPKEY_FROM_SCRATCH_ENABLED = "dbMaintainer.fromScratch.enabled";
    public static final String PROPKEY_CLEAR_DB_CODE_ENABLED = "dbMaintainer.clearDbCode.enabled";
    public static final String PROPKEY_KEEP_RETRYING_AFTER_ERROR_ENABLED = "dbMaintainer.keepRetryingAfterError.enabled";
    public static final String PROPKEY_DISABLE_CONSTRAINTS_ENABLED = "dbMaintainer.disableConstraints.enabled";
    public static final String PROPKEY_UPDATE_SEQUENCES_ENABLED = "dbMaintainer.updateSequences.enabled";
    public static final String PROPKEY_GENERATE_DATA_SET_STRUCTURE_ENABLED = "dbMaintainer.generateDataSetStructure.enabled";
    protected ExecutedScriptInfoSource versionSource;
    protected ScriptSource scriptSource;
    protected ScriptRunner scriptRunner;
    protected DBClearer dbClearer;
    protected DBCleaner dbCleaner;
    protected ConstraintsDisabler constraintsDisabler;
    protected SequenceUpdater sequenceUpdater;
    protected DataSetStructureGenerator dataSetStructureGenerator;
    protected boolean fromScratchEnabled;
    protected boolean disableConstraintsEnabled;
    protected boolean keepRetryingAfterError;

    protected DBMaintainer() {
    }

    public DBMaintainer(Properties configuration, SQLHandler sqlHandler) {
        try {
            boolean generateDtd;
            this.scriptRunner = DatabaseModuleConfigUtils.getConfiguredDatabaseTaskInstance(ScriptRunner.class, configuration, sqlHandler);
            this.versionSource = DatabaseModuleConfigUtils.getConfiguredDatabaseTaskInstance(ExecutedScriptInfoSource.class, configuration, sqlHandler);
            this.scriptSource = ConfigUtils.getConfiguredInstanceOf(ScriptSource.class, configuration, new String[0]);
            boolean cleanDbEnabled = PropertyUtils.getBoolean(PROPKEY_DB_CLEANER_ENABLED, configuration);
            if (cleanDbEnabled) {
                this.dbCleaner = DatabaseModuleConfigUtils.getConfiguredDatabaseTaskInstance(DBCleaner.class, configuration, sqlHandler);
            }
            this.fromScratchEnabled = PropertyUtils.getBoolean(PROPKEY_FROM_SCRATCH_ENABLED, configuration);
            this.keepRetryingAfterError = PropertyUtils.getBoolean(PROPKEY_KEEP_RETRYING_AFTER_ERROR_ENABLED, configuration);
            if (this.fromScratchEnabled) {
                this.dbClearer = DatabaseModuleConfigUtils.getConfiguredDatabaseTaskInstance(DBClearer.class, configuration, sqlHandler);
            }
            this.disableConstraintsEnabled = PropertyUtils.getBoolean(PROPKEY_DISABLE_CONSTRAINTS_ENABLED, configuration);
            this.constraintsDisabler = DatabaseModuleConfigUtils.getConfiguredDatabaseTaskInstance(ConstraintsDisabler.class, configuration, sqlHandler);
            boolean updateSequences = PropertyUtils.getBoolean(PROPKEY_UPDATE_SEQUENCES_ENABLED, configuration);
            if (updateSequences) {
                this.sequenceUpdater = DatabaseModuleConfigUtils.getConfiguredDatabaseTaskInstance(SequenceUpdater.class, configuration, sqlHandler);
            }
            if (generateDtd = PropertyUtils.getBoolean(PROPKEY_GENERATE_DATA_SET_STRUCTURE_ENABLED, configuration)) {
                this.dataSetStructureGenerator = DatabaseModuleConfigUtils.getConfiguredDatabaseTaskInstance(DataSetStructureGenerator.class, configuration, sqlHandler);
            }
        }
        catch (UnitilsException e) {
            logger.error((Object)"Error while initializing DbMaintainer", (Throwable)e);
            throw e;
        }
    }

    public void updateDatabase() {
        boolean fromScratchUpdateRecommended = this.versionSource.isFromScratchUpdateRecommended();
        Set<ExecutedScript> alreadyExecutedScripts = this.versionSource.getExecutedScripts();
        Version highestExecutedScriptVersion = this.getHighestExecutedScriptVersion(alreadyExecutedScripts);
        boolean shouldUpdateFromScratch = this.shouldUpdateDatabaseFromScratch(highestExecutedScriptVersion, alreadyExecutedScripts);
        if (this.fromScratchEnabled && (fromScratchUpdateRecommended || shouldUpdateFromScratch)) {
            this.constraintsDisabler.disableConstraints();
            this.dbClearer.clearSchemas();
            this.versionSource.clearAllExecutedScripts();
            this.updateDatabase(this.scriptSource.getAllUpdateScripts());
            return;
        }
        this.updateDatabase(this.scriptSource.getNewScripts(highestExecutedScriptVersion, alreadyExecutedScripts));
    }

    protected Version getHighestExecutedScriptVersion(Set<ExecutedScript> executedScripts) {
        Version highest = new Version("0");
        for (ExecutedScript executedScript : executedScripts) {
            if (!executedScript.getScript().isIncremental() || executedScript.getScript().getVersion().compareTo(highest) <= 0) continue;
            highest = executedScript.getScript().getVersion();
        }
        return highest;
    }

    public void resetDatabaseState() {
        this.versionSource.clearAllExecutedScripts();
        List<Script> allScripts = this.scriptSource.getAllUpdateScripts();
        for (Script script : allScripts) {
            this.versionSource.registerExecutedScript(new ExecutedScript(script, new Date(), true));
        }
    }

    protected void updateDatabase(List<Script> scripts) {
        if (scripts.isEmpty()) {
            logger.info((Object)"Database is up to date");
            return;
        }
        logger.info((Object)"Database update scripts have been found and will be executed on the database.");
        if (this.dbCleaner != null) {
            this.dbCleaner.cleanSchemas();
        }
        this.executeScripts(scripts);
        this.executePostProcessingScripts(this.scriptSource.getPostProcessingScripts());
        if (this.disableConstraintsEnabled) {
            this.constraintsDisabler.disableConstraints();
        }
        if (this.sequenceUpdater != null) {
            this.sequenceUpdater.updateSequences();
        }
        if (this.dataSetStructureGenerator != null) {
            this.dataSetStructureGenerator.generateDataSetStructure();
        }
    }

    protected void executeScripts(List<Script> scripts) {
        for (Script script : scripts) {
            try {
                ExecutedScript executedScript = new ExecutedScript(script, new Date(), false);
                this.versionSource.registerExecutedScript(executedScript);
                logger.info((Object)("Executing script " + script.getFileName()));
                this.scriptRunner.execute(script.getScriptContentHandle());
                executedScript.setSuccessful(true);
                this.versionSource.updateExecutedScript(executedScript);
            }
            catch (UnitilsException e) {
                logger.error((Object)("Error while executing script " + script.getFileName()), (Throwable)e);
                throw e;
            }
        }
    }

    protected void executePostProcessingScripts(List<Script> postProcessingScripts) {
        for (Script script : postProcessingScripts) {
            try {
                logger.info((Object)("Executing post processing script " + script.getFileName()));
                this.scriptRunner.execute(script.getScriptContentHandle());
            }
            catch (UnitilsException e) {
                logger.error((Object)("Error while executing post processing script " + script.getFileName()), (Throwable)e);
                throw e;
            }
        }
    }

    protected boolean shouldUpdateDatabaseFromScratch(Version currentVersion, Set<ExecutedScript> alreadyExecutedScripts) {
        if (this.scriptSource.isExistingIndexedScriptModified(currentVersion, alreadyExecutedScripts)) {
            if (!this.fromScratchEnabled) {
                throw new UnitilsException("One or more existing incremental database update scripts have been modified, but updating from scratch is disabled. You should either revert to the original version of the modified script and add an new incremental script that performs the desired update, or perform the update manually on the database and then reset the database state by invoking resetDatabaseState()");
            }
            logger.info((Object)"One or more existing database update scripts have been modified. Database will be cleared and rebuilt from scratch.");
            return true;
        }
        if (this.errorInIndexedScriptDuringLastUpdate(alreadyExecutedScripts)) {
            if (this.fromScratchEnabled) {
                if (!this.keepRetryingAfterError) {
                    throw new UnitilsException("During a previous database update, the execution of an incremental script failed! Since dbMaintainer.keepRetryingAfterError.enabled is set to false, the database will not be rebuilt from scratch, unless the failed (or another) incremental script is modified.");
                }
                logger.info((Object)"During a previous database update, the execution of a incremental script failed! Database will be cleared and rebuilt from scratch.");
                return true;
            }
            logger.warn((Object)"During a previous database update, the execution of an incremental script failed! Since from scratch updates are disabled, you should fix the erroneous script, solve the problem manually on the database, and then reset the database state by invoking resetDatabaseState()");
            return false;
        }
        return false;
    }

    protected boolean errorInIndexedScriptDuringLastUpdate(Set<ExecutedScript> alreadyExecutedScripts) {
        for (ExecutedScript script : alreadyExecutedScripts) {
            if (script.isSucceeded().booleanValue() || !script.getScript().isIncremental()) continue;
            return true;
        }
        return false;
    }
}

